/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CheckBoxWidget.cpp
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.9 $
//
// Description      : CheckBoxWidget.cpp contains the implementation of the 
//                    CCheckBoxWidget class.  This class displays a 
//                    square to the left of text.  The 
//                    text is always horizontally centered and vertically 
//                    centered.  The square has a white background and 
//                    uses black, white and two shades of grey to give 
//                    the appearance of being sunken.  An 'x' appears 
//                    in the square when the member variable 
//                    m_varChecked is true or not zero.  The only 
//                    colors that may be changed in the editor are the 
//                    background color and the foreground text color.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CWidget, General::CButtonWidget, 
//                    General::CTextWidget, Core::CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CheckBoxWidget.cpp $                                                                   
// Revision 1.9  2000/03/07 20:39:07  billyb                                                                   
// Changed function signatures to eliminate warnings.                                                                   
// Revision 1.8  2000/01/10 18:47:04  billyb                                                                   
// Changed widget to work as a radio type widget if                                                                   
// range data is used.                                                                   
// Revision 1.7  1999/12/08 17:41:45  billyb                                                                   
// Added CS_OWNDC.                                                                   
// Revision 1.6  1999/11/09 20:53:07  billyb                                                                   
// Changed FillRect to FillSolidRect or PatBlt.  Changed                                                                    
// BEGIN_MESSAGE_MAP to CButtonWidget as base class.                                                                   
// Now draws to offscreen memory and then blts to onscreen                                                                   
// memory.                                                                   
// Revision 1.5  1999/10/21 01:36:38  billyb                                                                   
// Implemented ResetProperties to make sure that the text was                                                                   
// vertically centered.                                                                   
// Revision 1.4  1999/10/14 19:44:06  billyb                                                                   
// Added checks of m_bEnabled.  Changed drawing to look                                                                   
// like a Windows checkbox when disabled.                                                                   
// Revision 1.3  1999/10/11 18:13:07  billyb                                                                   
// Made use of parent draw to get muliline centered text.                                                                   
// Revision 1.2  1999/10/04 00:37:19  billyb                                                                   
// Added comments.  Made owner drawn.  Corrected problems                                                                   
// with m_variant.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "CheckBoxWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
//
// CCheckBoxWidget::CCheckBoxWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Set the name of the widget which
//                    is used in the XML data and under the icons in the 
//                    editor.
//
/////////////////////////////////////////////////////////////////////////////
CCheckBoxWidget::CCheckBoxWidget()
{
    m_stlStrWidgetName  = _FSI_STL::string("CheckBox");

    CCheckBoxWidget::InitReinit();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::InitReinit()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 28 March 2000
//
// Engineer         : Billy Baker
//
// Description      : InitReinit is used to initialize member variables 
//                    when a widget is first created and when 
//                    instances are reused.
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::InitReinit()
{
    m_stlStrValue   = _FSI_STL::string("Blank");
    m_lAlign        = 1;
    m_lVAlign       = 1;

    m_varChecked.Value((long)0);
    m_varChecked_cv = m_varChecked;
}

/////////////////////////////////////////////////////////////////////////////
//
// CCheckBoxWidget::~CCheckBoxWidget()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CCheckBoxWidget::~CCheckBoxWidget()
{
}


BEGIN_MESSAGE_MAP(CCheckBoxWidget, CButtonWidget)
	//{{AFX_MSG_MAP(CCheckBoxWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_WINDOWPOSCHANGED()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CCheckBoxWidget::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A pointer to a new instance of CCheckBoxWidget.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::CreateObject() is a common 
//                    framework method used to create a new instance of 
//                    CCheckBoxWidget.  It is a static member.  The 
//                    address of this method is stored in a map of 
//                    widget name to CreateObject address in the 
//                    component interface for the DLL that contains the 
//                    CCheckBoxWidget.  Using this data structure, a 
//                    new instance of CCheckBoxWidget can be created 
//                    when one is encountered in the XML page 
//                    description file.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CCheckBoxWidget::CreateObject()
{
    return new CCheckBoxWidget();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - reference to a pointer 
//                                               that holds the data to 
//                                               create a CCheckBoxWidget.
//                    CWnd* pWnd               - the parent CWnd object.
//                    const long lId           - identifier.
//                    bool bEditMode           - whether editing is taking 
//                                               place.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::Initialize() is a common 
//                    framework method.  It is called after an instance 
//                    of CCheckBoxWidget has been created.  It is 
//                    responsible for initializing most of the internal 
//                    data members with data from the XMLWidget.  This 
//                    is done using the call to ResetProperties.  If 
//                    the XMLWidget pointer is NULL, a new XMLWidget 
//                    instance is created with default settings.  
//                    Generic help text is set here and any CWnd 
//                    derived Create() calls are made to create the 
//                    Windows object that allows for the use of the MFC 
//                    messages.  The HWND for the CWnd derived object 
//                    that is created is then added to a map in CWidget 
//                    that keeps track of what CWidget derived pointers 
//                    are valid.  This is to make sure that all of the 
//                    threads do not try to dereference bad pointers.
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                 const long lId, bool bEditMode)
{
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    CCheckBoxWidget::InitReinit();

    if (rpXMLWidget != NULL)
    {
        ResetProperties();
    }

    if (GetSafeHwnd() == NULL)
    {
        Create(m_stlStrValue.c_str(),
               WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | BS_OWNERDRAW | CS_OWNDC,
               CRect(m_exPtUpperLeft, m_exPtLowerRight),
               (CWnd*)pWnd, lId);
    }
    else
    {
        SetParent(pWnd);
        MoveWindow(m_exPtUpperLeft.X(), m_exPtUpperLeft.Y(),
                   m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                   m_exPtLowerRight.Y() - m_exPtUpperLeft.Y(), FALSE);
        ShowWindow(SW_NORMAL);
    }

    CDC* pDCur = GetDC();
    if (m_pDC->GetSafeHdc() != NULL)
    {
        m_pDC->DeleteDC();
    }
    m_pDC->CreateCompatibleDC(pDCur);

    if (m_pBMP->GetSafeHandle() != NULL)
    {
        m_pBMP->DeleteObject();
    }
    m_pBMP->CreateCompatibleBitmap(pDCur, m_exPtLowerRight.X() - m_exPtUpperLeft.X(),
                                    m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
    ReleaseDC(pDCur);

    m_pDC->SelectObject(m_pBMP);
    m_pDC->SetBkMode(TRANSPARENT);
    m_pDC->SelectObject(&m_font);

    m_pWnd = this;

    // For use with CWidget::IsValidAddress().
    m_mapValidAddresses[this] = m_pWnd->GetSafeHwnd();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 20 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::ResetProperties will call its 
//                    parent's ResetProperties method.  Afterwards, it
//                    will reset the alignment variables and call 
//                    TextFormat to reset the text formatting.
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::ResetProperties()
{
    CTextWidget::ResetProperties();

    m_lVAlign           = 1;

    TextFormat();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::OnLButtonDown()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::OnLButtonDown() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to showing a tracking rectangle in
//                    the editor or to show any focus or push down states
//                    in the runtime.
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
        m_bRedraw = false;

        CButtonWidget::OnLButtonDown(nFlags, point);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::OnLButtonUp()
//
// Inputs           : UINT nFlags  - flags that tell what other keys may 
//                                   have been pressed when the click 
//                                   occurred.
//                    CPoint point - the position of the click.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::OnLButtonUp() is an override of 
//                    the standard MFC method for CWnd derived classes. 
//                    Here, it is used to flip the state of the 
//                    checkbox and to tell all comms actions to update 
//                    via the call to CButtonWidget::OnLButtonUp().
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        m_bRedraw = false;

        // Flip the state.
        if ((long)m_varChecked == 0)
        {
            m_variant.Value((long)1);
        }
        else
        {
            m_variant.Value((long)0);
        }

        CButtonWidget::OnLButtonUp(nFlags, point);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::DrawItem()
//
// Inputs           : LPDRAWITEMSTRUCT lpDrawItemStruct - pointer to a 
//                                                        Win32 structure
//                    .
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::DrawItem() is an override of a 
//                    standard MFC method for use with owner drawn 
//                    controls.  It is overriden here to allow the 
//                    background to be whatever the user wants and to 
//                    make the square for the check resize as the size 
//                    of the widget resizes.
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
    CRect rect(&(lpDrawItemStruct->rcItem));
    CDC *pDC    = CDC::FromHandle(lpDrawItemStruct->hDC);

    CDC* pDCur  = pDC;
    pDC         = m_pDC;

    long int lSavedDC = pDC->SaveDC();

    // save the DC and set formatting parameters for 
    // horizontal and vertical alignment
    // fill the extents rectangle with the color for the background
    pDC->SetBkColor(m_clrBack);

    ::ExtTextOut(pDC->GetSafeHdc(), 0, 0, ETO_OPAQUE, (LPRECT)rect, NULL, 0, NULL);

    // Put 5 pixels between left edget of widget and left edge of
    // square for check.  Also, put 5 pixels between right edge of
    // square and the text.
    int nSideBorder = 5;
    CRect rectCheckBox;

    // Compute the size of the rectangle for the square used to show the
    // check status.  This only really needs to be done when the size of
    // the graphical element changes.  But, the code is probably not going
    // to impact rendering times.  Adding another member variable for 
    // keeping track of the square's rectangle and the text's rectangle
    // proably would show little if any speed up.
    if (rect.Width() < rect.Height())
    {
        rectCheckBox = CRect (rect.left + nSideBorder, 
                              rect.Height() / 2 - rect.Width()/10,
                              rect.left + nSideBorder + rect.Width() / 5,
                              rect.Height() / 2 + rect.Width()/10);

        // Update rect's left member to where the text should start.
        rect.left += rect.Width() / 5 + 2 * nSideBorder;
    }
    else
    {
        if (rect.Height() - 2 * nSideBorder > rect.Width() / 5)
        {
            rectCheckBox = CRect(rect.left + nSideBorder, 
                                 rect.Height() / 2 - rect.Width()/10,
                                 rect.left + nSideBorder + rect.Width() / 5,
                                 rect.Height() / 2 + rect.Width()/10);

            // Update rect's left member to where the text should start.
            rect.left += rect.Width() / 5 + 2 * nSideBorder;
        }
        else
        {
            rectCheckBox = CRect(rect.left + nSideBorder, 
                                 nSideBorder,
                                 rect.left + rect.Height() - nSideBorder,
                                 rect.Height() - nSideBorder);

            // Update rect's left member to where the text should start.
            rect.left += rect.Height();
        }
    }

    // Fill the rectCheckBox area with white.
    pDC->FillSolidRect(rectCheckBox, (COLORREF)(m_clrBack.HighlightColor()));

    // Put a black highlight in the upper left.
    pDC->MoveTo(rectCheckBox.left + 1, rectCheckBox.bottom - 3);
    pDC->LineTo(rectCheckBox.left + 1, rectCheckBox.top + 1);
    pDC->LineTo(rectCheckBox.right - 2, rectCheckBox.top + 1);

    long int lSavedDC2 = pDC->SaveDC();

    // Upper left highlight.
    CPen penD(PS_SOLID, 1, m_clrBack.DarkColor());
    pDC->SelectObject(&penD);
	pDC->MoveTo(rectCheckBox.left, rectCheckBox.bottom - 2);
	pDC->LineTo(rectCheckBox.left, rectCheckBox.top);
	pDC->LineTo(rectCheckBox.right - 1, rectCheckBox.top);

    // Lower right highlight.
    CPen penH(PS_SOLID, 1, m_clrBack);
    pDC->SelectObject(&penH);
	pDC->MoveTo(rectCheckBox.left + 1, rectCheckBox.bottom - 2);
	pDC->LineTo(rectCheckBox.right - 2, rectCheckBox.bottom - 2);
	pDC->LineTo(rectCheckBox.right - 2, rectCheckBox.top);

    pDC->RestoreDC(lSavedDC2);

    if (m_bEnabled == true)
    {
        rectCheckBox.DeflateRect(2, 2);
        pDC->PatBlt(rectCheckBox.left, rectCheckBox.top, 
                    rectCheckBox.Width(), rectCheckBox.Height(), 
                    WHITENESS);
        rectCheckBox.InflateRect(2, 2);
    }
    else
    {
        rectCheckBox.DeflateRect(2, 2);
        pDC->FillSolidRect(rectCheckBox, (COLORREF)m_clrBack);
        rectCheckBox.InflateRect(2, 2);
    }

    // If checked, put in an x.
    if ((long)m_varChecked != 0)
    {
	    pDC->MoveTo(rectCheckBox.left + 3, rectCheckBox.top + 3);
	    pDC->LineTo(rectCheckBox.right - 3, rectCheckBox.bottom - 3);

	    pDC->MoveTo(rectCheckBox.left + 3, rectCheckBox.top + 4);
	    pDC->LineTo(rectCheckBox.right - 4, rectCheckBox.bottom - 3);

	    pDC->MoveTo(rectCheckBox.left + 4, rectCheckBox.top + 3);
	    pDC->LineTo(rectCheckBox.right - 3, rectCheckBox.bottom - 4);

	    pDC->MoveTo(rectCheckBox.left + 3, rectCheckBox.bottom - 4);
	    pDC->LineTo(rectCheckBox.right - 3, rectCheckBox.top + 2);

	    pDC->MoveTo(rectCheckBox.left + 4, rectCheckBox.bottom - 4);
	    pDC->LineTo(rectCheckBox.right - 3, rectCheckBox.top + 3);

	    pDC->MoveTo(rectCheckBox.left + 3, rectCheckBox.bottom - 5);
	    pDC->LineTo(rectCheckBox.right - 4, rectCheckBox.top + 2);
    }

    CRect rectO(&(lpDrawItemStruct->rcItem));
    pDCur->BitBlt(rectO.left, rectO.top, rectO.Width(), rectO.Height(), pDC, rectO.left, rectO.top, SRCCOPY);
    pDC->RestoreDC(lSavedDC);

    m_bRepaint = true;
    CRect rectOld(&(lpDrawItemStruct->rcItem));
    lpDrawItemStruct->rcItem = rect;
    CTextWidget::DrawItem(lpDrawItemStruct);
    lpDrawItemStruct->rcItem = rectOld;
}

/////////////////////////////////////////////////////////////////////////////
//
// CVariant* CCheckBoxWidget::GetValue()
//
// Inputs           : CString& rstrValue - the name of the internal 
//                                         variable whose value is needed
//                    .
//
// Return Values    : A pointer to CVariant instance that holds the 
//                    value for the requested internal variable.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::GetValue() is a common framework 
//                    method.  It is used when ever a user performs an 
//                    action like a button click or pressing a 
//                    return/enter key. These actions are performed on 
//                    the graphical element and signal that data needs 
//                    to go from the graphical element to somewhere 
//                    else.  Here, the somewhere else would either be a 
//                    local comms variable or a host variable.  Here, the
//                    value being sent is the status of the checkbox.
//
/////////////////////////////////////////////////////////////////////////////
CVariant* CCheckBoxWidget::GetValue(const CString &rstrValue)
{
    // CWidget provides m_variant for use by everyone to
    // send a value to comms.  m_variant is changed in OnLButtonUp().
    if (m_bEnabled == true)
    {
        return &m_variant;
    }
    else
    {
        return NULL;
    }
}

//////////////////////////////////////////////////////////////////////
// Methods called from Comms thread
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CCheckBoxWidget::ChangeValue()
//
// Inputs           : CString& rstrElementVar - the internal name of a 
//                                              variable that needs to be 
//                                              updated.
//                    CChangeValue* pCV       - pointer to data used to 
//                                              update an internal 
//                                              variable.
//
// Return Values    : None.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBox::ChangeValue() is a common framework 
//                    method that is used by the Comms thread to send 
//                    new data to the graphical elements.  Since it is 
//                    called from another thread, the special internal 
//                    variables are used to store the updates.  Before 
//                    the graphical element is redrawn, 
//                    UpdateRenderVariables is called to copy the 
//                    updated values to the values used for rendering.  
//                    This causes more memory to be used but prevents 
//                    the use of synchronization objects that may stall 
//                    the Comms thread.
//
/////////////////////////////////////////////////////////////////////////////
void CCheckBoxWidget::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
    if (pCV == NULL)
    {
        return;
    }

    // Do not use m_variant or m_variant_cv.  Support for ranges
    // is not implemented.
    if (rstrElementVar == "Default")
    {
        if (pCV->UseRange() == true)
        {
            if (pCV->TrueOrFalseValue() == true)
            {
                m_varChecked_cv.Value((long)1);
            }
            else
            {
                m_varChecked_cv.Value((long)0);
            }
        }
        else
        {
            if ((long)*(pCV->Variant()) != 0)
            {
                m_varChecked_cv.Value((long)1);
            }
            else
            {
                m_varChecked_cv.Value((long)0);
            }
        }
    }
    else
    {
        CWidget::ChangeValue(rstrElementVar, pCV);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CCheckBoxWidget::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : true  - all of the render variables were updated.
//                    false - a problem occurred updating the render 
//                            variables.
//
// Date             : 03 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CCheckBoxWidget::UpdateRenderVariables is a 
//                    common framework method that is called by the 
//                    Comms thread to make sure that all of the 
//                    variables used for rendering have the most up to 
//                    date data.
//
/////////////////////////////////////////////////////////////////////////////
bool CCheckBoxWidget::UpdateRenderVariables()
{
    bool bRetVal = CWidget::UpdateRenderVariables();

    if (bRetVal == true)
    {
        m_varChecked = m_varChecked_cv;
    }

    return bRetVal;
}

