/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ButtonWidget.h
//
// Date             : 22 November 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : Buttonwidget.h contains the definition of the 
//                    CButtonWidget class.  CButtonWidget derives from 
//                    both the MFC CButton class as well as the CWidget 
//                    class in the Core library.  CButtonWidget is an 
//                    abstract class from which all other button-type 
//                    widgets should be derived.  The CButtonWidget 
//                    class contains the necessary code for the timer 
//                    to determine if the mouse has left the 
//                    button-type widget's client area.  All derived class
//                    should have ON_WM_LBUTTONDBLCLK() in their message map
//                    but should not override the implementation of 
//                    OnLButtonDblClk in CButtonWidget since it simply 
//                    redirects the double click to OnLButtonDown.  Likewise,
//                    derived classes should have ON_WM_PAINT(), 
//                    ON_WM_SETCURSOR, ON_WM_RBUTTONUP, and ON_WM_ERASEBKGND
//                    in their message maps but should not override the 
//                    CButtonWidget implementations of the associated message
//                    handlers.  Derived classes can override OnLButtonDown,
//                    OnLButtonUp, OnMouseMove, and OnMouseLeave.
//
//                    Other methods that should be implemented in all Widget 
//                    classes are CreateObject, which should be static, 
//                    Initialize, and ResetProperties.  See CWidget for
//                    more information about each.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : MFC.
//
// Components Used  : CButton.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(_BUTTONWIDGET_H_)
#define _BUTTONWIDGET_H_

#ifdef GENERAL
#define GENERALAPI __declspec( dllexport )
#else
#define GENERALAPI __declspec( dllimport )
#endif

#include "..\core\Widget.h"

#include "resource.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ButtonWidget.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CButtonWidget window

class GENERALAPI CButtonWidget : public CButton, public CWidget
{
protected:
    CBitmap*                    m_pBMP;
    CDC*                        m_pDC;

    virtual void InitReinit();

// Construction
public:
	CButtonWidget();

// Attributes
public:
  	enum { IDB = IDB_BUTTON_WIDGET };

// Operations
protected:
    BOOL TrackMouseEvent(LPTRACKMOUSEEVENT ptme);
public:
    virtual void Draw();
    virtual void ResetProperties();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CButtonWidget)
	protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CButtonWidget();

	// Generated message map functions
protected:
	//{{AFX_MSG(CButtonWidget)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnWindowPosChanged(WINDOWPOS FAR* lpwndpos);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnPaint();
	afx_msg HBRUSH CtlColor(CDC* pDC, UINT nCtlColor);
	//}}AFX_MSG
    afx_msg long OnMouseLeave(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_BUTTONWIDGET_H_)
