// ButtonWidget.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "..\core\UpdateList.h"
#include "ButtonWidget.h"
#include "..\core\ColorPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID CALLBACK TrackMouseTimerProc(HWND hWnd,UINT uMsg, UINT idEvent, 
                                  DWORD dwTime) 
{
    RECT rect;      
    POINT pt;      
    GetClientRect(hWnd,&rect);

    MapWindowPoints(hWnd,NULL,(LPPOINT)&rect,2);      
    GetCursorPos(&pt);
      
    if (!PtInRect(&rect,pt) || (WindowFromPoint(pt) != hWnd)) 
    {
        if (!KillTimer(hWnd,idEvent)) 
        {            // Error killing the timer!
        }         
        PostMessage(hWnd,WM_MOUSELEAVE,0,0);      
    }  
    else
        PostMessage(hWnd,WM_MOUSEHOVER,0,0);      
}   

BOOL CButtonWidget::TrackMouseEvent(LPTRACKMOUSEEVENT ptme) 
{
    if (!ptme || ptme->cbSize < sizeof(TRACKMOUSEEVENT)) 
    {
        OutputDebugString(TEXT("TrackMouseEvent: invalid "
                        "TRACKMOUSEEVENT structure\n"));
        return FALSE;      
    }      
    
    if (!IsWindow(ptme->hwndTrack)) 
    {
        OutputDebugString(TEXT("TrackMouseEvent: invalid hwndTrack\n"));         
        return FALSE;
    }      
    
    if (!(ptme->dwFlags & TME_LEAVE)) 
    {
        OutputDebugString(TEXT("TrackMouseEvent: invalid dwFlags\n"));
        return FALSE;      
    }
    return SetTimer(ptme->dwFlags, 100, (TIMERPROC)TrackMouseTimerProc);   
}

/////////////////////////////////////////////////////////////////////////////
// CButtonWidget
CButtonWidget::CButtonWidget() : CWidget()
{
    m_stlStrWidgetName = _FSI_STL::string("Button");

    AddColorPage();

    // Must be set once for InitReinit to work correctly.
    m_pBMP  = NULL;
    m_pDC   = NULL;

    CButtonWidget::InitReinit();
}

void CButtonWidget::InitReinit()
{
    if (m_pBMP != NULL)
    {
        if (m_pBMP->GetSafeHandle() != NULL)
        {
            m_pBMP->DeleteObject();
        }

        delete m_pBMP;
    }

    m_pBMP = new CBitmap();

    if (m_pDC != NULL)
    {
        if (m_pDC->GetSafeHdc() != NULL)
        {
            m_pDC->DeleteDC();
        }

        delete m_pDC;
    }

    m_pDC = new CDC();
}


CButtonWidget::~CButtonWidget()
{
//    if (m_bEditing == false)
//    {
//        _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
//        _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
//        while (lIt != lendIt)
//        {
//            (*lIt)->OnUnload();
//            lIt++;
//        }
//    }

    if (m_pBMP != NULL)
    {
        if (m_pBMP->GetSafeHandle() != NULL)
        {
            m_pBMP->DeleteObject();
        }

        delete m_pBMP;
    }

    if (m_pDC != NULL)
    {
        if (m_pDC->GetSafeHdc() != NULL)
        {
            m_pDC->DeleteDC();
        }

        delete m_pDC;
    }
}


BEGIN_MESSAGE_MAP(CButtonWidget, CButton)
	//{{AFX_MSG_MAP(CButtonWidget)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONDBLCLK()
	ON_WM_SETCURSOR()
	ON_WM_LBUTTONUP()
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_RBUTTONUP()
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_CTLCOLOR_REFLECT()
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_MOUSELEAVE, OnMouseLeave)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CButtonWidget message handlers
void CButtonWidget::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
        CWidget::Track(point);
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (nFlags & MK_LBUTTON)
        {
            if (m_bLButtonDown != true)
            {
                m_bRedraw = true;
                m_bLButtonDown = true;
            }
        }
        else
        {
            if (m_bLButtonDown != false)
            {
                m_bRedraw = true;
                m_bLButtonDown = false;
            }
        }
    }
}

void CButtonWidget::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	OnLButtonDown(nFlags, point);
}

BOOL CButtonWidget::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
    if (m_bEditing == true && m_pTracker != NULL)
    {
        if (pWnd == this && m_pTracker->SetCursor(pWnd, nHitTest))
        {
            return TRUE;
        }
    }
	
	return CButton::OnSetCursor(pWnd, nHitTest, message);
}

void CButtonWidget::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (m_bEditing == true)
    {
    }
    else
    {
        if (m_bFocus != true)
        {
	        m_bFocus = true;
            m_bRedraw = true;
        }

        if (m_bLButtonDown != false)
        {
            m_bRedraw = true;
            m_bLButtonDown = false;
        }

        if (m_bEditing == false)
        {
            _FSI_STL::list<CAction*>::iterator lIt = m_listActions.begin();
            _FSI_STL::list<CAction*>::iterator lendIt = m_listActions.end();
            while (lIt != lendIt)
            {
                (*lIt)->OnLButtonUp();
                lIt++;
            }
        }
    }
}


void CButtonWidget::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CButton::OnWindowPosChanged(lpwndpos);

    CWidget::PosChanged(CRect(lpwndpos->x, lpwndpos->y,
                              lpwndpos->x + lpwndpos->cx,
                              lpwndpos->y + lpwndpos->cy));
}

BOOL CButtonWidget::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
    NMHDR* pHdr = (NMHDR*)lParam;
    CWnd* pWnd = FromHandle(pHdr->hwndFrom);
    CPoint ptCursor;
    GetCursorPos(&ptCursor);
    ScreenToClient(&ptCursor);
    if (IsChild(pWnd))
    {
        switch(pHdr->code)
        {
        case WM_LBUTTONDOWN:
            {
                OnLButtonDown(MK_LBUTTON,ptCursor);
                return TRUE;
            }
            break;
        case WM_LBUTTONUP:
            {
                OnLButtonUp(MK_LBUTTON,ptCursor);
                return TRUE;
            }
            break;
        };
    }
	
	return CButton::OnNotify(wParam, lParam, pResult);
}

void CButtonWidget::OnRButtonUp(UINT nFlags, CPoint point) 
{
    CWidget::RButtonUp(nFlags, point);
}

void CButtonWidget::OnMouseMove(UINT nFlags, CPoint point) 
{
    if (m_bFocus != true)
    {
        TRACKMOUSEEVENT tme;  

        tme.cbSize      = sizeof(TRACKMOUSEEVENT); 
        tme.dwFlags     = TME_LEAVE; 
        tme.hwndTrack   = GetSafeHwnd();  
        TrackMouseEvent(&tme); 
	    m_bFocus = true;
        m_bRedraw = true;
    }

    if (nFlags & MK_LBUTTON)
    {
        if (m_bLButtonDown != true)
        {
            m_bRedraw = true;
            m_bLButtonDown = true;
        }
    }
    else
    {
        if (m_bLButtonDown != false)
        {
            m_bRedraw = true;
            m_bLButtonDown = false;
        }
    }

	CButton::OnMouseMove(nFlags, point);
}

long CButtonWidget::OnMouseLeave(WPARAM wParam, LPARAM lParam)
{
    m_bFocus = false;
    m_bLButtonDown = false;
//    if (m_bEditing == false)
    {
//        Invalidate(FALSE);
    }
    
    return 0;
}

BOOL CButtonWidget::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

void CButtonWidget::OnPaint() 
{
    HWND hWnd = BaseWidget()->Wnd()->GetParent()->GetSafeHwnd();
//    if (CWidget::ScreenRedrawing(hWnd) == true)
//    {
//        CButton::OnPaint();
//        OutputDebugString("OnPaint called while screen can draw!!!!!\n");
//    }
//    else
//    {
        m_bRepaint = true;

        CUpdateList::AddPaintWidget(hWnd, this);
        CRect rect(0, 0, m_exPtLowerRight.X() - m_exPtUpperLeft.X(), m_exPtLowerRight.Y() - m_exPtUpperLeft.Y());
        ValidateRect(rect);

        _FSI_STL::list<CWidget*>::iterator wIt  = NULL;
        CWidget* pSubWidget                     = GetNextSubWidget(wIt);
        CButtonWidget* pButtonWidget            = NULL;
        while (pSubWidget != NULL)
        {
            pButtonWidget = dynamic_cast<CButtonWidget*>(pSubWidget);
            if (pButtonWidget != NULL)
            {
                pButtonWidget->OnPaint();
            }
            else
            {
                CUpdateList::AddPaintWidget(hWnd, pSubWidget);
            }
            pSubWidget = GetNextSubWidget(wIt);
        }
//    }
}

HBRUSH CButtonWidget::CtlColor(CDC* pDC, UINT nCtlColor) 
{
    CBrush brush;
    brush.CreateStockObject(NULL_BRUSH);
	return (HBRUSH)brush.GetSafeHandle();
}

void CButtonWidget::Draw()
{
    if (m_bDrawThisPass == true)
    {
        m_bDrawThisPass = false;
    
        if (IsWindowEnabled() == TRUE  && m_bEnabled == false ||
            IsWindowEnabled() == FALSE && m_bEnabled == true)
        {
            m_bRepaint = true;

            SetRedraw(FALSE);
            EnableWindow(m_bEnabled);
            SetRedraw(TRUE);
        }

        if ((IsWindowVisible()?true:false) != m_bDisplay)
        {
           ShowWindow(m_bDisplay);
        }

        DRAWITEMSTRUCT dwi;
        memset(&dwi, 0, sizeof(dwi));
        dwi.CtlType = ODT_BUTTON;
        dwi.CtlID   = m_lID;
        dwi.hDC     = ::GetDC(GetSafeHwnd());
        dwi.rcItem.left  = 0;
        dwi.rcItem.right = m_exPtLowerRight.X() - m_exPtUpperLeft.X();
        dwi.rcItem.top   = 0;
        dwi.rcItem.bottom = m_exPtLowerRight.Y() - m_exPtUpperLeft.Y();
        CRect rect(dwi.rcItem);

        DrawItem(&dwi);

        ::ReleaseDC(GetSafeHwnd(), dwi.hDC);
    }
}

void CButtonWidget::ResetProperties()
{
   CWidget::ResetProperties();
   CWidget::ExtentsProperties();

   CXMLElement* pXMLElement    = NULL;
   POSITION pos                = NULL;
   STRING2STRING_MAP::iterator s2sIt;
   _FSI_STL::string stlStrGlobalColor;
   CString strValue;
   CString strUpr;
   _FSI_STL::string stlStrUpr;

   // Get all of the color data
   STRING_LIST::iterator lIt   = m_listColorSelectable.begin();
   STRING_LIST::iterator lendIt = m_listColorSelectable.end();
   while (lIt != lendIt)
   {
      if (m_pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("COLOR")) == true)
      {
         // If no GLOBALCOLOR, then colorGlobal should have its default
         // settings.
         CColor colorGlobal;

         strValue    = pXMLElement->ElementValue().c_str();

         // Get the GLOBALCOLOR data or create a new attribute for it.
         if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GLOBALCOLOR")) == true)
         {
             stlStrGlobalColor = (*s2sIt).second;
             colorGlobal = CColor::GlobalColor(CString((*s2sIt).second.c_str()));
         }
         else
         {
             pXMLElement->AddAttribute(_FSI_STL::string("GLOBALCOLOR"),
                                       _FSI_STL::string("Not Used"));
         }

         // Get the PLANE data or create a new attribute for it.
         if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("PLANE")) == true)
         {
             strUpr = (*s2sIt).second.c_str();
             strUpr.MakeUpper();

             stlStrUpr = _FSI_STL::string((LPCTSTR)strUpr);

             m_mapColorSelectables[stlStrUpr].s_color = CColor(strValue);
             m_mapColorSelectables[stlStrUpr].s_color_cv = CColor(strValue);

             if (stlStrGlobalColor != "Not Used")
             {
                 m_mapColorSelectables[stlStrUpr].s_color = colorGlobal;
                 m_mapColorSelectables[stlStrUpr].s_color_cv = colorGlobal;
             }
         }
         else
         {
             pXMLElement->AddAttribute(_FSI_STL::string("PLANE"), _FSI_STL::string("UNKNOWN"));
         }
      }

      lIt++;
   }

   lIt = m_listColorSelectable.begin();

   // Put in any colors that are in the list but were not int
   // the XML file.
   while (lIt != lendIt)
   {
      strUpr = (*lIt).c_str();
      strUpr.MakeUpper();

      stlStrUpr = _FSI_STL::string((LPCTSTR)strUpr);
      if (m_mapColorSelectables.find(stlStrUpr) == m_mapColorSelectables.end())
      {
         STRING2STRING_MAP* mapS2S = new STRING2STRING_MAP;
         (*mapS2S)["GLOBALCOLOR"] = "Not Used";

         // color attribute was not in the map but is in the list--add it.
         m_mapColorSelectables[stlStrUpr] = ColorsWithChangeValue();

         strValue.Format("%03d%03d%03d", m_mapColorSelectables[(*lIt)].s_color.Red(), 
                                   m_mapColorSelectables[(*lIt)].s_color.Green(),
                                   m_mapColorSelectables[(*lIt)].s_color.Blue());

         (*mapS2S)["PLANE"] = stlStrUpr;

         m_pXMLWidget->AddElement(_FSI_STL::string("COLOR"), 
                                  _FSI_STL::string((LPCTSTR)strValue),
                                  mapS2S);
      }

      lIt++;
   }
}