// AirspeedSlewAction.cpp: implementation of the CAirspeedSlewAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "ComboWidget.h"
#include "AirspeedSlewAction.h"
#include "..\comms\CommsShared.h"
#include "WorkingDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAirspeedSlewAction::CAirspeedSlewAction()
{
   m_stlStrWidgetName = _FSI_STL::string("AirspeedSlew");
}


CAirspeedSlewAction::~CAirspeedSlewAction()
{
}


void CAirspeedSlewAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, const long lId, bool bEditMode)
{
   if (rpXMLWidget == NULL)
   {
      m_stlStrName   =  m_stlStrWidgetName.c_str()  +  CString(" Action");
   }

   CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

   if (rpXMLWidget != NULL)
   {
      ResetProperties();
   }

   m_pAction = this;
   m_pWidget = (CWidget*)this;

   if (!m_bEditing)
      OnUpdate();
}


CWidget* CAirspeedSlewAction::CreateObject()
{
   return   new   CAirspeedSlewAction();
}


enum LButtonUpReturn CAirspeedSlewAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CVariant CVar_currentLatitude;
   CCommsShared::GetHostValue(CVar_currentLatitude,   _FSI_STL::string("ac_latitude"));

   CVariant CVar_currentLongitude;
   CCommsShared::GetHostValue(CVar_currentLongitude,  _FSI_STL::string("ac_longitude"));


   CVariant CVar_repositionLatitude;
   CCommsShared::GetHostValue(CVar_repositionLatitude,   _FSI_STL::string("Reposition_Latitude"));

   CVariant CVar_repositionLongitude;
   CCommsShared::GetHostValue(CVar_repositionLongitude,  _FSI_STL::string("Reposition_Longitude"));


   CVar_repositionLatitude    =  CVar_currentLatitude;
   CCommsShared::SetHostValue(CVar_repositionLatitude, _FSI_STL::string("Reposition_Latitude"), 0);

   CVar_repositionLongitude   =  CVar_currentLongitude;
   CCommsShared::SetHostValue(CVar_repositionLongitude, _FSI_STL::string("Reposition_Longitude"), 0);


   CVariant CVar_repositionSelect;
   CCommsShared::GetHostValue(CVar_repositionSelect,     _FSI_STL::string("Reposition_Select"));


   CVar_repositionSelect.Value(20L);
   CCommsShared::SetHostValue(CVar_repositionSelect, _FSI_STL::string("Reposition_Select"), 0);

   m_pParentWidget->Wnd()->Invalidate();

   m_sync.Unlock();
   return   LBU_OK;
}


void  CAirspeedSlewAction::ResetProperties()
{
   CWidget::ResetProperties();
}

