// TimsInterface.h: interface for the CTimsInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TIMSINTERFACE_H__FF3F2EC5_249A_4F07_8B0C_300A28D9A9B6__INCLUDED_)
#define AFX_TIMSINTERFACE_H__FF3F2EC5_249A_4F07_8B0C_300A28D9A9B6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SchedEventRec.h"
#include "StudentRec.h"
#include "SyllabusRec.h"
#include <afxtempl.h>
#include <comdef.h>

class CTimsInterface  
{
public:
	void GetTrainingOrgs();
	bool m_bTIMSDown;
	void GetSorties();
	void SetTestMode(int nMode);
   enum { TEST_NONE     = 0,
          TEST_EVENTS   = 1 << 0,
          TEST_STUDENTS = 1 << 1,
          TEST_SORTIES  = 1 << 2,
   };

	//int m_nEventCount;
	CTimsInterface();
	virtual ~CTimsInterface();
   void GetEvents();
   void GetStudents(CString TrainingOrgName);

   CArray< CSchedEventRec, CSchedEventRec& > m_EventList;
   CArray< CString,        CString&        > m_TrainingOrgList;
   CArray< CStudentRec,    CStudentRec&    > m_StudentList;
   CArray< CSyllabusRec,   CSyllabusRec&   > m_SyllabusList;
   CArray< CString,        CString&        > m_SortieList;
   
private:
	void GetSyllabusList();
	int m_nTestMode;
   void DumpError(_com_error &e);
};

#endif // !defined(AFX_TIMSINTERFACE_H__FF3F2EC5_249A_4F07_8B0C_300A28D9A9B6__INCLUDED_)
