// TimsInterface.cpp: implementation of the CTimsInterface class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ftdplanningapp.h"
#include "TimsInterface.h"
#include "FTDPlanningAppDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTimsInterface::CTimsInterface()
{
   m_nTestMode = TEST_NONE;
   m_bTIMSDown = false;
}

CTimsInterface::~CTimsInterface()
{

}


void CTimsInterface::GetEvents() 
{
   //   m_nEventCount = 0;

      if (!m_nTestMode & TEST_EVENTS)
       {
         try
         {
            SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
            
            // The following is not necessary, but can make debugging easier
            //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
            
               // Use the SimProfile COM object
               _RecordsetPtr ADORecSetPtr;
               HRESULT hr = p->GetSchedEvents( (SIMPROFILELib::_Recordset**)&ADORecSetPtr );

               if( SUCCEEDED(hr) )
               {
                   short bEOF = NULL;

                   if (!ADORecSetPtr->adoEOF)
                   {
                       ADORecSetPtr->MoveFirst();
                   }

                   while( !bEOF )
                   {
                      CSchedEventRec eventRec;

                       // Get fields from recordset
                       HRESULT hr;
                       _variant_t vVar;
                       _bstr_t bstrItemBuffer = " ";

                       // 0: Instructor Name
                       hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar );

                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt == VT_BSTR )
                              eventRec.InstructorName = vVar.bstrVal;
                       }

                       // 1: Student Name
                       hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt == VT_BSTR )
                              eventRec.StudentName = vVar.bstrVal;
                       }

                       // 2: Event ID
                       hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt == VT_BSTR )
                              eventRec.EventID = vVar.bstrVal;
                       }

                       // 3: Sortie File
                       hr = ADORecSetPtr->get_Collect( variant_t((long)3), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt == VT_BSTR )
                              eventRec.SortieFile = vVar.bstrVal;
                       }

                       // 4: Start Time
                       hr = ADORecSetPtr->get_Collect( variant_t((long)4), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt != VT_EMPTY )
                           {
                              COleDateTime dt = vVar.date;
                              eventRec.StartTime = dt.Format("%y-%m-%d   %H:%M");
                           }
                       }

                       // 5: Duration
                       hr = ADORecSetPtr->get_Collect( variant_t((long)5), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt != VT_EMPTY )
                           {
                              char cTmp[10];
                              float fTmp = ((float)vVar.intVal)/10000;
                              _gcvt( fTmp, 4, cTmp );
                              eventRec.Duration = cTmp;
                           }
                       }                   

                       // 6: End Time
                       hr = ADORecSetPtr->get_Collect( variant_t((long)6), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt != VT_EMPTY )
                           {
                              COleDateTime dt = vVar.date;
                              eventRec.EndTime = dt.Format("%y-%m-%d   %H:%M");
                           }
                       }      
                    
                       // 7: Device
                       hr = ADORecSetPtr->get_Collect( variant_t((long)7), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt == VT_BSTR )
                              eventRec.Device = vVar.bstrVal;
                       } 

                       // 8: Student's Logon ID
                       hr = ADORecSetPtr->get_Collect( variant_t((long)8), &vVar );
                       if( vVar.vt != VT_NULL )
                       {
                           if( vVar.vt == VT_BSTR )
                              eventRec.StudentLogonID = vVar.bstrVal;
                       }

                       m_EventList.Add(eventRec);

                       ADORecSetPtr->MoveNext();
                       bEOF = ADORecSetPtr->adoEOF;
                   }
               }
         }
         catch(_com_error& e )
         {
            if (e.Error() == 0x8000FFFF)
            {
               ::MessageBox( NULL, "TIMS is unavailable or mis-configured on this computer.", _T("TIMS Interface Catastrophic Failure"), MB_ICONEXCLAMATION|MB_OK );
               m_bTIMSDown = true;
            }
            else if (e.Error() == 0x800a0bcd)
            {
               //::MessageBox( NULL, "No scheduled FTD events were found for this instructor.    ", _T("Attention"), MB_ICONEXCLAMATION|MB_OK );
            }
           else
               DumpError(e);
         }
      }
      else
         { 

         CSchedEventRec eventRec;

         // Dummy database for offline testing

         eventRec.InstructorName = "Instructor, I.R.";
         eventRec.Device         = "OFT #1";
         eventRec.Duration       = "1.0";
         eventRec.EndTime        = "01/27/00  09:00";
         eventRec.EventID        = "I1001";
         eventRec.SortieFile     = "I1001";
         eventRec.StartTime      = "01/27/00  08:00";
         eventRec.StudentName    = "Baker, B.";
         eventRec.StudentLogonID = "bbaker";
         m_EventList.Add(eventRec);

         eventRec.InstructorName = "Instructor, I.R.";
         eventRec.Device         = "IFT #1";
         eventRec.Duration       = "1.0";
         eventRec.EndTime        = "01/27/00  10:00";
         eventRec.EventID        = "B1002";
         eventRec.SortieFile     = "B1002";
         eventRec.StartTime      = "01/27/00  09:00";
         eventRec.StudentName    = "Callahan, C.";
         eventRec.StudentLogonID = "ccallaha";
         m_EventList.Add(eventRec);

         eventRec.InstructorName = "Instructor, I.R.";
         eventRec.Device         = "UTD #1";
         eventRec.Duration       = "1.0";
         eventRec.EndTime        = "01/27/00  11:00";
         eventRec.EventID        = "I3001";
         eventRec.SortieFile     = "I3001";
         eventRec.StartTime      = "01/27/00  10:00";
         eventRec.StudentName    = "Dardenne, D.";
         eventRec.StudentLogonID = "ddardenn";
         m_EventList.Add(eventRec);
      }
}


void CTimsInterface::DumpError(_com_error &e)
{
    CString str;
   _bstr_t bstrSource( e.Source() );
   _bstr_t bstrDescription( e.Description() );

    //m_iQuery = 0;


    switch( e.Error() )
    {
    case 0x800a0bcd:
       ::MessageBox( NULL, "No records found", _T("Error"), MB_OK );
        break;
    
    case 0x80040e14: // Connection failed or error in sql
       ::MessageBox( NULL, "Database connection failed", _T("Error"), MB_OK );
        break;

    default:
       str.Format( "\tCode = %08lx", e.Error() );
       str += " ErrMsg: "; str += e.ErrorMessage();
       str += " Source: "; str += bstrSource;
       str += " Description: "; str += bstrDescription;
      AfxMessageBox( str );
        break;
    }
}


void CTimsInterface::SetTestMode(int nMode)
{
   m_nTestMode = nMode;
}



void CTimsInterface::GetStudents(CString TrainingOrgName)
{
   if (!(m_nTestMode & TEST_STUDENTS))
   {
      ///////////////////////////////////////////////////////////////////////////
      //
      // For the supplied training organization, get the list of students and their id's

       _bstr_t m_bstrParameter = TrainingOrgName;

      int nTrainingOrgs;

      if (TrainingOrgName == (CString)"ALL TRAINING ORGS")
         nTrainingOrgs = m_TrainingOrgList.GetSize();
      else
         nTrainingOrgs = 1;

      for (int i=0; i<nTrainingOrgs; i++)
      {

       m_StudentList.RemoveAll();

       try
       {
           SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
          
          // The following is not necessary, but can make debugging easier
          //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
          
           // Use the SimProfile COM object
           _RecordsetPtr ADORecSetPtr;
           HRESULT hr = p->GetStudents( (SIMPROFILELib::_Recordset**)&ADORecSetPtr, m_bstrParameter );

           if( SUCCEEDED(hr) )
           {
               short bEOF = NULL;

               if (!ADORecSetPtr->adoEOF)
               {
                   ADORecSetPtr->MoveFirst();
               }

               while( !bEOF )
               {
                   CStudentRec studentRec;

                   // Get fields from recordset
                   HRESULT hr;
                   _variant_t vVar0;
                   _variant_t vVar1;
                   _variant_t vVar2;
                   _variant_t vVar3;
                   _variant_t vVar4;
                   _variant_t vVar5;
                   _variant_t vVar6;

                   CString strBuffer;

                   // STUDENT
                   hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );
                   if( vVar0.vt != VT_NULL )
                   {
                       if( vVar0.vt == VT_BSTR )
                       {
                           studentRec.m_Name = vVar0.bstrVal;
                           studentRec.m_OrgName = m_TrainingOrgList[i];
                       }
                   }

                   // SSN
                   hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                   if( vVar1.vt != VT_NULL )
                   {
                       if( vVar1.vt == VT_BSTR )
                       {
                           studentRec.m_ID = vVar1.bstrVal;
                           studentRec.m_ID.Remove('-');
                       }
                   }

                   /*
                   // RESOUCE ID
                   hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar2 );
                   if( vVar2.vt != VT_NULL )
                   {
                       if( vVar2.vt != VT_EMPTY )
                       {
                           int iTmp = vVar2.intVal;
                           char cTmp[10];
                           itoa( iTmp, cTmp, 10 );
                           strBuffer += cTmp;
                           strBuffer += " | ";
                       }
                   }

                   // SYLLABUS ID
                   hr = ADORecSetPtr->get_Collect( variant_t((long)3), &vVar3 );
                   if( vVar3.vt != VT_NULL )
                   {
                       if( vVar3.vt != VT_EMPTY )
                       {
                           int iTmp = vVar3.intVal;
                           char cTmp[10];
                           itoa( iTmp, cTmp, 10 );
                           strBuffer += cTmp;
                           strBuffer += " | ";
                       }
                   }

                
                   // ACTTIME
                   hr = ADORecSetPtr->get_Collect( variant_t((long)4), &vVar4 );
                   if( vVar4.vt != VT_NULL )
                   {
                       if( vVar4.vt != VT_EMPTY )
                       {
                           COleDateTime dt = vVar4.date;
                           CString strTmp = dt.Format("%H:%M");
                           strBuffer += strTmp;
                           strBuffer += " | ";
                       }
                   }

                   // NOTACTTIME
                   hr = ADORecSetPtr->get_Collect( variant_t((long)5), &vVar5 );
                   if( vVar5.vt != VT_NULL )
                   {
                       if( vVar5.vt != VT_EMPTY )
                       {
                           COleDateTime dt = vVar5.date;
                           CString strTmp = dt.Format("%H:%M");
                           strBuffer += strTmp;
                           strBuffer += " | ";
                       }
                   } */

                   // Student Logon ID
                   hr = ADORecSetPtr->get_Collect( variant_t((long)6), &vVar6 );
                   if( vVar6.vt != VT_NULL )
                   {
                       if( vVar6.vt == VT_BSTR )
                       {
                           studentRec.m_LogonID = vVar6.bstrVal;
                       }
                   }

                   m_StudentList.Add( studentRec );

                   // Move pointer to next
                   ADORecSetPtr->MoveNext();
                   bEOF = ADORecSetPtr->adoEOF;
               }
           }
       }
      catch( _com_error &e )
       {
         if (e.Error() == 0x8000FFFF && m_bTIMSDown)
         {
            // do nothing if we already detected TIMS is down
         }
         else if (e.Error() == 0x800a0bcd)
         {
            //::MessageBox( NULL, "No students were returned by TIMS for\ntraining organization \"" + m_TrainingOrgList[i]+"\"" , _T("Attention"), MB_ICONEXCLAMATION|MB_OK );
         }
         else
            DumpError(e);
       }
     }
   }
   else // fake db, add students that belong to given training org name
   {
      CStudentRec studentRec;

      m_StudentList.RemoveAll();

      studentRec.m_Name    = "Abdelrahman, A.";
      studentRec.m_ID      = "111111111";
      studentRec.m_OrgName = "Engineering";
      studentRec.m_LogonID = "aabdelra";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Baker, B.";
      studentRec.m_ID      = "222222222";
      studentRec.m_OrgName = "Engineering";
      studentRec.m_LogonID = "bbaker";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Callahan, C.";
      studentRec.m_ID      = "333333333";
      studentRec.m_OrgName = "Engineering";
      studentRec.m_LogonID = "ccallaha";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Dardenne, D.";
      studentRec.m_ID      = "444444444";
      studentRec.m_OrgName = "Logistics";
      studentRec.m_LogonID = "ddardenn";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Easley, E.";
      studentRec.m_ID      = "555555555";
      studentRec.m_OrgName = "Logistics";
      studentRec.m_LogonID = "eeasley";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Farmer, F.";
      studentRec.m_ID      = "666666666";
      studentRec.m_OrgName = "Logistics";
      studentRec.m_LogonID = "ffarmer";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Lawson, M.";
      studentRec.m_ID      = "777777777";
      studentRec.m_OrgName = "D64GIS";
      studentRec.m_LogonID = "mikel";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);

      studentRec.m_Name    = "Brissey, C.";
      studentRec.m_ID      = "888888888";
      studentRec.m_OrgName = "D64GIS";
      studentRec.m_LogonID = "brisseyc";
      if (studentRec.m_OrgName == TrainingOrgName ||
         TrainingOrgName == (CString)"ALL TRAINING ORGS")
         m_StudentList.Add(studentRec);
   }

}


void CTimsInterface::GetSyllabusList()
{
   m_SyllabusList.RemoveAll();

   CSyllabusRec sylRec;

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
       
       // The following is not necessary, but can make debugging easier
       //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
       
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetProdSyl( (SIMPROFILELib::_Recordset**)&ADORecSetPtr );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                _variant_t vVar2;
                CString strBuffer;

                // NAME
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );

                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                        sylRec.Name = vVar0.bstrVal;
                    }
                }
            
                // VERSION
                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        sylRec.Version = vVar1.bstrVal;
                    }
                }

                // SYLID
                hr = ADORecSetPtr->get_Collect( variant_t((long)2), &vVar2 );
                if( vVar2.vt != VT_NULL )
                {
                    if( vVar2.vt != VT_EMPTY )
                    {
                        int iTmp = vVar2.intVal;
                        char cTmp[10];
                        itoa( iTmp, cTmp, 10 );
                        sylRec.SyllabusID = cTmp;
                    }
                }

                m_SyllabusList.Add( sylRec );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
        }
    }
   catch( _com_error &e )
    {
       if (e.Error() == 0x8000FFFF && m_bTIMSDown)
         {
            // do nothing if we already detected TIMS is down
         }
       else if (e.Error() == 0x800a0bcd)
       {
         ::MessageBox( NULL, "No syllabus versions were returned by TIMS.    ", _T("Attention"), MB_ICONEXCLAMATION|MB_OK );
       }
       else if ((e.Error() == 0x80040154) && m_nTestMode)
       {
          // do nothing; test database
       }
       else
           DumpError(e);
   }   
}

void CTimsInterface::GetSorties()
{
   m_SortieList.RemoveAll();

   if (m_nTestMode)
   {
      m_SortieList.Add(CString("TEST1"));
      m_SortieList.Add(CString("TEST2"));
      m_SortieList.Add(CString("TEST3"));
      m_SortieList.Add(CString("B1001"));
      m_SortieList.Add(CString("TEST5"));
      return;
   }

   if (m_SyllabusList.GetSize() == 0)
      GetSyllabusList();

   for (int i=0; i< m_SyllabusList.GetSize(); i++)
   {
      CString sortieFile;

      _bstr_t m_bstrParameter = m_SyllabusList[i].SyllabusID;

    try
    {
        SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
       
       // The following is not necessary, but can make debugging easier
       //HRESULT hr = p.CreateInstance( __uuidof(SIMPROFILELib::Profile) );
       
        // Use the SimProfile COM object
        _RecordsetPtr ADORecSetPtr;
        HRESULT hr = p->GetDeviceEvents( (SIMPROFILELib::_Recordset**)&ADORecSetPtr, m_bstrParameter );

        if( SUCCEEDED(hr) )
        {
            short bEOF = NULL;

            if (!ADORecSetPtr->adoEOF)
            {
                ADORecSetPtr->MoveFirst();
            }

            while( !bEOF )
            {
                // Get fields from recordset
                HRESULT hr;
                _variant_t vVar0;
                _variant_t vVar1;
                CString strBuffer;

                // SYLEVENT
                /*
                hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );

                if( vVar0.vt != VT_NULL )
                {
                    if( vVar0.vt == VT_BSTR )
                    {
                       sortieFile = vVar0.bstrVal;
                    }
                }*/
            
                // SORTIE FILE
                hr = ADORecSetPtr->get_Collect( variant_t((long)1), &vVar1 );
                if( vVar1.vt != VT_NULL )
                {
                    if( vVar1.vt == VT_BSTR )
                    {
                        sortieFile = vVar1.bstrVal;
                    }
                }

                m_SortieList.Add( sortieFile );

                // Move pointer to next
                ADORecSetPtr->MoveNext();
                bEOF = ADORecSetPtr->adoEOF;
            }
        }
    }
   catch( _com_error &e )
    {
         if (e.Error() == 0x8000FFFF && m_bTIMSDown)
         {
            // do nothing if we already detected TIMS is down
         }
         else if (e.Error() == 0x800a0bcd)
         {
            //::MessageBox( NULL, "No sortie files were returned by TIMS for\nsyllabus \"" + m_SyllabusList[i].Name+"\"" , _T("Attention"), MB_ICONEXCLAMATION|MB_OK );
         }
         else
      DumpError(e);
   }
   }
}

void CTimsInterface::GetTrainingOrgs()
{
   m_TrainingOrgList.RemoveAll();
   m_TrainingOrgList.Add((CString)"ALL TRAINING ORGS");

   if (!(m_nTestMode & TEST_STUDENTS))
   {
      ///////////////////////////////////////////////////////////////////////////
      //
      // First, get the list of training organizations /////////////////////////
   
       try
       {
           SIMPROFILELib::IProfilePtr p( __uuidof(SIMPROFILELib::Profile) );
          
           // Use the SimProfile COM object
           _RecordsetPtr ADORecSetPtr;
           HRESULT hr = p->GetOrganizations( (SIMPROFILELib::_Recordset**)&ADORecSetPtr );

           if( SUCCEEDED(hr) )
           {
               short bEOF = NULL;

               if (!ADORecSetPtr->adoEOF)
               {
                   ADORecSetPtr->MoveFirst();
               }

               while( !bEOF )
               {
                   // Get fields from recordset
                   HRESULT hr;
                   _variant_t vVar0;
                   CString strBuffer;

                   // Positional method
                   hr = ADORecSetPtr->get_Collect( variant_t((long)0), &vVar0 );

                   if( vVar0.vt != VT_NULL )
                   {
                       if( vVar0.vt == VT_BSTR )
                       {
                           strBuffer = vVar0.bstrVal;
                       }
                   }
            
                   if (strBuffer != "")
                     m_TrainingOrgList.Add(strBuffer);

                   // Move pointer to next
                   ADORecSetPtr->MoveNext();
                   bEOF = ADORecSetPtr->adoEOF;
               }
           }
       }
      catch( _com_error &e )
       {
         if (e.Error() == 0x8000FFFF && m_bTIMSDown)
         {
            // do nothing if we already detected TIMS is down
         }
         else if (e.Error() == 0x800a0bcd)
         {
            ::MessageBox( NULL, "No training organizations were returned by TIMS.    ", _T("Attention"), MB_ICONEXCLAMATION|MB_OK );
         }
         else
            DumpError(e);
      }
   }
   else
   {
      // make fake database

      m_TrainingOrgList.Add((CString)"Engineering");
      m_TrainingOrgList.Add((CString)"Logistics");
      m_TrainingOrgList.Add((CString)"D64GIS");
      m_TrainingOrgList.Add((CString)"D68CSG");
   }
}
