// RegistrySettings.cpp: implementation of the CRegistrySettings class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "RegistrySettings.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRegistrySettings::CRegistrySettings()
{
   m_bUseFakeDB = FALSE;
}

void CRegistrySettings::WriteRegistry()
{
   HKEY hKey;
   DWORD dw;

   // Phase 1:  Write keys under FTD Planning area
   RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FTD Planning"),
              0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

   if (hKey == NULL)
   {
      ::MessageBox(NULL,"User does not have appropriate permissions to write registry.  Try as Administrator.","Error: Cannot Write Registry",MB_ICONEXCLAMATION|MB_OK);
      return;
   }

   else
   {
     m_strDefaultBase.MakeUpper();

     RegSetValueEx(hKey, _T("Station Type"     ),  NULL, REG_DWORD, (BYTE*)&m_nLocation,          sizeof m_nLocation         );
     RegSetValueEx(hKey, _T("HideOptionsDialog"),  NULL, REG_DWORD, (BYTE*)&m_bHideOptionsDialog, sizeof m_bHideOptionsDialog);
     RegSetValueEx(hKey, _T("Default Base"     ),  NULL, REG_SZ,    (BYTE*)(LPCTSTR)m_strDefaultBase,  m_strDefaultBase.GetLength() + 1);     
     RegSetValueEx(hKey, _T("Sortie Master DB" ),  NULL, REG_SZ,    (BYTE*)(LPCTSTR)m_strSortieMaster, m_strSortieMaster.GetLength() + 1);     
     RegSetValueEx(hKey, _T("UseFakeDB"        ),  NULL, REG_DWORD, (BYTE*)&m_bUseFakeDB, sizeof m_bUseFakeDB);

     RegCloseKey(hKey);
   }


   // Phase 2:  Write keys under Common area

   RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\Common"),
              0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

   if (hKey == NULL)
   {
      ::MessageBox(NULL,"User does not have appropriate permissions to write registry.  Try as Administrator.","Error: Cannot Write Registry",MB_ICONEXCLAMATION|MB_OK);
      return;
   }

   else
   {
      RegSetValueEx(hKey, _T("IOS Exec Path" ), NULL, REG_SZ,   (BYTE*)(LPCTSTR)m_strIOSExecPath,  m_strIOSExecPath.GetLength()   + 1);
      RegSetValueEx(hKey, _T("IOS Options"   ), NULL, REG_SZ,   (BYTE*)(LPCTSTR)m_strIOSOptions,   m_strIOSOptions.GetLength()    + 1);
      RegSetValueEx(hKey, _T("Profile Path"  ), NULL, REG_SZ,   (BYTE*)(LPCTSTR)m_strProfilePath,  m_strProfilePath.GetLength()   + 1);
      RegSetValueEx(hKey, _T("SWS Name"      ), NULL, REG_SZ,   (BYTE*)(LPCTSTR)m_strSWSName,      m_strSWSName.GetLength()       + 1);
      RegSetValueEx(hKey, _T("Debrief Folder"), NULL, REG_SZ,   (BYTE*)(LPCTSTR)m_strDebriefFolder,m_strDebriefFolder.GetLength() + 1);
      
      RegCloseKey(hKey);
   }
}


void CRegistrySettings::ReadRegistry()
{
    HKEY hKey;
    unsigned long int ulData = 0;
    DWORD dwSize = sizeof (unsigned long int);
    DWORD dwType, dwCount;
    CString strValue;
    LONG lResult;

    // Phase 1:  Read keys under FTD Planning tree

    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FTD Planning"), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
      // get station type
      RegQueryValueEx(hKey, _T("Station Type"),      NULL, NULL, (BYTE*)&m_nLocation, &dwSize);

      // get hideOptionsDialog boolean
      RegQueryValueEx(hKey, _T("HideOptionsDialog"), NULL, NULL, (BYTE*)&ulData,      &dwSize);
      m_bHideOptionsDialog = (ulData != FALSE);

      // get default base ID
      lResult = RegQueryValueEx(hKey, _T("Default Base"), 
                                    NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("Default Base"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strDefaultBase = strValue;
      }



      // get sortie master db
      lResult = RegQueryValueEx(hKey, _T("Sortie Master DB"), NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("Sortie Master DB"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strSortieMaster = strValue;
      }


      // get test database flag for offline testing
      if (RegQueryValueEx(hKey, _T("UseFakeDB"), NULL, NULL, (BYTE*)&ulData,  &dwSize) == ERROR_SUCCESS)
         m_bUseFakeDB = (ulData != FALSE);
      else
         m_bUseFakeDB = FALSE;



      RegCloseKey(hKey);
    }



    // Phase 2:  Read keys under Common tree

    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\Common"), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {

      //get ios exec path
      lResult = RegQueryValueEx(hKey, _T("IOS Exec Path"), 
                                    NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("IOS Exec Path"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strIOSExecPath = strValue;
      }


      //get ios exec path
      lResult = RegQueryValueEx(hKey, _T("IOS Options"), 
                                    NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("IOS Options"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strIOSOptions = strValue;
      }


      // get event profile path
      lResult = RegQueryValueEx(hKey, _T("Profile Path"), 
                                    NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("Profile Path"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strProfilePath = strValue;
      }


      // get SWS name
      lResult = RegQueryValueEx(hKey, _T("SWS Name"), 
                                    NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("SWS Name"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strSWSName = strValue;
      }


      // get debrief folder name
      lResult = RegQueryValueEx(hKey, _T("Debrief Folder"), 
                                    NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("Debrief Folder"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
         strValue.ReleaseBuffer();
         m_strDebriefFolder = strValue;
      }


      RegCloseKey(hKey);

      }


   // Phase 3: Read keys under FSISuite\Comms tree

   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Comms"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get SWS name
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("DebriefOutput"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("DebriefOutput"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_strDebriefSource   =  strValue;
      m_strDebriefSource   =  m_strDebriefSource.Left(m_strDebriefSource.ReverseFind('.'));

      RegCloseKey(hKey);
   }

   // Phase 4: Read keys under FSISuite\IOS tree

   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\IOS"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get sorite editor exec path
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("SORTIE_EDIT"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("SORTIE_EDIT"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      //m_strSortieEditExecPath   =  '"' + strValue + "\\sortieedit.exe\"";
      m_strSortieEditExecPath   =  strValue + "\\sortieedit.exe";

      RegCloseKey(hKey);
   }


   // Phase 5: Read keys under FSISuite\Sortie Files

   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Sortie Files"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get sorite editor exec path
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("SORTIE_DB"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("SORTIE_DB"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_strIOSSortiePath  =  strValue;


      RegCloseKey(hKey);
   }



}
