// OptionsDialog.cpp : implementation file
//

#include "stdafx.h"
#include "FTDPlanningApp.h"
#include "OptionsDialog.h"
#include "RegistrySettings.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionsDialog dialog

extern CRegistrySettings theRegistry;


COptionsDialog::COptionsDialog(CWnd* pParent /*=NULL*/)
	: CDialog(COptionsDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionsDialog)
	m_bHideOptionsDialog = FALSE;
	m_strIOSExecPath = _T("");
	m_strSWSName = _T("");
	m_nLocation = -1;
	m_strProfilePath = _T("");
	m_strDefaultBase = _T("");
	m_strDebriefFolder = _T("");
	m_strIOSOptions = _T("");
	m_strSortieMaster = _T("");
	m_bUseFakeDB = FALSE;
	//}}AFX_DATA_INIT
}


void COptionsDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionsDialog)
	DDX_Check(pDX, IDC_HIDE_OPTIONS_CHECK, m_bHideOptionsDialog);
	DDX_Text(pDX, IDC_IOS_PATH_EDIT, m_strIOSExecPath);
	DDX_Text(pDX, IDC_SWS_NAME_EDIT, m_strSWSName);
	DDX_Radio(pDX, IDC_LOCATION_RADIO1, m_nLocation);
	DDX_Text(pDX, IDC_EVENT_PATH_EDIT, m_strProfilePath);
	DDX_Text(pDX, IDC_BASE_EDIT, m_strDefaultBase);
	DDX_Text(pDX, IDC_DEBRIEF_FOLDER_EDIT, m_strDebriefFolder);
	DDX_Text(pDX, IDC_IOS_EXEC_OPTIONS_EDIT, m_strIOSOptions);
	DDX_Text(pDX, IDC_SORTIE_MASTER_EDIT, m_strSortieMaster);
	DDX_Check(pDX, IDC_USE_DEBUG_CHECK, m_bUseFakeDB);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionsDialog, CDialog)
	//{{AFX_MSG_MAP(COptionsDialog)
	ON_BN_CLICKED(IDC_LOCATION_RADIO1, SelectIOS)
	ON_BN_CLICKED(IDC_LOCATION_RADIO2, SelectRIS)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionsDialog message handlers


BOOL COptionsDialog::OnInitDialog() 
{
   CDialog::OnInitDialog();

   theRegistry.ReadRegistry();

   m_nLocation           = theRegistry.m_nLocation;
   m_bHideOptionsDialog  = theRegistry.m_bHideOptionsDialog;
   m_strIOSExecPath      = theRegistry.m_strIOSExecPath;
   m_strIOSOptions       = theRegistry.m_strIOSOptions;
   m_strSWSName          = theRegistry.m_strSWSName;
   m_strProfilePath      = theRegistry.m_strProfilePath;
   m_strDefaultBase      = theRegistry.m_strDefaultBase;
   m_strSortieMaster     = theRegistry.m_strSortieMaster;
   m_strDebriefFolder    = theRegistry.m_strDebriefFolder;
   m_bUseFakeDB          = theRegistry.m_bUseFakeDB;

   if (m_nLocation == TYPE_IS_IOS)
      SelectIOS();
   else
      SelectRIS();

   UpdateData(FALSE);
    
	return TRUE;
}


void COptionsDialog::OnOK() 
{

   UpdateData(TRUE);

   // Make sure trailing slash exists for SWS name
   if (m_strSWSName[m_strSWSName.GetLength() - 1] != '\\')
      m_strSWSName += '\\';

   // Make sure no trailing slash for profile path
   if (m_strProfilePath[m_strProfilePath.GetLength() - 1] == '\\')
      m_strProfilePath.Delete(m_strProfilePath.GetLength() - 1);

   theRegistry.m_nLocation           = m_nLocation;
   theRegistry.m_bHideOptionsDialog  = m_bHideOptionsDialog;
   theRegistry.m_strIOSExecPath      = m_strIOSExecPath;
   theRegistry.m_strIOSOptions       = m_strIOSOptions;
   theRegistry.m_strSWSName          = m_strSWSName;
   theRegistry.m_strProfilePath      = m_strProfilePath;
   theRegistry.m_strDefaultBase      = m_strDefaultBase;
   theRegistry.m_strSortieMaster     = m_strSortieMaster;
   theRegistry.m_strDebriefFolder    = m_strDebriefFolder; 
   theRegistry.m_bUseFakeDB          = m_bUseFakeDB;

   theRegistry.WriteRegistry();

   CDialog::OnOK();
}


void COptionsDialog::SelectIOS()
{
   GetDlgItem(IDC_IOS_EXEC_OPTIONS_EDIT)->EnableWindow(TRUE);
   GetDlgItem(IDC_IOS_PATH_EDIT)->EnableWindow(TRUE);   
}

void COptionsDialog::SelectRIS()
{
   GetDlgItem(IDC_IOS_EXEC_OPTIONS_EDIT)->EnableWindow(FALSE);
   GetDlgItem(IDC_IOS_PATH_EDIT)->EnableWindow(FALSE);
}

