// FTDPlanningAppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FTDPlanningApp.h"
#include "FTDPlanningAppDlg.h"
#include "OptionsDialog.h"
#include <lm.h>
#include "RegistrySettings.h"
#include <process.h>
#include <windows.h>
#include <winbase.h>
#include "WorkingDlg.h"
#include "ConfirmationDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CRegistrySettings theRegistry;

enum {   
         COLUMN_INSTRUCTOR = 0,
         COLUMN_STUDENT    = 1,
         COLUMN_STUDENTID  = 2,
         COLUMN_EVENT      = 3,
         COLUMN_SORTIE     = 4,
         COLUMN_START      = 5,
         COLUMN_DURATION   = 6,
         COLUMN_END        = 7,
         COLUMN_DEVICE     = 8
     };

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About



class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFTDPlanningAppDlg dialog

CFTDPlanningAppDlg::CFTDPlanningAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFTDPlanningAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFTDPlanningAppDlg)
	m_ID_1 = _T("");
	m_ID_2 = _T("");
	m_ID_3 = _T("");
	m_bPreloadSortie = FALSE;
	m_bRecordDebrief = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
   
   //defaults
   m_SelectedBase    = "NONE";
   m_SelectedID      = "000000000";
   m_SelectedSortie  = "none";
   m_SelectedStudent = "none";
   m_StudentLogonID  = "";

   m_bRecordDebrief  = TRUE;
   m_bCustomStudent  = FALSE;
   m_bCustomSortie   = FALSE;
   m_bUninitializedLesson = false;
}

void CFTDPlanningAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFTDPlanningAppDlg)
	DDX_Control(pDX, IDC_TRN_ORG_SELECT_COMBO2, m_TrnOrgCtrl);
	DDX_Control(pDX, IDC_SORTIE_SELECT_COMBO, m_SortieSelCtrl);
	DDX_Control(pDX, IDC_NAME_SELECT_COMBO, m_NameSelCtrl);
	DDX_Control(pDX, IDC_LISTCTRL, m_listCtrl);
	DDX_Text(pDX, IDC_ID_SELECT_EDIT1, m_ID_1);
	DDV_MaxChars(pDX, m_ID_1, 3);
	DDX_Text(pDX, IDC_ID_SELECT_EDIT2, m_ID_2);
	DDV_MaxChars(pDX, m_ID_2, 2);
	DDX_Text(pDX, IDC_ID_SELECT_EDIT3, m_ID_3);
	DDV_MaxChars(pDX, m_ID_3, 4);
	DDX_Check(pDX, IDC_AUTOLOAD_CHECK, m_bPreloadSortie);
	DDX_Check(pDX, IDC_RECORD_CHECK, m_bRecordDebrief);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFTDPlanningAppDlg, CDialog)
	//{{AFX_MSG_MAP(CFTDPlanningAppDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPTIONS, OnEditOptions)
	ON_EN_CHANGE(IDC_ID_SELECT_EDIT1, OnChangeIdSelectEdit1)
	ON_EN_CHANGE(IDC_ID_SELECT_EDIT2, OnChangeIdSelectEdit2)
	ON_EN_CHANGE(IDC_ID_SELECT_EDIT3, OnChangeIdSelectEdit3)
	ON_CBN_SELCHANGE(IDC_NAME_SELECT_COMBO, OnSelchangeNameSelectCombo)
	ON_NOTIFY(NM_CLICK, IDC_LISTCTRL, OnClickListctrl)
	ON_CBN_SELCHANGE(IDC_SORTIE_SELECT_COMBO, OnSelchangeSortieSelectCombo)
	ON_BN_CLICKED(IDC_SORTIEEDIT_BUTTON, OnSortieeditButton)
	ON_NOTIFY(NM_DBLCLK, IDC_LISTCTRL, OnDblclkListctrl)
	ON_CBN_SELCHANGE(IDC_TRN_ORG_SELECT_COMBO2, OnSelchangeTrnOrgSelectCombo2)
	ON_WM_QUERYENDSESSION()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFTDPlanningAppDlg message handlers

BOOL CFTDPlanningAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

   theRegistry.ReadRegistry();

	// Add "About..." menu item to system menu.
	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
   // Get the user name
    wchar_t         szCurrentUser[256];
    LPWSTR          DomainController = NULL;
    char            szLoginName[256];
    DWORD           dwSizeofCurrentUser = sizeof(szCurrentUser);
    DWORD           dwSizeofLoginName = sizeof szLoginName;

    // Get the name of the current user in unicode form.
    GetUserNameW(szCurrentUser, &dwSizeofCurrentUser);
    GetUserName(szLoginName, &dwSizeofLoginName);

    m_UserName = szLoginName;
    m_strFullProfilePath = theRegistry.m_strSWSName + theRegistry.m_strProfilePath + "\\" + m_UserName + ".ini";

    char nameBuffer[256];
    unsigned long nameBufferlen = sizeof nameBuffer;
    nameBuffer[0] = 0x00;

   ///////////////////////////////////////////
   // getting user's full name
   LPBYTE   ComputerName;
   struct   _USER_INFO_2   *ui;
   NetGetDCName(NULL,   NULL, &ComputerName);
 
   if (NetUserGetInfo((LPWSTR)ComputerName,   (LPWSTR)&szCurrentUser,   2, (LPBYTE *)&ui))
      printf( "Error getting current user name.\n" );
   else 
      WideCharToMultiByte(CP_ACP,   0, ui->usri2_full_name, -1, nameBuffer, 256, NULL, NULL);
   if (nameBuffer[0] != 0x00)
      m_FullUserName = nameBuffer;


   // Initialize list control with column headings
   CRect       rect;
   LV_COLUMN   lvcolumn;
   const       num_cols = 9;
   TCHAR       rgtsz[num_cols][24] = {_T("Instructor"), _T("Student Name"), _T("Student Logon"), _T("Event"), _T("Sortie File"), _T("Start Time"), _T("Duration"), _T("End Time"), _T("Device")};

   m_listCtrl.GetWindowRect(&rect);

   for (int ii = 0; ii < num_cols; ii++)  // add the columns to the list control
   {
      lvcolumn.mask     =  LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
      lvcolumn.fmt      =  LVCFMT_LEFT;
      lvcolumn.pszText  =  rgtsz[ii];
      lvcolumn.iSubItem =  ii;
      lvcolumn.cx       =  (rect.Width() - GetSystemMetrics(SM_CXVSCROLL) - 2) /  num_cols;
      m_listCtrl.InsertColumn(ii, &lvcolumn);  // assumes return value is OK.
   }

   m_listCtrl.SetExtendedStyle(LVS_EX_FULLROWSELECT);

   if (theRegistry.m_bUseFakeDB)
      theTimsInterface.SetTestMode(CTimsInterface::TEST_EVENTS | CTimsInterface::TEST_STUDENTS);


   CFTDPlanningAppDlg::OnGetEvents();

   theTimsInterface.GetTrainingOrgs();
   for (int i=0; i<theTimsInterface.m_TrainingOrgList.GetSize(); i++)
   {
      m_TrnOrgCtrl.AddString(theTimsInterface.m_TrainingOrgList[i]);
   }

   CFTDPlanningAppDlg::OnGetSorties();


   if (theRegistry.m_bHideOptionsDialog)
      (CButton *)GetDlgItem(IDC_OPTIONS)->ShowWindow(SW_HIDE);
   else
      (CButton *)GetDlgItem(IDC_OPTIONS)->ShowWindow(SW_SHOW);


   VERIFY(m_label1Font.CreateFont(
      28,                        // nHeight
      0,                         // nWidth
      0,                         // nEscapement
      0,                         // nOrientation
      FW_NORMAL,                 // nWeight
      TRUE,                      // bItalic
      FALSE,                     // bUnderline
      0,                         // cStrikeOut
      ANSI_CHARSET,              // nCharSet
      OUT_DEFAULT_PRECIS,        // nOutPrecision
      CLIP_DEFAULT_PRECIS,       // nClipPrecision
      DEFAULT_QUALITY,           // nQuality
      DEFAULT_PITCH | FF_DONTCARE,  // nPitchAndFamily
      "Arial"));          
   
   CWnd *pHeading = GetDlgItem(IDC_LABEL1_TEXT);
   pHeading->SetFont(&m_label1Font);
   pHeading->SetWindowText("FTD Scheduled Events");

   VERIFY(m_label2Font.CreateFont(
      20,                        // nHeight
      0,                         // nWidth
      0,                         // nEscapement
      0,                         // nOrientation
      FW_NORMAL,                 // nWeight
      FALSE,                     // bItalic
      FALSE,                     // bUnderline
      0,                         // cStrikeOut
      ANSI_CHARSET,              // nCharSet
      OUT_DEFAULT_PRECIS,        // nOutPrecision
      CLIP_DEFAULT_PRECIS,       // nClipPrecision
      DEFAULT_QUALITY,           // nQuality
      DEFAULT_PITCH | FF_DONTCARE,  // nPitchAndFamily
      "Arial Italic"));          
   
   CWnd *pUser = GetDlgItem(IDC_USERNAME);
   pUser->SetFont(&m_label2Font);
   pUser->SetWindowText(m_UserName);

   m_SelectedBase = theRegistry.m_strDefaultBase;

   if (theRegistry.m_nLocation == COptionsDialog::TYPE_IS_RIS)
   {
      m_bPreloadSortie = TRUE;

      //Copy master sortie to instructor temp dir
      CString strSource = theRegistry.m_strSWSName + theRegistry.m_strSortieMaster + "\\" + "sortie";
      CString strDest   = theRegistry.m_strSWSName + theRegistry.m_strSortieMaster + "\\" + m_UserName + "\\" + "sortie";

      CWorkingDlg workingDlg;
      workingDlg.m_CStr_source              = strSource;
      workingDlg.m_CStr_destination         = strDest;
      workingDlg.m_CStr_primary_extension   = "mdb";
      workingDlg.m_CStr_secondary_extension = "";
      workingDlg.m_CStr_start_caption       = "Copying sortie file...";
      workingDlg.m_CStr_finish_caption      = "Finished copying sortie file.";

      CString strInstructorFolder = theRegistry.m_strSWSName + theRegistry.m_strSortieMaster + "\\" + m_UserName;

      BOOL bRetVal = CreateDirectory(LPCTSTR(strInstructorFolder),  NULL);

      if (!bRetVal)
      {
         DWORD dwLastErr = GetLastError();
         if (dwLastErr != ERROR_ALREADY_EXISTS)
         {
            CString strErrNum;
            strErrNum.Format("%d",dwLastErr);
            CString msg = "Error #" + strErrNum + " attempting to create " + strInstructorFolder;
            MessageBox(msg, "FILE ERROR", MB_ICONEXCLAMATION|MB_OK);
         }
      }

      workingDlg.DoModal();

      //Change attributes to non-read-only
      if (SetFileAttributes(strDest+".mdb",FILE_ATTRIBUTE_NORMAL) == 0)
      {
         CString strErrNum;
         strErrNum.Format("%d",GetLastError());
         CString msg = "Error #" + strErrNum + " attempting to change Sortie file to read-write: " + strDest+".mdb";
         MessageBox(msg, "FILE ERROR", MB_ICONEXCLAMATION|MB_OK);
      }

      EnableAdhocButtons();
      m_listCtrl.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED); // set to ad-hoc
      m_listCtrl.SetSelectionMark(0);
      m_listCtrl.SetFocus();

   }
   else if (theRegistry.m_nLocation == COptionsDialog::TYPE_IS_IOS)
   {
      char lpReturnedString[256];
      if (
        
         !GetPrivateProfileString("FTD TIMS Interface", "Preload Sortie",  "0", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath)
         )
      {
       CString msg = "Error attempting read from " + m_strFullProfilePath;
       ::MessageBox(NULL, msg, "File or Network Error", MB_ICONEXCLAMATION|MB_OK);
      }

      m_bPreloadSortie = atoi(lpReturnedString);


      GetPrivateProfileString("FTD TIMS Interface", "Sortie Base",  "KRND", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_SelectedBase = lpReturnedString;

      GetPrivateProfileString("FTD TIMS Interface", "Selected Sortie", "NONE", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_SelectedSortie = lpReturnedString;

      GetPrivateProfileString("FTD TIMS Interface", "Selected Student","none", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_SelectedStudent = lpReturnedString;

      GetPrivateProfileString("FTD TIMS Interface", "Record Debriefing", "0", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_bRecordDebrief = atoi(lpReturnedString);

      GetPrivateProfileString("FTD TIMS Interface", "Custom Student", "1", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_bCustomStudent = atoi(lpReturnedString);

      GetPrivateProfileString("FTD TIMS Interface", "Custom Sortie", "0", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_bCustomSortie = atoi(lpReturnedString);

      GetPrivateProfileString("FTD TIMS Interface", "Student Logon ID","", lpReturnedString, sizeof lpReturnedString, m_strFullProfilePath);
      m_StudentLogonID = lpReturnedString;

      if (m_bCustomSortie)
      {
        
         //Copy from SWS instructor temp dir to local location specified by HKLM

         CString strSource(theRegistry.m_strSWSName + theRegistry.m_strSortieMaster + "\\" + m_UserName + "\\" + "sortie");
         CString strDest(theRegistry.m_strIOSSortiePath.Left(theRegistry.m_strIOSSortiePath.ReverseFind('.')));

         CWorkingDlg workingDlg;
         workingDlg.m_CStr_source              = strSource;
         workingDlg.m_CStr_destination         = strDest;
         workingDlg.m_CStr_primary_extension   = "mdb";
         workingDlg.m_CStr_secondary_extension = "";
         workingDlg.m_CStr_start_caption       = "Copying sortie file...";
         workingDlg.m_CStr_finish_caption      = "Finished copying sortie file.";
         workingDlg.DoModal();
      }
      else
      {
         //Copy from SWS master sortie to local location specified by HKLM
         CString strSource(theRegistry.m_strSWSName + theRegistry.m_strSortieMaster + "\\" + "sortie");
         CString strDest(theRegistry.m_strIOSSortiePath.Left(theRegistry.m_strIOSSortiePath.ReverseFind('.')));

         CWorkingDlg workingDlg;
         workingDlg.m_CStr_source              = strSource;
         workingDlg.m_CStr_destination         = strDest;
         workingDlg.m_CStr_primary_extension   = "mdb";
         workingDlg.m_CStr_secondary_extension = "";
         workingDlg.m_CStr_start_caption       = "Copying sortie file...";
         workingDlg.m_CStr_finish_caption      = "Finished copying sortie file.";
         workingDlg.DoModal();

         //Change attributes to non-read-only
         if (SetFileAttributes(strDest+".mdb",FILE_ATTRIBUTE_NORMAL) == 0)
         {
            CString strErrNum;
            strErrNum.Format("%d",GetLastError());
            CString msg = "Error #" + strErrNum + " attempting to change Sortie file to read-write: " + strDest+".mdb";
            MessageBox(msg, "FILE ERROR", MB_ICONEXCLAMATION|MB_OK);
         }


      }


      // If previously selected in the list box at the RIS, highlight that same line again
      if (!m_bCustomStudent)
      {
         CString student, sortie;
         int nItem = m_listCtrl.GetNextItem(-1, LVNI_ALL);
         int itemCount = m_listCtrl.GetItemCount();

         while (nItem < itemCount)
         {
            student = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENT);
            sortie  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_SORTIE );
            if (student == m_SelectedStudent &&
                sortie  == m_SelectedSortie )
            {
               m_listCtrl.SetItemState(nItem, LVIS_SELECTED, LVIS_SELECTED);
               m_listCtrl.SetSelectionMark(nItem);
               m_listCtrl.SetFocus();
               break;
            }
            nItem++;
         }
      }
      else
      {
         if (m_bPreloadSortie == FALSE && m_bRecordDebrief == FALSE)
         {
            // this is included only so if you start the IOS without a prebrief at
            // the RIS, and it comes up with "ad hoc" lesson assigned with no debrief
            // or sortie load checkbox selected; as soon as you pick a "real" student
            // it will set those checkboxes to true by default.
            m_bUninitializedLesson = true;
         }
         m_NameSelCtrl.SetCurSel(m_NameSelCtrl.FindStringExact(-1, m_SelectedStudent));
         m_SortieSelCtrl.SetCurSel(m_SortieSelCtrl.FindStringExact(-1, m_SelectedSortie));
         m_listCtrl.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED);
         m_listCtrl.SetSelectionMark(0);
         m_listCtrl.CListCtrl::SetItemText(0, COLUMN_STUDENT,   m_SelectedStudent);
         m_listCtrl.CListCtrl::SetItemText(0, COLUMN_SORTIE,    m_SelectedSortie );
         m_listCtrl.CListCtrl::SetItemText(0, COLUMN_STUDENTID, m_StudentLogonID );
      }
      m_listCtrl.SetFocus();
   }


   UpdateData(FALSE);

	return FALSE; // because we set focus
}


void CFTDPlanningAppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFTDPlanningAppDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFTDPlanningAppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


//////////////////////////////////////////////////////////////////////////////
void CFTDPlanningAppDlg::OnGetStudents() 
{
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );

    theTimsInterface.GetStudents(m_SelectedTrainingOrg);

    m_NameSelCtrl.ResetContent();

    for (int i=0; i<theTimsInterface.m_StudentList.GetSize(); i++)
    {
       m_NameSelCtrl.AddString(theTimsInterface.m_StudentList[i].m_Name);
    }
}


//////////////////////////////////////////////////////////////////////////////
//
void CFTDPlanningAppDlg::OnGetEvents() 
{
   HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
   HCURSOR hPrevCursor = SetCursor( hWaitCursor );

   CSchedEventRec eventRec;
   eventRec.InstructorName = m_FullUserName;
   eventRec.EventID        = "ad hoc";
   eventRec.StudentName    = "none";
   eventRec.SortieFile     = "none";
   eventRec.StartTime      = "--";
   eventRec.EndTime        = "--";
   eventRec.Duration       = "--";
   eventRec.Device         = "--";

   theTimsInterface.GetEvents();

   theTimsInterface.m_EventList.Add( eventRec );

   LVITEM lvitem;
   lvitem.mask      = LVIF_TEXT;
   lvitem.iItem     = 0;

   for (int i=0; i<theTimsInterface.m_EventList.GetSize(); i++)
   {

      lvitem.iSubItem = COLUMN_INSTRUCTOR;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].InstructorName;
      m_listCtrl.InsertItem(&lvitem);

      lvitem.iSubItem = COLUMN_STUDENT;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].StudentName;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_STUDENTID;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].StudentLogonID;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_EVENT;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].EventID;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_SORTIE;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].SortieFile;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_START;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].StartTime;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_DURATION;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].Duration;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_END;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].EndTime;
      m_listCtrl.SetItem(&lvitem);

      lvitem.iSubItem = COLUMN_DEVICE;
      lvitem.pszText  = (char *)(LPCTSTR)theTimsInterface.m_EventList[i].Device;
      m_listCtrl.SetItem(&lvitem);

   }
}


void CFTDPlanningAppDlg::OnEditOptions() 
{
   COptionsDialog dlg;
   dlg.DoModal();
}


void CFTDPlanningAppDlg::OnChangeIdSelectEdit1() 
{
   if (((CEdit *)GetDlgItem(IDC_ID_SELECT_EDIT1))->LineLength() == 3)
   {
      NextDlgCtrl();
   }
}

void CFTDPlanningAppDlg::OnChangeIdSelectEdit2() 
{
	if (((CEdit *)GetDlgItem(IDC_ID_SELECT_EDIT2))->LineLength() == 2)
   {
      NextDlgCtrl();
   }
}

void CFTDPlanningAppDlg::OnChangeIdSelectEdit3() 
{
   if (((CEdit *)GetDlgItem(IDC_ID_SELECT_EDIT3))->LineLength() == 4)
   {
      UpdateData(TRUE);
      GotoDlgCtrl(GetDlgItem(IDC_ID_SELECT_EDIT1));
      m_SelectedID = m_ID_1 + m_ID_2 + m_ID_3;

      // try to match input ID with known ID's
      bool bFound = false;
      for (int i=0; i<theTimsInterface.m_StudentList.GetSize(); i++)
         if (theTimsInterface.m_StudentList[i].m_ID == m_SelectedID)
         {
            bFound = true;
            CComboBox *pNameSelCombo = (CComboBox *)GetDlgItem(IDC_NAME_SELECT_COMBO);

            int nPos = pNameSelCombo->FindStringExact(-1, theTimsInterface.m_StudentList[i].m_Name);
            pNameSelCombo->SetCurSel(nPos);

            ClearSelections();
            m_NameSelCtrl.GetLBText(nPos, m_SelectedStudent);
            m_listCtrl.SetItemText(0, COLUMN_STUDENT, m_SelectedStudent);
            m_listCtrl.SetItemText(0, COLUMN_STUDENTID, theTimsInterface.m_StudentList[i].m_LogonID);
            m_listCtrl.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED); // set to ad-hoc
            m_listCtrl.SetSelectionMark(0);
            m_listCtrl.SetFocus();

            m_bCustomStudent = TRUE;
         }

       if (!bFound)
       {
         CString errMsg = "Unknown ID: " + m_SelectedID;
         ::MessageBox(NULL, (LPCTSTR)errMsg,"Unknown Student ID",MB_ICONEXCLAMATION|MB_OK);
         m_ID_1 = m_ID_2 = m_ID_3 = m_SelectedID = "";
         UpdateData(FALSE);
         ((CComboBox *)GetDlgItem(IDC_NAME_SELECT_COMBO))->SetCurSel(-1);
         GotoDlgCtrl(GetDlgItem(IDC_ID_SELECT_EDIT1));
       }
   }
	
}

void CFTDPlanningAppDlg::ClearIDFields()
{
   m_ID_1 = "";
   m_ID_2 = "";
   m_ID_3 = "";
   UpdateData(FALSE);
}

void CFTDPlanningAppDlg::OnSelchangeNameSelectCombo() 
{
   ClearIDFields();	
   ClearSelections();
   int nSel = m_NameSelCtrl.GetCurSel();
   if (nSel != CB_ERR)
   {
      m_NameSelCtrl.GetLBText(nSel, m_SelectedStudent);
      m_listCtrl.SetItemText(0, COLUMN_STUDENT, m_SelectedStudent);
      for (int i=0; i < theTimsInterface.m_StudentList.GetSize(); i++)
      {
         // Get the LogonID by comparing the selected full name
         if (m_SelectedStudent == theTimsInterface.m_StudentList[i].m_Name)
         {
            m_StudentLogonID = theTimsInterface.m_StudentList[i].m_LogonID;
            m_listCtrl.SetItemText(0, COLUMN_STUDENTID, m_StudentLogonID);
         }
      }
      m_listCtrl.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED); // set to ad-hoc
      m_listCtrl.SetSelectionMark(0);
      m_listCtrl.SetFocus();
   }

   m_bCustomStudent = TRUE;
}


void CFTDPlanningAppDlg::OnOK() 
{
   UpdateData(TRUE);

   // Added this for the case where the user is using arrow keys and the Enter key
   // instead of clicking on items.
   
	POSITION pos = m_listCtrl.GetFirstSelectedItemPosition();
   int nItem = m_listCtrl.GetNextSelectedItem(pos);
   m_SelectedStudent = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENT  );
   m_SelectedSortie  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_SORTIE   );
   m_StudentLogonID  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENTID);

   if (nItem == 0)
      EnableAdhocButtons();
   else
      DisableAdhocButtons();
   ////////// 

   CConfirmationDlg dlg;

   dlg.m_SelSortieText = "Selected Sortie: " + m_SelectedSortie;
   dlg.m_SelStudentText= "Selected Student: " + m_SelectedStudent;
   dlg.m_SelLogonID    = "(" + m_StudentLogonID + ")";

   if (dlg.DoModal() != IDOK)
   {
      if (!m_bCustomStudent)
      {
         m_listCtrl.SetFocus();
      }

      return;
   }

   CString strPreloadSortie,strCustomStudent,strRecordDebrief,strCustomSortie;
   strPreloadSortie.Format("%d", m_bPreloadSortie);
   strCustomStudent.Format("%d", m_bCustomStudent);
   strRecordDebrief.Format("%d", m_bRecordDebrief);
   strCustomSortie.Format( "%d", m_bCustomSortie );

   if (
      !WritePrivateProfileString("FTD TIMS Interface", "Sortie Base",      m_SelectedBase,    m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Selected Sortie",  m_SelectedSortie,  m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Selected Student", m_SelectedStudent, m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Preload Sortie",   strPreloadSortie,  m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Record Debriefing",strRecordDebrief,  m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Custom Student",   strCustomStudent,  m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Custom Sortie",    strCustomSortie,   m_strFullProfilePath) ||
      !WritePrivateProfileString("FTD TIMS Interface", "Student Logon ID", m_StudentLogonID,  m_strFullProfilePath)
      )
   {
    CString msg = "Error attempting write to " + m_strFullProfilePath;
    ::MessageBox(NULL, msg, "File or Network Error", MB_ICONEXCLAMATION|MB_OK);
   }


   if (theRegistry.m_nLocation == COptionsDialog::TYPE_IS_IOS)
   {
      OnStartIosButton();

      // Delete the instructor's .ini file when done
      if (DeleteFile(m_strFullProfilePath) == 0)
      {
         CString msg = "Error attempting delete of " + m_strFullProfilePath;
         ::MessageBox(NULL, msg, "File or Network Error", MB_ICONEXCLAMATION|MB_OK);
      }
   }
   
	CDialog::OnOK();
}


void CFTDPlanningAppDlg::OnClickListctrl(NMHDR* pNMHDR, LRESULT* pResult) 
{
	POSITION pos = m_listCtrl.GetFirstSelectedItemPosition();
   int nItem = m_listCtrl.GetNextSelectedItem(pos);

   if (nItem == 0) // is ad hoc event
   {
      m_bCustomStudent = TRUE;
      EnableAdhocButtons();
      // I think this will fix something?
      m_SelectedStudent = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENT  );
      m_SelectedSortie  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_SORTIE   );
      m_StudentLogonID  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENTID);
   }
   else
   {
      DisableAdhocButtons();

      m_SelectedStudent = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENT  );
      m_SelectedSortie  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_SORTIE   );
      m_StudentLogonID  = m_listCtrl.CListCtrl::GetItemText(nItem, COLUMN_STUDENTID);
/*
      CComboBox *pCombo = (CComboBox *)GetDlgItem(IDC_NAME_SELECT_COMBO);
      int nPos = pCombo->FindStringExact(-1, m_SelectedStudent);
      pCombo->SetCurSel(nPos);

      pCombo = (CComboBox *)GetDlgItem(IDC_SORTIE_SELECT_COMBO);
      nPos = pCombo->FindStringExact(-1, m_SelectedSortie);
      pCombo->SetCurSel(nPos);
*/
      m_bCustomStudent = FALSE;

      if (m_bUninitializedLesson == true)
      {
         m_bUninitializedLesson = false;

         m_bRecordDebrief = TRUE;
         m_bPreloadSortie = TRUE;
         UpdateData(FALSE);
      }
   }
	
	*pResult = 0;
}


void CFTDPlanningAppDlg::OnGetSorties() 
{
    HCURSOR hWaitCursor = LoadCursor( NULL, IDC_WAIT );
    HCURSOR hPrevCursor = SetCursor( hWaitCursor );
 
    theTimsInterface.GetSorties();

    for (int i=0;i<theTimsInterface.m_SortieList.GetSize();i++)
    {
       m_SortieSelCtrl.AddString(theTimsInterface.m_SortieList[i]);
    }
}


void CFTDPlanningAppDlg::OnStartIosButton() 
{
   CString strFullExecPath = theRegistry.m_strIOSExecPath + " " + theRegistry.m_strIOSOptions;

   ShowWindow(SW_HIDE);

   int are_we_done_yet  =  _spawnl(_P_NOWAIT, LPCTSTR(theRegistry.m_strIOSExecPath), LPCTSTR(strFullExecPath), NULL);

   while (WaitForSingleObject((HANDLE)are_we_done_yet, 500)   == WAIT_TIMEOUT)
   {
      MSG msg;
      while (::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) 
      { 
         if (!AfxGetApp()->PumpMessage()) 
            break; 
      } 
   }

   ShowWindow(SW_SHOW);

   if (m_bRecordDebrief)
   {
      CWorkingDlg workingDlg;
      workingDlg.m_CStr_source              = theRegistry.m_strDebriefSource;
      workingDlg.m_CStr_destination         = theRegistry.m_strSWSName + theRegistry.m_strDebriefFolder +
                                              "\\" + m_StudentLogonID + "\\" + m_SelectedSortie;
      workingDlg.m_CStr_primary_extension   = "dat";
      workingDlg.m_CStr_secondary_extension = "ini";
      workingDlg.m_CStr_start_caption       = "Saving Debriefing Data...";
      workingDlg.m_CStr_finish_caption      = "Finished saving debriefing data.";

      CString strStudentFolder = theRegistry.m_strSWSName + theRegistry.m_strDebriefFolder +
                                              "\\" + m_StudentLogonID;

      BOOL bRetVal = CreateDirectory(LPCTSTR(strStudentFolder),  NULL);

      if (!bRetVal)
      {
         DWORD dwLastErr = GetLastError();
         if (dwLastErr != ERROR_ALREADY_EXISTS)
         {
            CString strErrNum;
            strErrNum.Format("%d",dwLastErr);
            CString msg = "Error #" + strErrNum + " attempting to create " + strStudentFolder;
            MessageBox(msg, "FILE ERROR", MB_ICONEXCLAMATION|MB_OK);
         }
      }

      workingDlg.DoModal();
   }


   if (m_SelectedStudent != "none")
      MessageBox("Please remember to update the student records.","Reminder", MB_ICONINFORMATION|MB_OK);
}

void CFTDPlanningAppDlg::OnSelchangeSortieSelectCombo() 
{

   int nSel = m_SortieSelCtrl.GetCurSel();
   if (nSel != CB_ERR)
   {
      m_SortieSelCtrl.GetLBText(nSel, m_SelectedSortie);
      m_listCtrl.SetItemText(0, COLUMN_SORTIE, m_SelectedSortie);
      m_listCtrl.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED); // set to ad-hoc
      m_listCtrl.SetSelectionMark(0);
      m_listCtrl.SetFocus();
   }

	m_bCustomStudent = TRUE;
}



void CFTDPlanningAppDlg::DumpError(_com_error &e)
{
    CString str;
	_bstr_t bstrSource( e.Source() );
	_bstr_t bstrDescription( e.Description() );

    switch( e.Error() )
    {
    case 0x800a0bcd:
		MessageBox( "No records found", _T("Error") );
        break;
    
    case 0x80040e14: // Connection failed or error in sql
		MessageBox( "Database connection failed", _T("Error") );
        break;

    default:
	    str.Format( "\tCode = %08lx", e.Error() );
	    str += " ErrMsg: ";	str += e.ErrorMessage();
	    str += " Source: "; str += bstrSource;
	    str += " Description: "; str += bstrDescription;
    	AfxMessageBox( str );
        break;
    }
}

void CFTDPlanningAppDlg::OnSortieeditButton() 
{
	

   m_bCustomSortie = TRUE;

   if (theRegistry.m_nLocation == COptionsDialog::TYPE_IS_RIS)
   {
      //Set HKCU to point to instructor temp dir on SWS
      HKEY hKey;
      DWORD dw;
      RegCreateKeyEx(HKEY_CURRENT_USER, _T("Software\\FlightSafety\\FSISuite\\Sortie Files"),
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

      if (hKey == NULL)
      {
         ::MessageBox(NULL,"User does not have appropriate permissions to write HKCU registry. ","Error: Cannot Write Registry",MB_ICONEXCLAMATION|MB_OK);
         return;
      }
      else
      {
         CString strTempSortie = theRegistry.m_strSWSName + theRegistry.m_strSortieMaster + "\\" + m_UserName + "\\" + "sortie.mdb";
         RegSetValueEx(hKey, _T("SORTIE_DB"),  NULL, REG_SZ, (BYTE*)(LPCTSTR)strTempSortie,  strTempSortie.GetLength() + 1);
      }

   }

   // execute sortie editor
   CString strFullExecPath = theRegistry.m_strSortieEditExecPath + " /Base " + m_SelectedBase + " /Lesson " + m_SelectedSortie;

   _spawnl(_P_WAIT, LPCTSTR(theRegistry.m_strSortieEditExecPath), LPCTSTR(strFullExecPath), NULL);


   // Get the currently selected base and lesson from an INI file so that we know what sortie was edited.
   CString  strFullProfilePath("C:\\winnt\\temp\\sortiedata.ini");
   char     lpReturnedString[256];
   GetPrivateProfileString("SortieData", "Base",  m_SelectedBase, lpReturnedString, sizeof lpReturnedString, strFullProfilePath);
   m_SelectedBase    =  lpReturnedString;
   GetPrivateProfileString("SortieData", "Lesson",  m_SelectedSortie,   lpReturnedString, sizeof lpReturnedString,   strFullProfilePath);
   m_SelectedSortie  =  lpReturnedString;
   m_listCtrl.CListCtrl::SetItemText(0, COLUMN_SORTIE,    m_SelectedSortie);
   m_SortieSelCtrl.SetCurSel(m_SortieSelCtrl.FindStringExact(-1, m_SelectedSortie));
   UpdateData(FALSE);

   if (theRegistry.m_nLocation == COptionsDialog::TYPE_IS_RIS)
   {
      //Delete HKCU key after sortie editing is finished
      if (RegDeleteKey(HKEY_CURRENT_USER, _T("Software\\FlightSafety\\FSISuite\\Sortie Files")) != ERROR_SUCCESS)
      {
         ::MessageBox(NULL,"Error deleting HKCU\\Software\\FlightSafety\\FSISuite\\Sortie Files","Error: Cannot Write Registry",MB_ICONEXCLAMATION|MB_OK);
      }
   }
	
}


void CFTDPlanningAppDlg::OnDblclkListctrl(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NMHDR   dummyNMHDR;
   LRESULT dummyLRESULT;

   *pResult = 0;
	
   OnClickListctrl(&dummyNMHDR, &dummyLRESULT);

   OnOK();
}


void CFTDPlanningAppDlg::DisableAdhocButtons()
{
   GetDlgItem( IDC_STATICGROUP           )->EnableWindow(FALSE);
   GetDlgItem( IDC_STATICLABEL1          )->EnableWindow(FALSE);
   GetDlgItem( IDC_STATICLABEL2          )->EnableWindow(FALSE);
   GetDlgItem( IDC_STATICLABEL3          )->EnableWindow(FALSE);
   GetDlgItem( IDC_STATICLABEL4          )->EnableWindow(FALSE);
   GetDlgItem( IDC_ID_SELECT_EDIT1       )->EnableWindow(FALSE);
   GetDlgItem( IDC_ID_SELECT_EDIT2       )->EnableWindow(FALSE);
   GetDlgItem( IDC_ID_SELECT_EDIT3       )->EnableWindow(FALSE);
   GetDlgItem( IDC_NAME_SELECT_COMBO     )->EnableWindow(FALSE);
   GetDlgItem( IDC_SORTIE_SELECT_COMBO   )->EnableWindow(FALSE);
   GetDlgItem( IDC_TRN_ORG_SELECT_COMBO2 )->EnableWindow(FALSE);
}


void CFTDPlanningAppDlg::EnableAdhocButtons()
{
   GetDlgItem( IDC_STATICGROUP           )->EnableWindow(TRUE);
   GetDlgItem( IDC_STATICLABEL1          )->EnableWindow(TRUE);
   GetDlgItem( IDC_STATICLABEL2          )->EnableWindow(TRUE);
   GetDlgItem( IDC_STATICLABEL3          )->EnableWindow(TRUE);
   GetDlgItem( IDC_STATICLABEL4          )->EnableWindow(TRUE);
   GetDlgItem( IDC_ID_SELECT_EDIT1       )->EnableWindow(TRUE);
   GetDlgItem( IDC_ID_SELECT_EDIT2       )->EnableWindow(TRUE);
   GetDlgItem( IDC_ID_SELECT_EDIT3       )->EnableWindow(TRUE);
   GetDlgItem( IDC_NAME_SELECT_COMBO     )->EnableWindow(TRUE);
   GetDlgItem( IDC_SORTIE_SELECT_COMBO   )->EnableWindow(TRUE);
   GetDlgItem( IDC_TRN_ORG_SELECT_COMBO2 )->EnableWindow(TRUE);
}


void CFTDPlanningAppDlg::ClearSelections()
{
   for (int i=0; i<m_listCtrl.GetItemCount(); i++)
   {
      m_listCtrl.SetItemState(i, !LVIS_SELECTED, LVIS_SELECTED);
   }
   m_listCtrl.SetSelectionMark(-1);
}



void CFTDPlanningAppDlg::OnSelchangeTrnOrgSelectCombo2() 
{
   m_TrnOrgCtrl.GetLBText(m_TrnOrgCtrl.GetCurSel(), m_SelectedTrainingOrg);

   CFTDPlanningAppDlg::OnGetStudents();
}

BOOL CFTDPlanningAppDlg::OnQueryEndSession() 
{
   AfxBeginThread(CFTDPlanningAppDlg::MsgThread, (LPVOID)0);

	if (!CDialog::OnQueryEndSession())
		return FALSE;

	return FALSE;
}

UINT CFTDPlanningAppDlg::MsgThread(LPVOID param)
{
   ::MessageBox(NULL, "Please exit all applications before attempting to Logoff", "FTDPlanningApp - Attention", MB_ICONSTOP |  MB_OK);
   return   0;
}