// WidgetProps.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "fsisuite.h"
#include "mainfrm.h"
#include "fsisuitedoc.h"
#include "WidgetProps.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWidgetProps

CWidgetProps::CWidgetProps(CWidget* pWidget, CWidget* pClickedWidget) :
                             CPropertiesDlg()
{
    m_pWidget = pWidget;
    m_pClickedWidget = pClickedWidget;
}


CWidgetProps::~CWidgetProps()
{
    m_vectWidgets.clear();
    if (m_pWidget != NULL)
    {
        m_pWidget->WidgetProps(NULL);
    }
}


void CWidgetProps::DoDataExchange(CDataExchange* pDX)
{
	CPropertiesDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWidgetProps)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWidgetProps, CPropertiesDlg)
	//{{AFX_MSG_MAP(CWidgetProps)
	ON_BN_CLICKED(ID_APPLY_NOW, OnApplyNow)
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_NOTIFY(TVN_SELCHANGED, IDC_COMPONENT_TREE, OnSelchangedComponentTree)
	ON_NOTIFY(TVN_KEYDOWN, IDC_COMPONENT_TREE, OnKeyDownTree)
	ON_WM_CLOSE()
    ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWidgetProps message handlers
void CWidgetProps::OnSelchangedComponentTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    HTREEITEM hSelectedItem = pNMTreeView->itemNew.hItem;
	*pResult = 0;

    _FSI_STL::map<_FSI_STL::string,CBasePage*> mapOptions = m_mapOptions;
    m_mapOptions.clear();

    // If libraries have been loaded, then get their property pages.
    unsigned int ucStep = 0;
    bool bFound = false;
    FindItem(m_pctrlTree->GetSafeHwnd(),NULL,ucStep,hSelectedItem, bFound);
    
    // call the function
	_FSI_STL::list<CreatePage>* pPropPagesList = (m_vectWidgets[ucStep])->WidgetPropPages();

    CBasePage* pPage = NULL;
    _FSI_STL::list<void*> listVoidCI;

    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    STRING2CI_MAP s2cimap = pApp->GetComponentInterfaces();
    STRING2CI_MAP::iterator s2ciIt = s2cimap.begin();
    STRING2CI_MAP::iterator s2ciendIt = s2cimap.end();
    CComponentInterface* pCI;

    while (s2ciIt != s2ciendIt)
    {
        pCI = (*s2ciIt).second;
        listVoidCI.push_back((void*)pCI);
        s2ciIt++;
    }

    _FSI_STL::string stlStrCurrentPage;
    if (m_pPropSheet != NULL)
    {
        if (m_pPropSheet->GetSafeHwnd() != NULL)
        {
            CBasePage* pBasePage = dynamic_cast<CBasePage*>(m_pPropSheet->GetActivePage());
            if (pBasePage != NULL)
            {
                stlStrCurrentPage = pBasePage->PageName();
            }
        }
    }

	_FSI_STL::list<CreatePage>::iterator lIt    = pPropPagesList->begin();
	_FSI_STL::list<CreatePage>::iterator lendIt = pPropPagesList->end();
    while (lIt != lendIt)
    {
        pPage = (*lIt)();
        if (pPage != NULL)
        {
            // Add the new property page to the map of
            // property pages.
            m_mapOptions[pPage->PageName()] = pPage;

            // Set the property page's widget member
            // to the widget just clicked.
            pPage->Widget(m_vectWidgets[ucStep]);

            // Give the property page initial values
            pPage->SetProperties(m_vectWidgets[ucStep]);
            pPage->ComponentInterfaces(listVoidCI);
        }

        lIt++;
    }


    DisplayNewPropertySheet(mapOptions);

    if (m_pPropSheet != NULL)
    {
        if (m_mapOptions.find(stlStrCurrentPage) != m_mapOptions.end())
        {
            m_pPropSheet->SetActivePage(m_mapOptions[stlStrCurrentPage]);
        }
    }
}

void CWidgetProps::OnApplyNow() 
{
	// TODO: Add your control notification handler code here
    CWidget* pWidget = NULL;

    // Get the selected item.
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    HTREEITEM hSelectedItem = m_pctrlTree->GetSelectedItem();

    // Find the count of the selected item in the tree.
    unsigned int ucStep = 0;
    bool bFound = false;
    FindItem(m_pctrlTree->GetSafeHwnd(),NULL,ucStep,hSelectedItem, bFound);

    CMainFrame* pFrame = (CMainFrame*)GetParent();
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());
    CView* pView = pFrame->GetActiveView();

    if (bFound == true)
    {
        // Get the widget associated with the selected item.
	    pWidget = m_vectWidgets[ucStep];

        // Update all of the properties.
	    _FSI_STL::map<_FSI_STL::string, CBasePage*>::iterator mIt = m_mapOptions.begin();
        for (; mIt != m_mapOptions.end(); mIt++)
        {
            (*mIt).second->UpdateProperties(pWidget);
        }
        pWidget->ResetProperties();

        // Redraw the widget.
        if (pWidget->Wnd() != NULL)
        {
            pWidget->Wnd()->Invalidate(FALSE);
        }
        else
        {
            pView->Invalidate(TRUE);
        }

        pDoc->SetModifiedFlag();
        CXMLPage* pXMLPage = new CXMLPage;
        *pXMLPage = *(pDoc->XMLPage());
        pDoc->m_undoPages.apply_push(pXMLPage);

        CString   maybeNewText(pWidget->Name().c_str());
        m_pctrlTree->SetItemText(hSelectedItem, (LPCTSTR)maybeNewText);
    }

    pFrame->EditorTree()->AddWidgets(pDoc);
}

void CWidgetProps::OnOK() 
{
	// TODO: Add extra validation here
    OnApplyNow();

    CMainFrame* pFrame = (CMainFrame*)GetParent();
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());
    CXMLPage* pXMLPage = new CXMLPage;
    *pXMLPage = *(pDoc->XMLPage());
    pDoc->m_undoPages.ok_push(pXMLPage);

    DestroyWindow();
}

void CWidgetProps::OnHelp() 
{
	// TODO: Add your control notification handler code here
//    ((CMainFrame*)AfxGetMainWnd())->PostMessage(WM_COMMAND, ID_HELP_FINDER, 0);
}

void CWidgetProps::OnCancel() 
{
	// TODO: Add extra cleanup here
    CMainFrame* pFrame = (CMainFrame*)GetParent();
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());
    CXMLPage* pXMLPage = pDoc->m_undoPages.undo(true);
    CXMLPage* pCurrXMLPage = pDoc->XMLPage();

    if (pCurrXMLPage != NULL && pXMLPage != NULL)
    {
        if (*pXMLPage == *pCurrXMLPage)
        {
            DestroyWindow();
            return;
        }

        if (pDoc->m_listWidgets.size() > 0)
        {
            _FSI_STL::list<CWidget*>::iterator lwIt = pDoc->m_listWidgets.begin();
            for (; lwIt != pDoc->m_listWidgets.end(); lwIt++)
            {
                if ((*lwIt)->Wnd() != NULL)
                {
                    (*lwIt)->Wnd()->DestroyWindow();
                }
                (*lwIt)->Deleting(true);
            }
            pDoc->m_listWidgets.clear();
        }
        *pCurrXMLPage = *pXMLPage;
        pDoc->ResetView();

        pFrame->EditorTree()->AddWidgets(pDoc);
    }
    DestroyWindow();
}

BOOL CWidgetProps::Create(CWnd* pParentWnd) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL bRetVal = CPropertiesDlg::Create(IDD,pParentWnd);

    // Fill list with first set of pages
    _FSI_STL::map<_FSI_STL::string,CBasePage*> mapBlank;
    DisplayNewPropertySheet(mapBlank);

    // Fill tree with the nested widgets
    HTREEITEM hTreeClicked = NULL;
    if (m_pWidget != NULL)
    {
        TraverseBaseWidgets(m_pWidget, TVI_ROOT, hTreeClicked);
    }

    m_pctrlTree->SelectItem(hTreeClicked);
    SetWindowText("Widget Properties");
	return bRetVal;
}

void CWidgetProps::TraverseBaseWidgets(CWidget* pWidget, HTREEITEM hTreeParent,
                                       HTREEITEM& hTreeClicked)
{
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    HTREEITEM hTreeChild;
    hTreeChild = m_pctrlTree->InsertItem(pWidget->Name().c_str(),
                                         0, 0, hTreeParent);
    m_vectWidgets.push_back(pWidget);
    if (pWidget->Wnd() == m_pClickedWidget->Wnd())
    {
        hTreeClicked = hTreeChild;
    }

    _FSI_STL::list<CWidget*>::iterator wIt = NULL;
    CWidget* pSubWidget = pWidget->GetNextSubWidget(wIt);
    while (pSubWidget != NULL)
    {
        TraverseBaseWidgets(pSubWidget, hTreeChild, hTreeClicked);
        pSubWidget = pWidget->GetNextSubWidget(wIt);
    }

    _FSI_STL::list<CAction*>::iterator aIt = NULL;
    CWidget* pAction = pWidget->GetNextAction(aIt);
    while (pAction != NULL)
    {
        m_vectWidgets.push_back(pAction);
        m_pctrlTree->InsertItem(pAction->Name().c_str(), 0,0, hTreeChild);
        pAction = pWidget->GetNextAction(aIt);
    }
}

void CWidgetProps::FindItem(HWND hWnd, HTREEITEM hItem, unsigned int& ucTreeCount, 
               HTREEITEM hSelectedItem, bool& rbFound)
{
    // If hItem is NULL, start search from root item.
    if (hItem == NULL)
    {
        hItem = (HTREEITEM)::SendMessage(hWnd, TVM_GETNEXTITEM,TVGN_ROOT, 0);
    }

    while (hItem != NULL && hSelectedItem != hItem && rbFound == false)
    {
        ucTreeCount++;
        TV_ITEM item;

        item.hItem = hItem;
        item.mask = TVIF_CHILDREN;
        ::SendMessage(hWnd, TVM_GETITEM, 0, (LPARAM)&item);

        // Check whether we have child items.
        // Recursively traverse child items.
        HTREEITEM hItemChild = NULL;
        if (item.cChildren)
        {

            hItemChild = (HTREEITEM)::SendMessage(hWnd, TVM_GETNEXTITEM,
                                                TVGN_CHILD, (LPARAM)hItem);
            FindItem(hWnd, hItemChild,ucTreeCount,hSelectedItem, rbFound);

        }

        // Go to next sibling item.
        if (hItemChild != hSelectedItem)
        {
            hItem = (HTREEITEM)::SendMessage(hWnd, TVM_GETNEXTITEM,
                                             TVGN_NEXT, (LPARAM)hItem);
        }
        else
        {
            rbFound = true;
        }
    }

    if (hSelectedItem == hItem && hItem != NULL)
    {
        rbFound = true;
    }
} 

void CWidgetProps::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CPropertiesDlg::OnClose();
}

void CWidgetProps::OnDestroy()
{
    CMainFrame* pFrame = (CMainFrame*)GetParent();

    pFrame->m_pDlgWidgetProps = NULL;
}

void CWidgetProps::OnKeyDownTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    if (m_pctrlTree == NULL)
    {
        return;
    }

    // If delete key is pressed, then delete the currently selected item
    // and all children. This means destroying the windows controls and
    // deleting the memory for the widgets as well as removing the widgets
    // from the list of widgets.
    NMTVKEYDOWN* pKD = (NMTVKEYDOWN*)pNMHDR;

    if (pKD->wVKey == VK_DELETE)
    {
        HTREEITEM hItem = m_pctrlTree->GetSelectedItem();
        if (hItem != NULL)
        {
            CMainFrame* pFrame = (CMainFrame*)GetParent();
            CFSISuiteDoc* pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());

            m_vectToDelete.clear();

            DeleteTraversal(hItem);

            // Cleanup the XML and Widget data structures within the Widget
            // and XMLWidget classes.
            _FSI_STL::vector<CWidget*>::iterator vIt = m_vectToDelete.begin();
            for (; vIt != m_vectToDelete.end(); vIt++)
            {
                if ((*vIt)->BaseWidget() == (*vIt))
                {
                    pDoc->XMLPage()->DeleteItem((*vIt)->XMLWidget());
                }
                else
                {
                    (*vIt)->ParentWidget()->XMLWidget()->DeleteItem((*vIt)->XMLWidget());
                    if ((*vIt)->Action() != NULL)
                    {
                        (*vIt)->ParentWidget()->DeleteAction((*vIt)->Action());
                    }
                    else
                    {
                        (*vIt)->ParentWidget()->DeleteWidget((*vIt));
                    }
                }
            }

            // Step backwards to delete the windows and memory for the widgets
            // from the bottom most widget to the top most widget.
            _FSI_STL::vector<CWidget*>::reverse_iterator rvIt = 
                                                    m_vectToDelete.rbegin();

            for (; rvIt != m_vectToDelete.rend(); rvIt++)
            {
                if ((*rvIt)->Wnd() != NULL)
                {
                    (*rvIt)->Wnd()->DestroyWindow();
                }

                if ((*rvIt) == m_pWidget)
                {
                    m_pWidget = NULL;
                }

                (*rvIt)->Deleting(true);
            }

            CXMLPage* pXMLPage = new CXMLPage;
            *pXMLPage = *(pDoc->XMLPage());
            pDoc->m_undoPages.ok_push(pXMLPage);

            pFrame->EditorTree()->AddWidgets(pDoc);
        }
    }
    *pResult = 0;
}

void CWidgetProps::DeleteTraversal(HTREEITEM hItem)
{
    if (hItem == NULL)
    {
        return;
    }

    // Recursively get "delete" all of the children or the
    // selected item.
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    while (m_pctrlTree->ItemHasChildren(hItem) == TRUE)
    {
        HTREEITEM hNextItem = m_pctrlTree->GetChildItem(hItem);
        DeleteTraversal(hNextItem);
    }

    unsigned int ucStep = 0;
    bool bFound = false;

    FindItem(m_pctrlTree->GetSafeHwnd(), NULL, ucStep, 
             hItem, bFound);
    CWidget* pWidget = m_vectWidgets[ucStep];

    // Don't delete the page widget.
    CString strWidgetName(pWidget->WidgetName().c_str());
    strWidgetName.MakeUpper();
    if (strWidgetName == "PAGE")
    {
        return;
    }

    // Remove the widget from the local vector of widgets.
    _FSI_STL::vector<CWidget*>::iterator vIt = NULL;
    vIt = _FSI_STL::find(m_vectWidgets.begin(), m_vectWidgets.end(), pWidget);
    if (vIt != m_vectWidgets.end())
    {
        m_vectWidgets.erase(vIt);
    }


    CMainFrame* pFrame = (CMainFrame*)GetParent();
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());
    _FSI_STL::list<CWidget*>::iterator lIt = NULL;

    // Remove the widget from the document's list of widgets.
    lIt = _FSI_STL::find(pDoc->m_listWidgets.begin(), pDoc->m_listWidgets.end(), 
                    pWidget);
    
    if (lIt != pDoc->m_listWidgets.end())
    {
        pDoc->m_listWidgets.erase(lIt);
    }

    m_vectToDelete.push_back(pWidget);

    // Remove the widget from the tree control.
    m_pctrlTree->DeleteItem(hItem);

}
