// PropertiesDlg.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "fsisuite.h"
#include "PropertiesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPropertiesDlg dialog


CPropertiesDlg::CPropertiesDlg()
	: CDialog(CPropertiesDlg::IDD, NULL)
{
	//{{AFX_DATA_INIT(CPropertiesDlg)
	//}}AFX_DATA_INIT
    m_pPropSheet = NULL;
}

CPropertiesDlg::~CPropertiesDlg()
{
    Cleanup();
}

void CPropertiesDlg::Cleanup()
{
  	if (m_mapOptions.size() > 0)
	{
	    // Don't delete the pointers since they will be deleted when 
        // the CI is deleted.
        _FSI_STL::map<_FSI_STL::string, CBasePage*>::iterator mIt = m_mapOptions.begin();
        for (; mIt != m_mapOptions.end(); mIt++)
        {
            m_pPropSheet->RemovePage(0);
            delete (*mIt).second;
        }
		m_mapOptions.clear();
	}

    if (m_pPropSheet != NULL) 
    {
        m_pPropSheet->DestroyWindow();
        delete m_pPropSheet;
        m_pPropSheet = NULL;
    }
}


void CPropertiesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPropertiesDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPropertiesDlg, CDialog)
	//{{AFX_MSG_MAP(CPropertiesDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPropertiesDlg message handlers

BOOL CPropertiesDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
    CenterWindow();
   
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPropertiesDlg::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class
	CDialog::PostNcDestroy();
    delete this;
}

void CPropertiesDlg::LoadPages()
{
    _FSI_STL::map<_FSI_STL::string, CBasePage*>::iterator mIt = m_mapOptions.begin();

    for (; mIt != m_mapOptions.end(); mIt++)
    {
        m_pPropSheet->AddPage((*mIt).second);
    }
}

void CPropertiesDlg::DisplayNewPropertySheet(_FSI_STL::map<_FSI_STL::string,CBasePage*>& rmapOptions)
{
    CPropertySheet* pPropSheet = m_pPropSheet;
    m_pPropSheet = new CPropertySheet();
    ASSERT(m_pPropSheet);

    LoadPages();

    // Retrieve the location of the window
    CRect rectListWnd;
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    m_pctrlTree->GetWindowRect(rectListWnd);
    ScreenToClient(rectListWnd);

    m_pPropSheet->EnableStackedTabs(FALSE);

    if (!m_pPropSheet->Create(this, WS_SYSMENU | WS_CHILD | WS_CLIPSIBLINGS | 
                                    WS_VISIBLE, 0))
    {
        if (pPropSheet != NULL)
        {
            pPropSheet->DestroyWindow();
            if (rmapOptions.size() > 0)
            {
                _FSI_STL::map<_FSI_STL::string,CBasePage*>::iterator mIt = 
                                                               rmapOptions.begin();
                for (; mIt != rmapOptions.end(); mIt++)
                {
                    delete (*mIt).second;
                }
                rmapOptions.clear();
            }
            delete pPropSheet;
        }
        return;
    }

    m_pPropSheet->ModifyStyleEx(0, WS_EX_CONTROLPARENT);

    m_pPropSheet->SetWindowPos(NULL, rectListWnd.right+7,rectListWnd.top - 5,0,
                                0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);

    if (pPropSheet != NULL)
    {
        pPropSheet->DestroyWindow();

        if (rmapOptions.size() > 0)
        {
            _FSI_STL::map<_FSI_STL::string,CBasePage*>::iterator mIt = 
                                                           rmapOptions.begin();
            for (; mIt != rmapOptions.end(); mIt++)
            {
                delete (*mIt).second;
            }
            rmapOptions.clear();
        }
        delete pPropSheet;
    }
}

void CPropertiesDlg::DeleteTreeItem(CString& rstrComponentName)
{
	// When a component library is deleted or disabled, the
	// DeleteComponent method should be called with the name
	// of the component being deleted or disabled.

    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
	HTREEITEM hTreeItem = m_pctrlTree->GetRootItem();
    CString strComponent(rstrComponentName);
    CString strCurrentItem;

	while (hTreeItem != NULL)
	{
        strCurrentItem = m_pctrlTree->GetItemText(hTreeItem);
        if (strCurrentItem == strComponent)
        {
            m_pctrlTree->DeleteItem(hTreeItem);
            hTreeItem = NULL;
        }
        else
        {
		    hTreeItem = m_pctrlTree->GetNextSiblingItem(hTreeItem);
        }
	}
}

void CPropertiesDlg::InsertTreeItem(CString& rstrComponentName)
{
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    m_pctrlTree->InsertItem(rstrComponentName,0,0);
}

