// Options.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "FSISuite.h"
#include "MainFrm.h"
#include "Options.h"

#include "ComponentPage.h"
#include "DepthPage.h"
#include "MultimonitorPage.h"
#include "MiscPage.h"

#include "..\core\ColorPage.h"
#include "GlobalColorPage.h"
#include "GlobalFontPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const unsigned char ucDIV_TITLE_AND_EDITING = 10;
/////////////////////////////////////////////////////////////////////////////
// COptions dialog


COptions::COptions() : CPropertiesDlg()
{
	//{{AFX_DATA_INIT(COptions)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

COptions::~COptions()
{
    if (m_listFileNames.size() > 0)
    {
        _FSI_STL::list<CString*>::iterator lIt = m_listFileNames.begin();
        for (; lIt != m_listFileNames.end(); lIt++)
        {
            DeleteFile((LPCTSTR)*(*lIt));
            delete *lIt;
        }
        m_listFileNames.clear();
    }
}


void COptions::DoDataExchange(CDataExchange* pDX)
{
	CPropertiesDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptions)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptions, CPropertiesDlg)
	//{{AFX_MSG_MAP(COptions)
	ON_BN_CLICKED(ID_APPLY_NOW, OnApplyNow)
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_NOTIFY(TVN_SELCHANGED, IDC_COMPONENT_TREE, OnSelchangedComponentTree)
    ON_WM_DESTROY()
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_NOTIFY_CHANGE, OnNotifyChange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptions message handlers
void COptions::OnSelchangedComponentTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    CString strNewComponent = 
                          m_pctrlTree->GetItemText(pNMTreeView->itemNew.hItem);
	*pResult = 0;

    _FSI_STL::map<_FSI_STL::string, CBasePage*> mapOptions = m_mapOptions;
    m_mapOptions.clear();

    // If libraries have been loaded, then get their property pages.
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    CComponentInterface* pCI = 
                           pApp->FindComponentInterfaceByName(strNewComponent);

    if (pCI != NULL)
    {
        // call the function
		_FSI_STL::list<CreatePage>* pPropPagesList = pCI->PropPages();

		_FSI_STL::list<CreatePage>::iterator lIt;
        CString strTitle;
        CBasePage* pPage = NULL;
        for (lIt = pPropPagesList->begin();
			 lIt != pPropPagesList->end();
             lIt++)
        {
            pPage = (*lIt)();
            if (pPage != NULL)
            {
                m_mapOptions[pPage->PageName()] = pPage;
                pPage->SetProperties((void*)(pCI->ComponentName().c_str()));
            }
        }

    }
    else
    {
        CBasePage* pPage = new CComponentPage;
        m_mapOptions[pPage->PageName()] = pPage;
        pPage->SetProperties(NULL);
        pPage = new CDepthPage;
        m_mapOptions[pPage->PageName()] = pPage;
        pPage->SetProperties(NULL);
        pPage = new CMultimonitorPage;
        m_mapOptions[pPage->PageName()] = pPage;
        pPage->SetProperties(NULL);
        pPage = new CGlobalColorPage;
        m_mapOptions[pPage->PageName()] = pPage;
        pPage->SetProperties(NULL);
        pPage = new CGlobalFontPage;
        m_mapOptions[pPage->PageName()] = pPage;
        pPage->SetProperties(NULL);
        pPage = new CMiscPage;
        m_mapOptions[pPage->PageName()] = pPage;
        pPage->SetProperties(NULL);
    }

    DisplayNewPropertySheet(mapOptions);
}

void COptions::OnApplyNow() 
{
	// TODO: Add your control notification handler code here
    CWidget::ResetFonts();
    CColor::ResetColors();

    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    HTREEITEM hSelectedItem = m_pctrlTree->GetSelectedItem();
    CString strComponent = m_pctrlTree->GetItemText(hSelectedItem);

    // Update all of the properties.
	_FSI_STL::map<_FSI_STL::string, CBasePage*>::iterator mIt = m_mapOptions.begin();
    while(mIt != m_mapOptions.end())
    {
        (*mIt).second->UpdateProperties((void*)(LPCTSTR)strComponent);
        mIt++;
    }


    // Cleanup the property pages that could have come from the component
    // libraries that are about to be unloaded. 
    Cleanup();

    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();

    char* cTempFileName = _tempnam("c:\\temp","fsiopt");
    if (cTempFileName != NULL)
    {
        CString* pstrFileName = new CString(cTempFileName);
        HKEY hKey;
        RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite"), 0, KEY_READ, &hKey);

        if (hKey != NULL)
        {
            static HANDLE           hToken;   
            static TOKEN_PRIVILEGES tp;
            static LUID             luid;   
    
            // Enable backup privilege.
            OpenProcessToken( GetCurrentProcess(),
                              TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken ) ;
            LookupPrivilegeValue( NULL, "SeBackupPrivilege", &luid );
            tp.PrivilegeCount           = 1;   
            tp.Privileges[0].Luid       = luid;
            tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
            AdjustTokenPrivileges( hToken, FALSE, &tp,
                                   sizeof(TOKEN_PRIVILEGES), NULL, NULL );

            // Insert your code here to save the registry keys/subkeys.
            RegSaveKey(hKey, cTempFileName, NULL);

            // Disable backup privilege.
            AdjustTokenPrivileges( hToken, TRUE, &tp, sizeof(TOKEN_PRIVILEGES),
                                   NULL, NULL );
            RegCloseKey(hKey);

            m_undoOptions.apply_push(pstrFileName);
            m_listFileNames.push_back(new CString(*pstrFileName));
            free(cTempFileName);
        }
    }

    // Reload all configuration data.
    ::PostThreadMessage(pApp->m_nThreadID, TM_LOAD_CONFIG_DATA, 0, 0);
}

void COptions::OnOK() 
{
	// TODO: Add extra validation here
    OnApplyNow();

    // Don't need an ok_push for the undo since the undo structure is only for
    // this instance of the options dialog.  The apply now will take care of
    // the changes.

    DestroyWindow();
}

void COptions::OnHelp() 
{
	// TODO: Add your control notification handler code here
    GetParent()->PostMessage(WM_COMMAND, ID_HELP_FINDER, 0);
}

void COptions::OnCancel() 
{
	// TODO: Add extra cleanup here
    Cleanup();

    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    CString* pstrFileName = m_undoOptions.undo(true);
    if (pstrFileName != NULL)
    {
        HKEY hKey;
        RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite"), 0, KEY_READ, &hKey);

        if (hKey != NULL)
        {
            static HANDLE           hToken;   
            static TOKEN_PRIVILEGES tp;
            static LUID             luid;   
    
            // Enable backup privilege.
            OpenProcessToken( GetCurrentProcess(),
                              TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken );
            LookupPrivilegeValue( NULL, "SeRestorePrivilege", &luid );
            tp.PrivilegeCount           = 1;   
            tp.Privileges[0].Luid       = luid;
            tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
            AdjustTokenPrivileges( hToken, FALSE, &tp,
                                   sizeof(TOKEN_PRIVILEGES), NULL, NULL );

            // Insert your code here to save the registry keys/subkeys.
            RegRestoreKey(hKey, (LPCTSTR)*pstrFileName, NULL);

            // Disable backup privilege.
            AdjustTokenPrivileges( hToken, TRUE, &tp, sizeof(TOKEN_PRIVILEGES),
                                   NULL, NULL );
            RegCloseKey(hKey);


            // Reload all configuration data.
            ::PostThreadMessage(pApp->m_nThreadID, TM_LOAD_CONFIG_DATA, 0, 0);
        }
    }

    DestroyWindow();
}

BOOL COptions::Create(CWnd* pParentWnd) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL bRetVal = CPropertiesDlg::Create(IDD,pParentWnd);
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    m_undoOptions.maxSize(pApp->MaxUndoSize());

    char* cTempFileName = _tempnam("c:\\temp","fsiopt");
    if (cTempFileName != NULL)
    {
        HKEY hKey;
        RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite"), 0, KEY_READ, &hKey);

        if (hKey != NULL)
        {
            static HANDLE           hToken;   
            static TOKEN_PRIVILEGES tp;
            static LUID             luid;   
    
            // Enable backup privilege.
            OpenProcessToken( GetCurrentProcess(),
                              TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken ) ;
            LookupPrivilegeValue( NULL, "SeBackupPrivilege", &luid );
            tp.PrivilegeCount           = 1;   
            tp.Privileges[0].Luid       = luid;
            tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
            AdjustTokenPrivileges( hToken, FALSE, &tp,
                                   sizeof(TOKEN_PRIVILEGES), NULL, NULL );

            // Insert your code here to save the registry keys/subkeys.
            RegSaveKey(hKey, cTempFileName, NULL);

            // Disable backup privilege.
            AdjustTokenPrivileges( hToken, TRUE, &tp, sizeof(TOKEN_PRIVILEGES),
                                   NULL, NULL );
            RegCloseKey(hKey);
            m_undoOptions.ok_push(new CString(cTempFileName));
            m_listFileNames.push_back(new CString(cTempFileName));
            free(cTempFileName);
        }
    }

    m_pctrlTree = (CTreeCtrl*)GetDlgItem(IDC_COMPONENT_TREE);
    CBasePage* pPage = new CComponentPage;
    m_mapOptions[pPage->PageName()] = pPage;
    pPage = new CDepthPage;
    m_mapOptions[pPage->PageName()] = pPage;
    pPage->SetProperties(NULL);
    pPage = new CMultimonitorPage;
    m_mapOptions[pPage->PageName()] = pPage;
    pPage->SetProperties(NULL);
    pPage = new CGlobalColorPage;
    m_mapOptions[pPage->PageName()] = pPage;
    pPage->SetProperties(NULL);
    pPage = new CGlobalFontPage;
    m_mapOptions[pPage->PageName()] = pPage;
    pPage->SetProperties(NULL);
    pPage = new CMiscPage;
    m_mapOptions[pPage->PageName()] = pPage;
    pPage->SetProperties(NULL);

    _FSI_STL::map<_FSI_STL::string, CBasePage*> mapBlank;
    DisplayNewPropertySheet(mapBlank);
	
	HTREEITEM hTreeItem = m_pctrlTree->InsertItem("Suite Setup",0,0);

    // If libraries have been loaded, then get their property dialogs.
    STRING2CI_MAP s2cimap = pApp->GetComponentInterfaces();
    STRING2CI_MAP::iterator s2ciIt = s2cimap.begin();
    STRING2CI_MAP::iterator s2ciendIt = s2cimap.end();
    CComponentInterface* pCI;

    while (s2ciIt != s2ciendIt)
    {
        // call the function
        pCI = (*s2ciIt).second;
        hTreeItem = m_pctrlTree->InsertItem((pCI->ComponentName()).c_str(),0,0);
        s2ciIt++;
    }

	return bRetVal;
}

void COptions::OnDestroy()
{
    CMainFrame* pFrame = (CMainFrame*)GetParent();

    pFrame->m_pDlgOptions = NULL;
}

LPARAM COptions::OnNotifyChange(WPARAM wParam, LPARAM lParam)
{
    NMTREEVIEW nmtv;
    TVITEM tvItem;
    tvItem.mask = TVIF_HANDLE;
    tvItem.hItem = m_pctrlTree->GetSelectedItem();
    nmtv.hdr.idFrom = m_pctrlTree->GetDlgCtrlID();
    nmtv.hdr.hwndFrom = m_pctrlTree->GetSafeHwnd();
    nmtv.hdr.code = TVN_SELCHANGED;
    nmtv.itemOld = tvItem;
    nmtv.itemNew = tvItem;
    SendMessage(WM_NOTIFY, nmtv.hdr.idFrom, (long)&nmtv);

    return 0;
}