#ifndef _MULTIMONITORPAGE_H_
#define _MULTIMONITORPAGE_H_

#include <multimon.h>

#include "..\core\STLTypes.h"

#include "..\core\BasePage.h"

#include "resource.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// MultimonitorPage.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CMultimonitorPage dialog

class CMultimonitorPage : public CBasePage
{
private:
    _FSI_STL::vector<MONITORINFOEX> m_vectMonitorInfo;

protected:
    virtual void Initialize();

// Construction
public:
	CMultimonitorPage();   // standard constructor
    static CBasePage* CreateObject();

    void AddMonitorInfo(MONITORINFOEX mi);

// Dialog Data
	//{{AFX_DATA(CMultimonitorPage)
	enum { IDD = IDD_SUITE_PAGE_MULTIMONITOR };
	CComboBox	m_ctrlDisplaysCombo;
	BOOL	m_bAllDisplays;
	CString	m_strMonitorResolution;
	CString	m_strNumberOfDisplays;
	CString	m_strDisplaysInUse;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMultimonitorPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL


// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CMultimonitorPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeDisplaysCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // #ifndef _MULTIMONITORPAGE_H_
