// MultimonitorPage.cpp : implementation file
//
#include "..\core\stdafx.h"
#include "MultimonitorPage.h"

#include "FSISuite.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

BOOL CALLBACK EnumMonitorPageProc(HMONITOR hMonitor, HDC hdcMonitor, 
                                  LPRECT lprcMonitor, LPARAM dwData)
{
    CMultimonitorPage* pPage = (CMultimonitorPage*)dwData;

    MONITORINFOEX mi;        
    mi.cbSize = sizeof(mi);
    GetMonitorInfo(hMonitor, (MONITORINFO*)&mi);
    pPage->AddMonitorInfo(mi);
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMultimonitorPage dialog


CMultimonitorPage::CMultimonitorPage() : CBasePage(CMultimonitorPage::IDD)
{
	//{{AFX_DATA_INIT(CMultimonitorPage)
	m_bAllDisplays = FALSE;
	m_strMonitorResolution = _T("");
	m_strNumberOfDisplays = _T("");
	m_strDisplaysInUse = _T("");
	//}}AFX_DATA_INIT
    Initialize();
}

void CMultimonitorPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultimonitorPage)
	DDX_Control(pDX, IDC_DISPLAYS_COMBO, m_ctrlDisplaysCombo);
	DDX_Check(pDX, IDC_ALL_DISPLAYS_CHECK, m_bAllDisplays);
	DDX_Text(pDX, IDC_MONITOR_RES_STATIC, m_strMonitorResolution);
	DDX_Text(pDX, IDC_NUM_OF_DISPLAYS, m_strNumberOfDisplays);
	DDX_Text(pDX, IDC_DISPLAYS_IN_USE, m_strDisplaysInUse);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMultimonitorPage, CDialog)
	//{{AFX_MSG_MAP(CMultimonitorPage)
	ON_CBN_SELCHANGE(IDC_DISPLAYS_COMBO, OnSelchangeDisplaysCombo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMultimonitorPage message handlers
BOOL CMultimonitorPage::OnInitDialog() 
{
	CDialog::OnInitDialog();

    EnumDisplayMonitors(NULL,NULL,EnumMonitorPageProc,(long)this);

    char cConvertedNumber[32];

    m_ctrlDisplaysCombo.ResetContent();
    unsigned char ucMonitorStep = 1;
    for (; ucMonitorStep <= m_vectMonitorInfo.size(); ucMonitorStep++)
    {
        itoa(ucMonitorStep,cConvertedNumber,10);
        m_ctrlDisplaysCombo.AddString(cConvertedNumber);
    }

    m_ctrlDisplaysCombo.SetCurSel(0);

    MONITORINFOEX mi = m_vectMonitorInfo[0];
    m_strMonitorResolution.Format("%d x %d", 
                                  mi.rcMonitor.right-mi.rcMonitor.left,
                                  mi.rcMonitor.bottom-mi.rcMonitor.top);

    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();

    m_strDisplaysInUse.Format("%d",pApp->m_vectThreads.size() + 1);

    m_strNumberOfDisplays.Format("%d", m_vectMonitorInfo.size());

    UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMultimonitorPage::Initialize()
{
    m_stlStrPageName = _FSI_STL::string("Multimonitor");
}


void CMultimonitorPage::OnSelchangeDisplaysCombo() 
{
    CString strMonitorRes;
    unsigned char ucMonitorNumber = m_ctrlDisplaysCombo.GetCurSel();

    MONITORINFOEX mi = m_vectMonitorInfo[ucMonitorNumber];
    m_strMonitorResolution.Format("%d x %d",mi.rcMonitor.right-mi.rcMonitor.left,
                                 mi.rcMonitor.bottom-mi.rcMonitor.top);

    UpdateData(FALSE);
}

CBasePage* CMultimonitorPage::CreateObject()
{
    return new CMultimonitorPage;
}

void CMultimonitorPage::SetProperties(void* pWidget)
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
                 _T("Software\\FlightSafety\\FSISuite\\Settings"),
                 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("UseAllDisplays"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        m_bAllDisplays = ulData;       

        RegCloseKey(hKey);
    }
}

void CMultimonitorPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
                 _T("Software\\FlightSafety\\FSISuite\\Settings"),
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                 &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);

        unsigned long int ulData;
        DWORD dwSize = sizeof(unsigned long int);
        ulData = m_bAllDisplays;
        RegSetValueEx(hKey, _T("UseAllDisplays"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        RegCloseKey(hKey);
    }
}

void CMultimonitorPage::AddMonitorInfo(MONITORINFOEX mi)
{
    m_vectMonitorInfo.push_back(mi);
}
