// MiscPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "MiscPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMiscPage dialog


CMiscPage::CMiscPage(CWnd* pParent /*=NULL*/)
	: CBasePage(CMiscPage::IDD)
{
	//{{AFX_DATA_INIT(CMiscPage)
	m_strHelpFilePath = _T("");
	m_bUseScale = FALSE;
	m_bHideComponentButtons = FALSE;
	//}}AFX_DATA_INIT
    m_stlStrPageName    = _FSI_STL::string("Miscellaneous");
}


void CMiscPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMiscPage)
	DDX_Text(pDX, IDC_HELPFILE_PATH, m_strHelpFilePath);
	DDX_Check(pDX, IDC_SCALING, m_bUseScale);
	DDX_Check(pDX, IDC_HIDE_COMPONENTS, m_bHideComponentButtons);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMiscPage, CDialog)
	//{{AFX_MSG_MAP(CMiscPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CBasePage* CMiscPage::CreateObject()
{
    return new CMiscPage;
}

void CMiscPage::SetProperties(void* pWidget)
{
    HKEY hKey;

    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("UseScale"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);

        if (ulData > 0)
        {
            m_bUseScale = TRUE;
        }
        else
        {
            m_bUseScale = FALSE;
        }

      // Hide component buttons 

        RegQueryValueEx(hKey, _T("HideComponentButtons"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        if (ulData > 0)
        {
            m_bHideComponentButtons = TRUE;
        }
        else
        {
            m_bHideComponentButtons = FALSE;
        }

         // Get the name of the GlobalFont.
		CString strValue;
		DWORD dwType, dwCount;
		LONG lResult = RegQueryValueEx(hKey, _T("HelpFile"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("HelpFile"), NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_strHelpFilePath = strValue;

        RegCloseKey(hKey);
    }
}

void CMiscPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"),
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);

        DWORD dwSize = sizeof(m_bUseScale);
        RegSetValueEx(hKey, _T("UseScale"), NULL, REG_DWORD, (BYTE*)&m_bUseScale, dwSize);

        RegSetValueEx(hKey, _T("HideComponentButtons"), NULL, REG_DWORD, (BYTE*)&m_bHideComponentButtons, dwSize);

        RegSetValueEx(hKey, _T("HelpFile"), NULL, REG_SZ, (BYTE*)(LPCTSTR)m_strHelpFilePath, m_strHelpFilePath.GetLength() + 1);

        RegCloseKey(hKey);
    }
}
