/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MainFrm.h
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.10 $
//
// Description      : MainFrm.h contains the definition of the 
//                    CMainFrame class derived from CFrameWnd.  The 
//                    main frame is the main application window that 
//                    contains the menu, any toolbars, and the client 
//                    area that should be filled with views.  For 
//                    FSISuite, the main application window has a menu, 
//                    a rebar at the bottom with three parts, and a 
//                    client area that should display pages.  The three 
//                    areas on the rebar are (1) an area for selecting 
//                    a component (IOS, Malfunction Editor, Lesson Plan 
//                    Editor, Debug, etc), a component specific area 
//                    which would be used for quick access to 
//                    frequented areas in that component (Area Map, 
//                    Malfunctions, etc for IOS), and a global area 
//                    that has a print button, a help button, and a 
//                    navigation button.  This global area is the same 
//                    no matter which component is selected.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MainFrm.h $
// Revision 1.10  2000/05/18 21:02:21  billyb
// Added help editor.
// Revision 1.9  2000/03/07 00:58:40  billyb
// Changed function signatures to eliminate warnings.
// Removed unused methods.
// Revision 1.8  2000/02/08 20:30:06  billyb
// Added two new message handlers for displaying and closing
// automatic popups.
// Revision 1.7  2000/02/04 10:04:50  billyb
// Centered help windows on the correct screen when running
// with multiple monitors.  Changed CreateWidgets to use OnScreenView
// rather than the OffScreenView.  Created OnMultimonClose for when
// the primary window needs to close the other monitors down.
// Revision 1.6  2000/01/24 08:51:37  billyb
// Added member, accessor, and mutator for help file path.
// Added message handler for creating a page once the
// thread for reading the file has completed.
// Revision 1.5  1999/11/28 23:02:02  billyb
// Reordered member variables for better memory access.  
// Removed unused OnInitMenu method.  Added persistant
// overlay management handlers.  Added DestroyOverlays.
// Revision 1.4  1999/10/14 19:41:39  billyb
// Added IXMLDOMDocument* member.
// Revision 1.3  1999/09/13 17:05:03  billyb
// Changed ID numbers for collar controls.  Added 
// pointers to a CXMLPage for the horizontal and 
// vertical collars.  Added methods for computing 
// the size of the collars.  Added methods to 
// change the collars.  Changed TreverseWidgets
// signature.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_MAINFRM_H_)
#define _MAINFRM_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum
{
    IDC_COMPONENT_BUTTON                = 36500,
    IDC_HORIZONTAL_COMPONENT_SPECIFIC   = 36000,
    IDC_VERTICAL_COMPONENT_SPECIFIC     = 35500,
};

static const unsigned short IDC_COMPONENT_BUTTON_MIN = 36500;
static const unsigned short IDC_COMPONENT_BUTTON_MAX = 36999;

#include "EditorTree.h"
#include "EditorControls.h"
#include "bottombar.h"
#include "leftrightbar.h"

class CWidgetProps;
class COptions;
class CPropertiesDlg;
class COverlayDlg;
class CHelpEditor;

struct PageFlipTestStruct
{
    HWND        s_hWnd;
    int         s_nTestLength;
    int         s_nTestRestTime;
};

class CMainFrame : public CFrameWnd
{
private:
    bool CheckHideComponentButtons();

    bool                                m_bHelpEditorMenuAdded;

    static const UINT                   m_WM_MULTIMON_CLOSE;

    static unsigned char                m_ucNumberOfWindows;
    unsigned char                       m_ucWindowNumber;
    unsigned short int                  m_ushNumberOfComponents;

    static const float                  m_fClientRatio;

    IXMLDOMDocument *                   m_pXMLDoc;

    // Stores the entire application window before printing.  This
    // was needed because choosing properties once the print dialog
    // was displayed would cause the print dialog to be printed along 
    // with the application window.  Thus, the bitmap is created before
    // the print dialog appears and then the view class prints the 
    // bitmap and destroys it.
    HBITMAP                             m_hbm;

    CStatic*                            m_pwndLeftRightContainer;

    unsigned short int                  m_ushLastTop;
    unsigned short int                  m_ushFirstBottom;

    CStatic*                            m_pwndBottomContainer;

    CXMLPage*                           m_pVerticalXMLPage;
    CXMLPage*                           m_pHorizontalXMLPage;

    long int                            m_lLastComponentID;

    CHelpEditor*                        m_pHelpEditor;

    unsigned long int                   m_ulLoadNumber;

    CEditorTree                         m_wndEditorTree;
    CEditorControls                     m_wndEditorControls;

    CBottomBar                          m_wndBottomBar;
    CLeftRightBar                       m_wndLeftRightBar;

    _FSI_STL::vector<CAction*>          m_vectPageChangeActions;

    // A dynamic list of buttons on the componet bar.
    _FSI_STL::vector<CButton*>          m_vectComponentButtons;

    _FSI_STL::list<CWidget*>            m_listVerticalComponentSpecificWidgets;
    _FSI_STL::list<CWidget*>            m_listBottomComponentSpecificWidgets;

    _FSI_STL::list<COverlayDlg*>        m_listOverlays;

    _FSI_STL::string                    m_stlStrLastComponentName;
    _FSI_STL::string                    m_stlStrHelpFile;

    _FSI_STL::map<_FSI_STL::string, COverlayDlg*>     m_mapNameToOverlay;

    void TraverseWidgets(CXMLWidget* pXMLWidget, 
                        CWnd* pParentWnd, unsigned long& rulId, 
                        CWidget* pBaseParentWidget, CWidget* pParentWidget,
                        _FSI_STL::list<CWidget*>& rlistWidgets);

   static   UINT  MsgThread(LPVOID param);

protected: // create from serialization only
	CMainFrame();
	HPALETTE GetSystemPalette();  
    DECLARE_DYNCREATE(CMainFrame)
    void AppendFilterSuffix(CString& filter, OPENFILENAME& ofn,
	                                CDocTemplate* pTemplate, 
                                    CString* pstrDefaultExt);
    void HorizontalCollarSize(CRect& rectHorizontal);
    void VerticalCollarSize(CRect& rectVertical);
     

// Attributes
public:
    // Constants for setting the number of buttons across the Rebar and
    // the width between the buttons.  
    static const unsigned char      m_ucButtonDivider;
    static const unsigned char      m_ucButtonsAcross;
    static const unsigned char      m_ucButtonsDown;
    static const unsigned char      m_ucBottomHeight;
    static const unsigned long int  m_ulClientScreenWidthBase;
    static const unsigned long int  m_ulClientScreenHeightBase;

    // The options dialog that allows for adding, deleting, and disabling
    // componet libraries as well as containing all of the component
    // library implement option pages.
    COptions*                        m_pDlgOptions;

    // The widget props dialog that allows for changing the values 
    // of the elements for a widget.
    CWidgetProps*                    m_pDlgWidgetProps;

    struct PageFlipTestStruct        m_pfts;

    _FSI_STL::string HelpFile();

    void HelpFile(const _FSI_STL::string& rstlStrHelpFile);

    friend class CHelpEditor;

// Operations
public:
    static UINT Rest(LPVOID param);
    CEditorControls* EditorControls();
    CEditorTree* EditorTree();
    HBITMAP PrintScreen();
    void PrintScreen(HBITMAP hbm);
    void BeginClose();
    void CreateBitmap();
    void DestroyOverlays();
    void StartAs(const CString& strComponent);
    unsigned char WindowNumber();
    unsigned long LoadNumber();

    void PageFlipTestLength(const CString& rstrTestLength);
    void PageFlipTestRest(const CString& rstrTestRest);
    void PerformPageFlipTest();

    _FSI_STL::string LastComponent();
    long int LastComponentID();


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

// Implementation
public:
	bool m_bAdmin;
	virtual ~CMainFrame();
    void AddComponent(const _FSI_STL::string& rstlStrComponentName);
    void DeleteComponent(const _FSI_STL::string& rstlStrComponentName);
    void DeleteComponentSpecific();
    void NullComponent();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnHelpFinder();
	afx_msg void OnEditRedo();
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditRedo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileNew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
   afx_msg void OnUpdateEditOptions(CCmdUI* pCmdUI);
	afx_msg void OnDestroy();
	afx_msg void OnClose();
	afx_msg void OnFileOpen();
    afx_msg void OnFileNew();
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnQueryEndSession();
	//}}AFX_MSG
    // respond to click on component button
	afx_msg void OnComponentButton(UINT nCommandID);  

    // Display options dialog
    afx_msg void OnOptions();

    // Display a help editor
    afx_msg void OnHelpEditor();

    // Load a most recently used file.  This is not normal.
    // CWinApp has a OnOpenRecentFile but we need the multimonitor
    // stuff.
    afx_msg BOOL OnOpenRecentFile(UINT nID);

    afx_msg void OnHelp();

    afx_msg void OnPrint();
    afx_msg void OnPrintPreview();

    LPARAM OnDisplayWidgetProps(WPARAM wParam, LPARAM lParam);
    LPARAM OnDisplayOverlay(WPARAM wParam, LPARAM lParam);
    LPARAM OnUpdateEditView(WPARAM wParam, LPARAM lParam);
	LPARAM OnChangePage(WPARAM wParam, LPARAM lParam);
	LPARAM OnChangeHorizontalContent(WPARAM wParam, LPARAM lParam);
	LPARAM OnChangeVerticalContent(WPARAM wParam, LPARAM lParam);
	LPARAM OnOverlayClose(WPARAM wParam, LPARAM lParam);
	LPARAM OnNextTab(WPARAM wParam, LPARAM lParam);
	LPARAM OnPreviousTab(WPARAM wParam, LPARAM lParam);
	LPARAM OnDialogHelp(WPARAM wParam, LPARAM lParam);
    LPARAM OnReadFileComplete(WPARAM wParam, LPARAM lParam);
    LPARAM OnMultimonClose(WPARAM wParam, LPARAM lParam);
    LPARAM OnDisplayAutoOverlay(WPARAM wParam, LPARAM lParam);
    LPARAM OnCloseAutoOverlay(WPARAM wParam, LPARAM lParam);
    LPARAM OnRestedNowChange(WPARAM wParam, LPARAM lParam);

    DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_MAINFRM_H_)
