/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MainFrm.cpp
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.16 $
//
// Description      : MainFrm.cpp is the implemenation of the 
//                    CMainFrame class.  This file was generated
//                    by DevStudio.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MainFrm.cpp $
// Revision 1.16  2000/05/30 22:57:17  billyb
// Added support for specifying a help file other than the default.
// Revision 1.15  2000/05/18 21:03:55  billyb
// Added help editor.  Fixed display of help.
// Revision 1.14  2000/03/31 22:55:24  billyb
// Deleted old code.  Fixed display of editor controls when no
// bottom collar.  Added all widgets on the collars when the collars
// change.  
// Revision 1.13  2000/03/07 00:59:34  billyb
// Changed function signatures to eliminate warnings.
// Removed unused variables.  Elimnated other warnings.
// Revision 1.12  2000/02/08 20:31:27  billyb
// Removed message map entries for add and remove overlay.
// Added message handlers for display and close automatic popups.
// Added comments and restructured code.
// Revision 1.11  2000/02/04 10:04:38  billyb
// Centered help windows on the correct screen when running
// with multiple monitors.  Changed CreateWidgets to use OnScreenView
// rather than the OffScreenView.  Created OnMultimonClose for when
// the primary window needs to close the other monitors down.
// Revision 1.10  2000/01/27 22:19:28  billyb
// Changed help methods to work with help path member.  Added
// cleanup code for double buffered view.  Added support for
// reading XML files from a worker thread.  
// Revision 1.9  1999/11/28 23:46:41  billyb
// Removed OnInitMenu.  Added handlers for management of
// persistant overlays.  
// Revision 1.8  1999/11/09 20:05:46  billyb
// Removed commented code.
// Revision 1.7  1999/11/08 21:28:54  billyb
// Moved creation of editor bars to when the page editor button
// is first clicked.  Removed a delete this statement that was not
// valid.
// Revision 1.6  1999/10/25 17:48:37  billyb
// Removed AfxMessageBox for help path.  Parsed string
// from dialog to display help.
// Revision 1.5  1999/10/14 19:42:13  billyb
// Added creation, initialization, and clean up of 
// IXMLDOMDocument* member.  Made sure to send m_pXMLDoc
// to ParseFile.
// Revision 1.4  1999/09/28 06:12:58  billyb
// Fixed wrong HWNDs in ChangePage and moved the
// setting of the current frame to inside of the call to
// PreventRedraw which may not return immediately.
// This should avoid a problem with multi-monitor.
// Revision 1.3  1999/09/13 17:36:28  billyb
// Added pointers to a CXMLPage for the horizontal and 
// vertical collars.  Added methods for computing 
// the size of the collars.  Added methods to 
// change the collars.  Changed TreverseWidgets
// signature.  OnComponentButton now uses
// change collar methods.
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include <lm.h>
#include "FSISuite.h"
#include "FSISuiteDoc.h"
#include "FSISuiteView.h"
#include "FSISuitePreviewView.h"

#include "CollarContainer.h"

#include "MainFrm.h"
#include "Options.h"
#include "WidgetProps.h"

#include "..\core\Range.h"
#include "..\core\OverlayDlg.h"
#include "..\core\PageWidget.h"

#include "HelpEditor.h"

#include "htmlhelp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const unsigned char CMainFrame::m_ucButtonDivider = 5;
const unsigned char CMainFrame::m_ucButtonsAcross = 14;
const unsigned char CMainFrame::m_ucButtonsDown = 15;
unsigned char CMainFrame::m_ucNumberOfWindows = 0;
const unsigned char CMainFrame::m_ucBottomHeight = 178;
const float CMainFrame::m_fClientRatio = 1.44f;
const unsigned long int CMainFrame::m_ulClientScreenWidthBase = 1280;

// The following line has been changed from its original, obvious value of 1024 to
// a new value of 1090.  This is to fix some window clipping issues that
// showed up in Windows 7, but also have been seen in Windows XP.  The issue
// is the the right side of certain buttons can be cut off on the screen.
// Why this fixes the problem is a bit of a mystery, since the intuitive answer
// would be to change the WIDTH variable, not the HEIGHT variable, but their
// effects must be somehow interdependent.  19 JAN 2012 - M LAWSON
const unsigned long int CMainFrame::m_ulClientScreenHeightBase = 1090;

const UINT              CMainFrame::m_WM_MULTIMON_CLOSE = RegisterWindowMessage("WM_MULTIMON_CLOSE");

const UINT    WM_RESTED_NOW_CHANGE = RegisterWindowMessage("WM_RESTED_NOW_CHANGE");

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
    ON_WM_HELPINFO()
	ON_COMMAND(ID_HELP_FINDER, OnHelpFinder)
	ON_COMMAND(ID_EDIT_REDO, OnEditRedo)
	ON_COMMAND(ID_EDIT_UNDO, OnEditUndo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_REDO, OnUpdateEditRedo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_UNDO, OnUpdateEditUndo)
	ON_UPDATE_COMMAND_UI(ID_FILE_NEW, OnUpdateFileNew)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
   ON_UPDATE_COMMAND_UI(ID_EDIT_OPTIONS, OnUpdateEditOptions)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_WM_GETMINMAXINFO()
	ON_WM_SIZE()
    ON_COMMAND(ID_HELP, OnHelp)
    ON_COMMAND(ID_DEFAULT_HELP, OnHelpFinder)
	ON_WM_QUERYENDSESSION()
	//}}AFX_MSG_MAP
    ON_COMMAND(ID_EDIT_OPTIONS,OnOptions)
	ON_COMMAND_RANGE(IDC_COMPONENT_BUTTON_MIN, IDC_COMPONENT_BUTTON_MAX, 
                     OnComponentButton)
	ON_COMMAND(IDC_PRINT, OnPrint)
	ON_COMMAND(IDC_PRINT_PREVIEW, OnPrintPreview)
    ON_MESSAGE(WM_DISPLAY_WIDGET_PROPS, OnDisplayWidgetProps)
    ON_MESSAGE(WM_DISPLAY_OVERLAY, OnDisplayOverlay)
    ON_MESSAGE(WM_UPDATE_EDIT_VIEW, OnUpdateEditView)
	ON_MESSAGE(WM_CHANGE_PAGE, OnChangePage)
    ON_MESSAGE(WM_OVERLAY_CLOSED, OnOverlayClose)
	ON_MESSAGE(WM_GET_NEXT_TAB, OnNextTab)
    ON_MESSAGE(WM_GET_PREV_TAB, OnPreviousTab)
    ON_MESSAGE(WM_DIALOG_HELP, OnDialogHelp)
    ON_MESSAGE(WM_CHANGE_VERT_COLLAR, OnChangeVerticalContent)
    ON_COMMAND_EX_RANGE(ID_FILE_MRU_FILE1, ID_FILE_MRU_FILE16, OnOpenRecentFile)
    ON_MESSAGE(WM_FILE_READ_COMPLETE, OnReadFileComplete)
    ON_REGISTERED_MESSAGE(m_WM_MULTIMON_CLOSE, OnMultimonClose)
    ON_REGISTERED_MESSAGE(WM_RESTED_NOW_CHANGE, OnRestedNowChange)
    ON_REGISTERED_MESSAGE(CRange::m_WM_DISPLAY_AUTO_OVERLAY, OnDisplayAutoOverlay)
    ON_REGISTERED_MESSAGE(CRange::m_WM_CLOSE_AUTO_OVERLAY, OnCloseAutoOverlay)
    ON_COMMAND(ID_HELP_EDITOR, OnHelpEditor)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CMainFrame::CMainFrame()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : Default constructor. Initializes the pointer to 
//                    the optoins dialog to NULL.  The component 
//                    section of the Rebar is also assumed to be 
//                    maximized.  The boolean should probably be set to 
//                    the same value when the application was last 
//                    closed.  Likewise, if the command line states a 
//                    specific component to start with, the component 
//                    section should be minimized.
//
/////////////////////////////////////////////////////////////////////////////
CMainFrame::CMainFrame()
{
    m_bHelpEditorMenuAdded      = false;
    m_pDlgOptions               = NULL;	
    m_pDlgWidgetProps           = NULL;	
    m_ushNumberOfComponents     = 0;
    m_hbm                       = NULL;
    m_lLastComponentID          = 0;
    m_ulLoadNumber              = 0;

    m_ucWindowNumber            = m_ucNumberOfWindows;
    m_ucNumberOfWindows++;

    m_pHelpEditor               = NULL;
    m_pwndLeftRightContainer    = NULL;
    m_pwndBottomContainer       = NULL;
    m_ushLastTop                = 0;
    m_ushFirstBottom            = 0;
    m_pVerticalXMLPage          = NULL;
    m_pHorizontalXMLPage        = NULL;
    m_pXMLDoc                   = NULL;
    m_stlStrHelpFile            = _FSI_STL::string("");

    srand((unsigned)time(NULL));

    m_pfts.s_hWnd               = NULL;
    m_pfts.s_nTestLength        = 2000;  // seconds
    m_pfts.s_nTestRestTime      = 1000;  // milliseconds

    m_bAdmin                    = true;  // normally, "false", but true for debug purposes

    CoInitialize(NULL);

    //
    // Create an empty XML document
    //
    if (CoCreateInstance(CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER,
                                IID_IXMLDOMDocument, (void**)&m_pXMLDoc) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    VARIANT_BOOL vb = VARIANT_FALSE;

    if (m_pXMLDoc->put_validateOnParse(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_resolveExternals(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_async(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// CMainFrame::~CMainFrame()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : The default destructor frees the memory in the 
//                    vector of buttons on the component section of the Rebar.
//
/////////////////////////////////////////////////////////////////////////////
CMainFrame::~CMainFrame()
{
    // Destroy the container that runs vertically.
    if (m_pwndLeftRightContainer != NULL && 
        !(m_pwndLeftRightContainer->IsKindOf(RUNTIME_CLASS(CEditorTree))))
    {
        if (m_pwndLeftRightContainer->GetSafeHwnd() != NULL)
        {
            m_pwndLeftRightContainer->DestroyWindow();
        }

        delete m_pwndLeftRightContainer;
    }

    // Destroy the container that runs horizontally.
    if (m_pwndBottomContainer != NULL && 
        !(m_pwndBottomContainer->IsKindOf(RUNTIME_CLASS(CEditorControls))))
    {
        if (m_pwndBottomContainer->GetSafeHwnd() != NULL)
        {
            m_pwndBottomContainer->DestroyWindow();
        }

        delete m_pwndBottomContainer;
    }

    // Delete any buttons that may have been on the vertical collar..
    _FSI_STL::vector<CButton*>::iterator vIt = m_vectComponentButtons.begin();
    while (vIt != m_vectComponentButtons.end())
    {
        delete (*vIt);

        vIt++;
    }
    m_vectComponentButtons.clear();

    // Destroy any widgets that may still be around on the vertical collar.
    if (m_listVerticalComponentSpecificWidgets.size() > 0)
    {
        _FSI_STL::list<CWidget*>::iterator wIt = 
                                    m_listVerticalComponentSpecificWidgets.begin();
        while (wIt != m_listVerticalComponentSpecificWidgets.end())
        {
            (*wIt)->Deleting(true);

            wIt++;
        }

        m_listVerticalComponentSpecificWidgets.clear();
    }

    // Destroy any widgets that may still be around on the horizontal collar.
    if (m_listBottomComponentSpecificWidgets.size() > 0)
    {
        _FSI_STL::list<CWidget*>::iterator wIt = 
                                    m_listBottomComponentSpecificWidgets.begin();
        while (wIt != m_listBottomComponentSpecificWidgets.end())
        {
            (*wIt)->Deleting(true);

            wIt++;
        }

        m_listBottomComponentSpecificWidgets.clear();
    }

    // Delete any created bitmaps for print preview.
    if (m_hbm != NULL) DeleteObject(m_hbm);

    // Delete any XML for the vertical collar.
    if (m_pVerticalXMLPage != NULL)
    {
        delete m_pVerticalXMLPage;
    }

    // Delete any XML for the horizontal collar.
    if (m_pHorizontalXMLPage != NULL)
    {
        delete m_pHorizontalXMLPage;
    }

    // Free the XMLDOM interface pointer.
    if (m_pXMLDoc != NULL)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

//	cs.style = WS_OVERLAPPED | WS_CAPTION | FWS_ADDTOTITLE |
//		 WS_THICKFRAME | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX | 
//         WS_MAXIMIZE | WS_DISABLED;
    cs.style |= WS_DISABLED;
 
    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    if (pApp == NULL)
    {
        return TRUE;
    }

	if (m_ucWindowNumber == 0)
	{
        MONITORINFOEX mi;
        pApp->MonitorInfo(mi, 0);

        cs.cx = mi.rcMonitor.right - mi.rcMonitor.left;
        cs.cy = mi.rcMonitor.bottom - mi.rcMonitor.top;
        cs.x = 0;
        cs.y = 0;
	}
	else
	{
		cs.cx = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->Width();
		cs.cy = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->Height();
		cs.x  = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->left;
		cs.y  = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->top;
    }

	return TRUE;
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	// We're disabling the Maximize button here, because FSISuite
	// has a problem on Windows 7 maximizing one screen (but not the other).
	// Since the Maximize button is not a requirement of JPATS, this is the
	// most expedient solution.  17 JAN 2012 - M LAWSON
	ModifyStyle(WS_MAXIMIZEBOX, 0);

    // Create the main application window.
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

    m_wndBottomBar.Create(this);
    m_wndLeftRightBar.Create(this);

    // Set the default size of a button.  This should not use SM_CXSCREEN since
    // multimonitors will be supported.  It should use the corresponding
    // identifier for current monitor display width.
	CRect rectWindow;
	GetWindowRect(&rectWindow);

    // Subtract twice the size of the frame from the width of the entire
    // frame.  Then, subtract the height of the client area times the
    // client ratio.  The result is the width of the left/right bar.
    unsigned long int ulBottomHeight = (int)(((float)m_ucBottomHeight / 
                                                (float)m_ulClientScreenHeightBase) * 
                                             GetSystemMetrics(SM_CYSCREEN) + .5);

    unsigned long int l1 = (rectWindow.Height() - 
                                           2*GetSystemMetrics(SM_CYSIZEFRAME) -
                                             GetSystemMetrics(SM_CYMENU) -
                                             GetSystemMetrics(SM_CYCAPTION) -
                                             ulBottomHeight) * m_fClientRatio;
    unsigned long int l2 = 2*GetSystemMetrics(SM_CYSIZEFRAME);
    unsigned long int ulLeftRightWidth = rectWindow.Width() - 
                                         l2 -
                                         l1;

    EnableDocking(CBRS_ALIGN_ANY);
    m_wndBottomBar.SetBarStyle(CBRS_ALIGN_BOTTOM );

    m_wndBottomBar.m_sizeHorz = CSize(-1,ulBottomHeight);
    m_wndBottomBar.m_sizeVert = CSize(350,900);
    m_wndBottomBar.m_sizeFloat = CSize(350,350);

    m_wndLeftRightBar.SetBarStyle(CBRS_ALIGN_LEFT);

    m_wndLeftRightBar.m_sizeHorz = CSize(-1,ulLeftRightWidth);
    m_wndLeftRightBar.m_sizeVert = CSize(ulLeftRightWidth,-1);
    m_wndLeftRightBar.m_sizeFloat = CSize(350,350);

    CMenu* pMenu = GetMenu();
    if (pMenu != NULL)
    {
        pMenu->EnableMenuItem(ID_FILE_SAVE_AS, 
                              MF_DISABLED | MF_GRAYED | MF_BYCOMMAND);
    }


    // This section sets m_bAdmin to true or false depending if the user is
    // a member of Administrators or not.  Otherwise, we don't want students
    // and instructors to modify the Options dialog.

    wchar_t         szCurrentUser[256];
    LPWSTR DomainController = NULL;

    DWORD           dwSizeofCurrentUser = sizeof(szCurrentUser);

    // Get the name of the current user in unicode form.
    GetUserNameW(szCurrentUser, &dwSizeofCurrentUser);

    LPGROUP_USERS_INFO_0 pBuffer = NULL;
    DWORD           dwEntriesRead;
    DWORD           dwTotalEntries;
    NET_API_STATUS  nStatus;

    USES_CONVERSION;

    // Get the groups for the current user.

    
/*
    NetGetDCName(NULL, NULL, (LPBYTE *)&DomainController);

    nStatus = NetUserGetGroups(DomainController, szCurrentUser, 0, 
                                  (LPBYTE*)&pBuffer, 
                                   MAX_PREFERRED_LENGTH,
                                   &dwEntriesRead,
                                   &dwTotalEntries); */
                                   

    
    nStatus = NetUserGetLocalGroups(NULL, szCurrentUser, 0,
                                    LG_INCLUDE_INDIRECT,
                                    (LPBYTE*)&pBuffer, 
                                    MAX_PREFERRED_LENGTH,
                                    &dwEntriesRead,
                                    &dwTotalEntries);

    if (nStatus == NERR_Success)
    {
        if (pBuffer != NULL)
        {
            LPGROUP_USERS_INFO_0 pTempBuffer = pBuffer;

            // Check each group to which the user belongs to see if
            // the user should be able to change the options settings.
            for (DWORD i = 0; i < dwEntriesRead; ++i)
            {
                OutputDebugString(W2A(pTempBuffer->grui0_name));
                if (strstr(W2A(pTempBuffer->grui0_name),
                           "Administrators") != NULL)
                {
                    m_bAdmin = true;
                }

                ++pTempBuffer;
            }
        }
    }

    if (pBuffer)
        NetApiBufferFree(pBuffer);

//    if (DomainController)
//       NetApiBufferFree(DomainController);

	return 0;

}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnOptions()
{
	if (FindWindow(NULL, "Suite Options") == NULL)
	{
        m_pDlgOptions = new COptions();

        if (m_pDlgOptions != NULL)
        {
            m_pDlgOptions->Create(this);
        }
    }
}

void CMainFrame::OnHelpEditor()
{
    if (m_pHelpEditor == NULL)
    {
        m_pHelpEditor = new CHelpEditor;
        
        if (m_pHelpEditor != NULL)
        {
            m_pHelpEditor->MainFrame(this);
            m_pHelpEditor->Create();
        }
    }
}

void CMainFrame::AddComponent(const _FSI_STL::string& rstlStrComponentName)
{
    DWORD dwButtonVisible = 0;

    if (!CheckHideComponentButtons())
       dwButtonVisible = WS_VISIBLE;

    // Sets the size of the button.
	CRect rectWindow;
    if (m_wndLeftRightBar.GetSafeHwnd() != NULL)
    {
	    m_wndLeftRightBar.GetWindowRect(&rectWindow);
    }
    else
    {
        GetWindowRect(&rectWindow);
    }

    unsigned long int ulButtonHeight = (rectWindow.Height() - (m_ucButtonsDown+1)*m_ucButtonDivider)/m_ucButtonsDown;

    unsigned long int ulButtonWidth = rectWindow.Width() - 2*m_ucButtonDivider;

    CRect rectButtonSize(0, 0, ulButtonWidth, ulButtonHeight);


    // Creates a new button and adds it to the first section of the Rebar and
    // to the vector of buttons on the first section of the Rebar.
    CButton* wndButtonNewComponent = new CButton;
    unsigned short int ushComponentCount = m_vectComponentButtons.size();
    wndButtonNewComponent->Create(rstlStrComponentName.c_str(),
                                  dwButtonVisible | WS_CHILD | BS_CHECKBOX | 
                                    BS_MULTILINE | BS_CENTER | BS_PUSHLIKE,
                                  rectButtonSize, &m_wndLeftRightBar,
                                  IDC_COMPONENT_BUTTON+m_ushNumberOfComponents);
    wndButtonNewComponent->MoveWindow(m_ucButtonDivider,
                                     (ushComponentCount+1)* m_ucButtonDivider + 
                                     ushComponentCount * rectButtonSize.Height(),
                                     rectButtonSize.Width(),
                                     rectButtonSize.Height());

    m_vectComponentButtons.push_back(wndButtonNewComponent);
    m_ushNumberOfComponents++;
}

void CMainFrame::DeleteComponent(const _FSI_STL::string& rstlStrComponentName)
{
    // Sets the size of the button.
	CRect rectWindow;
    if (m_wndLeftRightBar.GetSafeHwnd() != NULL)
    {
	    m_wndLeftRightBar.GetWindowRect(&rectWindow);
    }
    else
    {

	    GetWindowRect(&rectWindow);
        CRect rectButtonSize(0,m_ucButtonDivider,
           (rectWindow.Width()-(m_ucButtonsAcross-1)*m_ucButtonDivider)/
                                                                m_ucButtonsAcross,
           (rectWindow.Width()-(m_ucButtonsAcross-1)*m_ucButtonDivider)/
                                                                m_ucButtonsAcross);
    }

    unsigned long int ulButtonHeight = (rectWindow.Height() - (m_ucButtonsDown+1)*m_ucButtonDivider)/m_ucButtonsDown;

    unsigned long int ulButtonWidth = rectWindow.Width() - 2*m_ucButtonDivider;

    CRect rectButtonSize(0, 0, ulButtonWidth, ulButtonHeight);

    _FSI_STL::vector<CButton*>::iterator vIt = m_vectComponentButtons.begin();
    bool bButtonFound = false;
    CString strButtonText;
    unsigned short int  ushButtonNumber = 0;

    // Steps through the vector of buttons on the first section of the Rebar
    // and tries to find the button corresponding to the component library
    // being unloaded/deleted.  If a button is found, it is destroyed and
    // the memory for the button is deleted.
    while (bButtonFound != true && vIt != m_vectComponentButtons.end())
    {
        (*vIt)->GetWindowText(strButtonText);
        if (strstr(strButtonText,rstlStrComponentName.c_str()) != NULL)
        {
            (*vIt)->DestroyWindow();
            delete (*vIt);
            m_vectComponentButtons.erase(vIt);
            bButtonFound = true;
            ushButtonNumber++;
        }

        vIt++;
    }

    // Move all of the rest of the buttons down;
    vIt = m_vectComponentButtons.begin();
    while (vIt != m_vectComponentButtons.end())
    {
        (*vIt)->MoveWindow(m_ucButtonDivider,
                           ushButtonNumber * rectButtonSize.Height() + 
                               (ushButtonNumber+1) * m_ucButtonDivider,
                           rectButtonSize.Width(),
                           rectButtonSize.Height());
        ushButtonNumber++;
        vIt++;
    }
}

void CMainFrame::OnComponentButton(UINT nCommandID)
{

    CWnd* pWnd = m_wndLeftRightBar.GetDlgItem(nCommandID);

    CString strButtonName("");
    if (pWnd != NULL)
    {
        pWnd->GetWindowText(strButtonName);
    }
    else
    {
        // Most likely a message sent when the options dialog was applied
        // or cancelled.  The IDs have been reset. Thus, just set the button
        // name to the last clicked component button.
        strButtonName = m_stlStrLastComponentName.c_str();
    }

    // Reset only if a button was actually clicked.
    if (pWnd != NULL)
    {
        m_stlStrLastComponentName = _FSI_STL::string((LPCTSTR)strButtonName);
        m_lLastComponentID = nCommandID;
    }

	CRect rectWindow;
    if (m_wndLeftRightBar.GetSafeHwnd() != NULL)
    {
	    m_wndLeftRightBar.GetWindowRect(&rectWindow);
    }
    else
    {
	    GetWindowRect(&rectWindow);
    }

    CRect rectBar;
    m_wndLeftRightBar.GetWindowRect(&rectBar);

    unsigned long int ulButtonHeight = (rectWindow.Height() - (m_ucButtonsDown+1)*m_ucButtonDivider)/m_ucButtonsDown;

    unsigned long int ulButtonWidth = rectWindow.Width() - 2*m_ucButtonDivider;

    CRect rectButtonSize(0, 0, ulButtonWidth, ulButtonHeight);

    // Move buttons down.
    _FSI_STL::vector<CButton*>::reverse_iterator rvIt = 
                                               m_vectComponentButtons.rbegin();
    bool bDone = false;
    unsigned short int ushButtonNumber = 1;
    while (rvIt != m_vectComponentButtons.rend() && bDone == false)
    {
        CString strName;
        (*rvIt)->GetWindowText(strName);
        if (strName == strButtonName)
        {
            bDone = true;
            m_ushLastTop = m_vectComponentButtons.size() - ushButtonNumber;
        }
        else
        {
            (*rvIt)->MoveWindow(m_ucButtonDivider,
                                rectBar.Height() - 
                                   ushButtonNumber*(ulButtonHeight + 
                                                    m_ucButtonDivider),
                                rectButtonSize.Width(),
                                rectButtonSize.Height());
            ushButtonNumber++;
        }

        rvIt++;
    }

    // Move buttons up.
    _FSI_STL::vector<CButton*>::iterator vIt = m_vectComponentButtons.begin();
    bDone = false;
    ushButtonNumber = 0;
    while (vIt != m_vectComponentButtons.end() && bDone == false)
    {
        CString strName;
        (*vIt)->GetWindowText(strName);
        if (strName == strButtonName)
        {
            bDone = true;
            m_ushFirstBottom = ushButtonNumber + 1;
        }
        (*vIt)->MoveWindow(m_ucButtonDivider,
                           m_ucButtonDivider +      
                               ushButtonNumber*(ulButtonHeight + 
                                                m_ucButtonDivider),
                           rectButtonSize.Width(),
                           rectButtonSize.Height());
        ushButtonNumber++;
        vIt++;
    }

    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());
    CComponentInterface* pCI = 
                             pApp->FindComponentInterfaceByName(strButtonName);
    if (pCI != NULL)
    {
        // Create new CStatic holders for the component
        // specific controls.  Or, assign the addresses
        // of the editor controls to the CStatic*.
        if (pCI->EditPageMode() == false)
        {
            OnChangeVerticalContent(0, (long)(pCI->ComponentSpecificPage(m_ucWindowNumber).c_str()));
            OnChangeHorizontalContent(0, (long)(pCI->SecondaryComponentSpecificPage(m_ucWindowNumber).c_str()));

            if (m_bHelpEditorMenuAdded)
            {
                CMenu* pMenu = GetMenu();
                if (pMenu != NULL)
                {
                    pMenu->RemoveMenu(ID_HELP_EDITOR, MF_BYCOMMAND);
                    DrawMenuBar();
                }
                m_bHelpEditorMenuAdded = false;
            }

            // Get rid of any help editor dialogs
            if (m_pHelpEditor != NULL)
            {
                m_pHelpEditor->DestroyWindow();
                m_pHelpEditor = NULL;
            }
        }
        else
        {
            if (m_wndEditorControls.GetSafeHwnd() == NULL)
            {
                // Create the editor bar
                if (m_wndEditorControls.Create(&m_wndBottomBar))
                {
                    // Hide the editor bar
                    m_wndEditorControls.MoveWindow(-10000, -10000, 100, 100);
                }
            }

            if (m_wndEditorTree.GetSafeHwnd() == NULL)
            {
                // Create the editor bar
                if (m_wndEditorTree.Create(&m_wndLeftRightBar))
                {
                    // Hide the editor bar
                    m_wndEditorTree.MoveWindow(-10000, -10000, 100, 100);
                }
            }

            CString strFile = "";
            CRect rect(0, 0, 0, 0);

            OnChangeVerticalContent(0, (long)((LPCTSTR)strFile));

            m_pwndLeftRightContainer = &m_wndEditorTree;
            VerticalCollarSize(rect);
            m_pwndLeftRightContainer->MoveWindow(rect);

            OnChangeHorizontalContent(0, (long)((LPCTSTR)strFile));

            m_pwndBottomContainer = &m_wndEditorControls;
            HorizontalCollarSize(rect);
            m_pwndBottomContainer->MoveWindow(rect);

            // Clean out the reusable widgets.
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > >::iterator mIt      = NULL;
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > >::iterator mendIt   = NULL;
            _FSI_STL::list<CWidget*>::iterator lIt       = NULL;
            _FSI_STL::list<CWidget*>::iterator lendIt    = NULL;
            mIt         = CWidget::m_mapReusableWidgets.begin();
            mendIt      = CWidget::m_mapReusableWidgets.end();
            HWND hWnd   = GetActiveView()->GetSafeHwnd();
            while (mIt != mendIt)
            {
                lIt     = ((*mIt).second)[hWnd].begin();
                lendIt  = ((*mIt).second)[hWnd].end();

                while (lIt != lendIt)
                {
                    (*lIt)->Deleting(true);
                    lIt++;
                }

                ((*mIt).second)[hWnd].clear();

                mIt++;
            }

            if (!m_bHelpEditorMenuAdded)
            {
                CMenu* pMenu = GetMenu();
                if (pMenu != NULL)
                {
                    m_bHelpEditorMenuAdded = (TRUE == pMenu->InsertMenu(pMenu->GetMenuItemCount() - 1, 
                                                               MF_BYPOSITION, 
                                                               ID_HELP_EDITOR, "Hel&p Editor"));
                    DrawMenuBar();
                }
            }
        }

        // Load the page and setup Undo if needed.
        CFSISuiteDoc* pDoc = 
                   dynamic_cast<CFSISuiteDoc*>(GetActiveView()->GetDocument());

        pDoc->EditMode(pCI->EditPageMode());
        if (pCI->EditPageMode() == true)
        {
            if (GetActiveDocument()->GetPathName() != "")
            {
                // Load the last document into the editor.
                pApp->OpenFile((LPCTSTR)(GetActiveDocument()->GetPathName()),
                               m_ucWindowNumber);
            }
            else
            {
                // Create a new page to edit.
                CXMLPage* pXMLPage = new CXMLPage;
                if (pXMLPage != NULL)
                {
                    *pXMLPage = *(pDoc->XMLPage());
                }
                pDoc->m_undoPages.maxSize(pApp->MaxUndoSize());
                pDoc->m_undoPages.ok_push(pXMLPage);
                m_wndEditorTree.AddWidgets((CFSISuiteDoc*)GetActiveDocument());
            }
        }
        else
        {
            CString strPathName(pCI->MainPageFile(m_ucWindowNumber).c_str());
            pApp->OpenFile((LPCTSTR)strPathName, m_ucWindowNumber);
        }
    }
}


void CMainFrame::DeleteComponentSpecific()
{
    _FSI_STL::list<CWidget*>::iterator wIt = 
                                m_listVerticalComponentSpecificWidgets.begin();
    while (wIt != m_listVerticalComponentSpecificWidgets.end())
    {
        if (CWidget::IsValidAddress((*wIt)) == VALID)
        {
            (*wIt)->Wnd()->DestroyWindow();
        }

        if (CWidget::IsValidAddress((*wIt)) != INVALID)
        {
            (*wIt)->Deleting(true);
        }

        wIt++;
    }

    m_listVerticalComponentSpecificWidgets.clear();

    wIt = m_listBottomComponentSpecificWidgets.begin();
    while (wIt != m_listBottomComponentSpecificWidgets.end())
    {
        if (CWidget::IsValidAddress((*wIt)) == VALID)
        {
            (*wIt)->Wnd()->DestroyWindow();
        }

        if (CWidget::IsValidAddress((*wIt)) != INVALID)
        {
            (*wIt)->Deleting(true);
        }

        wIt++;
    }

    m_listBottomComponentSpecificWidgets.clear();
}

void CMainFrame::NullComponent()
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    pDoc->EditMode(false);
    pDoc->UpdateAllViews(NULL);
}

LPARAM CMainFrame::OnDisplayWidgetProps(WPARAM wParam, LPARAM lParam)
{
    CWidget* pWidget = (CWidget*)lParam;
    CWidget* pClickedWidget = (CWidget*)wParam;
    if (m_pDlgWidgetProps == NULL)
    {
        m_pDlgWidgetProps = new CWidgetProps(pWidget, pClickedWidget);
        if (m_pDlgWidgetProps != NULL)
        {
            if (pWidget->Wnd() != NULL)
            {
                m_pDlgWidgetProps->Create(pWidget->Wnd()->GetParentFrame());
            }
            else
            {
                // Special case for page widgets.  This would coume
                // form CFSISuiteView's OnRButtonUp which means it
                // was sent to the correct main frame for ownership.
                m_pDlgWidgetProps->Create(this);
            }
            pWidget->WidgetProps(m_pDlgWidgetProps);
        }
    }

    return 0;
}

LPARAM CMainFrame::OnUpdateEditView(WPARAM wParam, LPARAM lParam)
{
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    unsigned char ucWindowNumber = (unsigned char)lParam;

    if (m_ucWindowNumber == ucWindowNumber)
    {
        CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
        pDoc->InitializeAttributes(pDoc->m_listWidgets);
        GetActiveView()->Invalidate(FALSE);
    }
    else
    {
        unsigned int unWindowStep = 0;
        CMainFrame* pFrame   = NULL;
        CFSISuiteDoc* pDoc   = NULL;
        while (unWindowStep < pApp->m_vectThreads.size())
        {
            pFrame = 
                   (CMainFrame*)(pApp->m_vectThreads[unWindowStep]->m_pMainWnd);

            if (pFrame->m_ucWindowNumber == ucWindowNumber)
            {
                pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());
                pDoc->InitializeAttributes(pDoc->m_listWidgets);
                pFrame->GetActiveView()->Invalidate(FALSE);
            }

            unWindowStep++;
        }
    }

    return 0;
}

void CMainFrame::TraverseWidgets(CXMLWidget* pXMLWidget, 
                                  CWnd* pParentWnd,
                                  unsigned long& rulId, 
                                  CWidget* pBaseParentWidget, 
                                  CWidget* pParentWidget,
                                  _FSI_STL::list<CWidget*>& rlistWidgets)
{
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    if (pXMLWidget != NULL)
    {
        if (pApp->m_mapWidgets.find(pXMLWidget->WidgetName()) !=
                                                  pApp->m_mapWidgets.end())
        {
            CWidget* pWidget = pApp->m_mapWidgets[pXMLWidget->WidgetName()]();

            if (pBaseParentWidget == NULL)
            {
                pBaseParentWidget = pWidget;
            }

            if ( pWidget != NULL)
            {
                if (pParentWidget != NULL)
                {
                    pParentWidget->AddWidget(pWidget);
                }

                rlistWidgets.push_back(pWidget);

                pWidget->ParentWidget(pParentWidget);
                pWidget->Initialize(pXMLWidget,pParentWnd, rulId, false);
                pWidget->BaseWidget(pBaseParentWidget);
                rulId++;
                WIDGET_LIST::iterator wlIt = NULL;
                CXMLWidget* pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                while ( pXMLSubWidget != NULL)
                {
                    TraverseWidgets(pXMLSubWidget, pWidget->Wnd(), rulId, 
                                    pBaseParentWidget, pWidget, rlistWidgets);
                    pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                }
            }
        }
        else if (pApp->m_mapActions.find(pXMLWidget->WidgetName()) !=
                                                  pApp->m_mapActions.end())
        {
            CWidget* pAction = pApp->m_mapActions[pXMLWidget->WidgetName()]();

            if (pBaseParentWidget == NULL)
            {
                pBaseParentWidget = pAction;
            }

            if ( pAction != NULL)
            {
                rlistWidgets.push_back(pAction);

                pAction->ParentWidget(pParentWidget);
                pAction->Initialize(pXMLWidget, pParentWnd, rulId, false);

                if (pParentWidget != NULL)
                {
                    pParentWidget->AddAction(pAction->Action());
                }
                pAction->BaseWidget(pBaseParentWidget);
                rulId++;
                WIDGET_LIST::iterator wlIt = NULL;
                CXMLWidget* pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                while ( pXMLSubWidget != NULL)
                {
                    TraverseWidgets(pXMLSubWidget, pAction->Wnd(), rulId, 
                                    pBaseParentWidget, pAction, rlistWidgets);
                    pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                }
            }
        }
    }
}

void CMainFrame::OnEditRedo() 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    if (pDoc->m_undoPages.canRedo() == true && m_pDlgWidgetProps == NULL &&
        pDoc->EditMode() == true)
    {
        CXMLPage* pXMLPage = pDoc->m_undoPages.redo();
        CXMLPage* pCurrXMLPage = pDoc->XMLPage();
        if (pCurrXMLPage != NULL && pXMLPage != NULL)
        {
            if (pDoc->m_listWidgets.size() > 0)
            {
                _FSI_STL::list<CWidget*>::iterator lwIt = pDoc->m_listWidgets.begin();
                while (lwIt != pDoc->m_listWidgets.end())
                {
                    if ((*lwIt)->Wnd() != NULL)
                    {
                        (*lwIt)->Wnd()->DestroyWindow();
                    }
                    (*lwIt)->Deleting(true);

                    lwIt++;
                }

                pDoc->m_listWidgets.clear();
            }
            *pCurrXMLPage = *pXMLPage;
            pDoc->ResetView();

            m_wndEditorTree.AddWidgets(pDoc);
        }
    }
}

void CMainFrame::OnEditUndo() 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    if (pDoc->m_undoPages.canUndo() == true && m_pDlgWidgetProps == NULL &&
        pDoc->EditMode() == true)
    {
        CXMLPage* pXMLPage = pDoc->m_undoPages.undo();
        CXMLPage* pCurrXMLPage = pDoc->XMLPage();
        if (pCurrXMLPage != NULL && pXMLPage != NULL)
        {
            if (pDoc->m_listWidgets.size() > 0)
            {
                _FSI_STL::list<CWidget*>::iterator lwIt = pDoc->m_listWidgets.begin();
                while (lwIt != pDoc->m_listWidgets.end())
                {
                    if ((*lwIt)->Wnd() != NULL)
                    {
                        (*lwIt)->Wnd()->DestroyWindow();
                    }
                    (*lwIt)->Deleting(true);

                    lwIt++;
                }

                pDoc->m_listWidgets.clear();
            }
            *pCurrXMLPage = *pXMLPage;
            pDoc->ResetView();

            m_wndEditorTree.AddWidgets(pDoc);
        }
    }
}

void CMainFrame::OnUpdateEditRedo(CCmdUI* pCmdUI) 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    if (pDoc->m_undoPages.canRedo() == true && m_pDlgWidgetProps == NULL &&
        pDoc->EditMode() == true)
    {
        pCmdUI->Enable(true);
    }
    else
    {
        pCmdUI->Enable(false);
    }
}

void CMainFrame::OnUpdateEditUndo(CCmdUI* pCmdUI) 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();

    if (pDoc->m_undoPages.canUndo() == true && m_pDlgWidgetProps == NULL &&
        pDoc->EditMode() == true)
    {
        pCmdUI->Enable(true);
    }
    else
    {
        pCmdUI->Enable(false);
    }
}

BOOL CMainFrame::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
    NMHDR* pHdr = (NMHDR*)lParam;
    if (pHdr != NULL)
    {
        // A whole range of controls can send a WM_WINDOWPOSCHANGED message
        // when they are moved in the editor.  This code should only
        // be used for moving the widget.
        switch (pHdr->code)
        {
        case WM_WINDOWPOSCHANGED:
            {
                CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
                CXMLPage* pXMLPage = new CXMLPage;
                *pXMLPage = *(pDoc->XMLPage());
                pDoc->m_undoPages.ok_push(pXMLPage);
                pDoc->SetModifiedFlag();
            }
            break;
        };
    }
	
	return CFrameWnd::OnNotify(wParam, lParam, pResult);
}

void CMainFrame::OnUpdateFileNew(CCmdUI* pCmdUI) 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    if (pDoc->EditMode() == true)
    {
        pCmdUI->Enable(true);
    }
    else
    {
        pCmdUI->Enable(false);
    }
}

void CMainFrame::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    if (pDoc->EditMode() == true)
    {
        pCmdUI->Enable(true);
    }
    else
    {
        pCmdUI->Enable(false);
    }
}

void CMainFrame::OnUpdateFileSaveAs(CCmdUI* pCmdUI) 
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    if (pDoc->EditMode() == true)
    {
        pCmdUI->Enable(true);
    }
    else
    {
        pCmdUI->Enable(false);
    }
}
 
LPARAM CMainFrame::OnChangePage(WPARAM wParam, LPARAM lParam) 
{
    if (lParam == NULL)
        return 0;

    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    CString* pStr = (CString*)lParam;

    if (pApp != NULL)
        pApp->OpenFile((LPCTSTR)(*pStr), m_ucWindowNumber);

    delete pStr;

    return 0;
}

LPARAM CMainFrame::OnReadFileComplete(WPARAM wParam, LPARAM lParam)
{
    ThreadReadFileData* pData = reinterpret_cast<ThreadReadFileData*>(lParam);

    unsigned long ulLoadNumber = (unsigned long)wParam;

    if (ulLoadNumber < m_ulLoadNumber)
    {
        delete pData->s_pListWidgets;

        delete pData->s_pXMLPage;

        delete pData;

        return 0;
    }

    if (pData != NULL)
    {
        CFSISuiteDoc* pDoc = dynamic_cast<CFSISuiteDoc*>(GetActiveDocument());
        CFSISuiteView* pView = dynamic_cast<CFSISuiteView*>(GetActiveView());

        if (pDoc != NULL && pView != NULL)
        {
            pDoc->CreateWidgets(*(pData->s_pListWidgets), pDoc->OnScreenView(), 
                                pData->s_strFile, pData->s_pXMLPage);

            delete pData->s_pListWidgets;
//            delete pData->s_pXMLPage;
        }
        else
        {
            delete pData->s_pXMLPage;
            delete pData->s_pListWidgets;
        }

        delete pData;
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnChangeHorizontalContent()
//
// Inputs           : WPARAM wParam - not used.
//                    LPARAM lParam - a pointer to a string with file path 
///                                   information.
//
// Return Values    : None.
//
// Date             : 13 September 1999
//
// Engineer         : Billy Baker
//
// Description      : OnChangeHorizontalContent is used by the OnComponentButton 
//                    to load the correct collars when a component button is
//                    clicked.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnChangeHorizontalContent(WPARAM wParam, LPARAM lParam)
{
    // Get the size of the horizontal region that the
    // collar container my fill.
    CRect rectHorizontal(0, 0, 0, 0);
    HorizontalCollarSize(rectHorizontal);

    // Expand the string that was passed in with data about
    // what file to open.
    CString strFile(reinterpret_cast<LPCTSTR>(lParam));
    if (strFile.Find("^") > -1)
    {
        CWidget::ExpandPath(strFile);
    }

    CFSISuiteDoc* pDoc = dynamic_cast<CFSISuiteDoc*>(GetActiveView()->GetDocument());

    // Parse the page.
    CXMLPage* pXMLPage       = NULL;
    CStatic* pwndNewBottom   = NULL;

    _FSI_STL::list<CWidget*> listHorizontalWidgets;
    _FSI_STL::list<CWidget*>::iterator lIt = NULL;
    if (strFile != "")
    {
        pwndNewBottom = new CCollarContainer();

        if (pwndNewBottom != NULL)
        {
            // Create the windows object.
            if (m_wndBottomBar.GetSafeHwnd() != NULL)
            {
                pwndNewBottom->Create("", WS_CHILD, rectHorizontal,
                                         &m_wndBottomBar, IDC_STATIC);
            }
        }

        if (NULL != m_pwndBottomContainer)
        {
            CWidget::ScreenRedrawing(m_pwndBottomContainer->GetSafeHwnd(), false);
        }

        CWidget::ScreenRedrawing(pwndNewBottom->GetSafeHwnd(), true);

        pXMLPage = new CXMLPage();
        CXMLParser5 xmlParser((LPCTSTR)strFile);

        CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

        STRING_LIST::iterator slIt = pApp->m_listAvailableWidgets.begin();
        while (slIt != pApp->m_listAvailableWidgets.end())
        {
            xmlParser.AddAvailableWidget(*slIt);
            slIt++;
        }
        slIt = pApp->m_listAvailableActions.begin();
        while (slIt != pApp->m_listAvailableActions.end())
        {
            pXMLPage->AddAvailableWidget(*slIt);
            slIt++;
        }
        xmlParser.ParseFile(pXMLPage, m_pXMLDoc);

        // Recursively call TraverseWidgets to create the graphical
        // elements and actions defined in the XML.
        WIDGET_LIST::iterator wlIt  = NULL;
        CXMLWidget* pXMLWidget      = pXMLPage->GetNextWidget(wlIt);
        unsigned long ulId          = IDC_HORIZONTAL_COMPONENT_SPECIFIC + 1;

        while (pXMLWidget != NULL)
        {
            TraverseWidgets(pXMLWidget, pwndNewBottom, 
                                  ulId, NULL, NULL, listHorizontalWidgets);
            pXMLWidget = pXMLPage->GetNextWidget(wlIt);
        }

        // Find the page widget.
        lIt                         = listHorizontalWidgets.begin();
        bool bDone                  = false;
        CWidget* pPageWidget        = NULL;

        while (lIt != listHorizontalWidgets.end() && bDone == false)
        {
            CString strWidgetName((*lIt)->WidgetName().c_str());
            strWidgetName.MakeUpper();
            if (strWidgetName == "PAGE")
            {
                pPageWidget = (*lIt);
                bDone = true;
            }

            lIt++;
        }

        pDoc->Scale(listHorizontalWidgets, pPageWidget);
    }

    // If a collar container already exists and its not the editor controls,
    // then hide the existing collar container.
    if (m_pwndBottomContainer != NULL && 
            !(m_pwndBottomContainer->IsKindOf(RUNTIME_CLASS(CEditorControls))))
    {
        // bottom is not the editor controls
        if (m_pwndBottomContainer->GetSafeHwnd() != NULL)
        {
            m_pwndBottomContainer->MoveWindow(-10000, -10000, 100, 100);
        }

        // Show the new collar container.
        if (pwndNewBottom != NULL)
        {
            pwndNewBottom->ShowWindow(SW_SHOWNORMAL);
        }
    
        // Destroy the window for the collar container which should also destroy
        // all of the child windows.
        if (m_pwndBottomContainer->GetSafeHwnd() != NULL)
        {
            m_pwndBottomContainer->DestroyWindow();
        }

        delete m_pwndBottomContainer;

        // Assign the new collar container to the member pointer.
        m_pwndBottomContainer = pwndNewBottom;
    }
    else if (m_pwndBottomContainer != NULL && pwndNewBottom != NULL)
    {
        // bottom is the editor controls and have a new bottom
        if (m_pwndBottomContainer->GetSafeHwnd() != NULL)
        {
            m_pwndBottomContainer->MoveWindow(-10000, -10000, 100, 100);
        }

        // Show the new collar container.
        if (pwndNewBottom != NULL)
        {
            pwndNewBottom->ShowWindow(SW_SHOWNORMAL);
        }

        // Assign the new collar container to the member pointer.
        m_pwndBottomContainer = pwndNewBottom;
    }
    else if (m_pwndBottomContainer == NULL)
    {
        // bottom has not been set once
        // Show the new collar container.
        if (pwndNewBottom != NULL)
        {
            pwndNewBottom->ShowWindow(SW_SHOWNORMAL);
        }

        // Assign the new collar container to the member pointer.
        m_pwndBottomContainer = pwndNewBottom;
    }
    else if (m_pwndBottomContainer != NULL)
    {
        // bottom is the editor controls and don't have a new bottom
        if (m_pwndBottomContainer->GetSafeHwnd() != NULL)
        {
            m_pwndBottomContainer->MoveWindow(-10000, -10000, 100, 100);
        }

        // Assign the new collar container to the member pointer.
        m_pwndBottomContainer = NULL;
    }


    // Delete all of the CWidget derived objects.
    if (m_listBottomComponentSpecificWidgets.size() > 0)
    {
        lIt = m_listBottomComponentSpecificWidgets.begin();

        while (lIt != m_listBottomComponentSpecificWidgets.end())
        {
            if (CWidget::IsValidAddress((*lIt)) == VALID)
            {
                if ((*lIt)->Wnd() != NULL)
                {
                    (*lIt)->Wnd()->DestroyWindow();
                }

                (*lIt)->Deleting(true);
            }
            else if (CWidget::IsValidAddress((*lIt)) == VALID_ADDRESS)
            {
                (*lIt)->Deleting(true);
            }

            lIt++;
        }

        m_listBottomComponentSpecificWidgets.clear();
    }
/*
    // Add everyone to make sure that they will be in the
    // first update.  When they were created, they would have
    // added a WM_PAINT but that has to go through the
    // message loop and an update could occur before all
    // of the WM_PAINT message from the creates get processed.
    _FSI_STL::list<CWidget*>::iterator wlIt     = NULL;
    _FSI_STL::list<CWidget*>::iterator wlendIt  = NULL;
    if (!listHorizontalWidgets.empty() && NULL != m_pwndBottomContainer)
    {
        wlIt    = listHorizontalWidgets.begin();
        wlendIt = listHorizontalWidgets.end();

        while (wlIt != wlendIt)
        {
            if ((*wlIt)->Action() == NULL)
            {
                CUpdateList::AddPaintWidget(m_pwndBottomContainer->GetSafeHwnd(), 
                                            (*wlIt));
            }

            wlIt++;
        }
    }
*/
    // Assign the new list of widgets to the member list.
    m_listBottomComponentSpecificWidgets = listHorizontalWidgets;

    if (m_pHorizontalXMLPage != NULL)
    {
        delete m_pHorizontalXMLPage;
    }

    m_pHorizontalXMLPage = pXMLPage;

    if (NULL != m_pwndBottomContainer)
    {
        CWidget::ScreenRedrawing(m_pwndBottomContainer->GetSafeHwnd(), false);
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMainFrame::HorizontalCollarSize()
//
// Inputs           : CRect& rectHorizontal - a reference to a CRect that 
//                                            will get the value for the
//                                            size of the vertical collar.
//
// Return Values    : None.
//
// Date             : 13 September 1999
//
// Engineer         : Billy Baker
//
// Description      : HorizontalCollarSize will compute the area that the 
//                    horizontal collar may occupy.
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::HorizontalCollarSize(CRect& rectHorizontal)
{
    CRect rectWindow;

    m_wndBottomBar.GetWindowRect(&rectWindow);

    rectWindow.left     += GetSystemMetrics(SM_CXDLGFRAME);
    rectWindow.right    -= 2 * GetSystemMetrics(SM_CXDLGFRAME);

    unsigned long int ulBottomHeight = (int)(((float)m_ucBottomHeight / 
                                                (float)m_ulClientScreenHeightBase) * 
                                             GetSystemMetrics(SM_CYSCREEN) + .5);

    CRect rectButtonSize(0, m_ucButtonDivider,
       (rectWindow.Width()-(m_ucButtonsAcross-1)*m_ucButtonDivider)/m_ucButtonsAcross,
       ulBottomHeight - m_ucButtonDivider);

    CRect rectBottom(0, 0, 
                     rectWindow.Width() - 2*m_ucButtonDivider - rectButtonSize.Width(),  
                     ulBottomHeight);

    rectHorizontal = rectBottom; 
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnChangeVerticalContent()
//
// Inputs           : WPARAM wParam - not used.
//                    LPARAM lParam - a pointer to a string with file path 
///                                   information.
//
// Return Values    : None.
//
// Date             : 13 September 1999
//
// Engineer         : Billy Baker
//
// Description      : OnChangeVerticalContent is used by the OnComponentButton 
//                    to load the correct collars when a component button is
//                    clicked.  It is also used when a WM_CHANGE_VERT_COLLAR
//                    message is sent/posted.  
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnChangeVerticalContent(WPARAM wParam, LPARAM lParam)
{
    // Get the size of the vertical region that the
    // collar container my fill.
    CRect rectVertical(0, 0, 0, 0);
    VerticalCollarSize(rectVertical);

    // Expand the string that was passed in with data about
    // what file to open.
    CString strFile(reinterpret_cast<LPCTSTR>(lParam));
    if (strFile.Find("^") > -1)
    {
        CWidget::ExpandPath(strFile);
    }

    CFSISuiteDoc* pDoc = dynamic_cast<CFSISuiteDoc*>(GetActiveView()->GetDocument());

    // Parse the page.
    CXMLPage* pXMLPage          = NULL;
    CStatic* pwndNewLeftRight   = NULL;

    _FSI_STL::list<CWidget*> listVerticalWidgets;
    _FSI_STL::list<CWidget*>::iterator lIt = NULL;
    if (strFile != "")
    {
        pwndNewLeftRight = new CCollarContainer();

        if (pwndNewLeftRight != NULL)
        {
            // Create the windows object.
            if (m_wndLeftRightBar.GetSafeHwnd() != NULL)
            {
                pwndNewLeftRight->Create("", WS_CHILD, rectVertical,
                                         &m_wndLeftRightBar, IDC_STATIC);
            }
        }

        if (NULL != m_pwndLeftRightContainer)
        {
            CWidget::ScreenRedrawing(m_pwndLeftRightContainer->GetSafeHwnd(), false);
        }

        CWidget::ScreenRedrawing(pwndNewLeftRight->GetSafeHwnd(), true);

        pXMLPage = new CXMLPage();
        CXMLParser5 xmlParser((LPCTSTR)strFile);

        CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

        STRING_LIST::iterator slIt = pApp->m_listAvailableWidgets.begin();
        while (slIt != pApp->m_listAvailableWidgets.end())
        {
            xmlParser.AddAvailableWidget(*slIt);
            slIt++;
        }
        slIt = pApp->m_listAvailableActions.begin();
        while (slIt != pApp->m_listAvailableActions.end())
        {
            pXMLPage->AddAvailableWidget(*slIt);
            slIt++;
        }
        xmlParser.ParseFile(pXMLPage, m_pXMLDoc);

        // Recursively call TraverseWidgets to create the graphical
        // elements and actions defined in the XML.
        WIDGET_LIST::iterator wlIt  = NULL;
        CXMLWidget* pXMLWidget      = pXMLPage->GetNextWidget(wlIt);
        unsigned long ulId          = IDC_VERTICAL_COMPONENT_SPECIFIC + 1;

        while (pXMLWidget != NULL)
        {
            TraverseWidgets(pXMLWidget, pwndNewLeftRight, 
                                  ulId, NULL, NULL, listVerticalWidgets);
            pXMLWidget = pXMLPage->GetNextWidget(wlIt);
        }

        m_vectPageChangeActions.clear();
        // Find the page widget.
        lIt                         = listVerticalWidgets.begin();
        bool bDone                  = false;
        CWidget* pPageWidget        = NULL;

        while (lIt != listVerticalWidgets.end())// && bDone == false)
        {
            CString strWidgetName((*lIt)->WidgetName().c_str());
            strWidgetName.MakeUpper();
            if (strWidgetName == "PAGE" && !bDone)
            {
                pPageWidget = (*lIt);
                bDone = true;
            }

            if (strWidgetName == "CHANGE_PAGES")
            {
                m_vectPageChangeActions.push_back((*lIt)->Action());
            }

            lIt++;
        }

        pDoc->Scale(listVerticalWidgets, pPageWidget);
    }

    // If a collar container already exists and its not the editor controls,
    // then hide the existing collar container.
    if (m_pwndLeftRightContainer != NULL && 
            !(m_pwndLeftRightContainer->IsKindOf(RUNTIME_CLASS(CEditorTree))))
    {
        // leftright is not the editor tree
        if (m_pwndLeftRightContainer->GetSafeHwnd() != NULL)
        {
            m_pwndLeftRightContainer->MoveWindow(-10000, -10000, 100, 100);
        }

        // Show the new collar container.
        if (pwndNewLeftRight != NULL)
        {
            pwndNewLeftRight->ShowWindow(SW_SHOWNORMAL);
        }
    
        // Destroy the window for the collar container which should also destroy
        // all of the child windows.
        if (m_pwndLeftRightContainer->GetSafeHwnd() != NULL)
        {
            m_pwndLeftRightContainer->DestroyWindow();
        }

        delete m_pwndLeftRightContainer;

        // Assign the new collar container to the member pointer.
        m_pwndLeftRightContainer = pwndNewLeftRight;
    }
    else if (m_pwndLeftRightContainer != NULL && pwndNewLeftRight != NULL)
    {
        // leftright is the editor tree
        if (m_pwndLeftRightContainer->GetSafeHwnd() != NULL)
        {
            m_pwndLeftRightContainer->MoveWindow(-10000, -10000, 100, 100);
        }

        // Show the new collar container.
        if (pwndNewLeftRight != NULL)
        {
            pwndNewLeftRight->ShowWindow(SW_SHOWNORMAL);
        }

        // Assign the new collar container to the member pointer.
        m_pwndLeftRightContainer = pwndNewLeftRight;
    }
    else if (m_pwndLeftRightContainer == NULL)
    {
        // leftright has not be set once
        // Show the new collar container.
        if (pwndNewLeftRight != NULL)
        {
            pwndNewLeftRight->ShowWindow(SW_SHOWNORMAL);
        }

        // Assign the new collar container to the member pointer.
        m_pwndLeftRightContainer = pwndNewLeftRight;
    }
    else if (m_pwndLeftRightContainer != NULL)
    {
        // leftright is the editor tree and no new container
        if (m_pwndLeftRightContainer->GetSafeHwnd() != NULL)
        {
            m_pwndLeftRightContainer->MoveWindow(-10000, -10000, 100, 100);
        }

        // Assign the new collar container to the member pointer.
        m_pwndLeftRightContainer = NULL;
    }


    // Delete all of the CWidget derived objects.
    if (m_listVerticalComponentSpecificWidgets.size() > 0)
    {
        lIt = m_listVerticalComponentSpecificWidgets.begin();

        while (lIt != m_listVerticalComponentSpecificWidgets.end())
        {
            if (CWidget::IsValidAddress((*lIt)) == VALID)
            {
                if ((*lIt)->Wnd() != NULL)
                {
                    (*lIt)->Wnd()->DestroyWindow();
                }

                (*lIt)->Deleting(true);
            }
            else if (CWidget::IsValidAddress((*lIt)) == VALID_ADDRESS)
            {
                (*lIt)->Deleting(true);
            }

            lIt++;
        }

        m_listVerticalComponentSpecificWidgets.clear();
    }
/*
    // Add everyone to make sure that they will be in the
    // first update.  When they were created, they would have
    // added a WM_PAINT but that has to go through the
    // message loop and an update could occur before all
    // of the WM_PAINT message from the creates get processed.
    _FSI_STL::list<CWidget*>::iterator wlIt     = NULL;
    _FSI_STL::list<CWidget*>::iterator wlendIt  = NULL;
    if (!listVerticalWidgets.empty() && NULL != m_pwndLeftRightContainer)
    {
        wlIt    = listVerticalWidgets.begin();
        wlendIt = listVerticalWidgets.end();

        while (wlIt != wlendIt)
        {
            if ((*wlIt)->Action() == NULL)
            {
                CUpdateList::AddPaintWidget(m_pwndLeftRightContainer->GetSafeHwnd(), 
                                            (*wlIt));
            }

            wlIt++;
        }
    }
*/
    // Assign the new list of widgets to the member list.
    m_listVerticalComponentSpecificWidgets = listVerticalWidgets;

    if (m_pVerticalXMLPage != NULL)
    {
        delete m_pVerticalXMLPage;
    }

    m_pVerticalXMLPage = pXMLPage;

    if (NULL != m_pwndLeftRightContainer)
    {
        CWidget::ScreenRedrawing(m_pwndLeftRightContainer->GetSafeHwnd(), false);
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMainFrame::VerticalCollarSize()
//
// Inputs           : CRect& rectVertical - a reference to a CRect that 
//                                          will get the value for the
//                                          size of the vertical collar.
//
// Return Values    : None.
//
// Date             : 13 September 1999
//
// Engineer         : Billy Baker
//
// Description      : VerticalCollarSize will compute the area that the 
//                    vertical collar may occupy.
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::VerticalCollarSize(CRect& rectVertical)
{
    // Compute the size of the vertical CStatic.
    CRect rectLastTop;

    CRect rectBar;
    if (m_wndLeftRightBar.GetSafeHwnd() != NULL)
    {
        m_wndLeftRightBar.GetWindowRect(&rectBar);
    }
    else
    {
        return;
    }

    unsigned long int ulButtonWidth = rectBar.Width() - 2 * m_ucButtonDivider;

    if (m_ushLastTop < m_vectComponentButtons.size())
    {
        m_vectComponentButtons[m_ushLastTop]->GetWindowRect(&rectLastTop);
        m_wndLeftRightBar.ScreenToClient(&rectLastTop);
    }
    else
    {
        rectLastTop = CRect(m_ucButtonDivider, 
                            rectBar.Height() - m_ucButtonDivider,
                            ulButtonWidth, 
                            m_ucButtonDivider);
    }

    CRect rectFirstBottom;
    if (m_ushFirstBottom < m_vectComponentButtons.size())
    {
        m_vectComponentButtons[m_ushFirstBottom]->GetWindowRect(&rectFirstBottom);
        m_wndLeftRightBar.ScreenToClient(&rectFirstBottom);
    }
    else
    {
        rectFirstBottom = CRect(m_ucButtonDivider, 
                                rectBar.Height() - m_ucButtonDivider,
                                ulButtonWidth, 
                                m_ucButtonDivider);
    }

    // A rect with the size of the vertical CStatic.
    rectVertical = CRect(m_ucButtonDivider, 
                         rectLastTop.bottom + m_ucButtonDivider, 
                         ulButtonWidth + m_ucButtonDivider, 
                         rectFirstBottom.top - m_ucButtonDivider);
}


LPARAM CMainFrame::OnNextTab(WPARAM wParam, LPARAM lParam)
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    CWnd* pWnd = (CWnd*)lParam;
    bool bUseNext = false;
    bool bFound = false;
    CWnd** pNextWnd = (CWnd**)wParam;


    // Find the next CWnd derived widget that has WS_TABSTOP.
    _FSI_STL::list<CWidget*>::iterator lIt = pDoc->m_listWidgets.begin();
    while (lIt != pDoc->m_listWidgets.end() && bFound == false)
    {
        if (bUseNext == true)
        {
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    bFound = true;
                }
            }
        }

        if ((*lIt)->Wnd() == pWnd)
        {
            bUseNext = true;
        }

        lIt++;
    }

    CWidget* pWidget = NULL;
    lIt = pDoc->m_listWidgets.begin();
    if ((bFound == false) && (pWnd != (*lIt)->Wnd()))
    {
        // A next field wasn't found from pWnd to the end.
        // Start over and search from the beginning.
        while ((*lIt)->Wnd() != pWnd && bFound == false)
        {
            pWidget = (*lIt);
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    bFound = true;
                }
            }
            lIt++;
        }
    }

    return 0;
}

LPARAM CMainFrame::OnPreviousTab(WPARAM wParam, LPARAM lParam)
{
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();
    CWnd* pWnd = (CWnd*)lParam;
    CWnd** pNextWnd = (CWnd**)wParam;
    bool bFound = false;
    bool bUseNext = false;


    // Find the next CWnd derived widget that has WS_TABSTOP.
    _FSI_STL::list<CWidget*>::reverse_iterator lIt = pDoc->m_listWidgets.rbegin();
    while (lIt != pDoc->m_listWidgets.rend() && bFound == false)
    {
        if (bUseNext == true)
        {
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    bFound = true;
                }
            }
        }

        if ((*lIt)->Wnd() == pWnd)
        {
            bUseNext = true;
        }

        lIt++;
    }

    CWidget* pWidget = NULL;
    lIt = pDoc->m_listWidgets.rbegin();
    if ((bFound == false) && (pWnd != (*lIt)->Wnd()))
    {
        // A next field wasn't found from pWnd to the end.
        // Start over and search from the beginning.
        while ((*lIt)->Wnd() != pWnd && bFound == false)
        {
            pWidget = (*lIt);
            if ((*lIt)->Wnd() != NULL)
            {
                if ((*lIt)->Wnd()->GetStyle() & WS_TABSTOP &&
                    !((*lIt)->Wnd()->GetStyle() & BS_AUTORADIOBUTTON))
                {
                    *pNextWnd = (*lIt)->Wnd();
                    bFound = true;
                }
            }
            lIt++;
        }
    }

    return 0;
}

void CMainFrame::OnDestroy() 
{
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();

    pApp->MarkWndDestroyed(this);

    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetActiveDocument();

    if (pDoc != NULL)
    {
        _FSI_STL::list<CWidget*>::iterator lIt = pDoc->m_listWidgets.begin();
        while (lIt != pDoc->m_listWidgets.end())
        {
            (*lIt)->FrameworkParent(NULL);

            lIt++;
        }
    }

    // Get rid of any help editor dialogs
    if (m_pHelpEditor != NULL)
    {
        m_pHelpEditor->DestroyWindow();
        m_pHelpEditor = NULL;
    }

	CFrameWnd::OnDestroy();
}

void CMainFrame::OnClose() 
{
	CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();

    if (this == pApp->m_pMainWnd && 
        GetActiveView()->IsKindOf(RUNTIME_CLASS(CFSISuitePreviewView)) != TRUE)
    {
        if (pApp->m_vectThreads.size() > 0)
        {
            unsigned int un = 0;
            while (un < pApp->m_vectThreads.size())
            {
                CMainFrame* pFrame = 
                    dynamic_cast<CMainFrame*>(pApp->m_vectThreads[un]->m_pMainWnd);

                if (pFrame != NULL)
                {
                    ::SendMessage(pFrame->GetSafeHwnd(), m_WM_MULTIMON_CLOSE, 0, 0);
                }

                un++;

            }

            pApp->m_vectThreads.clear();
        }
    }

    CFSISuiteDoc* pDoc = dynamic_cast<CFSISuiteDoc*>(GetActiveDocument());

    if (pDoc != NULL)
        pDoc->OnScreenView(NULL);

    CFrameWnd::OnClose();
}

void CMainFrame::PageFlipTestLength(const CString& rstrTestLength)
{
    m_pfts.s_nTestLength = atoi(rstrTestLength);
}

void CMainFrame::PageFlipTestRest(const CString& rstrTestRest)
{
    m_pfts.s_nTestRestTime = atoi(rstrTestRest);
}

void CMainFrame::PerformPageFlipTest()
{
    m_pfts.s_hWnd = GetSafeHwnd();
    AfxBeginThread(Rest, (LPVOID)&m_pfts);
}

UINT CMainFrame::Rest(LPVOID param)
{
    struct PageFlipTestStruct pfts = *(struct PageFlipTestStruct*)param;

    if (pfts.s_hWnd == NULL)
        return 0;

    int i = pfts.s_nTestLength;

    while (i)
    {
        Sleep(pfts.s_nTestRestTime);

        ::PostMessage(pfts.s_hWnd, WM_RESTED_NOW_CHANGE, 0, 0);

        --i;
    }

    return 0;
}

LPARAM CMainFrame::OnRestedNowChange(WPARAM wParam, LPARAM lParam)
{
    int i = m_vectPageChangeActions.size();
    if (i > 0)
    {
        --i;

        float r = (float)rand();
        r /= RAND_MAX;

        i = i * r;

        m_vectPageChangeActions[i]->OnLButtonUp();
    }


    return 0;
}
LPARAM CMainFrame::OnMultimonClose(WPARAM wParam, LPARAM lParam)
{
    CFSISuiteDoc* pDoc = dynamic_cast<CFSISuiteDoc*>(GetActiveDocument());
    if (pDoc != NULL)
        pDoc->OnScreenView(NULL);

    CView* pView = GetActiveView();
    if (pView->IsKindOf(RUNTIME_CLASS(CFSISuitePreviewView)))
    {
        // Special case where a print preview window was
        // being displayed.  Close the print printview
        // then the real main frame.
        BeginClose();
    }

    BeginClose();

    AfxEndThread(0);

    return 0;
}
void CMainFrame::BeginClose()
{
 	if (m_lpfnCloseProc != NULL && !(*m_lpfnCloseProc)(this))
		return;

	// Note: only queries the active document
	CDocument* pDocument = GetActiveDocument();
	if (pDocument != NULL && !pDocument->CanCloseFrame(this))
	{
		// document can't close right now -- don't close it
		return;
	}

	// detect the case that this is the last frame on the document and
	// shut down with OnCloseDocument instead.
	if (pDocument != NULL && pDocument->m_bAutoDelete)
	{
		BOOL bOtherFrame = FALSE;
		POSITION pos = pDocument->GetFirstViewPosition();
		while (pos != NULL)
		{
			CView* pView = pDocument->GetNextView(pos);
			ASSERT_VALID(pView);
			if (pView->GetParentFrame() != this)
			{
				bOtherFrame = TRUE;
				break;
			}
		}
		if (!bOtherFrame)
		{
			pDocument->OnCloseDocument();
			return;
		}

		// allow the document to cleanup before the window is destroyed
		pDocument->PreCloseFrame(this);
	}
}

void CMainFrame::OnFileOpen() 
{
	CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();

	// prompt the user (with all document templates)
	CString newName;
	CFileDialog dlgFile(TRUE);

	CString title;
	VERIFY(title.LoadString(AFX_IDS_OPENFILE));

	dlgFile.m_ofn.Flags |= OFN_HIDEREADONLY | OFN_FILEMUSTEXIST;

	CString strFilter;
	CString strDefault;
	// do for all doc template
	CDocTemplate* pTemplate = GetActiveDocument()->GetDocTemplate();
    AppendFilterSuffix(strFilter, dlgFile.m_ofn, pTemplate,
		                    &strDefault);

	// append the "*.*" all files filter
	CString allFilter;
	VERIFY(allFilter.LoadString(AFX_IDS_ALLFILTER));
	strFilter += allFilter;
	strFilter += (TCHAR)'\0';   // next string please
	strFilter += _T("*.*");
	strFilter += (TCHAR)'\0';   // last string
	dlgFile.m_ofn.nMaxCustFilter++;

	dlgFile.m_ofn.lpstrFilter = strFilter;
	dlgFile.m_ofn.lpstrTitle = title;
	dlgFile.m_ofn.lpstrFile = newName.GetBuffer(_MAX_PATH);

	int nResult = dlgFile.DoModal();
	newName.ReleaseBuffer();

    if (nResult == IDOK)
    {
        pApp->OpenFile((LPCTSTR)newName, m_ucWindowNumber);
    }
}

void CMainFrame::OnFileNew()
{
    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    if (pApp == NULL)
    {
        return;
    }

    if (m_ucWindowNumber == 0)
    {
        POSITION pos = pApp->GetFirstDocTemplatePosition();
        CFSISuiteDocTemplate* pDocTemplate = 
                          (CFSISuiteDocTemplate*)pApp->GetNextDocTemplate(pos);
        pDocTemplate->OpenDocumentFile(NULL);
    }
    else
    {
        pApp->m_vectThreads[m_ucWindowNumber-1]->m_pDocTemplate->OpenDocumentFile(NULL);
    }

    m_wndEditorTree.FileNew((CFSISuiteDoc*)GetActiveDocument());
}

BOOL CMainFrame::OnOpenRecentFile(UINT nID)
{
    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    if (pApp != NULL)
    {
        PostThreadMessage(pApp->m_nThreadID, nID, 0, (long)m_ucWindowNumber);
    }

	return TRUE;
}

void CMainFrame::AppendFilterSuffix(CString& filter, OPENFILENAME& ofn,
	                                CDocTemplate* pTemplate, 
                                    CString* pstrDefaultExt)
{
	ASSERT_VALID(pTemplate);
	ASSERT_KINDOF(CDocTemplate, pTemplate);

	CString strFilterExt, strFilterName;
	if (pTemplate->GetDocString(strFilterExt, CDocTemplate::filterExt) &&
	 !strFilterExt.IsEmpty() &&
	 pTemplate->GetDocString(strFilterName, CDocTemplate::filterName) &&
	 !strFilterName.IsEmpty())
	{
		// a file based document template - add to filter list
		ASSERT(strFilterExt[0] == '.');
		if (pstrDefaultExt != NULL)
		{
			// set the default extension
			*pstrDefaultExt = ((LPCTSTR)strFilterExt) + 1;  // skip the '.'
			ofn.lpstrDefExt = (LPTSTR)(LPCTSTR)(*pstrDefaultExt);
			ofn.nFilterIndex = ofn.nMaxCustFilter + 1;  // 1 based number
		}

		// add to filter
		filter += strFilterName;
		ASSERT(!filter.IsEmpty());  // must have a file type name
		filter += (TCHAR)'\0';  // next string please
		filter += (TCHAR)'*';
		filter += strFilterExt;
		filter += (TCHAR)'\0';  // next string please
		ofn.nMaxCustFilter++;
	}
}

void CMainFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    if (pApp == NULL)
    {
        CFrameWnd::OnGetMinMaxInfo(lpMMI);
        return;
    }

	if (m_ucWindowNumber == 0)
	{
        MONITORINFOEX mi;
        pApp->MonitorInfo(mi, 0);

        lpMMI->ptMaxTrackSize.x = mi.rcMonitor.right - mi.rcMonitor.left;
        lpMMI->ptMaxTrackSize.y = mi.rcMonitor.bottom - mi.rcMonitor.top;
        lpMMI->ptMaxSize.x      = lpMMI->ptMaxTrackSize.x;
        lpMMI->ptMaxSize.y      = lpMMI->ptMaxTrackSize.y;
        lpMMI->ptMaxPosition.x  = 0;
        lpMMI->ptMaxPosition.y  = 0;
	}
	else
	{
        lpMMI->ptMaxTrackSize.x = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->Width();
        lpMMI->ptMaxTrackSize.y = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->Height();
        lpMMI->ptMaxSize.x      = lpMMI->ptMaxTrackSize.x;
        lpMMI->ptMaxSize.y      = lpMMI->ptMaxTrackSize.y;
        lpMMI->ptMaxPosition.x  = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->left;
        lpMMI->ptMaxPosition.y  = pApp->m_vectThreads[m_ucWindowNumber-1]->m_prectSize->top;
    }
	
	CFrameWnd::OnGetMinMaxInfo(lpMMI);
}

void CMainFrame::StartAs(const CString& strComponent)
{
    bool bFound = false;
    _FSI_STL::vector<CButton*>::iterator vIt = m_vectComponentButtons.begin();
    while (vIt != m_vectComponentButtons.end() && bFound == false)
    {
        CString str;
        (*vIt)->GetWindowText(str);

        if (str == strComponent)
        {
            PostMessage(WM_COMMAND, (*vIt)->GetDlgCtrlID(), 0);
            bFound = true;
        }

        vIt++;
    }
}

void CMainFrame::OnSize(UINT nType, int cx, int cy) 
{

    if (IsZoomed() == TRUE)
    {
        cx = 1280;
        cy = 1024;
    }

	CFrameWnd::OnSize(nType, cx, cy);
}


//////////////////////////////////////////////////////////////////////
//  Help
//////////////////////////////////////////////////////////////////////

void CMainFrame::OnHelpFinder()
{
    // Help topics on menu.
    HWND hWnd = HtmlHelp(GetSafeHwnd(), m_stlStrHelpFile.c_str(), HH_DISPLAY_TOPIC, 0);

    CWnd* pWnd = CWnd::FromHandle(hWnd);
    if (pWnd != NULL)
    {
        pWnd->CenterWindow(this);
    }
}

void CMainFrame::OnHelp()
{
    CFSISuiteDoc* pDoc  = dynamic_cast<CFSISuiteDoc*>(GetActiveDocument());
    CPageWidget* pPageWidget = dynamic_cast<CPageWidget*>(pDoc->PageWidget());
    CString strFilePath;
    if (pPageWidget != NULL)
    {
        strFilePath = pPageWidget->HelpFile().c_str();
    }

    HWND hWnd = HtmlHelp(GetSafeHwnd(), m_stlStrHelpFile.c_str(), HH_DISPLAY_TOPIC, 
                        (unsigned long)(LPCTSTR)("pages\\" + strFilePath));

    CWnd* pWnd = CWnd::FromHandle(hWnd);
    if (pWnd != NULL)
    {
        pWnd->CenterWindow(this);
    }
}

BOOL CMainFrame::OnHelpInfo(HELPINFO* pHelpInfo)
{
/*
    // F1 and shift F1 processing
    char cPage[] = "pageeditor.htm";

    HWND hWnd = HtmlHelp(GetSafeHwnd(), m_stlStrHelpFile.c_str(), HH_DISPLAY_TOPIC, 
                        (unsigned long)&cPage);

    CWnd* pWnd = CWnd::FromHandle(hWnd);
    if (pWnd != NULL)
    {
        pWnd->CenterWindow(this);
    }
*/
    OnHelp();

    return true;
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnDialogHelp()
//
// Inputs           : WPARAM wParam - not used.
//                    LPARAM lParam - address of a name of dialog to display 
//                                    help.
//
// Return Values    : 0
//
// Date             : 17 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Message handler to display help for a dialog.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnDialogHelp(WPARAM wParam, LPARAM lParam)
{
    CString strFilePath;
    CPageWidget* pPageWidget = NULL;

    if (lParam != NULL)
    {
        pPageWidget = (CPageWidget*)lParam;
    }
    else
    {
        return 0;
    }

    strFilePath = pPageWidget->HelpFile().c_str();

    HWND hWnd = HtmlHelp(GetSafeHwnd(), m_stlStrHelpFile.c_str(), HH_DISPLAY_TOPIC, 
                        (unsigned long)(LPCTSTR)("pages\\" + strFilePath));

    CWnd* pWnd = CWnd::FromHandle(hWnd);
    if (pWnd != NULL)
    {
        pWnd->CenterWindow(this);
    }

    return 0;
}

//////////////////////////////////////////////////////////////////////
//  Overlays
//////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
// void CMainFrame::DestroyOverlays()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 07 February 2000
//
// Engineer         : Billy Baker
//
// Description      : DestroyOverlays is invoked when the configuration
//                    of loaded libraries changes during runtime.
//                    It is used to clear any overlays that 
//                    were created as children of the main window.
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::DestroyOverlays()
{
    _FSI_STL::list<COverlayDlg*>::iterator lIt = m_listOverlays.begin();

    while (lIt != m_listOverlays.end())
    {
        (*lIt)->DestroyWindow();

        lIt = m_listOverlays.begin();
    }

    m_listOverlays.clear();
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnOverlayClose()
//
// Inputs           : WPARAM wParam - has the address of an instance of
//                                    COverlayDlg that is closing.
//                    LPARAM lParam - has the address of a string with
//                                    path data for the overlay file.
//
// Return Values    : 0.
//
// Date             : 08 February 2000
//
// Engineer         : Billy Baker
//
// Description      : OnOverlayClose() is invoked in respose to a
//                    SendMessage in COverlayDlg::OnDestroy.  Its purpose
//                    is to remove the overlay from the data structures that
//                    tell if the overlay has been created.  If the overlay
//                    is persistant, then it needs to be removed from the
//                    list of overlays that are children on the frame.  If
//                    not, then it needs to be removed from the list of
//                    overlays that are children of the view.  The overlay
//                    also needs to be removed from the map of all overlays
//                    created for an instance of CMainFrame.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnOverlayClose(WPARAM wParam, LPARAM lParam)
{
    CString strPathInfo = *(CString*)lParam;
    COverlayDlg* pOverlayDlg = (COverlayDlg*)wParam;

    // Remove from the the list of overlays for the mainframe
    // or for the view.
    if (pOverlayDlg->ParentWnd() == this)
    {
        m_listOverlays.remove(pOverlayDlg);
    }
    else
    {
        CFSISuiteView* pView = dynamic_cast<CFSISuiteView*>(GetActiveView());
        if (pView != NULL)
        {
            pView->RemoveOverlay(pOverlayDlg);
        }
    }

    // Remove from the map of overlays that have been on the screen
    // on which this instance of CMainFrame is displayed.
    _FSI_STL::map<_FSI_STL::string, COverlayDlg*>::iterator mIt;
    mIt = m_mapNameToOverlay.find((LPCTSTR)strPathInfo);
    if (mIt != m_mapNameToOverlay.end())
    {
        m_mapNameToOverlay.erase(mIt);
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnDisplayOverlay()
//
// Inputs           : WPARAM wParam - has the address of an instance of 
//                                    COverlayDlg to display.
//                    LPARAM lParam - has the address of a string that
//                                    contains the path to the file to 
//                                    display.
//
// Return Values    :  0 if successful.
//                    -1 otherwise.
//
// Date             : 08 February 2000
//
// Engineer         : Billy Baker
//
// Description      : OnDisplayOverlay() is invoked in response to the 
//                    posting or sending of a WM_DISPLAY_OVERLAY 
//                    message or from the OnDisplayAutoOverlay method 
//                    in this same class.  Its purpose is to display an 
//                    overlay.  The file must exist and the overlay 
//                    must not already be visible for the new instance 
//                    to be displayed.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnDisplayOverlay(WPARAM wParam, LPARAM lParam)
{
    COverlayDlg* pOverlayDlg = (COverlayDlg*)wParam;
    CString strPathInfo((LPCTSTR)lParam);
    if (pOverlayDlg != NULL)
    {
        // A dialog was created.  Check to see if the file exists.
        // If it doesn't, then destroy the overlay and display
        // a message.
        if (strPathInfo.Find("^") > -1)
        {
            CWidget::ExpandPath(strPathInfo);
        }

        if (::GetFileAttributes(strPathInfo) == 0xFFFFFFFF)
        {
            ::MessageBox(GetSafeHwnd(),
                         _T(strPathInfo + " not found."),
                         _T("Error"),
                         MB_OK);
			pOverlayDlg->DestroyWindow();
            return -1;
        }

        if (m_mapNameToOverlay.find((LPCTSTR)strPathInfo) != 
            m_mapNameToOverlay.end())
		{
            // Overlay is already displayed, destroy this new overlay.
			pOverlayDlg->DestroyWindow();
            return -1;
		}
		else
		{
            // Since the file exists and is not currently displayed,
            // read the file into a CXMLPage and then fit the dialog
            // to the page.
            CFSISuiteDoc* pDoc  = dynamic_cast<CFSISuiteDoc*>(GetActiveDocument());
            CWidget* pWidget    = NULL;
            if (pDoc != NULL)
            {
                pDoc->UseXMLDOMDocument(true);
                CXMLPage* pXMLPage = pDoc->ReadFile((LPCTSTR)lParam, 
                                                    pDoc->XMLDocument(),
                                                    pDoc->EditMode());
                pDoc->UseXMLDOMDocument(false);

                pOverlayDlg->XMLPage(pXMLPage);

                pDoc->CreateWidgets(pOverlayDlg->m_listWidgets, pOverlayDlg,
                                    (LPCTSTR)lParam, pXMLPage, true);

                pWidget = pDoc->InitializeAttributes(pOverlayDlg->m_listWidgets,
                                                     false);
                CPageWidget* pPageWidget = dynamic_cast<CPageWidget*>(pWidget);
                if (pPageWidget != NULL)
                {
                    if (pPageWidget->HelpFile() == "")
                    {
                        CString strFilePath(strPathInfo);

                        if (strFilePath.ReverseFind('\\') > -1)
                        {
                            strFilePath = strFilePath.Mid(strFilePath.ReverseFind('\\') + 1);
                        }

                        if (strFilePath.Find(".") > -1)
                        {
                            strFilePath = strFilePath.Left(strFilePath.Find("."));
                        }

                        strFilePath += ".htm";
                        pPageWidget->HelpFile(_FSI_STL::string((LPCTSTR)strFilePath));
                    }
                }

                pDoc->Scale(pOverlayDlg->m_listWidgets, pWidget);

                // Update the extents in case they were scaled.
                pWidget->UpperLeft(CExtentsPoint("0,0"));
                CRect rect;
                CView* pView = GetActiveView();
                pView->GetWindowRect(&rect);
                pWidget->LowerRight(CExtentsPoint(CPoint(rect.Width(), 
                                                      rect.Height())));
                ((CPageWidget*)pWidget)->UpdateExtents();

                pOverlayDlg->PathName(strPathInfo);
                pOverlayDlg->PageWidget(pWidget);
    		    pOverlayDlg->WindowName(CString((LPCTSTR)lParam));
			    pOverlayDlg->FitToPage();

                // Add to map of all overlays created for this instance
                // of CMainFrame.
                m_mapNameToOverlay[(LPCTSTR)strPathInfo] = pOverlayDlg;

                // Add to the list of overlays of the appropriate parent.
                // Note, do not try CWnd::GetParent for the dialog.  It
                // will always return the frame.
                CWnd* pWnd = pOverlayDlg->ParentWnd();
                if (pWnd == this)
                {
                    m_listOverlays.push_back(pOverlayDlg);
                }
                else
                {
                    CFSISuiteView* pView = dynamic_cast<CFSISuiteView*>(GetActiveView());
                    if (pView != NULL)
                    {
                        pView->AddOverlay(pOverlayDlg);
                    }
                }
            }
            else
            {
                // No document.
                pOverlayDlg->DestroyWindow();
                return -1;
            }
		}
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnDisplayAutoOverlay()
//
// Inputs           : WPARAM wParam - Not used.
//                    LPARAM lParam - the address of a string that has
//                                    a path to a file to display.
//
// Return Values    : 0.
//
// Date             : 08 February 2000
//
// Engineer         : Billy Baker
//
// Description      : OnDisplayAutoOverlay() is normally invoked from a
//                    PostMessage in CRange::PerformAction.  Its 
//                    purpose is to display a persistant overlay in 
//                    response to some data changing.  Examples would 
//                    include displaying a crash page when the aircraft 
//                    has crashed or a visual timeout page when the 
//                    visual system timesout.  If the overlay has 
//                    already been created and not destroyed, nothing 
//                    happens.  
//                    
//                    The lParam data is not deleted and should be in 
//                    the format or either d:\pages\slews.fml or 
//                    IOS^PAGES^slews.fml.  If the second case is used, 
//                    then the title of the overlay will display IOS - 
//                    Slews.  If the first case is used, then the title 
//                    of the overlay will display d:\pages\slews.fml.  
//                    
//                    Normally, the lParam value is the address of a 
//                    string in an instance of CRange.  CRanges are 
//                    created whenever the COMMS protocol is started 
//                    and deleted when the COMMS protocol is stopped.  The
//                    data should not change unless the variables file is
//                    reread in which case the COMMS protocol is stopped.
//                    
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnDisplayAutoOverlay(WPARAM wParam, LPARAM lParam)
{
    _FSI_STL::string* pstlStrPathInfo = (_FSI_STL::string*)lParam;
    if (pstlStrPathInfo != NULL)
    {
        CString strPathInfo(pstlStrPathInfo->c_str());

        // Expand the path to search the map of created overlays for
        // the current screen.
        if (strPathInfo.Find("^") > -1)
        {
            CWidget::ExpandPath(strPathInfo);
        }

        if (m_mapNameToOverlay.find((LPCTSTR)strPathInfo) == 
                                                    m_mapNameToOverlay.end())
        {
            // The overlay has not been created.  Reset the path string
            // in case ExpandPath was called.
            strPathInfo = CString(pstlStrPathInfo->c_str());

            COverlayDlg* pOverlayDlg = new COverlayDlg;
			pOverlayDlg->XMLPageName(strPathInfo);

            if (pOverlayDlg != NULL)
            {
                // Remove the OK button from the trim and eject overlays
                if ((strPathInfo == "IOS^PAGES^trim.fml") || (strPathInfo == "IOS^PAGES^ejection.fml"))
                {
                   pOverlayDlg->Options(PERSIST);
                   pOverlayDlg->Create(this);
                }
                else
                {
                   pOverlayDlg->Options(PERSIST | OK);
                   pOverlayDlg->Create(this);
                }
                OnDisplayOverlay((long)pOverlayDlg, (long)(LPCTSTR)strPathInfo);
            }
        }
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CMainFrame::OnCloseAutoOverlay()
//
// Inputs           : WPARAM wParam - Not used.
//                    LPARAM lParam - the address of a string that has
//                                    a path to a file to close.
//
// Return Values    : 0.
//
// Date             : 08 February 2000
//
// Engineer         : Billy Baker
//
// Description      : OnCloseAutoOverlay() is normally invoked from a
//                    PostMessage in CRange::PerformAction.  Its 
//                    purpose is to close a persistant overlay in 
//                    response to some data changing.  Examples would 
//                    include closing a visual timeout page when the 
//                    visual system resets.  If the overlay has not
//                    already been created or has been closed by the
//                    user, nothing happens.  
//                    
//                    The lParam data is not deleted and should be in 
//                    the format or either d:\pages\slews.fml or 
//                    IOS^PAGES^slews.fml.
//                    
//                    Normally, the lParam value is the address of a 
//                    string in an instance of CRange.  CRanges are 
//                    created whenever the COMMS protocol is started 
//                    and deleted when the COMMS protocol is stopped.  The
//                    data should not change unless the variables file is
//                    reread in which case the COMMS protocol is stopped.
//                    
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CMainFrame::OnCloseAutoOverlay(WPARAM wParam, LPARAM lParam)
{
    _FSI_STL::string* pstlStrPathInfo = (_FSI_STL::string*)lParam;
    if (pstlStrPathInfo != NULL)
    {
        CString strPathInfo(pstlStrPathInfo->c_str());

        if (strPathInfo.Find("^") > -1)
        {
            CWidget::ExpandPath(strPathInfo);
        }

        if (m_mapNameToOverlay.find((LPCTSTR)strPathInfo) != 
                                                    m_mapNameToOverlay.end())
        {
			m_mapNameToOverlay[(LPCTSTR)strPathInfo]->DestroyWindow();
        }
    }

    return 0;
}

//////////////////////////////////////////////////////////////////////
//  Printing
//////////////////////////////////////////////////////////////////////

void CMainFrame::OnPrint()
{
    // Send a message to the regular print channels to print.
    GetActiveView()->PostMessage(WM_COMMAND,ID_FILE_PRINT,0);
}

void CMainFrame::OnPrintPreview()
{
    CreateBitmap();

    GetActiveView()->PostMessage(WM_COMMAND, ID_FILE_PRINT_PREVIEW, 0);
}

// Create a copy of the current system palette.
HPALETTE CMainFrame::GetSystemPalette()   
{       
    HDC hDC;       
    HPALETTE hPal;
       
    LPLOGPALETTE lpLogPal;

    // Get a DC for the desktop.       
    hDC = ::GetDC(NULL);
    
    // Check to see if you are a running in a palette-based video mode.
    if (!(GetDeviceCaps(hDC, RASTERCAPS) & RC_PALETTE)) 
    {
        ::ReleaseDC(NULL, hDC);
        return NULL;       
    }
    
    // Allocate memory for the palette.
    lpLogPal = (LPLOGPALETTE)GlobalAlloc(GPTR, sizeof(LOGPALETTE) + 256 *
                              sizeof(PALETTEENTRY));       
    if (!lpLogPal)
    {
        ::ReleaseDC(NULL, hDC);
        return NULL;       
    }
    
    // Initialize.       
    lpLogPal->palVersion = 0x300;
    lpLogPal->palNumEntries = 256;

    // Copy the current system palette into the logical palette.
    GetSystemPaletteEntries(hDC, 0, 256,
                (LPPALETTEENTRY)(lpLogPal->palPalEntry));

    // Create the palette.       
    hPal = CreatePalette(lpLogPal);

    // Clean up.       
    GlobalFree(lpLogPal);       
    ::ReleaseDC(NULL, hDC);
    return hPal;   
}

void CMainFrame::CreateBitmap()
{
    HDC       hdcMemDC = NULL;
    HDC       hdcScreen;
    RECT      rc;
    HPALETTE  hPal;
    BITMAP    bmpScreen;

    // Get a DC for the screen.
    hdcScreen=::GetDC(NULL);

    int BitPerPixel = ::GetDeviceCaps(hdcScreen,BITSPIXEL);
    int Left,Top,Width,Height;

    // Get the rectangle bounding the window.
    GetWindowRect( &rc );

    // clip frame at edges
    Left = rc.left + 2;
    Top = rc.top + 2;
    Width = rc.right - rc.left - 4;
    Width = Width/4*4;
    Height = rc.bottom - rc.top - 4;
    Height = Height/4*4;

    hdcMemDC=::CreateCompatibleDC(hdcScreen);

    LPBYTE pBits;
    BITMAPINFO bmi;
       
    // Initialize to zeros.       
    ZeroMemory(&bmi, sizeof(bmi));

    // Initialize the header.
    bmi.bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    bmi.bmiHeader.biWidth = Width;       
    bmi.bmiHeader.biHeight = Height;
    bmi.bmiHeader.biPlanes = 1;       
    bmi.bmiHeader.biBitCount = 24;
    bmi.bmiHeader.biCompression = BI_RGB;

    // Delete any created bitmaps
    if (m_hbm != NULL) DeleteObject(m_hbm);

    // Create a Device Independent Bitmap (DIB).
    m_hbm = ::CreateDIBSection(hdcScreen, &bmi, DIB_RGB_COLORS, (void**)&pBits, NULL, 0);

    if (BitPerPixel>24) BitPerPixel=24;

    ::SetBitmapBits(m_hbm,2,&BitPerPixel);
    ::SelectObject(hdcMemDC,m_hbm);

    // Get the current system palette.
    hPal = GetSystemPalette();       
   
    // If a palette was returned.
    if (hPal) 
    {           
        // Apply the palette to the source DC.
        SelectPalette(hdcScreen, hPal, FALSE);
        RealizePalette(hdcScreen);

        // Apply the palette to the destination DC.
        SelectPalette(hdcMemDC, hPal, FALSE);
        RealizePalette(hdcMemDC);       
    }

    // Copy the window contents to the memory surface.
    BitBlt(hdcMemDC,0,0,Width,Height,hdcScreen,Left,Top,SRCCOPY);

    ::GetObject(m_hbm,sizeof(BITMAP),&bmpScreen);
    if(bmpScreen.bmBitsPixel>24) 
    {
        bmpScreen.bmBitsPixel = 24;
    }

    bmpScreen.bmWidthBytes = bmpScreen.bmWidth*(bmpScreen.bmBitsPixel/8);

    ::DeleteObject(hdcMemDC);
    ::ReleaseDC(NULL,hdcScreen);
    if (hPal)           
       DeleteObject(hPal);
}


//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////

CEditorControls* CMainFrame::EditorControls()
{
    return &m_wndEditorControls;
}

CEditorTree* CMainFrame::EditorTree()
{
    return &m_wndEditorTree;
}

HBITMAP CMainFrame::PrintScreen()
{
    return m_hbm;
}

_FSI_STL::string CMainFrame::LastComponent()
{
    return m_stlStrLastComponentName;
}

long int CMainFrame::LastComponentID()
{
    return m_lLastComponentID;
}

unsigned char CMainFrame::WindowNumber()
{
    return m_ucWindowNumber;
}

_FSI_STL::string CMainFrame::HelpFile()
{
    return m_stlStrHelpFile;
}

unsigned long CMainFrame::LoadNumber()
{
    ++m_ulLoadNumber;
    return m_ulLoadNumber;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////

void CMainFrame::PrintScreen(HBITMAP hbm)
{
    m_hbm = hbm;
}

void CMainFrame::HelpFile(const _FSI_STL::string& rstlStrHelpFile)
{
    m_stlStrHelpFile = rstlStrHelpFile;
}

bool CMainFrame::CheckHideComponentButtons()
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);

        RegQueryValueEx(hKey, _T("HideComponentButtons"), NULL, NULL, (BYTE*)&ulData, &dwSize);
        
        RegCloseKey(hKey);
        
        if (ulData > 0)
           return true;
    }
    return false;
}


void CMainFrame::OnUpdateEditOptions(CCmdUI* pCmdUI) 
{
    if (m_bAdmin)
    {
        pCmdUI->Enable(true);
    }
    else
    {
        pCmdUI->Enable(false);
    }
}

BOOL CMainFrame::OnQueryEndSession() 
{
	if (!CFrameWnd::OnQueryEndSession())
		return FALSE;
	
   AfxBeginThread(CMainFrame::MsgThread, (LPVOID)0);
	
	return FALSE;
}

UINT CMainFrame::MsgThread(LPVOID param)
{
   ::MessageBox(NULL, "Please exit all applications before attempting to Logoff", "FSISuite - Attention", MB_ICONSTOP |  MB_OK);
   return   0;
}