#if !defined(_HELPEDITOR_H_)
#define _HELPEDITOR_H_

#include <map>
#include <list>
#include "IniFile.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMainFrame;

class CHelpFile
{
public:
    CHelpFile();
    CHelpFile(const CHelpFile& HelpFile);

    void WriteFile();
    void ReadFile();

    _FSI_STL::string                                    m_stlStrFilename;
    _FSI_STL::list<CString>                             m_listSections;
    _FSI_STL::map<CString, CString>                     m_mapSectionData;
    _FSI_STL::list<CString>                             m_listRelatedTopics;
    _FSI_STL::map<CString, CString>                     m_mapRelatedTopicsData;
    _FSI_STL::string                                    m_stlStrTitle;
    _FSI_STL::string                                    m_stlStrProject;
};

class CHelpEditor : public CDialog
{
private:
    CMainFrame*                                         m_pFrame;

    _FSI_STL::map<CString, CIniFile>                    m_mapIniFiles;

    _FSI_STL::map<CString, _FSI_STL::map<CString, CHelpFile> > m_mapHelpFiles;

    CString                                             m_strHelpProjectSelection;

// Construction
public:
	CHelpEditor(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CHelpEditor)
	enum { IDD = IDD_HELP_EDITOR };
	CListCtrl	m_ctrlHelpProjectList;
	CListBox	m_ctrlSectionsListBox;
	CListBox	m_ctrlRelatedTopicsListBox;
	CString	m_strSectionText;
	CString	m_strSectionName;
	CString	m_strRelatedTopicName;
	CString	m_strProjectName;
	CString	m_strPageTitle;
	CString	m_strPageFilename;
	CString	m_strCompiledOutputFilename;
	CString	m_strMainFile;
	//}}AFX_DATA

    void MainFrame(const CMainFrame* pFrame);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHelpEditor)
	public:
	virtual BOOL Create();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
protected:

    bool ValidateMainFile();
    bool ValidateProject();
    bool ValidatePageFilename();
    bool ValidatePageTitle();
    bool ValidateCompiledOutputFilename();

	// Generated message map functions
	//{{AFX_MSG(CHelpEditor)
	afx_msg void OnMainFileBrowse();
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg void OnCompileHelp();
	afx_msg void OnAddProject();
	afx_msg void OnChangeProject();
	afx_msg void OnDeleteProject();
	afx_msg void OnAddPage();
	afx_msg void OnChangePage();
	afx_msg void OnDeletePage();
	afx_msg void OnAddSection();
	afx_msg void OnChangeSection();
	afx_msg void OnDeleteSection();
	afx_msg void OnAddTopic();
	afx_msg void OnChangeTopic();
	afx_msg void OnDeleteTopic();
	virtual void OnCancel();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg void OnClickHelpProjects(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangePageRelatedTopics();
	afx_msg void OnSelchangePageSections();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_HELPEDITOR_H_)
