#include "..\core\stdafx.h"
#include "fsisuite.h"
#include "MainFrm.h"
#include "HelpEditor.h"
#include <fstream>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CHelpFile::CHelpFile()
{
}

CHelpFile::CHelpFile(const CHelpFile& HelpFile)
{
    m_listRelatedTopics     = HelpFile.m_listRelatedTopics;
    m_listSections          = HelpFile.m_listSections;
    m_mapSectionData        = HelpFile.m_mapSectionData;
    m_stlStrTitle           = HelpFile.m_stlStrTitle;
    m_stlStrProject         = HelpFile.m_stlStrProject;
    m_stlStrFilename        = HelpFile.m_stlStrFilename;
    m_mapRelatedTopicsData  = HelpFile.m_mapRelatedTopicsData;
}

void CHelpFile::WriteFile()
{
    if (m_stlStrFilename == "")
    {
        return;
    }

    _FSI_STL::ofstream helpfile;
	helpfile.open(m_stlStrFilename.c_str());
    helpfile << "<HTML>\n";
    helpfile << "<HEAD>\n";
    helpfile << "<TITLE>" << m_stlStrTitle.c_str() << " (" << m_stlStrProject.c_str() << ")</TITLE>\n";
    helpfile << "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=iso-8859-1\">\n";
    helpfile << "<META NAME=\"Version\" CONTENT=\"1.1\">\n";

    helpfile << "   <STYLE>\n";
    helpfile << "       BODY {background: white; color: black; font-family: Arial;\n";
    helpfile << "             font-size: 10pt; white-space: pre; margin: 10px;\n";
    helpfile << "            }\n";
    helpfile << "       H2 {font-size: 18pt; font-weight: bold; white-space: pre;}\n";
    helpfile << "       TH {font-size: 12pt; color: white; font-weight: bold;\n";
    helpfile << "           white-space: pre;}\n";
    helpfile << "       TD {font-size: 12pt; text-align: justify;}\n";
    helpfile << "       DIV.box {border-STYLE: solid; border-width: 2px; padding: 10px;\n";
    helpfile << "                width: 100%;\n";
    helpfile << "               }\n";
    helpfile << "       DIV.nobox {border-STYLE: solid; border-width: 2px;\n";
    helpfile << "                  padding: 10px;\n";
    helpfile << "                  width: 100%; border-color: white;\n";
    helpfile << "                 }\n";
    helpfile << "   </STYLE>\n";
    helpfile << "</HEAD>\n";
    helpfile << "<BODY>\n";
    helpfile << "<!--Heading:  page title and (application) centered-->\n";
    helpfile << "<H2 STYLE=\"text-align: center\">" << m_stlStrTitle.c_str() << "</H2>\n";
    helpfile << "<!--Table nesting to insure that the heading stays on the same page \n";
    helpfile << "    as the information.-->\n";

    helpfile << "<TABLE BORDER=0 WIDTH=100%>\n";
    helpfile << "<TR>\n";
    helpfile << "<TD>\n";
    helpfile << "    <DIV CLASS=\"box\">\n";
    helpfile << "    <TABLE BORDER=0 WIDTH=100%>\n";
    helpfile << "    <TR ALIGN=CENTER VALIGN=CENTER  BGCOLOR=\"#000099\">\n";
    helpfile << "    <TH>Description</TH>\n";
    helpfile << "    </TR>\n";
    helpfile << "    </TABLE>\n";
    helpfile << "    </DIV>\n";
    helpfile << "</TD>\n";
    helpfile << "</TR>\n";

    _FSI_STL::list<CString>::iterator lCsIt     = m_listSections.begin();
    _FSI_STL::list<CString>::iterator lCsEndIt  = m_listSections.end();

    while (lCsIt != lCsEndIt)
    {
        helpfile << "<TR>\n";
        helpfile << "<TD>\n";
        helpfile << "    <DIV CLASS=\"nobox\">\n";
        helpfile << "    <TABLE BORDER=0 WIDTH=100%>\n";
        helpfile << "    <TR>\n";
        helpfile << "    <TD TITLE=\"Description\"><div align=\"left\">\n";
        helpfile << "                              <b TITLE=\"SectionName\">\n";
        helpfile <<  (LPCTSTR)(*lCsIt) << "\n";
        helpfile << "                              </b></div>\n";

        if (m_mapSectionData.find((*lCsIt)) != m_mapSectionData.end())
        {
            helpfile << "                            <div TITLE=\"SectionData\">\n";
            helpfile << (LPCTSTR)m_mapSectionData[(*lCsIt)] <<"\n";
            helpfile << "                            </div>\n";
        }

        helpfile << "    </TD>\n";
        helpfile << "    </TR>\n";
        helpfile << "    </TABLE>\n";
        helpfile << "    </DIV>\n";
        helpfile << "</TD>\n";
        helpfile << "</TR>\n";

        lCsIt++;
    }

    helpfile << "</TABLE>\n";
    helpfile << "&nbsp;\n";
    helpfile << "<!--Table nesting to insure that the heading stays on the same page \n";
    helpfile << "    as the related topics.-->\n";

    helpfile << "<TABLE BORDER=0 WIDTH=100%>\n";
    helpfile << "<TR>\n";
    helpfile << "<TD>\n";
    helpfile << "    <DIV CLASS=\"box\">\n";
    helpfile << "    <TABLE BORDER=0 WIDTH=100%>\n";
    helpfile << "    <TR ALIGN=CENTER VALIGN=CENTER BGCOLOR=\"#000099\">\n";
    helpfile << "    <TH>Related Topics</TH>\n";
    helpfile << "    </TR>\n";
    helpfile << "    </TABLE>\n";
    helpfile << "    </DIV>\n";
    helpfile << "</TD>\n";
    helpfile << "</TR>\n";

    lCsIt       = m_listRelatedTopics.begin();
    lCsEndIt    = m_listRelatedTopics.end();

    helpfile << "<TR>\n";
    helpfile << "<TD>\n";
    helpfile << "    <DIV CLASS=\"nobox\">\n";
    helpfile << "    <TABLE BORDER=0 WIDTH=100%>\n";
    helpfile << "    <TR>\n";
    helpfile << "    <TD CLASS=\"RelatedTopic\" TITLE=\"RelatedTopics\">\n"; 

    while (lCsIt != lCsEndIt)
    {
        if (m_mapRelatedTopicsData.find((*lCsIt)) != m_mapRelatedTopicsData.end())
        {
            CString str = m_mapRelatedTopicsData[(*lCsIt)];
            str.MakeReverse();
            if (str.Find("segap\\") > -1)
            {
                str = str.Left(str.Find("segap\\") + 5);
            }
            str.MakeReverse();

            helpfile << "                               <a TITLE=\"RelatedTopicData\" href=\"" << (LPCTSTR)str << "\">\n";
            helpfile << (LPCTSTR)(*lCsIt) << "\n";
            helpfile << "                               </a>";
        }

        lCsIt++;

        if (lCsIt != lCsEndIt)
        {
            helpfile << ", ";
        }

        helpfile << "\n";
    }

    helpfile << "    </TD>\n";
    helpfile << "    </TR>\n";
    helpfile << "    </TABLE>\n";
    helpfile << "    </DIV>\n";
    helpfile << "</TD>\n";
    helpfile << "</TR>\n";
    helpfile << "</TABLE>\n";

    helpfile << "</BODY>\n";
    helpfile << "</HTML>\n";

	helpfile.close();
}


void CHelpFile::ReadFile()
{
    if (m_stlStrFilename == "")
    {
        return;
    }

    _FSI_STL::string stlStrLine;
    _FSI_STL::ifstream helpfile;
    helpfile.open(m_stlStrFilename.c_str());

    bool bNextLineSectionData       = false;
    bool bNextLineSectionName       = false;
    bool bNextLineRelatedTopicName  = false;

    CString strLastSection;
    CString strLastTopicData;

    // Move through the file until we find the first section
    while (_FSI_STL::getline(helpfile, stlStrLine))
    {
        if (bNextLineSectionName == true)
        {
            bNextLineSectionName = false;
            strLastSection = stlStrLine.c_str();
            m_listSections.push_back(strLastSection);
        }

        if (bNextLineSectionData == true)
        {
            bNextLineSectionData = false;
            m_mapSectionData[strLastSection] = stlStrLine.c_str();
        }

        if (bNextLineRelatedTopicName == true)
        {
            bNextLineRelatedTopicName = false;
            m_listRelatedTopics.push_back(stlStrLine.c_str());
            m_mapRelatedTopicsData[stlStrLine.c_str()] = strLastTopicData;
        }

        if (stlStrLine.find("TITLE=\"SectionName\"") != stlStrLine.npos)
        {
            bNextLineSectionName = true;
        }

        if (stlStrLine.find("TITLE=\"SectionData\"") != stlStrLine.npos)
        {
            bNextLineSectionData = true;
        }

        if (stlStrLine.find("TITLE=\"RelatedTopicData\"") != stlStrLine.npos)
        {
            bNextLineRelatedTopicName = true;
            strLastTopicData = stlStrLine.c_str();
            strLastTopicData = strLastTopicData.Mid(strLastTopicData.Find("href") + 6);
            strLastTopicData = strLastTopicData.Left(strLastTopicData.Find("\""));
        }
    }

    helpfile.close();
}
CHelpEditor::CHelpEditor(CWnd* pParent /*=NULL*/)
	: CDialog(CHelpEditor::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHelpEditor)
	m_strSectionText = _T("");
	m_strSectionName = _T("");
	m_strRelatedTopicName = _T("");
	m_strProjectName = _T("");
	m_strPageTitle = _T("");
	m_strPageFilename = _T("");
	m_strCompiledOutputFilename = _T("");
	m_strMainFile = _T("");
	//}}AFX_DATA_INIT

    m_pFrame = NULL;
}


void CHelpEditor::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHelpEditor)
	DDX_Control(pDX, IDC_HELP_PROJECTS, m_ctrlHelpProjectList);
	DDX_Control(pDX, IDC_PAGE_SECTIONS, m_ctrlSectionsListBox);
	DDX_Control(pDX, IDC_PAGE_RELATED_TOPICS, m_ctrlRelatedTopicsListBox);
	DDX_Text(pDX, IDC_SECTION_TEXT, m_strSectionText);
	DDX_Text(pDX, IDC_SECTION_NAME, m_strSectionName);
	DDX_Text(pDX, IDC_RELATED_TOPIC_NAME, m_strRelatedTopicName);
	DDX_Text(pDX, IDC_PROJECT_NAME, m_strProjectName);
	DDX_Text(pDX, IDC_PAGE_TITLE, m_strPageTitle);
	DDX_Text(pDX, IDC_PAGE_FILENAME, m_strPageFilename);
	DDX_Text(pDX, IDC_OUTPUT_NAME, m_strCompiledOutputFilename);
	DDX_Text(pDX, IDC_MAIN_FILE, m_strMainFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHelpEditor, CDialog)
	//{{AFX_MSG_MAP(CHelpEditor)
	ON_BN_CLICKED(IDC_MAIN_FILE_BROWSE, OnMainFileBrowse)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_COMPILE_HELP, OnCompileHelp)
	ON_BN_CLICKED(IDC_ADD_PROJECT, OnAddProject)
	ON_BN_CLICKED(IDC_CHANGE_PROJECT, OnChangeProject)
	ON_BN_CLICKED(IDC_DELETE_PROJECT, OnDeleteProject)
	ON_BN_CLICKED(IDC_ADD_PAGE, OnAddPage)
	ON_BN_CLICKED(IDC_CHANGE_PAGE, OnChangePage)
	ON_BN_CLICKED(IDC_DELETE_PAGE, OnDeletePage)
	ON_BN_CLICKED(IDC_ADD_SECTION, OnAddSection)
	ON_BN_CLICKED(IDC_CHANGE_SECTION, OnChangeSection)
	ON_BN_CLICKED(IDC_DELETE_SECTION, OnDeleteSection)
	ON_BN_CLICKED(IDC_ADD_TOPIC, OnAddTopic)
	ON_BN_CLICKED(IDC_CHANGE_TOPIC, OnChangeTopic)
	ON_BN_CLICKED(IDC_DELETE_TOPIC, OnDeleteTopic)
	ON_NOTIFY(NM_CLICK, IDC_HELP_PROJECTS, OnClickHelpProjects)
	ON_LBN_SELCHANGE(IDC_PAGE_RELATED_TOPICS, OnSelchangePageRelatedTopics)
	ON_LBN_SELCHANGE(IDC_PAGE_SECTIONS, OnSelchangePageSections)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

bool CHelpEditor::ValidateMainFile()
{
    bool bRetVal = true;

    if (m_strMainFile == "")
    {
        AfxMessageBox("Please specify a main help file.");
        bRetVal = false;
    }

    return bRetVal;
}

bool CHelpEditor::ValidateProject()
{
    bool bRetVal = true;

    if (m_strProjectName == "")
    {
        AfxMessageBox("Please specify a project.");
        bRetVal = false;
    }

    return bRetVal;
}

bool CHelpEditor::ValidatePageFilename()
{
    bool bRetVal = true;

    if (m_strPageFilename == "")
    {
        AfxMessageBox("Please specify a filename.");
        bRetVal = false;
    }

    return bRetVal;
}

bool CHelpEditor::ValidatePageTitle()
{
    bool bRetVal = true;

    if (m_strPageTitle == "")
    {
        AfxMessageBox("Please specify a page title.");
        bRetVal = false;
    }

    return bRetVal;
}

bool CHelpEditor::ValidateCompiledOutputFilename()
{
    bool bRetVal = true;

    if (m_strCompiledOutputFilename == "")
    {
        AfxMessageBox("Please specify a filename for the compiled output.");
        bRetVal = false;
    }

    return bRetVal;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CHelpEditor::OnMainFileBrowse()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 10 May 2000
//
// Engineer         : Billy Baker
//
// Description      : OnMainFileBrowse will display a common file dialog
//                    so that the user may find and select the main HTML
//                    Help project (hhp) file.  This is the project file
//                    that will know about all of the other project files.
//
/////////////////////////////////////////////////////////////////////////////
void CHelpEditor::OnMainFileBrowse() 
{
    UpdateData(TRUE);
	CFileDialog cfd(TRUE,"hhp",m_strMainFile,NULL,
					"HTML Help project (*.hhp)|*.hhp|All Files "
					"(*.*)|*.*||",this);
	long int lReturnVal = 0;

	lReturnVal = cfd.DoModal();
	if (lReturnVal && lReturnVal != IDCANCEL)
	{
        m_strMainFile = cfd.GetPathName();

        // Reset all of the controls
	    m_strSectionText = _T("");
	    m_strSectionName = _T("");
	    m_strRelatedTopicName = _T("");
	    m_strProjectName = _T("");
	    m_strPageTitle = _T("");
	    m_strPageFilename = _T("");
	    m_strCompiledOutputFilename = _T("");

        m_ctrlHelpProjectList.DeleteAllItems();
        m_ctrlRelatedTopicsListBox.ResetContent();
        m_ctrlSectionsListBox.ResetContent();

        m_mapHelpFiles.clear();
        m_mapIniFiles.clear();

        m_mapIniFiles["Main"].SetPath(m_strMainFile);
        m_mapIniFiles["Main"].Reset();
        m_mapIniFiles["Main"].ReadFile();

        // Attempt to display the subprojects.
        int nNumValues = m_mapIniFiles["Main"].GetNumValues("MERGE FILES");
        int n = 0;
        CString strSubProject;
        int nItem = -1;
        while (n < nNumValues)
        {
            strSubProject = m_mapIniFiles["Main"].GetValuePair("MERGE FILES", n);
            if (strSubProject.Find("=") > -1)
            {
                strSubProject = strSubProject.Left(strSubProject.Find("="));
            }

            if (strSubProject.Find(".") > -1)
            {
                strSubProject = strSubProject.Left(strSubProject.Find("."));
            }

            // Each subproject will be under the directory that has the main
            // help project.
            CString strSubProjectPath(m_strMainFile);
            strSubProjectPath.MakeReverse();
            if (strSubProjectPath.Find("\\") > -1)
            {
                strSubProjectPath = strSubProjectPath.Mid(strSubProjectPath.Find("\\") + 1);
            }
            strSubProjectPath.MakeReverse();
            strSubProjectPath += "\\" + strSubProject + "\\" + strSubProject + ".hhp";
            m_mapIniFiles[strSubProject].SetPath(strSubProjectPath);
            m_mapIniFiles[strSubProject].Reset();
            if (m_mapIniFiles[strSubProject].ReadFile())
            {
                // Attempt to add the files for the subproject to the tree control.
                nItem = m_ctrlHelpProjectList.InsertItem(nItem + 1, strSubProject);
                int nNumFileTitles = m_mapIniFiles[strSubProject].GetNumValues("FILE_TITLES");
                int nFile = 0;
                strSubProjectPath = strSubProjectPath.Left(strSubProjectPath.Find(strSubProject)); 
                while (nFile < nNumFileTitles)
                {
                    CString strFileTitle = m_mapIniFiles[strSubProject].GetValuePair("FILE_TITLES", nFile);
                    CString strFilePath;

                    if (strFileTitle.Find("=") > -1)
                    {
                        strFilePath = strSubProjectPath + "pages\\" + strFileTitle.Mid(strFileTitle.Find("=") + 1);
                        strFileTitle = strFileTitle.Left(strFileTitle.Find("="));
                    }

                    nItem = m_ctrlHelpProjectList.InsertItem(nItem + 1, "          " + strFileTitle);
                    nFile++;

                    m_mapHelpFiles[strSubProject][strFileTitle].m_stlStrTitle   = (LPCTSTR)strFileTitle;
                    m_mapHelpFiles[strSubProject][strFileTitle].m_stlStrProject = (LPCTSTR)strSubProject;
                    m_mapHelpFiles[strSubProject][strFileTitle].m_stlStrFilename = (LPCTSTR)strFilePath; 
                    m_mapHelpFiles[strSubProject][strFileTitle].ReadFile();
                }
            }
            else
            {
                AfxMessageBox("Could not open subproject: " + strSubProject + 
                                " - " + strSubProjectPath + ".");
            }

            n++;
        }

        m_strCompiledOutputFilename = m_mapIniFiles["Main"].GetValue("OPTIONS","Compiled file");

        UpdateData(FALSE);
	}
}

void CHelpEditor::OnCompileHelp() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile())
    {
        return;
    }

    if (m_strCompiledOutputFilename == "")
    {
        AfxMessageBox("The output name is not valid.");
        return;
    }
    
    m_mapIniFiles["Main"].SetValue("OPTIONS", "Compiled file", m_strCompiledOutputFilename);

    _FSI_STL::map<CString, CIniFile>::iterator mProjectIt   = m_mapIniFiles.begin();
    _FSI_STL::map<CString, CIniFile>::iterator mendIt       = m_mapIniFiles.end();

    _FSI_STL::ofstream auxFiles;
    CString strPath;
    strPath = m_mapIniFiles["Main"].GetPath();
    strPath.Replace("hhp", "hhk");
    auxFiles.open(strPath);

    auxFiles << "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">\n";
    auxFiles << "<HTML>\n";
    auxFiles << "<HEAD>\n";
    auxFiles << "<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">\n";
    auxFiles << "<!-- Sitemap 1.0 -->\n";
    auxFiles << "</HEAD><BODY>\n";
    auxFiles << "<UL>\n";

    while (mProjectIt != mendIt)
    {
        (*mProjectIt).second.WriteFile();

        // If the project isn't the main project, then write out the table of contents with
        // the files in the project.
        if ((*mProjectIt).first != "Main")
        {
            int nFiles = (*mProjectIt).second.GetNumValues("FILES");
            int n = 0;

            CString strFileTitle;
            CString strFileName;

            while (n < nFiles)
            {
                strFileTitle = (*mProjectIt).second.GetValuePair("FILE_TITLES", n);

                if (strFileTitle.Find("=") > -1)
                {
                    strFileName  = "pages\\" + strFileTitle.Mid(strFileTitle.Find("=") + 1);
                    strFileTitle = strFileTitle.Left(strFileTitle.Find("="));
                }

                auxFiles << "        	<LI> <OBJECT type=\"text/sitemap\">\n";
                auxFiles << "			<param name=\"Name\" value=\"" << (LPCTSTR)strFileTitle << "\">\n";
                auxFiles << "			<param name=\"Local\" value=\"" << (LPCTSTR)strFileName << "\">\n";
                auxFiles << "			</OBJECT>\n";

                auxFiles << "	<UL>\n";

                _FSI_STL::list<CString>::iterator lIt = m_mapHelpFiles[(*mProjectIt).first][strFileTitle].m_listSections.begin();
                _FSI_STL::list<CString>::iterator lendIt = m_mapHelpFiles[(*mProjectIt).first][strFileTitle].m_listSections.end();

                while (lIt != lendIt)
                {
                    auxFiles << "        	<LI> <OBJECT type=\"text/sitemap\">\n";
                    auxFiles << "			<param name=\"Name\" value=\"" << (LPCTSTR)(*lIt) << "\">\n";
                    auxFiles << "			<param name=\"Local\" value=\"" << (LPCTSTR)strFileName << "\">\n";
                    auxFiles << "			</OBJECT>\n";

                    lIt++;
                }

                auxFiles << "	</UL>\n";


                lIt = m_mapHelpFiles[(*mProjectIt).first][strFileTitle].m_listSections.begin();
                lendIt = m_mapHelpFiles[(*mProjectIt).first][strFileTitle].m_listSections.end();

                while (lIt != lendIt)
                {
                    auxFiles << "        	<LI> <OBJECT type=\"text/sitemap\">\n";
                    auxFiles << "			<param name=\"Name\" value=\"" << (LPCTSTR)(*lIt) << "\">\n";
                    auxFiles << "			<param name=\"Local\" value=\"" << (LPCTSTR)strFileName << "\">\n";
                    auxFiles << "			</OBJECT>\n";

                    auxFiles << "	<UL>\n";
                    auxFiles << "        	<LI> <OBJECT type=\"text/sitemap\">\n";
                    auxFiles << "			<param name=\"Name\" value=\"" << (LPCTSTR)strFileTitle << "\">\n";
                    auxFiles << "			<param name=\"Local\" value=\"" << (LPCTSTR)strFileName << "\">\n";
                    auxFiles << "			</OBJECT>\n";
                    auxFiles << "	</UL>\n";

                    lIt++;
                }

                n++;
            }

        }

        // Attempt to write the help pages.
        int nNumValues = (*mProjectIt).second.GetNumValues("FILE_TITLES");
        int n = 0;
        CString strTitle;
        CString str;
        while (n < nNumValues)
        {
            str = (*mProjectIt).second.GetValuePair("FILE_TITLES", n);

            if (str.Find("=") > -1)
            {
                str = str.Left(str.Find("="));
            }

            _FSI_STL::list<CString>::iterator lcsIt;
            _FSI_STL::list<CString>::iterator lcsendIt;

            lcsIt       = m_mapHelpFiles[(*mProjectIt).first][str].m_listRelatedTopics.begin();
            lcsendIt    = m_mapHelpFiles[(*mProjectIt).first][str].m_listRelatedTopics.end();

            while (lcsIt != lcsendIt)
            {
                m_mapHelpFiles[(*mProjectIt).first][str].m_mapRelatedTopicsData[(*lcsIt)] = 
                        m_mapHelpFiles[(*mProjectIt).first][(*lcsIt)].m_stlStrFilename.c_str();


                lcsIt++;
            }

            m_mapHelpFiles[(*mProjectIt).first][str].WriteFile();

            n++;
        }
        
        mProjectIt++;
    }

    auxFiles << "</UL>\n";
    auxFiles << "</BODY>\n";
    auxFiles << "</HTML>\n";

    auxFiles.close();

    mProjectIt   = m_mapIniFiles.begin();

    strPath.Replace("hhk", "hhc");
    auxFiles.open(strPath);

    auxFiles << "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML//EN\">\n";
    auxFiles << "<HTML>\n";
    auxFiles << "<HEAD>\n";
    auxFiles << "<meta name=\"GENERATOR\" content=\"Microsoft&reg; HTML Help Workshop 4.1\">\n";
    auxFiles << "<!-- Sitemap 1.0 -->\n";
    auxFiles << "</HEAD><BODY>\n";
    auxFiles << "<OBJECT type=\"text/site properties\">\n";
    auxFiles << "</OBJECT>\n";

    auxFiles << "<UL>\n";

    _FSI_STL::map<CString, _FSI_STL::map<CString, CString> > mapOrderedData;

    // A two pass method.  Order the text then write out the contents.
    while (mProjectIt != mendIt)
    {
        if ((*mProjectIt).first != "Main")
        {
            mapOrderedData[(*mProjectIt).first];

            int nFiles = (*mProjectIt).second.GetNumValues("FILES");
            int n = 0;
            while (n < nFiles)
            {
                CString strFileTitle = (*mProjectIt).second.GetValuePair("FILE_TITLES", n);
                CString strFileName;

                if (strFileTitle.Find("=") > -1)
                {
                    strFileName  = "pages\\" + strFileTitle.Mid(strFileTitle.Find("=") + 1);
                    strFileTitle = strFileTitle.Left(strFileTitle.Find("="));
                }

                mapOrderedData[(*mProjectIt).first][strFileTitle] = strFileName;
                n++;
            }
        }

        mProjectIt++;
    }

    _FSI_STL::map<CString, _FSI_STL::map<CString, CString> >::iterator mODIt = mapOrderedData.begin();
    _FSI_STL::map<CString, _FSI_STL::map<CString, CString> >::iterator mODendIt = mapOrderedData.end();
    _FSI_STL::map<CString, CString>::iterator mSSIt;
    _FSI_STL::map<CString, CString>::iterator mSSendIt;
    mProjectIt   = m_mapIniFiles.begin();

    while (mODIt != mODendIt)
    {
        mSSIt = (*mODIt).second.begin();
        mSSendIt = (*mODIt).second.end();

        auxFiles << "	<LI> <OBJECT type=\"text/sitemap\">\n";
        auxFiles << "		<param name=\"Name\" value=\"" << (LPCTSTR)(*mODIt).first << "\">\n";
        auxFiles << "		<param name=\"Local\" value=\"\">\n";
        auxFiles << "		</OBJECT>\n";
        auxFiles << "   <UL>\n";

        while (mSSIt != mSSendIt)
        {
            auxFiles << "        	<LI> <OBJECT type=\"text/sitemap\">\n";
            auxFiles << "			<param name=\"Name\" value=\"" << (LPCTSTR)(*mSSIt).first << "\">\n";
            auxFiles << "			<param name=\"Local\" value=\"" << (LPCTSTR)(*mSSIt).second << "\">\n";
            auxFiles << "			</OBJECT>\n";

            mSSIt++;
        }

        auxFiles << "   </UL>\n";

        mODIt++;
    }

    auxFiles << "</UL>\n";
    auxFiles << "</BODY>\n";
    auxFiles << "</HTML>\n";

    auxFiles.close();

    // Get the path to hhw.exe which is in the registry.
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
                 _T("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\hhw.exe"),
                 0, KEY_READ, &hKey);
    CString strCompilerPath = "";
    if (hKey != NULL)
    {
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);

        // Get the name of the GlobalColor.
		CString strValue;
		DWORD dwType, dwCount;
		LONG lResult = RegQueryValueEx(hKey, "Path", 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, "Path", 
                                      NULL, &dwType,
				         (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        strCompilerPath = "\"" + strValue;

        RegCloseKey(hKey);
    }
    else
    {
        AfxMessageBox("Path to HTML Help Compiler (hhc.exe) cannot be determined.");
        return;
    }

    strCompilerPath += "\\hhc.exe\"" ;

    // Write a batch file to compile the help.
    strPath = m_mapIniFiles["Main"].GetPath();
    strPath.Replace("hhp", "cmd");

    auxFiles.open(strPath);

    auxFiles << (LPCTSTR)strCompilerPath << " \"" << (LPCTSTR)m_mapIniFiles["Main"].GetPath() << "\"\n";

    auxFiles.close();

    // Execute the batch file.  
    ShellExecute(GetSafeHwnd(), NULL, strPath, NULL, NULL, SW_SHOWNORMAL);
}

void CHelpEditor::OnAddProject() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject())
    {
        return;
    }

    CString strSubProjectPath(m_strMainFile);
    strSubProjectPath.MakeReverse();
    if (strSubProjectPath.Find("\\") > -1)
    {
        strSubProjectPath = strSubProjectPath.Mid(strSubProjectPath.Find("\\") + 1);
    }
    strSubProjectPath.MakeReverse();
    strSubProjectPath += "\\" + m_strProjectName;
    
    CreateDirectory(strSubProjectPath, NULL);
    
    strSubProjectPath += "\\" + m_strProjectName + ".hhp";

    m_mapIniFiles[m_strProjectName].SetPath(strSubProjectPath);
    m_mapIniFiles[m_strProjectName].Reset();

    int nItem = m_ctrlHelpProjectList.InsertItem(m_ctrlHelpProjectList.GetItemCount(), m_strProjectName);
    m_ctrlHelpProjectList.SetSelectionMark(nItem);

    if (m_mapIniFiles[m_strProjectName].ReadFile())
    {
        // Attempt to add the files for the subproject to the tree control.
        int nNumFileTitles = m_mapIniFiles[m_strProjectName].GetNumValues("FILE_TITLES");
        int nFile = 0;
        strSubProjectPath = strSubProjectPath.Left(strSubProjectPath.Find(m_strProjectName)); 
        while (nFile < nNumFileTitles)
        {
            CString strFileTitle = m_mapIniFiles[m_strProjectName].GetValuePair("FILE_TITLES", nFile);
            CString strFilePath;

            if (strFileTitle.Find("=") > -1)
            {
                strFilePath = strSubProjectPath + "pages\\" + strFileTitle.Mid(strFileTitle.Find("=") + 1);
                strFileTitle = strFileTitle.Left(strFileTitle.Find("="));
            }

            nItem = m_ctrlHelpProjectList.InsertItem(nItem + 1, "          " + strFileTitle);
            nFile++;

            m_mapHelpFiles[m_strProjectName][strFileTitle].m_stlStrTitle   = (LPCTSTR)strFileTitle;
            m_mapHelpFiles[m_strProjectName][strFileTitle].m_stlStrProject = (LPCTSTR)m_strProjectName;
            m_mapHelpFiles[m_strProjectName][strFileTitle].m_stlStrFilename = (LPCTSTR)strFilePath; 
            m_mapHelpFiles[m_strProjectName][strFileTitle].ReadFile();
        }
    }
    else
    {
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Compatibility",    "1.1");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Compiled file",    "..\\" + m_strProjectName + ".chm");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Contents file",    m_strProjectName + ".hhc");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Default Window",   "Main");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Default topic",    " ");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Display compile progress", "No");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Full-text search", "Yes");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Index file",            m_strProjectName + ".hhk");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Language",         "0x409 English (United States)");
        m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Title",            m_strProjectName);

        m_mapIniFiles[m_strProjectName].SetValue("WINDOWS", "Main",             "\"" + m_strProjectName + "\",\"" +
                                                                                m_strProjectName + ".hhc\",\"" +
                                                                                m_strProjectName + ".hhk\",,,,,,,0x2520,,0x3006,,,,,0,,,");
    }

    m_strPageTitle = "";
    m_strPageFilename = "";
    m_strSectionName = "";
    m_strSectionText = "";
    m_strRelatedTopicName = "";

    m_ctrlRelatedTopicsListBox.ResetContent();
    m_ctrlSectionsListBox.ResetContent();

    UpdateData(FALSE);

    m_mapIniFiles["Main"].SetValue("MERGE FILES", m_strProjectName + ".chm", "");
}

void CHelpEditor::OnChangeProject() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject())
    {
        return;
    }

    int nItem = m_ctrlHelpProjectList.GetSelectionMark();
    
    if (nItem != -1)
    {
        CString strSel = m_ctrlHelpProjectList.GetItemText(nItem, 0);
        if (strSel[0] != ' ')
        {
            if (m_mapIniFiles.find(strSel) != m_mapIniFiles.end())
            {
                m_mapIniFiles.erase(m_mapIniFiles.find(strSel));
            }
            m_mapIniFiles["Main"].DeleteValue("MERGE FILES", strSel + ".chm");
            m_ctrlHelpProjectList.SetItemText(nItem, 0, m_strProjectName);
            m_mapIniFiles["Main"].SetValue("MERGE FILES", m_strProjectName + ".chm", "");

            // Delete all pages for project
            if (m_mapHelpFiles.find(strSel) != m_mapHelpFiles.end())
            {
                m_mapHelpFiles.erase(m_mapHelpFiles.find(strSel));
            }

            CString strSubProjectPath(m_strMainFile);
            strSubProjectPath.MakeReverse();
            if (strSubProjectPath.Find("\\") > -1)
            {
                strSubProjectPath = strSubProjectPath.Mid(strSubProjectPath.Find("\\") + 1);
            }
            strSubProjectPath.MakeReverse();
            strSubProjectPath += "\\" + m_strProjectName;
    
            CreateDirectory(strSubProjectPath, NULL);
    
            strSubProjectPath += "\\" + m_strProjectName + ".hhp";

            m_mapIniFiles[m_strProjectName].SetPath(strSubProjectPath);
            m_mapIniFiles[m_strProjectName].Reset();

            if (m_mapIniFiles[m_strProjectName].ReadFile())
            {
                // Attempt to add the files for the subproject to the tree control.
                int nNumFileTitles = m_mapIniFiles[m_strProjectName].GetNumValues("FILE_TITLES");
                int nFile = 0;
                strSubProjectPath = strSubProjectPath.Left(strSubProjectPath.Find(m_strProjectName)); 
                while (nFile < nNumFileTitles)
                {
                    CString strFileTitle = m_mapIniFiles[m_strProjectName].GetValuePair("FILE_TITLES", nFile);
                    CString strFilePath;

                    if (strFileTitle.Find("=") > -1)
                    {
                        strFilePath = strSubProjectPath + "pages\\" + strFileTitle.Mid(strFileTitle.Find("=") + 1);
                        strFileTitle = strFileTitle.Left(strFileTitle.Find("="));
                    }

                    nItem = m_ctrlHelpProjectList.InsertItem(nItem + 1, "          " + strFileTitle);
                    nFile++;

                    m_mapHelpFiles[m_strProjectName][strFileTitle].m_stlStrTitle   = (LPCTSTR)strFileTitle;
                    m_mapHelpFiles[m_strProjectName][strFileTitle].m_stlStrProject = (LPCTSTR)m_strProjectName;
                    m_mapHelpFiles[m_strProjectName][strFileTitle].m_stlStrFilename = (LPCTSTR)strFilePath; 
                    m_mapHelpFiles[m_strProjectName][strFileTitle].ReadFile();
                }
            }
            else
            {
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Compatibility",    "1.1");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Compiled file",    "..\\" + m_strProjectName + ".chm");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Contents file",    m_strProjectName + ".hhc");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Default Window",   "Main");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Default topic",    " ");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Display compile progress", "No");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Full-text search", "Yes");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Index file",            m_strProjectName + ".hhk");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Language",         "0x409 English (United States)");
                m_mapIniFiles[m_strProjectName].SetValue("OPTIONS", "Title",            m_strProjectName);

                m_mapIniFiles[m_strProjectName].SetValue("WINDOWS", "Main",             "\"" + m_strProjectName + "\",\"" +
                                                                                        m_strProjectName + ".hhc\",\"" +
                                                                                        m_strProjectName + ".hhk\",,,,,,,0x2520,,0x3006,,,,,0,,,");
            }

            m_strPageTitle = "";
            m_strPageFilename = "";
            m_strSectionName = "";
            m_strSectionText = "";
            m_strRelatedTopicName = "";

            m_ctrlRelatedTopicsListBox.ResetContent();
            m_ctrlSectionsListBox.ResetContent();

            UpdateData(FALSE);
        }
        else
        {
            AfxMessageBox("Selection in list is not a project.");
        }
    }
    else
    {
        AfxMessageBox("No currect project to change.");
    }
}

void CHelpEditor::OnDeleteProject() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject())
    {
        return;
    }

    LVFINDINFO lvfi;
    lvfi.flags = LVFI_STRING;
    lvfi.psz   = (LPCTSTR)m_strProjectName;

    int nItem = m_ctrlHelpProjectList.FindItem(&lvfi);
    
    if (nItem != -1)
    {
        m_mapIniFiles["Main"].DeleteValue("MERGE FILES", m_strProjectName + ".chm");
        int n = m_ctrlHelpProjectList.GetNextItem(nItem, LVNI_BELOW);

        while (n != -1)
        {
            if (m_ctrlHelpProjectList.GetItemText(n, 0)[0] == ' ')
            {
                m_ctrlHelpProjectList.DeleteItem(n);
                n = m_ctrlHelpProjectList.GetNextItem(nItem, LVNI_BELOW);
            }
            else
            {
                n = -1;
            }
        }

        if (m_mapIniFiles.find(m_strProjectName) != m_mapIniFiles.end())
        {
            m_mapIniFiles.erase(m_mapIniFiles.find(m_strProjectName));
        }

        if (m_mapHelpFiles.find(m_strProjectName) != m_mapHelpFiles.end())
        {
            m_mapHelpFiles.erase(m_mapHelpFiles.find(m_strProjectName));
        }

        m_ctrlHelpProjectList.DeleteItem(nItem);

        m_strPageTitle = "";
        m_strPageFilename = "";
        m_strSectionName = "";
        m_strSectionText = "";
        m_strRelatedTopicName = "";

        m_ctrlRelatedTopicsListBox.ResetContent();
        m_ctrlSectionsListBox.ResetContent();

        UpdateData(FALSE);
    }
    else
    {
        AfxMessageBox("Project could not be found to delete.");
    }
}

void CHelpEditor::OnAddPage() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    LVFINDINFO lvfi;
    lvfi.flags = LVFI_STRING;
    lvfi.psz   = (LPCTSTR)m_strProjectName;

    int nItem = m_ctrlHelpProjectList.FindItem(&lvfi);
    
    if (nItem != -1)
    {
        m_mapIniFiles[m_strProjectName].SetValue("FILES", m_strPageFilename, "");
        m_mapIniFiles[m_strProjectName].SetValue("FILE_TITLES", m_strPageTitle, m_strPageFilename);
        m_mapIniFiles["Main"].SetValue("FILES", "pages\\" + m_strPageFilename, "");
        m_ctrlHelpProjectList.InsertItem(nItem + 1, "          " + m_strPageTitle);
        m_ctrlHelpProjectList.SetSelectionMark(nItem + 1);

        CString strPath(m_strMainFile);
        strPath.MakeReverse();
        if (strPath.Find("\\") > -1)
        {
            strPath= strPath.Mid(strPath.Find("\\") + 1);
        }
        strPath.MakeReverse();
        strPath += "\\pages\\" + m_strPageFilename;

        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_stlStrFilename   = (LPCTSTR)strPath;
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_stlStrProject    = (LPCTSTR)m_strProjectName;
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_stlStrTitle      = (LPCTSTR)m_strPageTitle;
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].ReadFile();

        m_strSectionName = "";
        m_strSectionText = "";
        m_strRelatedTopicName = "";

        m_ctrlRelatedTopicsListBox.ResetContent();
        m_ctrlSectionsListBox.ResetContent();

        UpdateData(FALSE);
    }
    else
    {
        AfxMessageBox("Project could not be found to add page.");
    }
}

void CHelpEditor::OnChangePage() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    int nItem = m_ctrlHelpProjectList.GetSelectionMark();
    
    if (nItem != -1)
    {
        CString strSel = m_ctrlHelpProjectList.GetItemText(nItem, 0);
        if (strSel[0] == ' ')
        {
            if (m_mapIniFiles.find(m_strProjectName) != m_mapIniFiles.end())
            {
                strSel.TrimLeft(" ");

                if (m_mapHelpFiles[m_strProjectName].find(strSel) != m_mapHelpFiles[m_strProjectName].end())
                {
                    m_mapHelpFiles[m_strProjectName].erase(m_mapHelpFiles[m_strProjectName].find(strSel));
                }

                CString strFile = m_mapIniFiles[m_strProjectName].GetValue("FILE_TITLES", strSel);
                m_mapIniFiles[m_strProjectName].DeleteValue("FILE_TITLES", strSel);
                m_mapIniFiles[m_strProjectName].DeleteValue("FILES", strFile);
                m_mapIniFiles["Main"].DeleteValue("FILES", strFile);

                m_ctrlHelpProjectList.SetItemText(nItem, 0, "          " + m_strPageTitle);
                m_mapIniFiles[m_strProjectName].SetValue("FILES", m_strPageFilename, "");
                m_mapIniFiles[m_strProjectName].SetValue("FILE_TITLES", m_strPageTitle, m_strPageFilename);
                m_mapIniFiles["Main"].SetValue("FILES", "pages\\" + m_strPageFilename, "");

                CString strPath(m_strMainFile);
                strPath.MakeReverse();
                if (strPath.Find("\\") > -1)
                {
                    strPath= strPath.Mid(strPath.Find("\\") + 1);
                }
                strPath.MakeReverse();
                strPath += "\\pages\\" + m_strPageFilename;

                m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_stlStrFilename   = (LPCTSTR)strPath;
                m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_stlStrProject    = (LPCTSTR)m_strProjectName;
                m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_stlStrTitle      = (LPCTSTR)m_strPageTitle;
                m_mapHelpFiles[m_strProjectName][m_strPageTitle].ReadFile();

                m_strSectionName = "";
                m_strSectionText = "";
                m_strRelatedTopicName = "";

                m_ctrlRelatedTopicsListBox.ResetContent();
                m_ctrlSectionsListBox.ResetContent();

                UpdateData(FALSE);
            }
            else
            {
                AfxMessageBox("Project is not valid.");
            }
        }
        else
        {
            AfxMessageBox("Selection in list is not a page.");
        }
    }
    else
    {
        AfxMessageBox("No currect page to change.");
    }
}

void CHelpEditor::OnDeletePage() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    LVFINDINFO lvfi;
    lvfi.flags = LVFI_STRING;
    CString str = "          " + m_strPageTitle;
    lvfi.psz   = (LPCTSTR)str;

    int nItem = m_ctrlHelpProjectList.FindItem(&lvfi);
    
    if (nItem != -1)
    {
        if (m_mapIniFiles.find(m_strProjectName) != m_mapIniFiles.end())
        {
            CString strFile = m_mapIniFiles[m_strProjectName].GetValue("FILE_TITLES", m_strPageTitle);
            m_mapIniFiles[m_strProjectName].DeleteValue("FILE_TITLES", m_strPageTitle);
            m_mapIniFiles[m_strProjectName].DeleteValue("FILES", strFile);

            m_ctrlHelpProjectList.DeleteItem(nItem);

            if (m_mapHelpFiles[m_strProjectName].find(m_strPageTitle) != m_mapHelpFiles[m_strProjectName].end())
            {
                m_mapHelpFiles[m_strProjectName].erase(m_mapHelpFiles[m_strProjectName].find(m_strPageTitle));
            }

            m_strSectionName = "";
            m_strSectionText = "";
            m_strRelatedTopicName = "";

            m_ctrlRelatedTopicsListBox.ResetContent();
            m_ctrlSectionsListBox.ResetContent();

            UpdateData(FALSE);
        }
        else
        {
            AfxMessageBox("Project is not valid.");
        }
    }
    else
    {
        AfxMessageBox("Page could not be found to delete.");
    }
}

void CHelpEditor::OnAddSection() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    if (m_strSectionName == "")
    {
        AfxMessageBox("Please enter a Section Name.");
        return;
    }

    if (m_strSectionText == "")
    {
        AfxMessageBox("Please enter text for the section.");
        return;
    }

    int nIndex = m_ctrlSectionsListBox.FindString(-1, m_strSectionName);
    if (nIndex == LB_ERR)
    {
        m_ctrlSectionsListBox.AddString(m_strSectionName);
        m_strSectionText.Replace("\r\r\n","<br>");
        m_strSectionText.Replace("\r\n","<br>");

        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.push_back(m_strSectionName);
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData[m_strSectionName] = m_strSectionText;
    }
    else
    {
        AfxMessageBox("Section cannot be added: duplicate section.");
    }
}

void CHelpEditor::OnChangeSection() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    if (m_strSectionName == "")
    {
        AfxMessageBox("Please enter a Section Name.");
        return;
    }

    if (m_strSectionText == "")
    {
        AfxMessageBox("Please enter text for the section.");
        return;
    }

    int nIndex = m_ctrlSectionsListBox.GetCurSel();
    if (nIndex != LB_ERR)
    {
        // See about removing the selected topic
        CString strSection;
        m_ctrlSectionsListBox.GetText(nIndex, strSection);
        _FSI_STL::list<CString>::iterator lIt = 
            _FSI_STL::find(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.begin(),
                           m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.end(),
                           strSection);
        if (lIt !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.erase(lIt);
        }

        if (m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.find(strSection) !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.erase(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.find(strSection));
        }

        m_ctrlSectionsListBox.DeleteString(nIndex);
        m_ctrlSectionsListBox.AddString(m_strSectionName);
        m_strSectionText.Replace("\r\r\n","<br>");
        m_strSectionText.Replace("\r\n","<br>");

        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.push_back(m_strSectionName);
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData[m_strSectionName] = m_strSectionText;
    }
    else
    {
        AfxMessageBox("No current selection to change.");
    }
}

void CHelpEditor::OnDeleteSection() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    if (m_strSectionName == "")
    {
        AfxMessageBox("Please enter a Section Name.");
        return;
    }

    int nIndex = m_ctrlSectionsListBox.FindString(-1, m_strSectionName);
    if (nIndex != LB_ERR)
    {
        // See about removing the selected section
        _FSI_STL::list<CString>::iterator lIt = 
            _FSI_STL::find(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.begin(),
                           m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.end(),
                           m_strSectionName);

        if (lIt !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listSections.erase(lIt);
        }

        if (m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.find(m_strSectionName) !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.erase(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.find(m_strSectionName));
        }

        m_ctrlSectionsListBox.DeleteString(nIndex);
    }
    else
    {
        AfxMessageBox("Section can not be found to delete.");
    }
}

void CHelpEditor::OnAddTopic() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    if (m_strRelatedTopicName == "")
    {
        AfxMessageBox("Please enter a Related Topic.");
        return;
    }

    int nIndex = m_ctrlRelatedTopicsListBox.FindString(-1, m_strRelatedTopicName);
    if (nIndex == LB_ERR)
    {
        m_ctrlRelatedTopicsListBox.AddString(m_strRelatedTopicName);
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.push_back(m_strRelatedTopicName);
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData[m_strRelatedTopicName] = 
                            m_mapHelpFiles[m_strProjectName][m_strRelatedTopicName].m_stlStrFilename.c_str();
    }
    else
    {
        AfxMessageBox("Topic cannot be added: duplicate topic.");
    }
}

void CHelpEditor::OnChangeTopic() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    if (m_strRelatedTopicName == "")
    {
        AfxMessageBox("Please enter a Related Topic.");
        return;
    }

    int nIndex = m_ctrlRelatedTopicsListBox.GetCurSel();
    if (nIndex != LB_ERR)
    {
        // See about removing the selected topic
        CString strTopic;
        m_ctrlRelatedTopicsListBox.GetText(nIndex, strTopic);
        _FSI_STL::list<CString>::iterator lIt = 
            _FSI_STL::find(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.begin(),
                           m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.end(),
                           strTopic);

        if (lIt !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.erase(lIt);
        }

        if (m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.find(strTopic) !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.erase(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.find(strTopic));
        }

        m_ctrlRelatedTopicsListBox.DeleteString(nIndex);
        m_ctrlRelatedTopicsListBox.AddString(m_strRelatedTopicName);

        // Put in the new topic
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.push_back(m_strRelatedTopicName);
        m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData[m_strRelatedTopicName] = 
                            m_mapHelpFiles[m_strProjectName][m_strRelatedTopicName].m_stlStrFilename.c_str();
    }
    else
    {
        AfxMessageBox("No current selection to change.");
    }
}

void CHelpEditor::OnDeleteTopic() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    if (m_strRelatedTopicName == "")
    {
        AfxMessageBox("Please enter a Related Topic.");
        return;
    }

    int nIndex = m_ctrlRelatedTopicsListBox.FindString(-1, m_strRelatedTopicName);
    if (nIndex != LB_ERR)
    {
        // See about removing the selected topic
        _FSI_STL::list<CString>::iterator lIt = 
            _FSI_STL::find(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.begin(),
                           m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.end(),
                           m_strRelatedTopicName);
        if (lIt !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_listRelatedTopics.erase(lIt);
        }

        if (m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.find(m_strRelatedTopicName) !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.end())
        {
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.erase(m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapRelatedTopicsData.find(m_strRelatedTopicName));
        }

        m_ctrlRelatedTopicsListBox.DeleteString(nIndex);
    }
    else
    {
        AfxMessageBox("Topic can not be found to delete.");
    }
}

void CHelpEditor::PostNcDestroy() 
{
	CDialog::PostNcDestroy();

    // For modeless, delete the instance.
    delete this;
}

BOOL CHelpEditor::Create() 
{
	return CDialog::Create(IDD);
}

void CHelpEditor::OnCancel() 
{
    DestroyWindow();
}

void CHelpEditor::OnOK() 
{
}

void CHelpEditor::OnClose() 
{
    DestroyWindow();
}

void CHelpEditor::OnDestroy() 
{
    if (m_pFrame != NULL)
    {
        m_pFrame->m_pHelpEditor = NULL;
    }

	CDialog::OnDestroy();
}

void CHelpEditor::MainFrame(const CMainFrame* pFrame)
{
    m_pFrame = const_cast<CMainFrame*>(pFrame);
}

BOOL CHelpEditor::OnInitDialog() 
{
	CDialog::OnInitDialog();

    m_ctrlHelpProjectList.InsertColumn(0, "Projects and Topics", LVCFMT_LEFT, 235);
	
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHelpEditor::OnClickHelpProjects(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;

    UpdateData(TRUE);

    int nItem = m_ctrlHelpProjectList.GetSelectionMark();
    if (nItem != -1)
    {
        m_strHelpProjectSelection = m_ctrlHelpProjectList.GetItemText(nItem, 0);
        m_strHelpProjectSelection.TrimLeft(" ");

        if (m_mapIniFiles.find(m_strHelpProjectSelection) != m_mapIniFiles.end())
        {
	        m_strSectionText = _T("");
	        m_strSectionName = _T("");
	        m_strRelatedTopicName = _T("");
	        m_strPageTitle = _T("");
	        m_strPageFilename = _T("");

            m_ctrlRelatedTopicsListBox.ResetContent();
            m_ctrlSectionsListBox.ResetContent();

            m_strProjectName = m_strHelpProjectSelection;
            UpdateData(FALSE);
        }
        else
        {
            if (m_mapIniFiles.find(m_strProjectName) != m_mapIniFiles.end())
            {
	            m_strSectionText = _T("");
	            m_strSectionName = _T("");
	            m_strRelatedTopicName = _T("");

                m_ctrlRelatedTopicsListBox.ResetContent();
                m_ctrlSectionsListBox.ResetContent();

                m_strPageTitle    = m_strHelpProjectSelection;
                m_strPageFilename = m_mapIniFiles[m_strProjectName].GetValue("FILE_TITLES",m_strPageTitle);

                if (m_mapHelpFiles.find(m_strProjectName) != m_mapHelpFiles.end())
                {
                    if (m_mapHelpFiles[m_strProjectName].find(m_strPageTitle) != m_mapHelpFiles[m_strProjectName].end())
                    {
                        CHelpFile& HelpFile = m_mapHelpFiles[m_strProjectName][m_strPageTitle];
                        _FSI_STL::list<CString>::iterator lIt   = HelpFile.m_listSections.begin();
                        _FSI_STL::list<CString>::iterator lendIt = HelpFile.m_listSections.end();

                        while (lIt != lendIt)
                        {
                            m_ctrlSectionsListBox.AddString((*lIt));
                            lIt++;
                        }

                        lIt   = HelpFile.m_listRelatedTopics.begin();
                        lendIt = HelpFile.m_listRelatedTopics.end();

                        while (lIt != lendIt)
                        {
                            m_ctrlRelatedTopicsListBox.AddString((*lIt));
                            lIt++;
                        }
                    }
                }

                UpdateData(FALSE);
            }
            else
            {
                AfxMessageBox("Project name is not valid.");
            }
        }
    }
    else
    {
        m_strHelpProjectSelection = "";
    }
}

void CHelpEditor::OnSelchangePageRelatedTopics() 
{
    UpdateData(TRUE);

    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    int nIndex = m_ctrlRelatedTopicsListBox.GetCurSel();
    if (nIndex != LB_ERR)
    {
        CString strTopic;
        m_ctrlRelatedTopicsListBox.GetText(nIndex, strTopic);
        m_strRelatedTopicName = strTopic;
        UpdateData(FALSE);
    }
}

void CHelpEditor::OnSelchangePageSections() 
{
    UpdateData(TRUE);
    if (!ValidateMainFile()     ||
        !ValidateProject()      ||
        !ValidatePageFilename() ||
        !ValidatePageTitle())
    {
        return;
    }

    int nIndex = m_ctrlSectionsListBox.GetCurSel();
    if (nIndex != LB_ERR)
    {
        CString strSection;
        m_ctrlSectionsListBox.GetText(nIndex, strSection);
        m_strSectionName = strSection;
        if (m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.find(strSection) !=
            m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData.end())
        {
            m_strSectionText = m_mapHelpFiles[m_strProjectName][m_strPageTitle].m_mapSectionData[strSection];
            m_strSectionText.Replace("<br>", "\r\n");
            UpdateData(FALSE);
        }
    }
}
