// GlobalFontPage.cpp : implementation file
//

#include "..\core\stdafx.h"


#include "..\core\BasePage.h"
#include "..\core\Color.h"
#include "..\core\ColorPage.h"
#include "..\core\Widget.h"

#include <map>
#include <string>

#include "resource.h"

#include "GlobalFontPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGlobalFontPage dialog


CGlobalFontPage::CGlobalFontPage() : CBasePage(CGlobalFontPage::IDD)
{
	//{{AFX_DATA_INIT(CGlobalFontPage)
	m_strAlias = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Global Fonts");

    m_strName = "Arial";
    m_strSize = "14";
    m_strStyle = "Regular";
    m_strOffset = "0";

    CWindowDC dc(GetDesktopWindow() );

	m_lPixelsPerInch = GetDeviceCaps(dc, LOGPIXELSY);	
	CFont *pfont = dc.GetCurrentFont();		
    pfont->GetLogFont( &m_logfont );
    
    m_font.CreateFontIndirect( &m_logfont );
}

CGlobalFontPage::~CGlobalFontPage()
{
}


void CGlobalFontPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGlobalFontPage)
	DDX_Control(pDX, IDC_GLOBAL_SHADOW_OFFSET_COMBO, m_comboOffset);
	DDX_Text(pDX, IDC_FONT_ALIAS, m_strAlias);
	DDX_Control(pDX, IDC_CHANGE_GLOBAL_FONT, m_wndFontChange);
	DDX_Control(pDX, IDC_FONT_LIST, m_ctrlFontList);
	DDX_Control(pDX, IDC_SAMPLE_FONT, m_staticSample);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGlobalFontPage, CBasePage)
	//{{AFX_MSG_MAP(CGlobalFontPage)
	ON_BN_CLICKED(IDC_CHANGE_GLOBAL_FONT, OnChangeGlobalFont)
	ON_NOTIFY(NM_CLICK, IDC_FONT_LIST, OnClickFontList)
	ON_BN_CLICKED(IDC_ADD_FONT_ALIAS_BUTTON, OnAddAlias)
	ON_BN_CLICKED(IDC_CHANGE_FONT_ALIAS_BUTTON, OnChangeAlias)
	ON_BN_CLICKED(IDC_DELETE_FONT_ALIAS_BUTTON, OnDeleteAlias)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGlobalFontPage message handlers
CBasePage* CGlobalFontPage::CreateObject()
{
    return new CGlobalFontPage;
}

void CGlobalFontPage::SetProperties(void* pWidget)
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        long int lGlobalFontCount = 0;
        long int lGlobalFontStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("GlobalFontCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lGlobalFontCount = ulData;

        CString strGlobalFontXXX;
        CString strGlobalFontData;
        CString strGlobalFontName;

        for (; lGlobalFontStep <= lGlobalFontCount; lGlobalFontStep++)
        {
            strGlobalFontXXX.Format("GlobalFont%d",lGlobalFontStep);

            // Get the name of the GlobalFont.
		    CString strValue;
		    DWORD dwType, dwCount;
		    LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontXXX, 
                                          NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            strGlobalFontName = strValue;

            // Get the DATA for the GlobalFont
            if (strGlobalFontName != "")
            {
                // Code copied from GetProfileString() in CWinApp 
                // implementation.
		        lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontName, 
                                               NULL, &dwType, NULL, &dwCount);
		        if (lResult == ERROR_SUCCESS)
		        {
			        ASSERT(dwType == REG_SZ);
			        lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalFontName, 
                                              NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                              &dwCount);

			        strValue.ReleaseBuffer();
		        }

                strGlobalFontData = strValue;

                m_mapParameters[(LPCTSTR)strGlobalFontName] = 
                                        _FSI_STL::string((LPCTSTR)strGlobalFontData);
            }

        }

        RegCloseKey(hKey);
    }
}

void CGlobalFontPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"),
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);
        long int lGlobalFontCount = m_ctrlFontList.GetItemCount();
        long int lGlobalFontStep = 0;
        unsigned long int ulData = lGlobalFontCount;
        DWORD dwSize = sizeof (unsigned long int);
        RegSetValueEx(hKey, _T("GlobalFontCount"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        CString strGlobalFontXXX;
        CString strGlobalFontData;
        CString strGlobalFontName;

        for (; lGlobalFontStep < lGlobalFontCount; lGlobalFontStep++)
        {
            strGlobalFontXXX.Format("GlobalFont%d",lGlobalFontStep+1);
            strGlobalFontName = m_ctrlFontList.GetItemText(lGlobalFontStep,0);

            RegSetValueEx(hKey, (LPCTSTR)strGlobalFontXXX, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strGlobalFontName, 
                            strGlobalFontName.GetLength() + 1);

            strGlobalFontData = m_ctrlFontList.GetItemText(lGlobalFontStep,1);

            RegSetValueEx(hKey, (LPCTSTR)strGlobalFontName, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strGlobalFontData, 
                            strGlobalFontData.GetLength() + 1);
        }

        RegCloseKey(hKey);
    }
}

BOOL CGlobalFontPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    m_ctrlFontList.SetExtendedStyle(m_ctrlFontList.GetExtendedStyle() & 
                                         LVS_EX_FULLROWSELECT);

    m_ctrlFontList.InsertColumn(0,"Parameter", LVCFMT_LEFT, 100);
    m_ctrlFontList.InsertColumn(1, "Data", LVCFMT_LEFT, 170);
	
    STRING2STRING_MAP::iterator mIt = m_mapParameters.begin();
    long int lFontStep = 0;
    for (; mIt != m_mapParameters.end(); mIt++, lFontStep++)
    {
        m_ctrlFontList.InsertItem(lFontStep, (*mIt).first.c_str());
        m_ctrlFontList.SetItemText(lFontStep, 1, (*mIt).second.c_str());
    }

    m_comboOffset.SelectString(-1, "0");

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGlobalFontPage::OnChangeGlobalFont() 
{
    // get the current data
    POSITION pos = m_ctrlFontList.GetFirstSelectedItemPosition();
    long int lSelectedIndex = -1;
    CString strFontName = "";

    if (pos != NULL)
    {
        lSelectedIndex = m_ctrlFontList.GetNextSelectedItem(pos);
        strFontName = m_ctrlFontList.GetItemText(lSelectedIndex, 0);
        CString strFont = 
                        m_ctrlFontList.GetItemText(lSelectedIndex, 1);

        if (strFont.Find(",") > -1)
        {
            m_strName = strFont.Left(strFont.Find(","));
            m_strSize = strFont.Mid(strFont.Find(",") + 1);
            if (m_strSize.Find(",") > -1)
            {
                m_strStyle = m_strSize.Left(m_strSize.Find(",")); 
                m_strSize = m_strSize.Mid(m_strSize.Find(",") + 1);
                if (m_strSize.Find(",") > -1)
                {
                    m_strOffset = m_strSize.Mid(m_strSize.Find(",") + 1);
                    m_strSize = m_strSize.Left(m_strSize.Find(","));
                }
            }
            else
            {
                m_strSize = "8";
            }
        }

	    m_font.GetLogFont( &m_logfont );	
        m_logfont.lfStrikeOut = false;
	    m_logfont.lfUnderline = false;
        int nFaceLength = __min(LF_FACESIZE - 1, m_strName.GetLength());
	    strncpy( m_logfont.lfFaceName, m_strName, nFaceLength );
        m_logfont.lfFaceName[nFaceLength] = '\0';

	    m_logfont.lfHeight = -MulDiv(atoi(m_strSize), m_lPixelsPerInch, 72);	 
	    m_logfont.lfWidth = 0;			
	    m_logfont.lfWeight = 400;			
        //Regular	
        m_logfont.lfItalic = FALSE;
	    if( m_strStyle.Find( _T("Italic") ) != -1 )		
        {
            m_logfont.lfItalic = TRUE;
        }

	    if( m_strStyle.Find( _T("Bold") ) != -1 )		
        {
            m_logfont.lfWeight = 700;
        }
    }
    else 
    {
	    m_font.GetLogFont( &m_logfont );	
    }

    CFontDialog    fd(&m_logfont, 
                      CF_SCREENFONTS | CF_NOSCRIPTSEL, 
                      NULL, 
                      this);

    if (fd.DoModal() == IDOK)
    {
	    m_font.DeleteObject();	
        m_font.CreateFontIndirect( &(fd.m_lf) );
 	    m_staticSample.SetFont(&m_font);	

        if (fd.m_lf.lfItalic > 0)
        {
            if (fd.m_lf.lfWeight == 700)
            {
                m_strStyle = "Bold Italic";
            }
            else
            {
                m_strStyle = "Italic";
            }
        }
        else if (fd.m_lf.lfWeight == 700)
        {
            m_strStyle = "Bold";
        }
        else
        {
            m_strStyle = "Regular";
        }

        m_strName = fd.GetFaceName();
        m_strSize.Format("%d",fd.GetSize()/10);
    }
}

void CGlobalFontPage::OnClickFontList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);
    POSITION pos = m_ctrlFontList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlFontList.GetNextSelectedItem(pos);
        CString strFontName = m_ctrlFontList.GetItemText(lSelectedIndex, 0);

        m_strAlias = strFontName; 

        CString strFont = 
                        m_ctrlFontList.GetItemText(lSelectedIndex, 1);

        if (strFont.Find(",") > -1)
        {
            m_strName = strFont.Left(strFont.Find(","));
            m_strSize = strFont.Mid(strFont.Find(",") + 1);
            if (m_strSize.Find(",") > -1)
            {
                m_strStyle = m_strSize.Left(m_strSize.Find(","));
                m_strSize = m_strSize.Mid(m_strSize.Find(",") + 1);
                if (m_strSize.Find(",") > -1)
                {
                    m_strOffset = m_strSize.Mid(m_strSize.Find(",") + 1);
                    m_strSize = m_strSize.Left(m_strSize.Find(","));
                }
            }
            else
            {
                m_strSize = "8";
            }
        }

	    m_font.GetLogFont( &m_logfont );	
        m_logfont.lfStrikeOut = false;
	    m_logfont.lfUnderline = false;
        int nFaceLength = __min(LF_FACESIZE - 1, m_strName.GetLength());
	    strncpy( m_logfont.lfFaceName, m_strName, nFaceLength );
        m_logfont.lfFaceName[nFaceLength] = '\0';

	    m_logfont.lfHeight = -MulDiv(atoi(m_strSize), m_lPixelsPerInch, 72);	 
	    m_logfont.lfWidth = 0;			
	    m_logfont.lfWeight = 400;			
        //Regular	
        m_logfont.lfItalic = FALSE;
	    if( m_strStyle.Find( _T("Italic") ) != -1 )		
        {
            m_logfont.lfItalic = TRUE;
        }

	    if( m_strStyle.Find( _T("Bold") ) != -1 )		
        {
            m_logfont.lfWeight = 700;
        }

	    m_font.DeleteObject();	
        m_font.CreateFontIndirect( &m_logfont );
  	    m_staticSample.SetFont(&m_font);	

        m_comboOffset.SelectString(-1, m_strOffset);
        UpdateData(FALSE);
    }

	
	*pResult = 0;
}

void CGlobalFontPage::OnAddAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);
    
    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        if (m_ctrlFontList.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_ctrlFontList.GetItemCount();
            lItemCount = m_ctrlFontList.InsertItem(lItemCount, 
													(LPCTSTR)m_strAlias);

            CString strValue;

            if (m_comboOffset.GetCurSel() == CB_ERR)
            {
                m_strOffset = "0";
            }
            else
            {
                m_comboOffset.GetLBText(m_comboOffset.GetCurSel(), 
                                        m_strOffset);
            }

            strValue.Format("%s,%s,%s,%s",m_strName, 
                                          m_strStyle, 
                                          m_strSize,
                                          m_strOffset);


            m_ctrlFontList.SetItemText(lItemCount, 1, strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Duplicate string encountered for alias name."),
                         _T("Error"), 
                         MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CGlobalFontPage::OnChangeAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        long int lFontIndex = m_ctrlFontList.FindItem(&lvfi,-1);
        if (lFontIndex > -1)
        {
            CString strValue;

            if (m_comboOffset.GetCurSel() == CB_ERR)
            {
                m_strOffset = "0";
            }
            else
            {
                m_comboOffset.GetLBText(m_comboOffset.GetCurSel(), 
                                        m_strOffset);
            }

            strValue.Format("%s,%s,%s,%s",m_strName, 
                                          m_strStyle, 
                                          m_strSize,
                                          m_strOffset);

            m_ctrlFontList.SetItemText(lFontIndex, 1, strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Alias name could not be found to change font data."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CGlobalFontPage::OnDeleteAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        long int lFontIndex = m_ctrlFontList.FindItem(&lvfi,-1);
        if (lFontIndex > -1)
        {
            m_ctrlFontList.DeleteItem(lFontIndex);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Alias name could not be found to delete alias "
                            "and font data."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}
