// GlobalColorPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "..\core\BasePage.h"
#include "..\core\Color.h"
#include "..\core\ColorPage.h"
#include "..\core\Widget.h"

#include <map>
#include <string>

#include "resource.h"

#include "GlobalColorPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGlobalColorPage dialog


CGlobalColorPage::CGlobalColorPage() : CBasePage(CGlobalColorPage::IDD)
{
	//{{AFX_DATA_INIT(CGlobalColorPage)
	m_strAlias = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Global Colors");
}

CGlobalColorPage::~CGlobalColorPage()
{
}


void CGlobalColorPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGlobalColorPage)
	DDX_Control(pDX, IDC_CHANGE_GLOBAL_COLOR, m_wndColorChange);
	DDX_Control(pDX, IDC_COLOR_LIST, m_ctrlColorList);
	DDX_Text(pDX, IDC_COLOR_ALIAS, m_strAlias);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGlobalColorPage, CBasePage)
	//{{AFX_MSG_MAP(CGlobalColorPage)
	ON_BN_CLICKED(IDC_CHANGE_GLOBAL_COLOR, OnChangeGlobalColor)
	ON_NOTIFY(NM_CLICK, IDC_COLOR_LIST, OnClickColorList)
	ON_BN_CLICKED(IDC_ADD_COLOR_ALIAS_BUTTON, OnAddAlias)
	ON_BN_CLICKED(IDC_CHANGE_COLOR_ALIAS_BUTTON, OnChangeAlias)
	ON_BN_CLICKED(IDC_DELETE_COLOR_ALIAS_BUTTON, OnDeleteAlias)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGlobalColorPage message handlers
CBasePage* CGlobalColorPage::CreateObject()
{
    return new CGlobalColorPage;
}

void CGlobalColorPage::SetProperties(void* pWidget)
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        long int lGlobalColorCount = 0;
        long int lGlobalColorStep = 1;
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("GlobalColorCount"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        lGlobalColorCount = ulData;

        CString strGlobalColorXXX;
        CString strGlobalColorRGB;
        CString strGlobalColorName;

        for (; lGlobalColorStep <= lGlobalColorCount; lGlobalColorStep++)
        {
            strGlobalColorXXX.Format("GlobalColor%d",lGlobalColorStep);

            // Get the name of the GlobalColor.
		    CString strValue;
		    DWORD dwType, dwCount;
		    LONG lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalColorXXX, 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalColorXXX, 
                                          NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }

            strGlobalColorName = strValue;

            // Get the RGB for the GlobalColor
            if (strGlobalColorName != "")
            {
                // Code copied from GetProfileString() in CWinApp 
                // implementation.
		        lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalColorName, 
                                               NULL, &dwType, NULL, &dwCount);
		        if (lResult == ERROR_SUCCESS)
		        {
			        ASSERT(dwType == REG_SZ);
			        lResult = RegQueryValueEx(hKey, (LPCTSTR)strGlobalColorName, 
                                              NULL, &dwType,
				             (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                              &dwCount);

			        strValue.ReleaseBuffer();
		        }

                strGlobalColorRGB = strValue;

                m_mapParameters[(LPCTSTR)strGlobalColorName] = 
                                        _FSI_STL::string((LPCTSTR)strGlobalColorRGB);
            }

        }

        RegCloseKey(hKey);
    }
}

void CGlobalColorPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"),
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);
        long int lGlobalColorCount = m_ctrlColorList.GetItemCount();
        long int lGlobalColorStep = 0;
        unsigned long int ulData = lGlobalColorCount;
        DWORD dwSize = sizeof (unsigned long int);
        RegSetValueEx(hKey, _T("GlobalColorCount"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        CString strGlobalColorXXX;
        CString strGlobalColorRGB;
        CString strGlobalColorName;

        for (; lGlobalColorStep < lGlobalColorCount; lGlobalColorStep++)
        {
            strGlobalColorXXX.Format("GlobalColor%d",lGlobalColorStep+1);
            strGlobalColorName = m_ctrlColorList.GetItemText(lGlobalColorStep,0);

            RegSetValueEx(hKey, (LPCTSTR)strGlobalColorXXX, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strGlobalColorName, 
                            strGlobalColorName.GetLength() + 1);

            strGlobalColorRGB = m_ctrlColorList.GetItemText(lGlobalColorStep,1);

            RegSetValueEx(hKey, (LPCTSTR)strGlobalColorName, NULL, REG_SZ, 
                            (BYTE*)(LPCTSTR)strGlobalColorRGB, 
                            strGlobalColorRGB.GetLength() + 1);
        }

        RegCloseKey(hKey);
    }
}

BOOL CGlobalColorPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    m_ctrlColorList.SetExtendedStyle(m_ctrlColorList.GetExtendedStyle() & 
                                         LVS_EX_FULLROWSELECT);

    m_ctrlColorList.InsertColumn(0,"Parameter", LVCFMT_LEFT, 100);
    m_ctrlColorList.InsertColumn(1, "Data", LVCFMT_LEFT, 170);
	
	// TODO: Add extra initialization here
    m_colorStatic.SubclassDlgItem(IDC_GLOBAL_COLOR,this);
    m_colorStatic.Color(m_color);

    STRING2STRING_MAP::iterator mIt = m_mapParameters.begin();
    long int lColorStep = 0;
    for (; mIt != m_mapParameters.end(); mIt++, lColorStep++)
    {
        m_ctrlColorList.InsertItem(lColorStep, (*mIt).first.c_str());
        m_ctrlColorList.SetItemText(lColorStep, 1, (*mIt).second.c_str());
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CGlobalColorPage::OnChangeGlobalColor() 
{
    // get the current data
    POSITION pos = m_ctrlColorList.GetFirstSelectedItemPosition();
    long int lSelectedIndex = -1;
    CString strColorName = "";

    // If found, then reset m_color to the data for the parameter.
    if (pos != NULL)
    {
        
        lSelectedIndex = m_ctrlColorList.GetNextSelectedItem(pos);
        strColorName = m_ctrlColorList.GetItemText(lSelectedIndex, 0);
        CString strColor = 
                        m_ctrlColorList.GetItemText(lSelectedIndex, 1);

        CString str = "";
        if (strColor.Find(",") > -1)
        {
            str = strColor.Mid(strColor.Find(",") + 1);
            strColor.Format("%03s",strColor.Left(strColor.Find(",")));
        }
        if (str.Find(",") > -1)
        {
            strColor.Format("%s%03s%03s", strColor, str.Left(str.Find(",")),
                                          str.Mid(str.Find(",") + 1));
        }

        if (strColor != "")
        {
            m_color = CColor(strColor);
        }
        else
        {
            m_color = CColor();
        }
    }
    else 
    {
        m_color = CColor();
    }

    CColorDialog    cd((COLORREF)m_color,0,this);

    if (cd.DoModal() == IDOK)
    {
        // Change the color.
        m_color = CColor(cd.GetColor());
        m_colorStatic.Color(m_color);
        m_colorStatic.Invalidate();
    }
}

void CGlobalColorPage::OnClickColorList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);
    POSITION pos = m_ctrlColorList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlColorList.GetNextSelectedItem(pos);
        CString strColorName = m_ctrlColorList.GetItemText(lSelectedIndex, 0);


        m_strAlias = strColorName; 

        CString strColor = 
                        m_ctrlColorList.GetItemText(lSelectedIndex, 1);

        CString str = "";
        if (strColor.Find(",") > -1)
        {
            str = strColor.Mid(strColor.Find(",") + 1);
            strColor.Format("%03s",strColor.Left(strColor.Find(",")));
        }
        if (str.Find(",") > -1)
        {
            strColor.Format("%s%03s%03s", strColor, str.Left(str.Find(",")),
                                          str.Mid(str.Find(",") + 1));
        }

        if (strColor != "")
        {
            m_color = CColor(strColor);
        }
        else
        {
            m_color = CColor();
        }
        m_colorStatic.Color(m_color);
        m_colorStatic.Invalidate();

        UpdateData(FALSE);
    }

	
	*pResult = 0;
}

void CGlobalColorPage::OnAddAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);
    
    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        if (m_ctrlColorList.FindItem(&lvfi,-1) == -1)
        {
            long int lItemCount = m_ctrlColorList.GetItemCount();
            lItemCount = m_ctrlColorList.InsertItem(lItemCount, 
													(LPCTSTR)m_strAlias);
            CString strValue;
            strValue.Format("%d,%d,%d",m_color.Red(), 
                                         m_color.Green(), 
                                         m_color.Blue());

            m_ctrlColorList.SetItemText(lItemCount, 1, strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Duplicate string encountered for alias name."),
                         _T("Error"), 
                         MB_OK);
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CGlobalColorPage::OnChangeAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        long int lColorIndex = m_ctrlColorList.FindItem(&lvfi,-1);
        if (lColorIndex > -1)
        {
            CString strValue;
            strValue.Format("%d,%d,%d",m_color.Red(), 
                                         m_color.Green(), 
                                         m_color.Blue());

            m_ctrlColorList.SetItemText(lColorIndex, 1, strValue);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Alias name could not be found to change color data."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}

void CGlobalColorPage::OnDeleteAlias() 
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);

    if (m_strAlias.GetLength() > 0)
    {
        LVFINDINFO lvfi;
        lvfi.flags = LVFI_STRING;
        lvfi.psz = (LPCTSTR)m_strAlias;
        long int lColorIndex = m_ctrlColorList.FindItem(&lvfi,-1);
        if (lColorIndex > -1)
        {
            m_ctrlColorList.DeleteItem(lColorIndex);
        }
        else
        {
            ::MessageBox(GetSafeHwnd(), 
                         _T("Alias name could not be found to delete alias "
                            "and color data."),
                         _T("Error"), 
                         MB_OK);
            return;
        }
    }
    else
    {
        ::MessageBox(GetSafeHwnd(),
                     _T("Null string encountered for alias name."),
                     _T("Error"),
                     MB_OK);
    }
}
