// FSISuiteWinThread.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "fsisuite.h"
#include "mainfrm.h"
#include "FSISuiteDoc.h"
#include "FSISuiteWinThread.h"
#include "FSISuiteView.h"

#include "Options.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteWinThread

IMPLEMENT_DYNCREATE(CFSISuiteWinThread, CWinThread)

CFSISuiteWinThread::CFSISuiteWinThread()
{
    m_pDocTemplate = NULL;
	m_prectSize = NULL;
}

CFSISuiteWinThread::~CFSISuiteWinThread()
{
    delete m_pDocTemplate;
	delete m_prectSize;
}

BOOL CFSISuiteWinThread::InitInstance()
{
    CFSISuiteDocTemplate* pTemplate = new CFSISuiteDocTemplate();
    m_pDocTemplate = pTemplate;
    CFSISuiteDoc* pDoc = dynamic_cast<CFSISuiteDoc*>(pTemplate->OpenDocumentFile(NULL));
    m_pMainWnd = pTemplate->m_pFrame;

    if (pDoc != NULL)
    {
        pTemplate->InitialUpdateFrame(pTemplate->m_pFrame, pDoc, TRUE);

        CWinApp* pApp = AfxGetApp();

        pDoc->OnScreenView((CFSISuiteView*)((CMainFrame*)m_pMainWnd)->GetActiveView());
        pDoc->UseScale(((CFSISuiteApp *)pApp)->FSI_GetProfileInt(_T("Settings"), _T("UseScale"), 0));

        CMainFrame* pFrame = dynamic_cast<CMainFrame*>(m_pMainWnd);
        if (pFrame != NULL)
        {
           pFrame->HelpFile(_FSI_STL::string(((CFSISuiteApp *)(LPCTSTR)pApp)->FSI_GetProfileString(_T("Settings"), 
                                                                        _T("HelpFile"), 
                                                                        NULL)));
        }
    }

    m_evMessage.SetEvent();

	return TRUE;
}

int CFSISuiteWinThread::ExitInstance()
{
	// TODO:  perform any per-thread cleanup here
	return CWinThread::ExitInstance();
}

BEGIN_MESSAGE_MAP(CFSISuiteWinThread, CWinThread)
	//{{AFX_MSG_MAP(CFSISuiteWinThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteWinThread message handlers
BOOL CFSISuiteWinThread::PreTranslateMessage(MSG* pMsg) 
{
    if (pMsg->message == TM_LOAD_COMPONENT)
    {
        CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
        CMainFrame* pFrame = (CMainFrame*)(m_pMainWnd);
        CFSISuiteDoc* pDoc = (CFSISuiteDoc*)(pFrame->GetActiveDocument());

        CXMLPage* pXMLPage = pDoc->XMLPage();
        if (pXMLPage != NULL) 
        {
            STRING_LIST::iterator slIt = pApp->m_listAvailableWidgets.begin();
            for (; slIt != pApp->m_listAvailableWidgets.end(); slIt++)
            {
                pXMLPage->AddAvailableWidget(*slIt);
            }
            slIt = pApp->m_listAvailableActions.begin();
            for (; slIt != pApp->m_listAvailableActions.end(); slIt++)
            {
                pXMLPage->AddAvailableWidget(*slIt);
            }
        }

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_DELETE_COMPONENT)
    {
        CMainFrame* pFrame = (CMainFrame*)(m_pMainWnd);
        CComponentInterface* pCI = (CComponentInterface*)(pMsg->lParam);

        CEditorControls* pEC = pFrame->EditorControls();
        pEC->DeleteTab(CString(pCI->ComponentName().c_str()));

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_LOAD_CONFIG_COMPONENT)
    {
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
        CComponentInterface* pCI = (CComponentInterface*)(pMsg->lParam);

        pFrame->AddComponent(pCI->ComponentName());

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_LOAD_CONFIG_EDIT)
    {
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
        CComponentInterface* pCI = (CComponentInterface*)(pMsg->lParam);

        CEditorControls* pEC = pFrame->EditorControls();
        pEC->AddTab(pCI);

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_OPEN_DOCUMENT)
    {
        CString* pstr = (CString*)pMsg->lParam;
        if (pstr == NULL)
        {
            pMsg->wParam = (long)m_pDocTemplate->OpenDocumentFile((LPCTSTR)(pMsg->lParam));
        }
        else
        {
            pMsg->wParam = (long)m_pDocTemplate->OpenDocumentFile((LPCTSTR)(*pstr));
        }
        delete pstr;

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_DELETE_COMPONENT_SPECIFIC)
    {
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;

        pFrame->DeleteComponentSpecific();
        pFrame->NullComponent();

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_DELETE_COMPONENT_GROUP)
    {
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
        CComponentInterface* pCI = (CComponentInterface*)(pMsg->lParam);

        pFrame->DeleteComponent(pCI->ComponentName());

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_OPTIONS_CLICK)
    {
        // Send a message to the main frame to simulate a click on the
        // component button that was last clicked.  This will refresh the
        // component specific bar
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;

        CString strLastComponent(pFrame->LastComponent().c_str());

        pFrame->SendMessage(WM_COMMAND, pFrame->LastComponentID(), 0);

//        CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();

        // Reload the last page.

        if (pFrame->m_pDlgOptions != NULL)
        {
            pFrame->m_pDlgOptions->SendMessage(WM_NOTIFY_CHANGE, 0, 0);
        }

        m_evMessage.SetEvent();

        return TRUE;
    }
    else if (pMsg->message == TM_START_AS)
    {
        CString* pstr = (CString*)pMsg->lParam;
        ((CMainFrame*)m_pMainWnd)->StartAs(*pstr);
        delete pstr;

        m_evMessage.SetEvent();

        return TRUE;
    }
    else
    {
        return CWinThread::PreTranslateMessage(pMsg);
    }
}
