/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FSISuiteView.h
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.7 $
//
// Description      : FSISuiteView.h contains the definition of the 
//                    CFSISuiteView class. CFSISuiteView is used to 
//                    display most of the content as specified by the
//                    XML files.  CFSISuiteView is also responsible for
//                    printing the entire application window and working
//                    with the print preview window.  CFSISuiteView sets
//                    up the OpenGL rendering context(s) and tells all 
//                    of the child windows that need to redraw to redraw 
//                    themselves.  Overlays that are not persistant and
//                    thus are attached to the view are also managed.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::list, Core::COverlayDlg.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FSISuiteView.h $                                                                   
// Revision 1.7  2000/03/31 22:55:58  billyb                                                                   
// Removed unused code.  Added check for when to erase the                                                                   
// background.                                                                    
// Revision 1.6  2000/03/07 20:32:46  billyb                                                                   
// Removed usage of wglShareLists.                                                                   
// Revision 1.5  2000/02/08 20:28:50  billyb                                                                   
// Changed overlay message handlers to normal methods.                                                                   
// Revision 1.4  2000/01/27 22:20:17  billyb                                                                   
// Added test code for multithreaded drawing.  Made CUpdateList                                                                   
// a parent.                                                                   
// Revision 1.3  1999/11/28 22:48:47  billyb                                                                   
// Removed m_hWnd member since it is in CWnd.                                                                   
// Revision 1.2  1999/11/28 22:35:42  billyb                                                                   
// Added comments.  Made constructor public.  Add                                                                    
// SetRenderContext for use with a two view double buffer system.                                                                   
// Added member variables for the HWND and the locked status.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_FSISUITEVIEW_H_)
#define _FSISUITEVIEW_H_

#include "..\core\UpdateList.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class COverlayDlg;

class CFSISuiteView : public CView, public CUpdateList
{
private:
    HBITMAP                             m_hbm;
    HGLRC                               m_hRC;
    HDC                                 m_hDC;

    CPoint                              m_ptStartSelection;
    CRect                               m_rectSelection;

    _FSI_STL::list<COverlayDlg*>        m_listOverlays;

    bool                                m_bAllowEraseBkgnd;
    bool                                m_bStartPreview;

    bool                                m_bWindows7;

    static _FSI_STL::map<HWND, BOOL>    m_mapLocked;
    static _FSI_STL::map<HWND, CCriticalSection*> m_mapSyncDrawing;

protected: // create from serialization only
	DECLARE_DYNCREATE(CFSISuiteView)
    BOOL DoFSIPrintPreview(UINT nIDResource, CView* pPrintView,
	                       CRuntimeClass* pPreviewViewClass, 
                           CPrintPreviewState* pState);

// Attributes
public:
	CFSISuiteView();
	CFSISuiteDoc* GetDocument();

// Operations
private:
    BOOL        InitializeOpenGL();
    BOOL        SetupPixelFormat();

public:
    void        DestroyOverlays();
    void        PreventRedraw();
    void        AllowRedraw();
    void        SetRenderingContext();
	void        AddOverlay(const COverlayDlg* pOverlayDlg);
    void        RemoveOverlay(const COverlayDlg* pOverlayDlg);
    void        AllowEraseBkgnd(bool bAllow);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFSISuiteView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrintPreview(CDC* pDC, CPrintInfo* pInfo, POINT point, CPreviewView* pView);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CFSISuiteView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CFSISuiteView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnFilePrint();
    afx_msg void OnFilePrintPreview();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	//}}AFX_MSG

    LPARAM OnUpdateScreen(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in FSISuiteView.cpp
inline CFSISuiteDoc* CFSISuiteView::GetDocument()
   { return (CFSISuiteDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_FSISUITEVIEW_H_)
