/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FSISuiteView.cpp
//
// Date             : 28 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.16 $
//
// Description      : FSISuiteView.cpp contains the implementation of the 
//                    CFSISuiteView class. CFSISuiteView is used to 
//                    display most of the content as specified by the
//                    XML files.  CFSISuiteView is also responsible for
//                    printing the entire application window and working
//                    with the print preview window.  CFSISuiteView sets
//                    up the OpenGL rendering context(s) and tells all 
//                    of the child windows that need to redraw to redraw 
//                    themselves.  Overlays that are not persistant and
//                    thus are attached to the view are also managed.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::list, Core::COverlayDlg.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FSISuiteView.cpp $                                                                   
// Revision 1.16  2000/04/07 05:30:24  billyb                                                                   
// Added support for better FPS displays in comms stats.                                                                   
// Added changing background color to white in printouts.                                                                   
// Revision 1.15  2000/03/31 22:58:44  billyb                                                                   
// Removed unused code.  Added checks for when to erase                                                                   
// the background.  Made sure to clean up resusable widgets                                                                   
// when the view is destroyed.  Made update list usage more                                                                   
// thread safe.                                                                   
// Revision 1.14  2000/03/07 20:32:37  billyb                                                                   
// Removed usage of wglShareLists.                                                                   
// Revision 1.13  2000/03/07 01:00:48  billyb                                                                   
// Removed/commented out unused variables.  Eliminated                                                                   
// warnings with casts.                                                                   
// Revision 1.12  2000/02/08 20:29:35  billyb                                                                   
// Removed overlay message map entries.  Changed overlay                                                                   
// message handlers to normal methods.                                                                   
// Revision 1.11  2000/02/04 10:02:04  billyb                                                                   
// Corrected RegisterClass problem in PreCreateWindow.                                                                   
// Changed an Invalidate to RedrawWindow with all children                                                                   
// in OnLButtonUp to fix OpenGL widget not redrawing in the                                                                   
// editor.  Uncommented some code in OnDestroy for cleanup.                                                                   
// Revision 1.10  2000/01/27 22:23:13  billyb                                                                   
// Added test code for mutithreaded drawing.  Made the view                                                                   
// have the CS_OWNDC class style so that it would keep                                                                   
// a single DC around.  Restored code for making the background                                                                   
// the correct color.  Added SetRenderingContext for the double                                                                   
// buffered views.                                                                   
// Revision 1.9  1999/11/29 06:49:15  billyb                                                                   
// Changed placement of call to CUpdateList::Cleanup to make                                                                   
// sure that m_hWnd was still valid.                                                                   
// Revision 1.8  1999/11/28 22:52:55  billyb                                                                   
// Added comments.  Initialized member variables.  Added cleanup                                                                   
// of update list to destructor.  Removed wglMakeCurrent code from                                                                   
// OnDraw (will now be in document).   Added SetRenderingContext.                                                                   
// Changes to work with double buffered views and and CUpdateList.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include <gl/gl.h>
#include <gl/glu.h>
#include "FSISuite.h"
#include "MainFrm.h"

#include "FSISuiteDoc.h"
#include "FSISuiteView.h"
#include "FSISuitePreviewView.h"

#include "..\core\OverlayDlg.h"
#include "..\core\OpenGLText.h"
#include "..\core\UpdateList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const LPCTSTR MYCLASSNAME = _T("FSISuiteView");

_FSI_STL::map<HWND, BOOL>               CFSISuiteView::m_mapLocked;
_FSI_STL::map<HWND, CCriticalSection*>  CFSISuiteView::m_mapSyncDrawing;

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteView

IMPLEMENT_DYNCREATE(CFSISuiteView, CView)

BEGIN_MESSAGE_MAP(CFSISuiteView, CView)
	//{{AFX_MSG_MAP(CFSISuiteView)
	ON_WM_LBUTTONDOWN()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_FILE_PRINT, OnFilePrint)
	ON_WM_RBUTTONUP()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT_DIRECT, OnFilePrint)
    ON_COMMAND(ID_FILE_PRINT_PREVIEW, OnFilePrintPreview)
    ON_MESSAGE(WM_UPDATE_SCREEN, OnUpdateScreen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteView construction/destruction

CFSISuiteView::CFSISuiteView() : m_hRC(0)
{
    m_hbm               = NULL;
    m_hRC               = NULL;
    m_bStartPreview     = false;
    m_hDC               = NULL;
    m_bAllowEraseBkgnd  = true;

    OSVERSIONINFO osv;
    osv.dwOSVersionInfoSize = sizeof osv;

    GetVersionEx(&osv);
    m_bWindows7 = (osv.dwMajorVersion > 5);
}

CFSISuiteView::~CFSISuiteView()
{
}

BOOL CFSISuiteView::PreCreateWindow(CREATESTRUCT& cs)
{
    cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

	if (CView::PreCreateWindow(cs))
    {
        static bool bRegistered = false;

        if (bRegistered == false)
        {
            WNDCLASSEX wc;
            wc.cbSize = sizeof(WNDCLASSEX);

            GetClassInfoEx(AfxGetInstanceHandle(), cs.lpszClass, &wc);

            wc.lpszClassName = MYCLASSNAME;
            wc.style |= CS_OWNDC | CS_HREDRAW | CS_VREDRAW;

            VERIFY(RegisterClassEx(&wc));
            bRegistered = true;
        }

        cs.lpszClass = MYCLASSNAME;
        return TRUE;
    }

    return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteView drawing

void CFSISuiteView::OnDraw(CDC* pDC)
{
	CFSISuiteDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

    if (pDC->IsKindOf(RUNTIME_CLASS(CPreviewDC)))
    {
        m_bStartPreview = true;
        OnBeginPrinting(pDC,NULL);
        m_bStartPreview = false;
        return;
    }

    CRect rectClientArea;
    GetClientRect(rectClientArea);

    if (pDoc->EditMode() == true)
    {
        if (pDoc->GridOn() == true)
        {
            unsigned long int ulGridXStep = 0;
            unsigned long int ulGridYStep = 0;

            for (; ulGridXStep*pDoc->GridX() <= rectClientArea.right; 
                   ulGridXStep++)
            {
	            pDC->MoveTo(rectClientArea.left+ulGridXStep*pDoc->GridX(), 
                            rectClientArea.top);
	            pDC->LineTo(rectClientArea.left+ulGridXStep*pDoc->GridX(), 
                            rectClientArea.bottom);
            }

            for (; ulGridYStep*pDoc->GridY() <= rectClientArea.bottom; 
                   ulGridYStep++)
            {
	            pDC->MoveTo(rectClientArea.left, 
                            rectClientArea.top+ulGridYStep*pDoc->GridY());
	            pDC->LineTo(rectClientArea.right, 
                            rectClientArea.top+ulGridYStep*pDoc->GridY());
            }
        }
    }

    CWidget::ScreenRedrawing(GetSafeHwnd(), false);
}

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteView printing

BOOL CFSISuiteView::OnPreparePrinting(CPrintInfo* pInfo)
{
	return DoPreparePrinting(pInfo);
}

void CFSISuiteView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
    HDC     hdcPrinter;
    int     iWidth;
    int     iHeight;
    DOCINFO di;
    DIBSECTION ds;

    // Get a HDC for the default printer.
    hdcPrinter = pDC->GetSafeHdc();//GetPrinterDC();       
 
    if (!hdcPrinter)
        return; //FALSE;       


    // Get the time for the printout
    CFont fontTime;
    struct tm* sTime;
    time_t now;
    time(&now);
    sTime=localtime(&now);

    char cTimeFormat[32];
    strftime(cTimeFormat, 32, "%#d %b %Y %X", sTime);
    cTimeFormat[31] = '\0';

    // Get the resolution of the printer device.
    iWidth  = GetDeviceCaps(hdcPrinter, HORZRES);
    iHeight = GetDeviceCaps(hdcPrinter, VERTRES);

    // Prepare the DOCINFO.
    ZeroMemory(&di, sizeof(di));       
   
    di.cbSize = sizeof(di);
    di.lpszDocName = "Window Contents";       

    m_hbm = ((CMainFrame*)GetParentFrame())->PrintScreen();
    BITMAP bm;
    GetObject(m_hbm, sizeof(BITMAP), (LPSTR)&bm);

    // Retrieve the information describing the surface.
    GetObject(m_hbm, sizeof(DIBSECTION), &ds);

    // Remove background color from the bitmap.

    CColor White(255,255,255);
    CColor Black(0,0,0);
    CColor SpecialBlack(1,1,1);

    CColor SpecialWhite(254,254,254);
    
    CColor MessageLogBackgroundColor(CColor::GlobalColor("Message Logging Background"));
    CColor BackgroundColor(CColor::GlobalColor("Background Color"));
    CColor IndexBackgroundColor(CColor::GlobalColor("Index Background Color"));

    CColor colorBackground = GetDocument()->PageColor();

    CColor currentColor;
    
    unsigned char *pBits = (unsigned char*)ds.dsBm.bmBits;
    for (int byteStep = 0; byteStep < ds.dsBm.bmWidthBytes * ds.dsBm.bmHeight; byteStep+=3)
        // The main frame creates this as a 24-bit bitmap, therefore the byteStep+=3
    {
       //CColor currentColor((unsigned char)pBits[2],(unsigned char)pBits[1],(unsigned char)pBits[0]);
       currentColor.Red  (pBits[2]);
       currentColor.Green(pBits[1]);
       currentColor.Blue (pBits[0]);

       if (currentColor == MessageLogBackgroundColor  ||
           currentColor == BackgroundColor            ||
           currentColor == IndexBackgroundColor       ||
           currentColor == SpecialBlack )
       {
            pBits[0] = White.Blue();
            pBits[1] = White.Green();
            pBits[2] = White.Red();
       }
       else if (currentColor == SpecialWhite )
       {
            pBits[0] = Black.Blue();
            pBits[1] = Black.Green();
            pBits[2] = Black.Red();
       }

        // First, flip black to white and white to black
        /*
        if (currentColor == Black)
        {
            pBits[0] = White.Blue();
            pBits[1] = White.Green();
            pBits[2] = White.Red();

        }
        else if (currentColor == White )
        {
            pBits[0] = Black.Blue();
            pBits[1] = Black.Green();
            pBits[2] = Black.Red();
        }
          */
        // Now, flip the background to white, also
       /*
        if (currentColor == colorBackground)
        {
            pBits[0] = White.Blue();
            pBits[1] = White.Green();
            pBits[2] = White.Red();
        }
        */
        pBits += 3;
    }

    if (pDC->IsKindOf(RUNTIME_CLASS(CPreviewDC)) && m_bStartPreview == true)
    {
        pDC->SaveDC();
        pDC->SetMapMode(MM_ISOTROPIC);
        CSize sz = pDC->GetViewportExt();

        CRect rectWindow;
        GetParentFrame()->GetWindowRect(&rectWindow);
        iWidth  = rectWindow.Width();
        iHeight = rectWindow.Height();

        // This must be done otherwise, the image will not display correctly.  
        pDC->SetWindowOrg(0,0);
        pDC->SetWindowExt(bm.bmWidth,bm.bmHeight);
        pDC->SetViewportOrg(0,0);
        pDC->SetViewportExt(iWidth, iHeight);

        int nFontHeight = MulDiv(8, -pDC->GetDeviceCaps(LOGPIXELSY), 72);

        // Print the contents of the surface.
        StretchDIBits(hdcPrinter,
                      0, -nFontHeight + 10, sz.cx, -1*sz.cy - (-nFontHeight + 10),
                      0, 0, bm.bmWidth, bm.bmHeight,
                      ds.dsBm.bmBits,
                      (LPBITMAPINFO)&ds.dsBmih,
                      DIB_RGB_COLORS,
                      SRCCOPY);

        fontTime.CreateFont(nFontHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0, 
                            ANSI_CHARSET, OUT_STROKE_PRECIS, 
                            CLIP_STROKE_PRECIS, DRAFT_QUALITY, 
                            VARIABLE_PITCH | FF_SWISS, _T("Arial"));

        pDC->SelectObject(&fontTime);
        pDC->SetBkMode(TRANSPARENT);
        pDC->SetTextAlign(TA_CENTER);
        pDC->TextOut(sz.cx/2, 5, cTimeFormat);

        pDC->RestoreDC(-1);

        // Clean up the objects you created.       
        DeleteDC(hdcPrinter);
    }
    else if (pDC->IsKindOf(RUNTIME_CLASS(CPreviewDC)) == false)
    {
        // Initialize the print job.
        if (StartDoc(hdcPrinter, &di) > 0) 
        {           
            // Prepare to send a page.
            if (StartPage(hdcPrinter) > 0) 
            {
                // Print the contents of the surface.
                int nFontHeight = MulDiv(8, -pDC->GetDeviceCaps(LOGPIXELSY), 72);

                StretchDIBits(hdcPrinter,
                              0, -nFontHeight + 10, iWidth, iHeight - (-nFontHeight + 10),
                              0, 0, bm.bmWidth, bm.bmHeight,
                              ds.dsBm.bmBits,
                              (LPBITMAPINFO)&ds.dsBmih,
                              DIB_RGB_COLORS,
                              SRCCOPY);

                fontTime.CreateFont(nFontHeight, 0, 0, 0, FW_NORMAL, 0, 0, 0, 
                                    ANSI_CHARSET, OUT_STROKE_PRECIS, 
                                    CLIP_STROKE_PRECIS, DRAFT_QUALITY, 
                                    VARIABLE_PITCH | FF_SWISS, _T("Arial"));

                pDC->SaveDC();

                pDC->SelectObject(&fontTime);
                pDC->SetBkMode(TRANSPARENT);
                pDC->SetTextAlign(TA_CENTER);
                pDC->TextOut(iWidth/2, 5, cTimeFormat);

                pDC->RestoreDC(-1);

                // Let the driver know the page is done.
                EndPage(hdcPrinter);           
            }

            // Let the driver know the document is done.
            EndDoc(hdcPrinter);       
        }

        // Clean up the objects you created.       
        DeleteDC(hdcPrinter);
    }
}

void CFSISuiteView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
    DeleteObject(m_hbm);  

    ((CMainFrame*)GetParentFrame())->PrintScreen(NULL);
}

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteView diagnostics

#ifdef _DEBUG
void CFSISuiteView::AssertValid() const
{
	CView::AssertValid();
}

void CFSISuiteView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFSISuiteDoc* CFSISuiteView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFSISuiteDoc)));
	return (CFSISuiteDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteView message handlers

void CFSISuiteView::OnLButtonDown(UINT nFlags, CPoint point) 
{
    if (GetDocument()->EditMode() == true)
    {
        m_ptStartSelection = point;
        SetCapture();
    }

	CView::OnLButtonDown(nFlags, point);
}

BOOL CFSISuiteView::OnEraseBkgnd(CDC* pDC) 
{
    if (true == m_bAllowEraseBkgnd)
    {
        CRect r;
        GetClientRect(r);

        CFSISuiteDoc* pDoc = GetDocument();
        ASSERT_VALID(pDoc);

        pDC->FillSolidRect(r, (COLORREF)pDoc->PageColor());
    }

	return TRUE; //CView::OnEraseBkgnd(pDC);
}

void CFSISuiteView::OnFilePrint() 
{
	// get default print info
	CPrintInfo printInfo;
	ASSERT(printInfo.m_pPD != NULL);    // must be set

    CMainFrame* pFrame = (CMainFrame*)GetParentFrame();

    delete printInfo.m_pPD;
    printInfo.m_pPD = new CPrintDialog(FALSE, PD_ALLPAGES | PD_USEDEVMODECOPIES |
		PD_NOSELECTION, pFrame);

    pFrame->CreateBitmap();
	if (LOWORD(GetCurrentMessage()->wParam) == ID_FILE_PRINT_DIRECT)
	{
		CCommandLineInfo* pCmdInfo = AfxGetApp()->m_pCmdInfo;
  
		if (pCmdInfo != NULL)
		{
			if (pCmdInfo->m_nShellCommand == CCommandLineInfo::FilePrintTo)
			{
				printInfo.m_pPD->m_pd.hDC = ::CreateDC(pCmdInfo->m_strDriverName,
					pCmdInfo->m_strPrinterName, pCmdInfo->m_strPortName, NULL);
				if (printInfo.m_pPD->m_pd.hDC == NULL)
				{
                    ::MessageBox(m_hWnd,
                                 _T("Could not start print job."),
                                 _T("Error"),
                                 MB_OK);
					return;
				}
			}
		}

		printInfo.m_bDirect = TRUE;
	}

	if (OnPreparePrinting(&printInfo))
	{
		// hDC must be set (did you remember to call DoPreparePrinting?)
		ASSERT(printInfo.m_pPD->m_pd.hDC != NULL);

		// setup the printing DC
		CDC dcPrint;
		if (!printInfo.m_bDocObject)
		{
			dcPrint.Attach(printInfo.m_pPD->m_pd.hDC);  // attach printer dc
			dcPrint.m_bPrinting = TRUE;
		}

		OnBeginPrinting(&dcPrint, &printInfo);

		OnEndPrinting(&dcPrint, &printInfo);    // clean up after printing

		dcPrint.Detach();   // will be cleaned up by CPrintInfo destructor
	}

}

void CFSISuiteView::OnFilePrintPreview()
{
	// In derived classes, implement special window handling here
	// Be sure to Unhook Frame Window close if hooked.

	// must not create this on the frame.  Must outlive this function
	CPrintPreviewState* pState = new CPrintPreviewState;

	// DoPrintPreview's return value does not necessarily indicate that
	// Print preview succeeded or failed, but rather what actions are necessary
	// at this point.  If DoPrintPreview returns TRUE, it means that
	// OnEndPrintPreview will be (or has already been) called and the
	// pState structure will be/has been deleted.
	// If DoPrintPreview returns FALSE, it means that OnEndPrintPreview
	// WILL NOT be called and that cleanup, including deleting pState
	// must be done here.

	if (!DoFSIPrintPreview(AFX_IDD_PREVIEW_TOOLBAR, this,
							RUNTIME_CLASS(CFSISuitePreviewView), pState))
	{
		// In derived classes, reverse special window handling here for
		// Preview failure case

		TRACE0("Error: DoPrintPreview failed.\n");
		AfxMessageBox(AFX_IDP_COMMAND_FAILURE);
		delete pState;      // preview failed to initialize, delete State now
	}
}

BOOL CFSISuiteView::DoFSIPrintPreview(UINT nIDResource, CView* pPrintView,
	CRuntimeClass* pPreviewViewClass, CPrintPreviewState* pState)
{
	ASSERT_VALID_IDR(nIDResource);
	ASSERT_VALID(pPrintView);
	ASSERT(pPreviewViewClass != NULL);
	ASSERT(pPreviewViewClass->IsDerivedFrom(RUNTIME_CLASS(CFSISuitePreviewView)));
	ASSERT(pState != NULL);

	CFrameWnd* pParent = STATIC_DOWNCAST(CFrameWnd, GetParentFrame());
	ASSERT_VALID(pParent);

	CCreateContext context;
	context.m_pCurrentFrame = pParent;
	context.m_pCurrentDoc = GetDocument();
	context.m_pLastView = this;

	// Create the preview view object
	CFSISuitePreviewView* pView = (CFSISuitePreviewView*)pPreviewViewClass->CreateObject();
	if (pView == NULL)
	{
		TRACE0("Error: Failed to create preview view.\n");
		return FALSE;
	}
	ASSERT_KINDOF(CFSISuitePreviewView, pView);
	pView->m_pPreviewState = pState;        // save pointer

	pParent->OnSetPreviewMode(TRUE, pState);    // Take over Frame Window

	// Create the toolbar from the dialog resource
	pView->m_pToolBar = new CDialogBar;
	if (!pView->m_pToolBar->Create(pParent, MAKEINTRESOURCE(nIDResource),
		CBRS_TOP, AFX_IDW_PREVIEW_BAR))
	{
		TRACE0("Error: Preview could not create toolbar dialog.\n");
		pParent->OnSetPreviewMode(FALSE, pState);   // restore Frame Window
		delete pView->m_pToolBar;       // not autodestruct yet
		pView->m_pToolBar = NULL;
		pView->m_pPreviewState = NULL;  // do not delete state structure
		delete pView;
		return FALSE;
	}
	pView->m_pToolBar->m_bAutoDelete = TRUE;    // automatic cleanup

	// Create the preview view as a child of the App Main Window.  This
	// is a sibling of this view if this is an SDI app.  This is NOT a sibling
	// if this is an MDI app.

	if (!pView->Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0,0,0,0), pParent, AFX_IDW_PANE_FIRST, &context))
	{
		TRACE0("Error: couldn't create preview view for frame.\n");
		pParent->OnSetPreviewMode(FALSE, pState);   // restore Frame Window
		pView->m_pPreviewState = NULL;  // do not delete state structure
		delete pView;
		return FALSE;
	}

	// Preview window shown now

	pState->pViewActiveOld = pParent->GetActiveView();
	CFSISuiteView* pActiveView = 
                (CFSISuiteView*)(pParent->GetActiveFrame()->GetActiveView());

	if (pActiveView != NULL)
		pActiveView->OnActivateView(FALSE, pActiveView, pActiveView);

	if (!pView->SetPrintView(pPrintView))
	{
		pView->OnPreviewClose();
		return TRUE;            // signal that OnEndPrintPreview was called
	}

	pParent->SetActiveView(pView);  // set active view - even for MDI

	// update toolbar and redraw everything
	pView->m_pToolBar->SendMessage(WM_IDLEUPDATECMDUI, (WPARAM)TRUE);
	pParent->RecalcLayout();            // position and size everything
	pParent->UpdateWindow();

	return TRUE;
}

void CFSISuiteView::OnRButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)GetDocument();
    if (pDoc->EditMode() == true)
    {
        GetParentFrame()->PostMessage(WM_DISPLAY_WIDGET_PROPS, 
                                    (long)(pDoc->PageWidget()),
                                    (long)(pDoc->PageWidget()->BaseWidget()));
    }
	CView::OnRButtonUp(nFlags, point);
}

void CFSISuiteView::OnEndPrintPreview(CDC* pDC, CPrintInfo* pInfo, POINT point, CPreviewView* pView) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	ASSERT_VALID(pDC);
	ASSERT_VALID(pView);

    CFSISuitePreviewView* pFSIView = (CFSISuitePreviewView*)pView;
	if (pFSIView->m_pPrintView != NULL)
    {
		pFSIView->OnEndPrinting(pDC, pInfo);
    }

	CFrameWnd* pParent = STATIC_DOWNCAST(CFrameWnd, GetParentFrame());
	ASSERT_VALID(pParent);

	// restore the old main window
	pParent->OnSetPreviewMode(FALSE, pFSIView->m_pPreviewState);

	// Force active view back to old one
	pParent->SetActiveView(pFSIView->m_pPreviewState->pViewActiveOld);
	if (pParent != GetParentFrame())
		OnActivateView(TRUE, this, this);   // re-activate view in real frame
	pFSIView->DestroyWindow();     // destroy preview view
			// C++ object will be deleted in PostNcDestroy

	// restore main frame layout and idle message
	pParent->RecalcLayout();
	pParent->SendMessage(WM_SETMESSAGESTRING, (WPARAM)AFX_IDS_IDLEMESSAGE, 0L);
	pParent->UpdateWindow();
}

void CFSISuiteView::OnLButtonUp(UINT nFlags, CPoint point) 
{
    if (GetCapture() == this && GetDocument()->EditMode() == true)
    {
        ReleaseCapture();
        SetRenderingContext();
        RedrawWindow(NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW | RDW_ERASE | RDW_ALLCHILDREN); 
        m_rectSelection = CRect(-1, -1 , 0, 0);
    }

	CView::OnLButtonUp(nFlags, point);
}

void CFSISuiteView::OnMouseMove(UINT nFlags, CPoint point) 
{
    if (GetCapture() == this && GetDocument()->EditMode() == true)
    {
        CPoint ptUpperLeft;
        CPoint ptLowerRight;

        if (m_ptStartSelection != point)
        {
            if (m_ptStartSelection.x < point.x &&
                m_ptStartSelection.y < point.y)
            {
                ptUpperLeft = m_ptStartSelection;
                ptLowerRight = point;
            }
            else if (m_ptStartSelection.x < point.x &&
                     m_ptStartSelection.y > point.y)
            {
                ptUpperLeft = CPoint(m_ptStartSelection.x, point.y);
                ptLowerRight = CPoint(point.x, m_ptStartSelection.y);
            }
            else if (m_ptStartSelection.x > point.x &&
                     m_ptStartSelection.y > point.y)
            {
                ptUpperLeft = point;
                ptLowerRight = m_ptStartSelection;
            }
            else if (m_ptStartSelection.x > point.x &&
                     m_ptStartSelection.y < point.y)
            {
                ptUpperLeft = CPoint(point.x,m_ptStartSelection.y);
                ptLowerRight = CPoint(m_ptStartSelection.x,point.y);
            }

            // The following code is close to the ZCT editor code.
            CDC* pDC = GetDC();
            long int nSavedDC = pDC->SaveDC();
            pDC->SetROP2(R2_NOTXORPEN);

            // Get the view's background color and use it to 
            // create a color for the rubberband rectangle.  This
            // was done because some color made the rubberband
            // rectangle hard to see.
            CColor color = GetDocument()->PageColor();
            unsigned char ucColor = __min(color.Red(), color.Green());
            ucColor = __min(ucColor, color.Blue());
            if (ucColor == 255) 
            {
                // Special case for a white background.  The color
                // is set back to black for a white background.
                ucColor = 0;
            }
            CPen penDotted(PS_DOT, 0, RGB(ucColor, ucColor, ucColor));
            pDC->SelectObject(&penDotted);
            pDC->SelectStockObject(NULL_BRUSH);
            pDC->Rectangle(m_rectSelection);

            m_rectSelection = CRect(ptUpperLeft, ptLowerRight);
            pDC->Rectangle(m_rectSelection);
            pDC->RestoreDC(nSavedDC);
            ReleaseDC(pDC);
        }
    }

    if (GetDocument()->EditMode() == true)
    {
        CEditorTree* pTree = ((CMainFrame*)GetParent())->EditorTree();
        if (pTree != NULL)
        {
            pTree->UpdatePos(point);
        }
    }

	CView::OnMouseMove(nFlags, point);
}

int CFSISuiteView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;

    m_hDC = ::GetDC(m_hWnd);

    InitializeOpenGL();

    CMainFrame* pFrame = (CMainFrame*)GetParentFrame();
    if (m_hWnd != NULL && pFrame != NULL)
    {
        CString str;
        str.Format("View on screen %d.",pFrame->WindowNumber());
        m_mapUpdateWindowText[m_hWnd] = (LPCTSTR)str;
    }

	return 0;
}

BOOL CFSISuiteView::InitializeOpenGL()
{
    if (!SetupPixelFormat())
    {
        return FALSE;
    }

    if (0 == (m_hRC = wglCreateContext(m_hDC)))
    {
        return FALSE;
    }


    if (FALSE == wglMakeCurrent(m_hDC, m_hRC))
    {
        return FALSE;
    }

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);

    glEnable(GL_STENCIL_TEST);
    glClearStencil(1);
    glClear(GL_STENCIL_BUFFER_BIT);

    glEnableClientState(GL_VERTEX_ARRAY);
    glEnable(GL_SCISSOR_TEST);
    glDisable(GL_DITHER);

    glShadeModel(GL_FLAT);

    glClearColor(.5, .5, .5, 1.0);

    COpenGLtext::Initialize();

    return TRUE;
}

BOOL CFSISuiteView::SetupPixelFormat()
{
    PIXELFORMATDESCRIPTOR pfd =
    {
        sizeof(PIXELFORMATDESCRIPTOR),         // Size of this structure
        1,                                     // Version of this structure    
        PFD_DRAW_TO_WINDOW   |                 // Draw to Window (not to bitmap)
        PFD_SUPPORT_OPENGL   |                 // Support OpenGL calls in window
        PFD_SWAP_COPY        |
        PFD_DOUBLEBUFFER,                      // Double buffered
        PFD_TYPE_RGBA,                         // RGBA Color mode
        32,                                    // Want 24bit color 
        0,0,0,0,0,0,                           // Not used to select mode
        0,0,                                   // Not used to select mode
        0,0,0,0,0,                             // Not used to select mode
        24,                                     // Size of depth buffer
        8,                                     // Not used to select mode
        0,                                     // Not used to select mode
        PFD_MAIN_PLANE,                        // Draw in main plane
        0,                                     // Not used to select mode
        0,0,0                                  // Not used to select mode
    };

    int pixelformat;

    if (0 == (pixelformat = ChoosePixelFormat(m_hDC, &pfd)))
    {
        return FALSE;
    }

    if (FALSE == SetPixelFormat(m_hDC, pixelformat, &pfd))
    {
        return FALSE;
    }

    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteView::DestroyOverlays()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CFSISuiteView::DestroyOverlays() should be called 
//                    when the page changes to make sure that child 
//                    overlays of the view are destroyed.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteView::DestroyOverlays()
{
    _FSI_STL::list<COverlayDlg*>::iterator lIt = m_listOverlays.begin();

    while (lIt != m_listOverlays.end())
    {
        (*lIt)->DestroyWindow();

        // The iterator is removed as part of DestroyWindow.

        lIt = m_listOverlays.begin();
    }

    m_listOverlays.clear();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteView::AddOverlay()
//
// Inputs           : WPARAM wParam - not used
//                    LPARAM lParam - the address of an overlay to add
//
// Return Values    : None.
//
// Date             : 08 July 1999
//
// Engineer         : Billy Baker
//
// Description      : OnAddOverlay is a message handler for WM_ADD_OVERLAY.  
//                    When an overlay is created as a child of the view class, 
//                    it needs to be added to the list of overlays to destroy 
//                    when the page changes.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteView::AddOverlay(const COverlayDlg* pOverlayDlg)
{
    m_listOverlays.push_back(const_cast<COverlayDlg*>(pOverlayDlg));
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteView::RemoveOverlay()
//
// Inputs           : WPARAM wParam - not used.
//                    LPARAM lParam - address of an overlay to remove.
//
// Return Values    : None.
//
// Date             : 08 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CFSISuiteView::OnRemoveOverlay() is a message handler
//                    for the WM_REMOVE_OVERLAY message.  This message is
//                    sent when an overlay is closed using the OK, CANCEL,
//                    or CLOSE buttons.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteView::RemoveOverlay(const COverlayDlg* pOverlayDlg)
{
    m_listOverlays.remove(const_cast<COverlayDlg*>(pOverlayDlg));
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteView::OnDestroy()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CFSISuiteView::OnDestroy() is an override of the 
//                    base class method.  This is done to cleanup the 
//                    OpenGL rendering context and helper objects for 
//                    OpenGL rendering.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteView::OnDestroy() 
{
    CWidget::ScreenRedrawing(m_hWnd, true);

	CView::OnDestroy();

    wglMakeCurrent(0, 0);

    wglDeleteContext(m_hRC);

    COpenGLtext::Cleanup();

    CUpdateList::Cleanup(m_hWnd);

    if (m_mapSyncDrawing.find(m_hWnd) != m_mapSyncDrawing.end())
    {
        delete m_mapSyncDrawing[m_hWnd];

        m_mapSyncDrawing.erase(m_mapSyncDrawing.find(m_hWnd));
    }

    ::ReleaseDC(m_hWnd, m_hDC);

    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > >::iterator mIt      = NULL;
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > >::iterator mendIt   = NULL;
    _FSI_STL::list<CWidget*>::iterator lIt       = NULL;
    _FSI_STL::list<CWidget*>::iterator lendIt    = NULL;
    mIt         = CWidget::m_mapReusableWidgets.begin();
    mendIt      = CWidget::m_mapReusableWidgets.end();
    while (mIt != mendIt)
    {
        lIt     = ((*mIt).second)[m_hWnd].begin();
        lendIt  = ((*mIt).second)[m_hWnd].end();

        while (lIt != lendIt)
        {
            (*lIt)->Deleting(true);
            lIt++;
        }

        ((*mIt).second)[m_hWnd].clear();

        mIt++;
    }
}



/////////////////////////////////////////////////////////////////////////////
//
// LPARAM CFSISuiteView::OnUpdateScreen()
//
// Inputs           : WPARAM wParam - not used.
//                    LPARAM lParam - not used.
//
// Return Values    : 0
//
// Date             : 10 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Message handler to redraw the widgets that need to be
//                    redrawn.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CFSISuiteView::OnUpdateScreen(WPARAM wParam, LPARAM lParam)
{
    if (false == m_bAllowEraseBkgnd)
    {
        CMainFrame* pFrame = dynamic_cast<CMainFrame*>(GetParentFrame());
        if (NULL != pFrame)
        {
	        CFSISuiteDoc* pDoc = GetDocument();
	        ASSERT_VALID(pDoc);

            CRect r;
            CDC* pDC = pFrame->GetDC();

            GetClientRect(r);
            ClientToScreen(r);
            pFrame->ScreenToClient(r);

            //Clear the back buffer for OpenGL.
            SetRenderingContext();  //clear the screen, OpenGL style.

            if (m_bWindows7)
            {
                glFlush();          // Use single buffer due to driver issues with PFD_COPY_SWAP
                glDrawBuffer(GL_FRONT);
            }
            else
            {
                SwapBuffers(m_hDC); //Swap OpenGL buffers.  Double-buffered for Windows 2000
            }

            //Now, clear the front buffer
            SetRenderingContext();  //clear the screen, OpenGL style.
            pDC->FillSolidRect(r, (COLORREF)pDoc->PageColor());  //clear the screen GDI style

            pFrame->ReleaseDC(pDC);
        }

        m_bAllowEraseBkgnd = true;
    }

    _FSI_STL::map<long, CWidget*>           updateList      = CUpdateList::GetList(m_hWnd);
    _FSI_STL::map<long, CWidget*>::iterator mIt             = NULL;
    _FSI_STL::map<long, CWidget*>::iterator mendIt          = NULL;
    CCriticalSection*                       pCS             = NULL;

    if (m_mapSyncDrawing.find(m_hWnd) == m_mapSyncDrawing.end())
    {
        pCS                         = new CCriticalSection;
        m_mapSyncDrawing[m_hWnd]    = pCS;
    }
    else
    {
        pCS                         = m_mapSyncDrawing[m_hWnd];
    }

    m_mapLocked[m_hWnd] = pCS->Lock();

    _FSI_STL::list<CWidget*> listOpenGLWidgets;

    mIt     = updateList.begin();
    mendIt  = updateList.end();

    while (mIt != mendIt)
    {
        if (CWidget::IsValidAddress((*mIt).second) == VALID)
        {
            if ((*mIt).second->DrawsOpenGL() == false)
            {
                (*mIt).second->Draw();
            }
            else
            {
                listOpenGLWidgets.push_back((*mIt).second);
            }
        }

        mIt++;
    }

    _FSI_STL::list<CWidget*>::iterator lIt      = listOpenGLWidgets.begin();
    _FSI_STL::list<CWidget*>::iterator lendIt   = listOpenGLWidgets.end();

    while (lIt != lendIt)
    {
        if (CWidget::IsValidAddress((*lIt)) == VALID)
        {
            (*lIt)->Draw();
        }

        lIt++;
    }

    if (true == CWidget::SwapNeeded(m_hWnd))
    {
        if (m_bWindows7)
        {
            glFlush();          // single buffered
        }
        else
        {
            SwapBuffers(m_hDC); // double buffered
        }

        CWidget::SwapNeeded(m_hWnd, false);
    }

    m_mapLocked[m_hWnd] = FALSE;
    pCS->Unlock();

    // If a page change is about to take place, then PreventRedraw
    // may be waiting for the previous unlock.  By not setting the
    // redraw status to false until after another safe lock, a page
    // change may take place without the redraw status going to true
    // and another update message possibly being sent.
    m_mapLocked[m_hWnd] = pCS->Lock();
    CWidget::ScreenRedrawing(m_hWnd, false);
    m_mapLocked[m_hWnd] = FALSE;
    pCS->Unlock();

    return 0;
}


void CFSISuiteView::PreventRedraw()
{
    if (m_mapSyncDrawing.find(m_hWnd) == m_mapSyncDrawing.end())
    {
        m_mapSyncDrawing[m_hWnd] = new CCriticalSection;
    }

    m_mapLocked[m_hWnd] = m_mapSyncDrawing[m_hWnd]->Lock();
}

void CFSISuiteView::AllowRedraw()
{
    if (m_mapSyncDrawing.find(m_hWnd) == m_mapSyncDrawing.end())
    {
        m_mapSyncDrawing[m_hWnd] = new CCriticalSection;
    }

    if (m_mapLocked[m_hWnd] != FALSE)
    {
        m_mapLocked[m_hWnd] = FALSE;
        m_mapSyncDrawing[m_hWnd]->Unlock();
    }
}

void CFSISuiteView::SetRenderingContext()
{
	CFSISuiteDoc* pDoc = GetDocument();
	if(pDoc)
	{

		CRect rect;
		GetWindowRect(&rect);

		glViewport(0, 0, rect.Width(), rect.Height());
		glScissor(0, 0, rect.Width(), rect.Height());
		glClearColor((float)pDoc->PageColor().Red()/255.0f,
					(float)pDoc->PageColor().Green()/255.0f,
					(float)pDoc->PageColor().Blue()/255.0f,
					1.0f);
		glClear(GL_COLOR_BUFFER_BIT);
	}

}

void CFSISuiteView::AllowEraseBkgnd(bool bAllow)
{
    m_bAllowEraseBkgnd = bAllow;
}
