// FSISuiteDoc.h : interface of the CFSISuiteDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(_FSISUITEDOC_H_)
#define _FSISUITEDOC_H_

#include "..\core\stltypes.h"
#include "..\core\Undo.h"

#include "..\core\XMLParser5.h"
#include "..\core\color.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CFSISuiteView;

typedef struct threadReadFileData
{
    CXMLPage*                   s_pXMLPage;
    _FSI_STL::list<CWidget*>*   s_pListWidgets;
    HWND                        s_hWndFrame;
    IXMLDOMDocument*            s_pXMLDoc;
    unsigned long               s_ulLoadNumber;
    bool                        s_bEditMode;
    CString                     s_strFile;
    CCriticalSection*           s_pSync;
} ThreadReadFileData;

class CFSISuiteDoc : public CDocument
{
private:
    CXMLPage*               m_pXMLPage;
    IXMLDOMDocument*        m_pXMLDoc;
    int                     m_nUseScale;
    bool                    m_bGridOn;
    bool                    m_bSnapOn;
    bool                    m_bSnapAllVertices;
    bool                    m_bEditMode;

    unsigned short          m_ushGridX;
    unsigned short          m_ushGridY;
    CWidget*                m_pPageWidget;
    CFSISuiteView*          m_pOnScreenView;
    CColor                  m_PageColor;

    // The string with the meaningful name for a page file.
    // This is contained within the page file's attributes.
    // masterindex.fml might have a meaningful name of "Master Index."
    CString                 m_strPageName;

    // The name of the component that m_strPageName goes with.  When the
    // page is loaded, the path of the file should be checked against the
    // current path and if it is different, change the component specific
    // area.
    CString                 m_strComponentName;

    CCriticalSection        m_syncXMLDoc;


protected: // create from serialization only
	CFSISuiteDoc();
    static UINT ThreadReadFile(LPVOID param);
	DECLARE_DYNCREATE(CFSISuiteDoc)

// Attributes
public:
   _FSI_STL::list<CWidget*>     m_listWidgets;
   CUndo<CXMLPage*>    m_undoPages;

// Operations
public:
    CWidget* InitializeAttributes(_FSI_STL::list<CWidget*>& listWidgets,
                                  bool bUpdateDoc = true);
    static CXMLPage* ReadFile(LPCTSTR lpszPathName, IXMLDOMDocument* pXMLDoc,
                              bool bEditMode);
    void CreateWidgets(_FSI_STL::list<CWidget*>& listWidgets, CWnd* pWnd,
                       LPCTSTR lpszPathName, CXMLPage* pXMLPage, 
                       bool bOverlay = false);
    void Snap(CPoint& ptScreen);
    void ResetView();
    void Scale(_FSI_STL::list<CWidget*>& listWidgets, CWidget* pPageWidget);
    void UseXMLDOMDocument(bool bUse);

    // Accessors
	CXMLPage*           XMLPage();
    CString             PageName();
    CColor              PageColor();
    CString             ComponentName();
    bool                GridOn();
    unsigned short      GridX();
    unsigned short      GridY();
    bool                SnapOn();
    bool                SnapAll();
    bool                EditMode();
    CWidget*            PageWidget();
    CFSISuiteView*      OnScreenView();
    int                 UseScale();
    IXMLDOMDocument*    XMLDocument();

    // Mutators
    void GridOn(const bool bGridOn);
    void GridX(const unsigned short ushGridX);
    void GridY(const unsigned short ushGridY);
    void SnapOn(const bool bSnapOn);
    void SnapAll(const bool bSnapAll);
    void EditMode(const bool bEditMode);
    void PageWidget(CWidget* pWidget);
    void OnScreenView(CFSISuiteView* pOnScreenView);
    void UseScale(int nUseScale);

    void TraverseWidgets(CXMLWidget* pXMLWidget, 
                        CWnd* pParentWnd, unsigned long& rulId, 
                        CWidget* pBaseParentWidget, CWidget* pParentWidget,
                        _FSI_STL::list<CWidget*>& listWidgets);
 
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFSISuiteDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CFSISuiteDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CFSISuiteDoc)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_FSISUITEDOC_H_)
