// FSISuiteDoc.cpp : implementation of the CFSISuiteDoc class
//

#include "..\core\stdafx.h"
#include <gl/gl.h>
#include <malloc.h>
#include "FSISuite.h"
#include "MainFrm.h"

#include "FSISuiteDoc.h"
#include "FSISuiteView.h"

#include "..\core\PageWidget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteDoc

IMPLEMENT_DYNCREATE(CFSISuiteDoc, CDocument)

BEGIN_MESSAGE_MAP(CFSISuiteDoc, CDocument)
	//{{AFX_MSG_MAP(CFSISuiteDoc)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
 
/////////////////////////////////////////////////////////////////////////////
// CFSISuiteDoc construction/destruction

CFSISuiteDoc::CFSISuiteDoc()
{
    m_pXMLPage          = NULL;
    m_bSnapOn           = true;
    m_bSnapAllVertices  = true;
    m_bEditMode         = false;
    m_bGridOn           = true;
    m_ushGridX          = 16;
    m_ushGridY          = 16;
    m_PageColor         = CColor(GetSysColor(COLOR_WINDOW));
    m_strPageName       = "Untitled";
    m_pPageWidget       = NULL;
    m_pXMLDoc           = NULL;
    m_pOnScreenView     = NULL;
    m_nUseScale         = 0;

    CoInitialize(NULL);
    //
    // Create an empty XML document
    //
    if (CoCreateInstance(CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER,
                                IID_IXMLDOMDocument, (void**)&m_pXMLDoc) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    VARIANT_BOOL vb = VARIANT_FALSE;

    if (m_pXMLDoc->put_validateOnParse(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_resolveExternals(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_async(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
}

CFSISuiteDoc::~CFSISuiteDoc()
{
    delete m_pXMLPage;

    if (m_pXMLDoc != NULL)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (!m_listWidgets.empty())
    {
        _FSI_STL::list<CWidget*>::iterator lwIt = m_listWidgets.begin();

        while (lwIt != m_listWidgets.end())
        {
            if (CWidget::IsValidAddress((*lwIt)) == VALID)
            {
                (*lwIt)->Wnd()->DestroyWindow();
            }

            if (CWidget::IsValidAddress((*lwIt)) != INVALID)
            {
                (*lwIt)->Deleting(true);
            }

            lwIt++;
        }

        m_listWidgets.clear();
    }
}

BOOL CFSISuiteDoc::OnNewDocument()
{
    if (m_pOnScreenView != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > >::iterator mIt      = NULL;
        _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<HWND, _FSI_STL::list<CWidget*> > >::iterator mendIt   = NULL;
        _FSI_STL::list<CWidget*>::iterator lIt       = NULL;
        _FSI_STL::list<CWidget*>::iterator lendIt    = NULL;
        mIt         = CWidget::m_mapReusableWidgets.begin();
        mendIt      = CWidget::m_mapReusableWidgets.end();
        HWND hWnd   = m_pOnScreenView->GetSafeHwnd();
        while (mIt != mendIt)
        {
            lIt     = ((*mIt).second)[hWnd].begin();
            lendIt  = ((*mIt).second)[hWnd].end();

            while (lIt != lendIt)
            {
                (*lIt)->Deleting(true);
                ++lIt;
            }

            ((*mIt).second)[hWnd].clear();

            ++mIt;
        }
    }

    delete m_pXMLPage;
    m_pXMLPage = NULL;

	if (!CDocument::OnNewDocument())
		return FALSE;

    if (m_pOnScreenView != NULL)
    {
        m_pOnScreenView->AllowEraseBkgnd(false);

        m_pOnScreenView->PreventRedraw();
        CWidget::ScreenRedrawing(m_pOnScreenView->GetSafeHwnd(), true);
        CWidget::SwapNeeded(m_pOnScreenView->GetSafeHwnd(), false);

        m_pOnScreenView->DestroyOverlays();
    }

    if (!m_listWidgets.empty())
    {
        _FSI_STL::list<CWidget*>::iterator lwIt     = m_listWidgets.begin();
        _FSI_STL::list<CWidget*>::iterator lwendIt  = m_listWidgets.end();

        while (lwIt != lwendIt)
        {
            if (CWidget::IsValidAddress((*lwIt)) == VALID)
            {
//                (*lwIt)->Wnd()->DestroyWindow();
                (*lwIt)->Wnd()->ShowWindow(SW_HIDE);
            }

            if (CWidget::IsValidAddress((*lwIt)) != INVALID)
                (*lwIt)->Deleting(true);

            ++lwIt;
        }

        m_listWidgets.clear();
    }


    CFSISuiteDocTemplate* pDocTemplate = dynamic_cast<CFSISuiteDocTemplate*>(GetDocTemplate());
    CMainFrame* pFrame = dynamic_cast<CMainFrame*>(pDocTemplate->m_pFrame);

    if (pFrame == NULL)
        return FALSE;

    m_pXMLPage          = new CXMLPage;

    if (m_pXMLPage != NULL)
    {
        CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());
        if (pApp != NULL)
        {
            STRING_LIST::iterator slIt = pApp->m_listAvailableWidgets.begin();
            while (slIt != pApp->m_listAvailableWidgets.end())
            {
                m_pXMLPage->AddAvailableWidget(*slIt);
                ++slIt;
            }
            slIt = pApp->m_listAvailableActions.begin();
            while (slIt != pApp->m_listAvailableActions.end())
            {
                m_pXMLPage->AddAvailableWidget(*slIt);
                ++slIt;
            }

            m_pXMLPage->AddWidget(_FSI_STL::string("FSISuitePage"),_FSI_STL::string(""));

            m_pPageWidget = InitializeAttributes(m_listWidgets);

            if (m_pPageWidget != NULL)
            {
                CPageWidget* pPageWidget = dynamic_cast<CPageWidget*>(m_pPageWidget);
                pPageWidget->WindowNumber(pFrame->WindowNumber());
                if (pPageWidget->HelpFile() != "")
                    pPageWidget->HelpFile(_FSI_STL::string(""));
            }

            if (m_bEditMode == true)
            {
                m_undoPages.clear();
                m_undoPages.maxSize(pApp->MaxUndoSize());
                CXMLPage* pXMLPage  = new CXMLPage;
                if (pXMLPage != NULL)
                {
                    *pXMLPage           = *(m_pXMLPage);

                    m_undoPages.ok_push(pXMLPage);
                }
            }
        }
    }

    if (NULL != m_pOnScreenView)
    {
        m_pOnScreenView->SetRenderingContext();
        m_pOnScreenView->AllowRedraw();
        m_pOnScreenView->AllowEraseBkgnd(true);
        m_pOnScreenView->Invalidate();
    }

    glClearStencil(1);
    glClear(GL_STENCIL_BUFFER_BIT);

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CFSISuiteDoc serialization

void CFSISuiteDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
        if (m_pXMLPage != NULL) 
        {
            ar << *m_pXMLPage; 
        }
	}
	else
	{
	}
}

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteDoc diagnostics

#ifdef _DEBUG
void CFSISuiteDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CFSISuiteDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteDoc commands
BOOL CFSISuiteDoc::OnOpenDocument(LPCTSTR lpszPathName) 
{
    // Start async read of file.
    ThreadReadFileData* pData = new ThreadReadFileData;
    if (pData != NULL)
    {
        pData->s_strFile.Format("%s", lpszPathName);

        pData->s_pXMLDoc    = m_pXMLDoc;

        pData->s_bEditMode  = m_bEditMode;

        pData->s_pSync      = &m_syncXMLDoc;

        CFSISuiteDocTemplate* pDocTemplate = 
                        dynamic_cast<CFSISuiteDocTemplate*>(GetDocTemplate());
        CMainFrame* pFrame = dynamic_cast<CMainFrame*>(pDocTemplate->m_pFrame);
        if (pFrame != NULL)
        {
            pData->s_hWndFrame      = pFrame->GetSafeHwnd();
            pData->s_ulLoadNumber   = pFrame->LoadNumber();

            AfxBeginThread(ThreadReadFile, (LPVOID)pData);
        }
        else
        {
            delete pData;
            pData = NULL;
        }
    }

    return TRUE;
}

UINT CFSISuiteDoc::ThreadReadFile(LPVOID param)
{
    ThreadReadFileData* pData = reinterpret_cast<ThreadReadFileData*>(param);
    if (pData != NULL)
    {
        if (pData->s_hWndFrame != NULL)
        {
            pData->s_pListWidgets = new _FSI_STL::list<CWidget*>;

            pData->s_pSync->Lock();
            pData->s_pXMLPage = ReadFile(pData->s_strFile, 
                                         pData->s_pXMLDoc, pData->s_bEditMode);

            pData->s_pSync->Unlock();
            ::PostMessage(pData->s_hWndFrame, WM_FILE_READ_COMPLETE, pData->s_ulLoadNumber, (long)param);
        }
        else
        {
            delete pData;
        }
    }

	return 0;
}

CXMLPage* CFSISuiteDoc::ReadFile(LPCTSTR lpszPathName, IXMLDOMDocument* pXMLDoc,
                                 bool bEditMode)
{
    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    if (pApp == NULL)
        return NULL;

    CString strFileName(lpszPathName);

    if (strFileName.Find("^") > -1)
        CWidget::ExpandPath(strFileName);

    CXMLPage* pXMLPage = NULL;

    if (bEditMode == false)
    {
        CXMLPage* pXMLCachePage = pApp->FindPage(strFileName);
        if (pXMLCachePage != NULL)
        {
            pXMLPage = new CXMLPage;
            if (pXMLPage != NULL)
                *pXMLPage = *pXMLCachePage;
        }
    }

    if (pXMLPage == NULL)
    {
        // It is not in the cache or we are editing.  Parse the file.
        CXMLParser5 xmlParser((LPCTSTR)strFileName);
        STRING_LIST::iterator slIt = pApp->m_listAvailableWidgets.begin();
        while (slIt != pApp->m_listAvailableWidgets.end())
        {
            xmlParser.AddAvailableWidget(*slIt);

            slIt++;
        }
        slIt = pApp->m_listAvailableActions.begin();
        while (slIt != pApp->m_listAvailableActions.end())
        {
            xmlParser.AddAvailableWidget(*slIt);
            slIt++;
        }
        pXMLPage = new CXMLPage;
        if (pXMLPage != NULL)
        {
            xmlParser.ParseFile(pXMLPage, pXMLDoc);
            if (bEditMode == false)
            {
                pApp->AddPage(strFileName,pXMLPage);
            }

            WIN32_FILE_ATTRIBUTE_DATA fad;
            if (::GetFileAttributesEx(strFileName, GetFileExInfoStandard, &fad) != 0)
            {
                pXMLPage->WriteFileTime(&(fad.ftLastWriteTime));
            }
        }
    }

    return pXMLPage;
}

void CFSISuiteDoc::CreateWidgets(_FSI_STL::list<CWidget*>& listWidgets, 
                                 CWnd* pWnd, LPCTSTR lpszPathName, 
                                 CXMLPage* pXMLPage, bool bOverlay) 
{
    // No page for which widget are needed.
    if (pXMLPage == NULL)
        return;

    // Show some indication that something is happening.
    CWaitCursor wait;

    CFSISuiteApp* pApp = dynamic_cast<CFSISuiteApp*>(AfxGetApp());

    if (pApp == NULL)
        return;

    // Make sure that we don't try to fill the view until everything
    // has been created.
    _FSI_STL::list<CWidget*>::iterator wlIt     = m_listWidgets.begin();
    _FSI_STL::list<CWidget*>::iterator wlendIt  = m_listWidgets.end();
    if (false == bOverlay)
    {
        m_pOnScreenView->AllowEraseBkgnd(false);

        m_pOnScreenView->PreventRedraw();
        CWidget::ScreenRedrawing(m_pOnScreenView->GetSafeHwnd(), true);
        CWidget::SwapNeeded(m_pOnScreenView->GetSafeHwnd(), false);

        if (!m_listWidgets.empty())
        {
            while (wlIt != wlendIt)
            {
                if (CWidget::IsValidAddress((*wlIt)) == VALID)
                {
//                    (*wlIt)->Wnd()->DestroyWindow();
                    (*wlIt)->Wnd()->ShowWindow(SW_HIDE);
                }

                if (CWidget::IsValidAddress((*wlIt)) != INVALID)
                {
                    (*wlIt)->Deleting(true);
                }

                ++wlIt;
            }

            m_listWidgets.clear();
        }
    }

    // If a page was sent, then through its widgets
    // to create all of the Windows windows.
    WIDGET_LIST::iterator lwIt  = NULL;
    CXMLWidget* pXMLWidget      = pXMLPage->GetNextWidget(lwIt);
    unsigned long ulId          = IDC_WIDGET;
    while (pXMLWidget != NULL)
    {
        TraverseWidgets(pXMLWidget, pWnd, ulId, NULL, NULL, listWidgets);
        pXMLWidget = pXMLPage->GetNextWidget(lwIt);
    }

    // Find the next CWnd derived widget that has WS_TABSTOP.
    wlIt     = listWidgets.begin();
    wlendIt  = listWidgets.end();
    bool bDone = false;
    CWnd* pLocalWnd = NULL;
    while (wlIt != wlendIt && bDone == false)
    {
        pLocalWnd = (*wlIt)->Wnd();
        if (pLocalWnd != NULL)
        {
            if (pLocalWnd->GetStyle() & WS_TABSTOP &&
                !(pLocalWnd->GetStyle() & BS_AUTORADIOBUTTON))
            {
                pLocalWnd->SetRedraw(FALSE);
                pLocalWnd->SetFocus();
                pLocalWnd->SetRedraw(TRUE);
                bDone = true;
            }
        }

        ++wlIt;
    }

    _heapmin();

//    SetProcessWorkingSetSize(GetCurrentProcess(), -1, -1);

    if (bOverlay == true)
        return;

    // If the page was not cached, then delete the page.
    delete m_pXMLPage;

    m_pXMLPage          = pXMLPage;

    m_pPageWidget       = InitializeAttributes(listWidgets);

    CPageWidget* pPageWidget = dynamic_cast<CPageWidget*>(m_pPageWidget);
    if (pPageWidget != NULL)
    {
        if (pPageWidget->HelpFile() == "")
        {
            CString strFilePath(lpszPathName);

            if (strFilePath.ReverseFind('\\') > -1)
                strFilePath = strFilePath.Mid(strFilePath.ReverseFind('\\') + 1);

            if (strFilePath.Find(".") > -1)
                strFilePath = strFilePath.Left(strFilePath.Find("."));

            strFilePath += ".htm";
            pPageWidget->HelpFile(_FSI_STL::string((LPCTSTR)strFilePath));
        }
    }

    CFSISuiteDocTemplate* pDocTemplate = dynamic_cast<CFSISuiteDocTemplate*>(GetDocTemplate());
    CMainFrame* pFrame  = dynamic_cast<CMainFrame*>(pDocTemplate->m_pFrame);

    if (pFrame == NULL)
        return;
 
    if (m_pPageWidget != NULL)
        dynamic_cast<CPageWidget*>(m_pPageWidget)->WindowNumber(pFrame->WindowNumber());

    Scale(listWidgets, m_pPageWidget);

    if (m_bEditMode == true)
    {
        m_undoPages.clear();
        m_undoPages.maxSize(pApp->MaxUndoSize());
        CXMLPage* pXMLPage  = new CXMLPage;
        if (pXMLPage != NULL)
        {
            *pXMLPage           = *(m_pXMLPage);

            m_undoPages.ok_push(pXMLPage);
        }
    }

    SetPathName(lpszPathName);

    if (m_pOnScreenView != NULL)
        m_pOnScreenView->DestroyOverlays();

    // Add everyone to make sure that they will be in the
    // first update.  When they were created, they would have
    // added a WM_PAINT but that has to go through the
    // message loop and an update could occur before all
    // of the WM_PAINT message from the creates get processed.
    if (!listWidgets.empty())
    {
        wlIt    = listWidgets.begin();
        wlendIt = listWidgets.end();

        while (wlIt != wlendIt)
        {
//            (*wlIt)->Deleting(false);
            if ((*wlIt)->Action() == NULL)
            {
                CUpdateList::AddPaintWidget(m_pOnScreenView->GetSafeHwnd(), 
                                            (*wlIt));
            }

            ++wlIt;
        }
    }

    m_listWidgets = listWidgets;

    m_pOnScreenView->SetRenderingContext();
    glClearStencil(1);
    glClear(GL_STENCIL_BUFFER_BIT);

    m_pOnScreenView->AllowRedraw();

    if (m_bEditMode == true)
    {
        CEditorTree* pTree = pFrame->EditorTree();
        if (pTree != NULL)
            pTree->AddWidgets(this);
    }
}   

CWidget* CFSISuiteDoc::InitializeAttributes(_FSI_STL::list<CWidget*>& listWidgets,
                                            bool bUpdateDoc)
{
    STRING2STRING_MAP::iterator s2sIt;
    CWidget* pPageWidget = NULL;

    if (m_pXMLPage != NULL)
    {
        bool bDone = false;

        // Find the page widget.
        _FSI_STL::list<CWidget*>::iterator lIt = listWidgets.begin();
        while (lIt != listWidgets.end() && bDone == false)
        {
            CString strWidgetName((*lIt)->WidgetName().c_str());
            strWidgetName.MakeUpper();
            if (strWidgetName == "PAGE")
            {
                pPageWidget = (*lIt);
                bDone = true;
            }

            lIt++;
        }

        if (bDone == false)
        {
            pPageWidget = new CPageWidget;
            if (pPageWidget == NULL)
                return NULL;

            listWidgets.push_back(pPageWidget);
            CXMLWidget* pXMLWidget = NULL;
            pPageWidget->Initialize(pXMLWidget, NULL, 
                                    IDC_WIDGET + listWidgets.size(), EditMode());

            pPageWidget->UpperLeft(CExtentsPoint("0,0"));
            CRect rect;
            POSITION pos = GetFirstViewPosition();
            // Warning: the first view may not be the active view!!!
            // That's ok here since both should be the same size.
            CFSISuiteView* pView = (CFSISuiteView*)GetNextView(pos);
            pView->GetWindowRect(&rect);
            pPageWidget->LowerRight(CExtentsPoint(CPoint(rect.Width(), rect.Height())));
            ((CPageWidget*)pPageWidget)->UpdateExtents();
            if (pXMLWidget != NULL)
            {
                pPageWidget->BaseWidget(pPageWidget);
                if (XMLPage()->AddWidget(pXMLWidget) == false)
                {
                    delete pXMLWidget;
                    pXMLWidget = NULL;
                    pPageWidget->XMLWidget(NULL);
                    return pPageWidget;
                }
            }
        }

        if (bUpdateDoc == true)
        {
            CXMLWidget* pXMLWidget = NULL;
            if (pPageWidget != NULL)
                pXMLWidget = pPageWidget->XMLWidget();

            if (pXMLWidget == NULL)
            {
                WIDGET_LIST::iterator wlIt = NULL;
                pXMLWidget = m_pXMLPage->GetNextWidget(wlIt);
                bDone = false;
                while ( pXMLWidget != NULL && bDone == false)
                {
                    if (pXMLWidget->WidgetName() == "PAGE")
                    {
                        pPageWidget->XMLWidget(pXMLWidget);
                        bDone = true;
                    }

                    if (bDone == false)
                    {
                        pXMLWidget = m_pXMLPage->GetNextWidget(wlIt);
                    }
                }
            }

            CXMLElement* pXMLElement = NULL;
            POSITION pos = NULL;
            if (pXMLWidget != NULL)
            {
                if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("NAME")) == true)
                {
                    m_strPageName = pXMLElement->ElementValue().c_str();
                }

                pXMLElement = NULL;

                CString strValue;
                _FSI_STL::string stlStrGlobalColor = _FSI_STL::string("");
                CColor colorGlobal;

                while (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("COLOR")) == true)
                {
                    strValue = pXMLElement->ElementValue().c_str();

                    stlStrGlobalColor = _FSI_STL::string("");
                    if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("GLOBALCOLOR")) == true)
                    {
                        stlStrGlobalColor = (*s2sIt).second;
                        colorGlobal = CColor::GlobalColor(CString(stlStrGlobalColor.c_str()));
                    }

                    if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("PLANE")) == true)
                    {
                        if (strstr((*s2sIt).second.c_str(), "BACKGROUND") != NULL)
                        {
                            m_PageColor = CColor(strValue);
                            if (stlStrGlobalColor != "Not Used")
                            {
                                m_PageColor = colorGlobal;
                            }

                            // Found the background color, leave the loop.
                            break;
                        }
                    }
                }

                pXMLElement = NULL;
                if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("SNAP")) == true)
                {
                    CString strSnapOn(pXMLElement->ElementValue().c_str());
                    strSnapOn.MakeUpper();
                    if (strstr(strSnapOn,"YES"))
                    {
                        m_bSnapOn = true;
                    }
                    else
                    {
                        m_bSnapOn = false;
                    }

                    if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("SNAPALL")) != false)
                    {
                        CString strSnapAll((*s2sIt).second.c_str());
                        strSnapAll.MakeUpper();
                        if (strSnapAll == "YES")
                        {
                            m_bSnapAllVertices = true;
                        }
                        else
                        {
                            m_bSnapAllVertices = false;
                        }
                    }
                }

                pXMLElement = NULL;
                if (pXMLWidget->FindElement(pXMLElement, pos, _FSI_STL::string("GRID")) == true)
                {
                    CString strGridOn(pXMLElement->ElementValue().c_str());
                    strGridOn.MakeUpper();
                    if (strstr(strGridOn,"YES"))
                    {
                        m_bGridOn = true;
                    }
                    else
                    {
                        m_bGridOn = false;
                    }
                
                    if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESX")) != false)
                    {
                        m_ushGridX = atoi((*s2sIt).second.c_str());
                    }

                    if (pXMLElement->FindAttribute(s2sIt,_FSI_STL::string("RESY")) != false)
                    {
                        m_ushGridY = atoi((*s2sIt).second.c_str());
                    }
                }
            }
        }
    }

    return pPageWidget;
}

void CFSISuiteDoc::TraverseWidgets(CXMLWidget* pXMLWidget, 
                                  CWnd* pParentWnd,
                                  unsigned long& rulId, 
                                  CWidget* pBaseParentWidget,
                                  CWidget* pParentWidget,
                                  _FSI_STL::list<CWidget*>& listWidgets)
{
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    if (pXMLWidget != NULL)
    {
        if (pApp->m_mapWidgets.find(pXMLWidget->WidgetName()) !=
                                                  pApp->m_mapWidgets.end())
        {
            CWidget* pWidget = NULL;
            HWND hWnd = NULL; 
            
            // If the base parent widget is NULL, the pWnd should
            // be the view, overlay, or collar.  If base parent widget
            // is not NULL, then the CWnd parent of the base parent widget
            // should be the view, overlay, or collar.
            if (pBaseParentWidget == NULL)
            {
                hWnd = pParentWnd->GetSafeHwnd();
            }
            else
            {
                hWnd = pParentWidget->FrameworkParent()->GetSafeHwnd();
            }

            _FSI_STL::string stlStrName = pXMLWidget->WidgetName();
            
            if (true == (CWidget::m_mapReusableWidgets[stlStrName][hWnd]).empty() ||
                true == m_bEditMode)
            {
                pWidget = pApp->m_mapWidgets[stlStrName]();
            }
            else
            {
                pWidget = (CWidget::m_mapReusableWidgets[stlStrName][hWnd]).front();
                (CWidget::m_mapReusableWidgets[stlStrName][hWnd]).pop_front();
            }

            if (pBaseParentWidget == NULL)
            {
                pBaseParentWidget = pWidget;
            }

            if ( pWidget != NULL)
            {
                if (pParentWidget != NULL)
                {
                    pParentWidget->AddWidget(pWidget);
                }
                listWidgets.push_back(pWidget);
                pWidget->ParentWidget(pParentWidget);
                if (pWidget->Wnd() != NULL)
                {
                    pWidget->Wnd()->SetRedraw(FALSE);
                }
                pWidget->Initialize(pXMLWidget,pParentWnd, rulId, m_bEditMode);
                pWidget->BaseWidget(pBaseParentWidget);
                if (pWidget->Wnd() != NULL)
                {
                    pWidget->Wnd()->SetRedraw(TRUE);
                }
                rulId++;
                WIDGET_LIST::iterator wlIt = NULL;
                CXMLWidget* pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                while ( pXMLSubWidget != NULL)
                {
                    TraverseWidgets(pXMLSubWidget, pWidget->Wnd(), rulId, 
                                    pBaseParentWidget, pWidget, listWidgets);
                    pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                }
            }
        }
        else if (pApp->m_mapActions.find(pXMLWidget->WidgetName()) !=
                                                  pApp->m_mapActions.end())
        {
            if (pBaseParentWidget != NULL)
            {
                CWidget* pAction = NULL;

                _FSI_STL::string stlStrName = pXMLWidget->WidgetName();
            
                pAction = pApp->m_mapActions[stlStrName]();

                if ( pAction != NULL)
                {
                    listWidgets.push_back(pAction);
                    pAction->ParentWidget(pParentWidget);
                    pAction->Initialize(pXMLWidget, pParentWnd, rulId, m_bEditMode);
                    if (pParentWidget != NULL)
                    {
                        pParentWidget->AddAction(pAction->Action());
                    }
                    pAction->BaseWidget(pBaseParentWidget);
                    rulId++;
                    WIDGET_LIST::iterator wlIt = NULL;
                    CXMLWidget* pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                    while ( pXMLSubWidget != NULL)
                    {
                        TraverseWidgets(pXMLSubWidget, pAction->Wnd(), rulId, 
                                        pBaseParentWidget, pAction, listWidgets);
                        pXMLSubWidget = pXMLWidget->GetNextSubWidget(wlIt);
                    }
                }
            }
        }
    }
}

void CFSISuiteDoc::Snap(CPoint& ptScreen)
{
    // An old graphics trick.  Divide the coordinate by the grid spacing as 
    // real numbers and then add .5 and cast back to an int.  This will round 
    // the floating point number to the integer number of cells over or down 
    // that the point should be.  This number is then multipled by the grid 
    // spacing to get the pixel.
    ptScreen.x = (int)((float)ptScreen.x/(float)m_ushGridX + 0.5) * m_ushGridX;
    ptScreen.y = (int)((float)ptScreen.y/(float)m_ushGridY + 0.5) * m_ushGridY;
}

void CFSISuiteDoc::ResetView()
{
    CWnd* pWnd              = (CWnd*)m_pOnScreenView;
    
    if (m_pXMLPage != NULL)
    {
        WIDGET_LIST::iterator wlIt = NULL;
        CXMLWidget* pXMLWidget = m_pXMLPage->GetNextWidget(wlIt);
        unsigned long ulId = IDC_WIDGET;
        while (pXMLWidget != NULL)
        {
            TraverseWidgets(pXMLWidget, pWnd, ulId, NULL, NULL, m_listWidgets);
            pXMLWidget = m_pXMLPage->GetNextWidget(wlIt);
        }

    }

    m_pPageWidget = InitializeAttributes(m_listWidgets);

    if (m_pPageWidget != NULL)
    {
        CFSISuiteDocTemplate* pDocTemplate = dynamic_cast<CFSISuiteDocTemplate*>(GetDocTemplate());
        CMainFrame* pFrame = dynamic_cast<CMainFrame*>(pDocTemplate->m_pFrame);
        dynamic_cast<CPageWidget*>(m_pPageWidget)->WindowNumber(pFrame->WindowNumber());

        CString strFilePath = GetPathName();

        if (strFilePath.ReverseFind('\\') > -1)
        {
            strFilePath = strFilePath.Mid(strFilePath.ReverseFind('\\') + 1);
        }

        if (strFilePath.Find(".") > -1)
        {
            strFilePath = strFilePath.Left(strFilePath.Find("."));
        }

        strFilePath += ".htm";
        dynamic_cast<CPageWidget*>(m_pPageWidget)->HelpFile(_FSI_STL::string((LPCTSTR)strFilePath));
    }

    UpdateAllViews(NULL);
}

void CFSISuiteDoc::Scale(_FSI_STL::list<CWidget*>& listWidgets, CWidget* pPageWidget)
{
    if (m_nUseScale == 1)
    {
        _FSI_STL::list<CWidget*>::iterator lIt = listWidgets.begin();
        while (lIt != listWidgets.end())
        {
            if ((*lIt) != pPageWidget)
            {
                if (pPageWidget != NULL)
                {
                    (*lIt)->Scale(pPageWidget->LowerRight(), true);
                }
            }

            lIt++;
        }
    }
 
    if (pPageWidget != NULL)
    {
        pPageWidget->UpperLeft(CExtentsPoint("0,0"));
        CRect rect;
        POSITION pos = GetFirstViewPosition();
        // Warning: the first view may not be the active view!!!
        // That's ok here since both should be the same size.
        CFSISuiteView* pView = (CFSISuiteView*)GetNextView(pos);
        pView->GetWindowRect(&rect);
        pPageWidget->LowerRight(CExtentsPoint(CPoint(rect.Width(), 
                                              rect.Height())));
        ((CPageWidget*)pPageWidget)->UpdateExtents();
    }
}

void CFSISuiteDoc::UseXMLDOMDocument(bool bUse)
{
    if (bUse)
        m_syncXMLDoc.Lock();
    else
        m_syncXMLDoc.Unlock();
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////
CFSISuiteView* CFSISuiteDoc::OnScreenView()
{
    return m_pOnScreenView;
}

CWidget* CFSISuiteDoc::PageWidget()
{
    return m_pPageWidget;
}

bool CFSISuiteDoc::EditMode()
{
    return m_bEditMode;
}

bool CFSISuiteDoc::SnapOn()
{
    return m_bSnapOn;
}

bool CFSISuiteDoc::SnapAll()
{
    return m_bSnapAllVertices;
}

unsigned short CFSISuiteDoc::GridY()
{
    return m_ushGridY;
}

unsigned short CFSISuiteDoc::GridX()
{
    return m_ushGridX;
}

CString CFSISuiteDoc::PageName()
{
    return m_strPageName;
}

CColor CFSISuiteDoc::PageColor()
{
    return m_PageColor;
}

CString CFSISuiteDoc::ComponentName()
{
    return m_strComponentName;
}

bool CFSISuiteDoc::GridOn()
{
    return m_bGridOn;
}

CXMLPage* CFSISuiteDoc::XMLPage()
{
    return m_pXMLPage; 
}

int CFSISuiteDoc::UseScale()
{
    return m_nUseScale;
}

IXMLDOMDocument* CFSISuiteDoc::XMLDocument()
{
    return m_pXMLDoc;
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////
void CFSISuiteDoc::OnScreenView(CFSISuiteView* pOnScreenView)
{
    m_pOnScreenView = pOnScreenView;
}

void CFSISuiteDoc::PageWidget(CWidget* pWidget)
{
    m_pPageWidget = pWidget;
}

void CFSISuiteDoc::EditMode(const bool bEditMode)
{
    m_bEditMode = bEditMode;

    CFSISuiteDocTemplate* pDocTemplate = dynamic_cast<CFSISuiteDocTemplate*>(GetDocTemplate());
    CMainFrame* pFrame = dynamic_cast<CMainFrame*>(pDocTemplate->m_pFrame);
    CMenu* pMenu = pFrame->GetMenu();
    if (pMenu == NULL)
    {
        return;
    }

    if (m_bEditMode == true)
    {
            pMenu->EnableMenuItem(ID_FILE_SAVE, MF_ENABLED | MF_BYCOMMAND);
    }
    else
    {
            pMenu->EnableMenuItem(ID_FILE_SAVE, 
                                  MF_DISABLED | MF_GRAYED | MF_BYCOMMAND);
    }
}

void CFSISuiteDoc::SnapOn(const bool bSnapOn)
{
    m_bSnapOn = bSnapOn;
}

void CFSISuiteDoc::SnapAll(const bool bSnapAll)
{
    m_bSnapAllVertices = bSnapAll;
}

void CFSISuiteDoc::GridX(const unsigned short ushGridX)
{
    m_ushGridX = ushGridX;
}

void CFSISuiteDoc::GridY(const unsigned short ushGridY)
{
    m_ushGridY = ushGridY;
}

void CFSISuiteDoc::GridOn(const bool bGridOn)
{
    m_bGridOn = bGridOn;
}

void CFSISuiteDoc::UseScale(int nUseScale)
{
    m_nUseScale = nUseScale;
}