// FSISuiteCommmandLineInfo.cpp: implementation of the CFSISuiteCommmandLineInfo class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "FSISuiteCommandLineInfo.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CFSISuiteCommandLineInfo::CFSISuiteCommandLineInfo() :
    m_bComponentFound(false),
    m_bPageFlipTestRestFound(false),
    m_bPageFlipTestLengthFound(false),
    m_strComponentName(""),
    m_strPageFlipTestRest(""),
    m_strPageFlipTestLength("")
{
}

void CFSISuiteCommandLineInfo::ParseParam(LPCTSTR pszParam, BOOL bFlag, 
                                          BOOL bLast)
{   
    if (bFlag && stricmp(pszParam, "Component") == 0)
    {
        m_bComponentFound = true;
    }
    else if (m_bComponentFound && !bFlag)
    {
        m_strComponentName  = CString(pszParam);
        m_bComponentFound   = false;
    }
    else if (bFlag && stricmp(pszParam, "PageFlipTestLength") == 0)
    {
        m_bPageFlipTestLengthFound = true;
    }
    else if (m_bPageFlipTestLengthFound && !bFlag)
    {
        m_strPageFlipTestLength     = CString(pszParam);
        m_bPageFlipTestLengthFound  = false;
    }
    else if (bFlag && stricmp(pszParam, "PageFlipTestRest") == 0)
    {
        m_bPageFlipTestRestFound = true;
    }
    else if (m_bPageFlipTestRestFound && !bFlag)
    {
        m_strPageFlipTestRest       = CString(pszParam);
        m_bPageFlipTestRestFound    = false;
    }
    else
    {
      CCommandLineInfo::ParseParam (pszParam, bFlag, bLast);
    }
}

CString CFSISuiteCommandLineInfo::ComponentName()
{
    return m_strComponentName;
}

CString CFSISuiteCommandLineInfo::PageFlipTestRest()
{
    return m_strPageFlipTestRest;
}

CString CFSISuiteCommandLineInfo::PageFlipTestLength()
{
    return m_strPageFlipTestLength;
}