/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FSISuite.h
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : FSISuite.h contains the definition of the CWinApp 
//                    derived class for the FSISuite application.  
//                    FSISuite is the framework that allows for plugin 
//                    components such as an IOS, a malfunction editor, 
//                    a lesson plan editor, etc.  This CWinApp derived 
//                    class, CFSISuiteApp, contains a number of data 
//                    structures for keeping track of which components 
//                    are loaded.  It is code in this class that allows 
//                    for the loading and unloading of the component 
//                    libraries.  This file was generated by DevStudio.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#if !defined(_FSISUITE_H_)
#define _FSISUITE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include <multimon.h>
#include <vector>
#include "resource.h"       // main symbols

#include "FSISuiteDocTemplate.h"
#include "FSISuiteWinThread.h"

#include "..\core\ComponentInterface.h"
#include "..\core\XMLPage.h"

typedef _FSI_STL::map<_FSI_STL::string,CreateObject>   STRING2WIDGET_MAP;
typedef _FSI_STL::map<_FSI_STL::string,CXMLPage*>      STRING2XMLPAGE_MAP;
typedef _FSI_STL::map<_FSI_STL::string,CreateAction>   STRING2ACTION_MAP;

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteApp:
// See FSISuite.cpp for the implementation of this class
//

class CFSISuiteApp : public CWinApp
{
protected:
   bool  FirstInstance();

private:
    struct CacheInfo
    {
        CString     m_strFilePath;
        CXMLPage*   m_pXMLPage;
    };

    CFSISuiteDocTemplate*           m_pDocTemplate;

    void Cleanup(bool bFinalCleanup = false);

    unsigned char                   m_ucUndoSize;
    unsigned char                   m_ucFileCacheSize;
    unsigned char                   m_ucCurrentFrame;
    bool                            m_bPageFlippingInUse;

    CString                         m_strOriginalOptionsBackup;
    CCriticalSection                m_syncFileOpen;
    CCriticalSection                m_sync;

    _FSI_STL::vector<MONITORINFOEX> m_vectMonitorInfo;

    STRING2CI_MAP                   m_mapComponentInterface;

    _FSI_STL::list<CacheInfo*>      m_listXMLFileCache;

public:
	BOOL FSI_WriteProfileString( LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszValue );
	BOOL FSI_WriteProfileInt( LPCTSTR lpszSection, LPCTSTR lpszEntry, int nValue );
	CString FSI_GetProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszDefault = NULL);
	UINT FSI_GetProfileInt(LPCTSTR lpszSection, LPCTSTR lpszEntry, int nDefault);
    _FSI_STL::vector<CFSISuiteWinThread*> m_vectThreads;
    STRING2WIDGET_MAP      m_mapWidgets;
    STRING2ACTION_MAP      m_mapActions;
    _FSI_STL::list<_FSI_STL::string> m_listAvailableWidgets;
    _FSI_STL::list<_FSI_STL::string> m_listAvailableActions;

    void LoadConfigData();

    void LoadWidgets(CComponentInterface* pCI);
    void UnloadWidgets(CComponentInterface* pCI);

    // Get the directory aliases and pass them to CWidget.
    void LoadDirectories(CComponentInterface* pCI);

    STRING2CI_MAP GetComponentInterfaces();
    bool LoadComponentLibrary(const CString& rStrPathName,CComponentInterface*& rpCI);
    void LoadComponentConfig(CComponentInterface* pCI);
    bool DeleteComponentLibrary(const CString& rStrPathName);
    CComponentInterface* FindComponentInterfaceByName(const CString& rStrComponentName);
    CComponentInterface* FindComponentInterfaceByPath(const CString& rStrPathName);
	CFSISuiteApp();

    // Methods for accessing the file cache.
    void AddPage(const CString& rStrPathName, const CXMLPage* pXMLPage);
    CXMLPage* FindPage(const CString& rStrPathName);
    unsigned char CacheSize();

    void AddMonitorInfo(MONITORINFOEX mi);
    void MonitorInfo(MONITORINFOEX& mi, const unsigned char ucWindowNumber);
    void MarkWndDestroyed(CFrameWnd* pWnd);

    CDocument* OpenFile(LPCTSTR lpszFileName, const unsigned char ucWindowNumber); 

    void SetLandscape();

    // Accessors
    unsigned char MaxUndoSize();
    unsigned char MaxFileCacheSize();

    // Mutators
    void MaxUndoSize(unsigned char ucUndoSize);
    void MaxFileCacheSize(unsigned char ucFileCacheSize);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFSISuiteApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	virtual CDocument* OpenDocumentFile(LPCTSTR lpszFileName);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	//}}AFX_VIRTUAL

// Implementation
	//{{AFX_MSG(CFSISuiteApp)
	afx_msg void OnAppAbout();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

   protected:
      void  SetVideoModeAndColors(void);
      void  RestoreVideoModeAndColors(void);

      DWORD m_old_COLOR_3DFACE;
      DWORD m_old_COLOR_MENU;
      DWORD m_old_COLOR_MENUTEXT;
      DWORD m_old_COLOR_WINDOWTEXT;
      DWORD m_old_COLOR_HIGHLIGHT;
      DWORD m_old_COLOR_HIGHLIGHTTEXT;
      DWORD m_old_COLOR_WINDOW;
      DWORD m_old_COLOR_BTNHIGHLIGHT;
      DWORD m_old_COLOR_3DSHADOW;

};

#define  NUMBER_OF_COLORS  9     // Count them! they are listed right above here.

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_FSISUITE_H_)
