/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FSISuite.cpp
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : FSISuite.cpp contains the implementation of the 
//                    CFSISuiteApp class.  Methods with additional 
//                    functionality here are InitInstance, 
//                    ExitInstance, OpenDocumentFile, 
//                    GetNextComponentInterface, LoadComponentLibrary, 
//                    LoadWidgets, and DeleteComponentLibrary.  This 
//                    file was generated by DevStudio.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include <afxadv.h>
#include "FSISuite.h"
#include "AboutDlg.h"

#define COMPILE_MULTIMON_STUBS
#include <multimon.h>

#include "MainFrm.h"
#include "FSISuiteDoc.h"
#include "FSISuiteView.h"
#include "FSISuiteWinThread.h"
#include "FSISuiteCommandLineInfo.h"

#include "Options.h"

#include "..\core\PageWidget.h"

#include "..\core\TLFrame.h"

#include "depthpage.h"

#include <algorithm>
#include <direct.h>
#include "winspool.h"

// Include DAO support in the main app so that it - instead of the DLL that's actually using it - cleans up DAO upon exit.
#include <afxdao.h>			// MFC DAO database classes
static   CDaoWorkspace  dummyDaoWorkspace;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFSISuiteApp

BEGIN_MESSAGE_MAP(CFSISuiteApp, CWinApp)
	//{{AFX_MSG_MAP(CFSISuiteApp)
    ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

BOOL CALLBACK EnumMonitorProc(HMONITOR hMonitor, HDC hdcMonitor, 
                              LPRECT lprcMonitor, LPARAM dwData)
{
//    hdcMonitor = ::GetDC(hMonitor);
    CFSISuiteApp* pApp = (CFSISuiteApp*)dwData;

    MONITORINFOEX mi;        
    mi.cbSize = sizeof(mi);
    GetMonitorInfo(hMonitor, (MONITORINFO*)&mi);
    pApp->AddMonitorInfo(mi);
//        mi.rcMonitor.right-mi.rcMonitor.left,
//                       mi.rcMonitor.bottom-mi.rcMonitor.top);
    return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
//
// CFSISuiteApp::CFSISuiteApp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : Default constuctor.
//
/////////////////////////////////////////////////////////////////////////////
CFSISuiteApp::CFSISuiteApp()
{
    m_ucUndoSize        = (ucMAX_UNDO_DEPTH - ucMIN_UNDO_DEPTH)/2;
    m_ucFileCacheSize   = (ucMAX_FILE_CACHE - ucMIN_FILE_CACHE)/2;
    m_ucCurrentFrame    = 0;
    m_bPageFlippingInUse = false;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CFSISuiteApp object

CFSISuiteApp theApp;

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CFSISuiteApp::InitInstance()
//
// Inputs           : None.
//
// Return Values    : true - if no problems occurred
//                    false - the application could not start
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : InitInstance initializes a number of libraries, 
//                    load the configuration data from a file or the 
//                    registry, registers the document and view, and 
//                    creates the main window.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CFSISuiteApp::InitInstance()
{  
   if (!FirstInstance())
   {
      MessageBox(NULL, "An instance of the IOS is already running!\nPlease select that one.", "NOTICE", MB_OK);
      exit(1);
   }

   SetVideoModeAndColors();

	AfxEnableControlContainer();

	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	SetRegistryKey(_T("FlightSafety"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

    // Add the page widget for display in the main view and on overlays.
    char cWidgetName[256];
    CWidget* pWidget = new CPageWidget;
    strcpy(cWidgetName,pWidget->WidgetName().c_str());
    m_listAvailableWidgets.push_front(_FSI_STL::string(strupr(cWidgetName)));
    m_mapWidgets[strupr(cWidgetName)] = CPageWidget::CreateObject;
    pWidget->Deleting(true);

    EnumDisplayMonitors(NULL,NULL,EnumMonitorProc,(long)this);

    long int lUseAllDisplays = FSI_GetProfileInt(_T("Settings"),
                                             _T("UseAllDisplays"), 0);

    if (m_vectMonitorInfo.size() == 1)
    {
        long int lScreenX = GetSystemMetrics(SM_CXSCREEN);
        long int lScreenY = GetSystemMetrics(SM_CYSCREEN);

        m_vectMonitorInfo[0].rcMonitor.left = 0;
        m_vectMonitorInfo[0].rcMonitor.top = 0;
		//CRect rectWork;
		//SystemParametersInfo(SPI_GETWORKAREA, NULL, &rectWork, NULL);
        if (lUseAllDisplays != 0)
        {
            m_vectMonitorInfo[0].rcMonitor.right = lScreenX/2;
            m_vectMonitorInfo[0].rcMonitor.bottom = lScreenY;
        }
        else
        {
            m_vectMonitorInfo[0].rcMonitor.right = lScreenX;
            m_vectMonitorInfo[0].rcMonitor.bottom = lScreenY;
        }
    }

	// Register document templates

	m_pDocTemplate = new CFSISuiteDocTemplate;
	AddDocTemplate(m_pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CFSISuiteCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)((CMainFrame*)m_pMainWnd)->GetActiveDocument();

    pDoc->OnScreenView((CFSISuiteView*)((CMainFrame*)m_pMainWnd)->GetActiveView());
    CTLFrame::RegisterClass();

    char* cTempFileName = _tempnam("c:\\temp","fsiopt");
    if (cTempFileName != NULL)
    {
        // Delete any old copies of fsiopt. This will mean that
        // only one instance can be run on a machine and be able
        // to undo changes to the registry.
        WIN32_FIND_DATA wfd;
        CString strDir = CString(cTempFileName);
        strDir.MakeReverse();
        strDir = strDir.Mid(strDir.Find("\\"));
        strDir.MakeReverse();
        CString strFile = strDir + "fsiopt*.*";
        HANDLE handle = FindFirstFile(strFile, &wfd);
        while (handle != INVALID_HANDLE_VALUE)
        {
            DeleteFile(strDir + wfd.cFileName);
            FindClose(handle);
            handle = FindFirstFile(strFile, &wfd);
        }

        HKEY hKey;
        RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite"), 0, KEY_READ, &hKey);

        if (hKey != NULL)
        {
            static HANDLE           hToken;   
            static TOKEN_PRIVILEGES tp;
            static LUID             luid;   
    
            // Enable backup privilege.
            OpenProcessToken( GetCurrentProcess(),
                              TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken ) ;
            LookupPrivilegeValue( NULL, "SeBackupPrivilege", &luid );
            tp.PrivilegeCount           = 1;   
            tp.Privileges[0].Luid       = luid;
            tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
            AdjustTokenPrivileges( hToken, FALSE, &tp,
                                   sizeof(TOKEN_PRIVILEGES), NULL, NULL );

            // Insert your code here to save the registry keys/subkeys.
            RegSaveKey(hKey, cTempFileName, NULL);

            // Disable backup privilege.
            AdjustTokenPrivileges( hToken, TRUE, &tp, sizeof(TOKEN_PRIVILEGES),
                                   NULL, NULL );
            RegCloseKey(hKey);
            m_strOriginalOptionsBackup = CString(cTempFileName);
            free(cTempFileName);
        }
    }

    // Put the printer into landscape mode.
    SetLandscape();

    if (lUseAllDisplays != 0)
    {
        // Special code for two windows that are half the size of the
        // entire screen.  Used with NT4 and multimonitors.
        if (m_vectMonitorInfo.size() == 1)
        {
            long int lScreenX = GetSystemMetrics(SM_CXSCREEN);
            long int lScreenY = GetSystemMetrics(SM_CYSCREEN);
            CRect rect[2];
			//CRect rectWork;
			//SystemParametersInfo(SPI_GETWORKAREA, NULL, &rectWork, NULL);
            rect[0] = m_vectMonitorInfo[0].rcMonitor;
            rect[1] = CRect(lScreenX/2+1,0,lScreenX,lScreenY);

            CFSISuiteWinThread* pThread = (CFSISuiteWinThread*)AfxBeginThread(RUNTIME_CLASS(CFSISuiteWinThread),
                                                              THREAD_PRIORITY_NORMAL,
                                                              0, CREATE_SUSPENDED);

			pThread->m_prectSize = new CRect(rect[1]);
            m_vectThreads.push_back(pThread);
            pThread->ResumeThread();
            WaitForSingleObject((HANDLE)(pThread->m_evMessage), INFINITE);
            pThread->m_evMessage.ResetEvent();
        }
        else
        {
            CRect rectMainWnd;
            m_pMainWnd->GetWindowRect(rectMainWnd);

            _FSI_STL::vector<MONITORINFOEX>::iterator vIt       = m_vectMonitorInfo.begin();
            _FSI_STL::vector<MONITORINFOEX>::iterator vendIt    = m_vectMonitorInfo.end();

            while (vIt != vendIt)
            {
                CRect rect((*vIt).rcMonitor);
                if (rect != rectMainWnd)
                {
                    CFSISuiteWinThread* pThread = (CFSISuiteWinThread*)AfxBeginThread(RUNTIME_CLASS(CFSISuiteWinThread),
                                                                      THREAD_PRIORITY_NORMAL,
                                                                      0, CREATE_SUSPENDED);

			        pThread->m_prectSize = new CRect((*vIt).rcMonitor);
                    m_vectThreads.push_back(pThread);
                    pThread->ResumeThread();
                    WaitForSingleObject((HANDLE)(pThread->m_evMessage), INFINITE);
                    pThread->m_evMessage.ResetEvent();
                }

                vIt++;
            }
        }
    }

    LoadConfigData();

    // Turn off some message boxes that would get in the way 
    // during page flip testing.
    if (cmdInfo.PageFlipTestRest()      != "" || 
        cmdInfo.PageFlipTestLength()    != "")
    {
        m_bPageFlippingInUse = true;
    }

    if (lUseAllDisplays != 0)
    {
        CMainFrame* pFrame = dynamic_cast<CMainFrame*>(m_pMainWnd);

        if (pFrame->GetActiveView() != NULL)
        {
            CRect r;
            pFrame->GetActiveView()->GetClientRect(r);
            pFrame->GetActiveView()->ClientToScreen(r);
            pFrame->ScreenToClient(r);

            CDC* pDC = pFrame->GetDC();

            if (pDoc != NULL)
            {
                pDC->FillSolidRect(r, (COLORREF)pDoc->PageColor());
            }

            pFrame->ReleaseDC(pDC);
        }

        if (cmdInfo.ComponentName() != "")
        {
            pFrame->StartAs(cmdInfo.ComponentName());
            CComponentInterface* pCI = 
                    FindComponentInterfaceByName(cmdInfo.ComponentName());

            if (pCI != NULL)
            {
                STRING2STRING_MAP* pMap = pCI->Directories();
                if (pMap != NULL)
                {
                    if (pMap->find("PAGES") != pMap->end())
                    {
                        chdir(pMap->find("PAGES")->second.c_str());
                    }
                }
            }
        }

        if (cmdInfo.PageFlipTestRest()      != "" || 
            cmdInfo.PageFlipTestLength()    != "")
        {
            pFrame->PageFlipTestRest(cmdInfo.PageFlipTestRest());
            pFrame->PageFlipTestLength(cmdInfo.PageFlipTestLength());
            pFrame->PerformPageFlipTest();
        }

        m_pMainWnd->EnableWindow();
        m_pMainWnd->UpdateWindow();

        unsigned int un = 0;
        CString* pstrComponent;
        while (un < m_vectThreads.size())
        {
            pstrComponent = new CString(cmdInfo.ComponentName());
            ::PostThreadMessage(m_vectThreads[un]->m_nThreadID,
                                TM_START_AS, 0, (long)pstrComponent);
            WaitForSingleObject((HANDLE)(m_vectThreads[un]->m_evMessage),
                                INFINITE);

            m_vectThreads[un]->m_evMessage.ResetEvent();

            pFrame = dynamic_cast<CMainFrame*>(m_vectThreads[un]->m_pMainWnd);

            if (cmdInfo.PageFlipTestRest()      != "" || 
                cmdInfo.PageFlipTestLength()    != "")
            {
                pFrame->PageFlipTestRest(cmdInfo.PageFlipTestRest());
                pFrame->PageFlipTestLength(cmdInfo.PageFlipTestLength());
                pFrame->PerformPageFlipTest();
            }

            m_vectThreads[un]->m_pMainWnd->EnableWindow();
            m_vectThreads[un]->m_pMainWnd->UpdateWindow();

            un++;
        }
    }
    else
    {
        CMainFrame* pFrame = dynamic_cast<CMainFrame*>(m_pMainWnd);

        if (pFrame->GetActiveView() != NULL)
        {
            CRect r;
            pFrame->GetActiveView()->GetClientRect(r);
            pFrame->GetActiveView()->ClientToScreen(r);
            pFrame->ScreenToClient(r);

            CDC* pDC = pFrame->GetDC();

            if (pDoc != NULL)
            {
                pDC->FillSolidRect(r, (COLORREF)pDoc->PageColor());
            }

            pFrame->ReleaseDC(pDC);
        }

        if (cmdInfo.ComponentName() != "")
        {
            ((CMainFrame*)m_pMainWnd)->StartAs(cmdInfo.ComponentName());
            CComponentInterface* pCI = 
                    FindComponentInterfaceByName(cmdInfo.ComponentName());

            if (pCI != NULL)
            {
                STRING2STRING_MAP* pMap = pCI->Directories();
                if (pMap != NULL)
                {
                    if (pMap->find("PAGES") != pMap->end())
                    {
                        chdir(pMap->find("PAGES")->second.c_str());
                    }
                }
            }
        }

        if (cmdInfo.PageFlipTestRest()      != "" || 
            cmdInfo.PageFlipTestLength()    != "")
        {
            pFrame->PageFlipTestRest(cmdInfo.PageFlipTestRest());
            pFrame->PageFlipTestLength(cmdInfo.PageFlipTestLength());
            pFrame->PerformPageFlipTest();
        }

        m_pMainWnd->EnableWindow();
        m_pMainWnd->UpdateWindow();
    }

    SetProcessWorkingSetSize(GetCurrentProcess(), -1, -1);


    // Open a dummy DAO workspace so that the main app - instead of the DLL that's actually using it - cleans up DAO upon exit.
    dummyDaoWorkspace.Open();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
// int CFSISuiteApp::ExitInstance()
//
// Inputs           : None.
//
// Return Values    : Returns an error value.
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : ExitInstance cleans up the memory associated with 
//                    the data structures for keeping track of which 
//                    components are loaded.  This is called after a 
//                    request to exit the application.
//
/////////////////////////////////////////////////////////////////////////////
int CFSISuiteApp::ExitInstance() 
{
   Cleanup(true);

   RestoreVideoModeAndColors();

	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
//
// CDocument* CFSISuiteApp::OpenDocumentFile()
//
// Inputs           : LPCTSTR lpszFileName - a pointer to the string 
//                    containing the full path to a file.
//
// Return Values    : NULL is the file could not be opened.
//                    
//                    A pointer to an instance of CFSISuiteDoc if the 
//                    file could be opened.
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : OpenDocumentFile responds to a request to open a 
//                    file.  The existance of the file is checked 
//                    before preceding with trying to open the file.  
//                    If no file exists with the given path, an error 
//                    message is logged. THIS METHOD SHOULD NEVER BE INVOKED
//                    EXCEPT BY CFSISuiteApp::OpenFile()!!!!!
//
/////////////////////////////////////////////////////////////////////////////
CDocument* CFSISuiteApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{
    CString strFileName(lpszFileName);

    if (strFileName.Find("^") > -1)
    {
        CWidget::ExpandPath(strFileName);
    }

    // Check to see if the file exists by using GetFileAttributes.
    // If the return value is not 0xFFFFFFFF, the the file exists
    // and the current document can be changed.
    if (::GetFileAttributes(strFileName) != 0xFFFFFFFF)
    {
        CDocument* pDoc = NULL;
        if (m_ucCurrentFrame != 0)
        {
            CString* strFile = new CString(strFileName);
            ::PostThreadMessage(m_vectThreads[m_ucCurrentFrame - 1]->m_nThreadID,
                                TM_OPEN_DOCUMENT, (long)pDoc, (long)strFile);
        }
        else
        {
            pDoc = m_pDocTemplate->OpenDocumentFile(strFileName);
        }

        return pDoc;
    }   
    else
    {
        if (!m_bPageFlippingInUse)
        {
            if (m_ucCurrentFrame != 0)
            {
                ::MessageBox(m_vectThreads[m_ucCurrentFrame-1]->m_pMainWnd->GetSafeHwnd(),
                             _T("\"" + strFileName + "\" could not be opened."),
                             _T("Error"),
                             MB_OK);
            }
            else
            {
                ::MessageBox(m_pMainWnd->GetSafeHwnd(),
                             _T("\"" + strFileName + "\" could not be opened."),
                             _T("Error"),
                             MB_OK);
            }
        }
    }
	return NULL;
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CFSISuiteApp::LoadComponentLibrary()
//
// Inputs           : CString& rStrPathName - the path to the DLL
//                    CComponentInterface*& rpCI - a reference to a 
//                    pointer for the new instance of a class derived 
//                    from CComponentInterface.
//
// Return Values    : true - if the library was loaded and the 
//                    component interface was created.
//                    false - problems occurred
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : LoadComponentLibrary should be called whenever a 
//                    component library needs to be loaded.  An attempt 
//                    will be made to load the library into memory.  
//                    Then an attempt will be made to get a pointer to 
//                    an exported method that should create an instance 
//                    of a class derived from CComponentInterface.  If 
//                    all goes well, a new tab will be added in the 
//                    page edit view and a button will be added to the 
//                    component bar if the component library data shows 
//                    that it needs to be there.  The CComponentProp 
//                    class currently makes use of this method.
//
/////////////////////////////////////////////////////////////////////////////
bool CFSISuiteApp::LoadComponentLibrary(const CString& rStrPathName, 
                                        CComponentInterface*& rpCI)
{
	bool bRetVal = true;
    HINSTANCE hDLL;               // Handle to DLL

    // Typedef for the signature of the method that each library is supposed
    // to implement to get a pointer to the interface that is implement in 
    // the libary.
    typedef bool (__cdecl* LPFNDLLCI)(CComponentInterface*& pCI, 
                                      _FSI_STL::string stlStrPathName);
    LPFNDLLCI lpfnDllCI;        // Function pointer

    // Load the library.
    hDLL = AfxLoadLibrary(rStrPathName);  
     if (hDLL != NULL)
    {
        // Since the library was loaded, get a pointer to the method
        // that creates an instance of the interface class.
        lpfnDllCI = (LPFNDLLCI)GetProcAddress(hDLL,
											    "ComponentInterface");

        // If the ComponentInterface method is not implemented and exported,
        // then free the library and return false.
        if (!lpfnDllCI)   
        {
            // handle the error      
            AfxFreeLibrary(hDLL);       
            bRetVal =  false;   
        }  
        else
        {
            // Else, if an instatiation of the ComponentInterface can not
            // be created (lpgnDLLCI(pCI) returns false) then free the 
            // library.
            CComponentInterface* pCI = NULL;
            if (lpfnDllCI(pCI,_FSI_STL::string((LPCTSTR)rStrPathName)) != false)
            {
                // If a library with the same path was already loaded,
                // then free the old library and set the map to the
                // new library.  This conditional may not be necessary
                // since loading the same library would probably mean that
                // a new version of the library was able and someone wanted
                // to load the new library.  It should not be possible to 
                // copy a new DLL over an existing DLL that is loaded into 
                // memory.  The other case where this would happen is if
                // someone just forgot what they were doing and tried to 
                // load the same library twice.
                CString strPathName(rStrPathName);
                strPathName.MakeUpper();
                if (m_mapComponentInterface.find(_FSI_STL::string((LPCSTR)strPathName)) != 
					m_mapComponentInterface.end())
                {
                    CComponentInterface* pMapCI = 
                                m_mapComponentInterface[(LPCSTR)strPathName];
                    if (pMapCI != NULL)
                    {
                        DeleteComponentLibrary(strPathName);
                    }
                }

                // Store the handle for the library for later freeing.
                pCI->DLLHandle(hDLL);

                // Add the pointer to the interface to the map data structure 
                // and return the new pointer.
                m_mapComponentInterface[(LPCSTR)strPathName] = pCI;
                rpCI = pCI;

                _FSI_STL::string  stlStrComponentName = pCI->ComponentName();

                LoadWidgets(pCI);

                CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
                CFSISuiteDoc* pDoc = 
                              (CFSISuiteDoc*)(pFrame->GetActiveDocument());

                CXMLPage* pXMLPage = pDoc->XMLPage();
                if (pXMLPage != NULL) 
                {
                    STRING_LIST::iterator slIt = m_listAvailableWidgets.begin();
                    while (slIt != m_listAvailableWidgets.end())
                    {
                        pXMLPage->AddAvailableWidget(*slIt);

                        slIt++;
                    }
                    slIt = m_listAvailableActions.begin();
                    while (slIt != m_listAvailableActions.end())
                    {
                        pXMLPage->AddAvailableWidget(*slIt);
                        slIt++;
                    }
                }

                
                _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = 
                                                        m_vectThreads.begin();
                while (vIt != m_vectThreads.end())
                {
                    ::PostThreadMessage((*vIt)->m_nThreadID,
                                        TM_LOAD_COMPONENT, 0, 0);
                    WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
                    (*vIt)->m_evMessage.ResetEvent();

                    vIt++;
                }

            }
            else
            {
                // A new component interface could not be created.
                AfxFreeLibrary(hDLL);
                bRetVal = false;
            }

        }
    }
	else
	{
        // The DLL could not be loaded.
		bRetVal = false;
	}

	return bRetVal;
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CFSISuiteApp::DeleteComponentLibrary()
//
// Inputs           : CString& rStrPathName - the path to the library
//
// Return Values    : true - the library was loaded
//                    false - the library was not loaded
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : DeleteComponentLibrary will check to see if the 
//                    library designated by rStrPathName is loaded.  If 
//                    it is, then the tab from the page edit view will 
//                    be deleted, the resources in the component bar 
//                    will be freed, and finally, the library will be 
//                    freed and the map updated to show that it is no 
//                    longer loaded.  This method is currently used by 
//                    the CComponentProp class.
//
/////////////////////////////////////////////////////////////////////////////
bool CFSISuiteApp::DeleteComponentLibrary(const CString& rStrPathName)
{
    bool bRetVal = true;
    CComponentInterface* pCI = NULL;
    CString strPathName(rStrPathName);
    strPathName.MakeUpper();
    pCI = m_mapComponentInterface[(LPCSTR)strPathName];
    if (pCI != NULL)
    {
        // The library at rStrPathName was loaded at some time.

        _FSI_STL::string  stlStrComponentName = pCI->ComponentName();
        _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = NULL;

        pCI->CleanComponentResources();

        // Based on the information in the Component Config file, do 
        // nothing, delete a button from the component bar 
        // (CMainFrame::DeleteComponent), or delete a group button from the
        // component bar (CMainFrame::DeleteComponentGroup).
        if (pCI->OnComponentBar() == true)
        {
            CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
            pFrame->DeleteComponent(stlStrComponentName);

            vIt = m_vectThreads.begin();

            while (vIt != m_vectThreads.end())
            {
                ::PostThreadMessage((*vIt)->m_nThreadID, 
                                    TM_DELETE_COMPONENT_GROUP, 0, (long)pCI);
                WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
                (*vIt)->m_evMessage.ResetEvent();

                vIt++;
            }
        }

        m_pDocTemplate->OpenDocumentFile(NULL);
        m_pMainWnd->Invalidate(FALSE);

        vIt = m_vectThreads.begin();
        while (vIt != m_vectThreads.end())
        {
            CDocument* pDoc = NULL;
            ::PostThreadMessage((*vIt)->m_nThreadID, TM_OPEN_DOCUMENT, (long)pDoc,NULL);
            WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
            (*vIt)->m_evMessage.ResetEvent();
            (*vIt)->m_pMainWnd->Invalidate(FALSE);

            vIt++;
        }

        UnloadWidgets(pCI);

        if (pCI->OnEditBar() == true)
        {

            CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;

            CEditorControls* pEC = pFrame->EditorControls();
            pEC->DeleteTab(CString(pCI->ComponentName().c_str()));

            _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = 
                                                    m_vectThreads.begin();
            while (vIt != m_vectThreads.end())
            {
                ::PostThreadMessage((*vIt)->m_nThreadID,
                                    TM_DELETE_COMPONENT, 0, (long)pCI);
                WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
                (*vIt)->m_evMessage.ResetEvent();

                vIt++;
            }
        }

        // Reset the window to a default state.
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;

        pFrame->DeleteComponentSpecific();
        pFrame->NullComponent();

        vIt = m_vectThreads.begin();
        while (vIt != m_vectThreads.end())
        {
            ::PostThreadMessage((*vIt)->m_nThreadID,
                                TM_DELETE_COMPONENT_SPECIFIC, 0, 0);
            WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
            (*vIt)->m_evMessage.ResetEvent();

            vIt++;
        }

        // Free the library and update the map to show that it is not
        // loaded (a NULL pointer value).
        HINSTANCE hDLL;
        hDLL = pCI->DLLHandle();

        delete pCI;
        AfxFreeLibrary(hDLL);
        m_mapComponentInterface[_FSI_STL::string((LPCSTR)strPathName)] = NULL;
    }
    else
    {
        // The library was not laoded.
        bRetVal = false;
    }

    return bRetVal;
}

CComponentInterface* CFSISuiteApp::FindComponentInterfaceByName(
                                              const CString& rStrComponentName)
{
    STRING2CI_MAP::iterator s2ciIt = m_mapComponentInterface.begin();
    _FSI_STL::string stlStrComponentName((LPCTSTR)rStrComponentName);

    while (s2ciIt != m_mapComponentInterface.end())
    {
        if ((*s2ciIt).second != NULL)
        {
            if ((*s2ciIt).second->ComponentName() == stlStrComponentName)
            {
                return (*s2ciIt).second;
            }
        }

        s2ciIt++;
    }

    return NULL;
}

CComponentInterface* CFSISuiteApp::FindComponentInterfaceByPath(
                                                   const CString& rStrPathName)
{
    CString strPathName(rStrPathName);
    strPathName.MakeUpper();
    STRING2CI_MAP::iterator s2ciIt = m_mapComponentInterface.find(
                                                        (LPCTSTR)strPathName);

    if (s2ciIt != m_mapComponentInterface.end())
    {
        return (*s2ciIt).second;
    }

    return NULL;
}

/////////////////////////////////////////////////////////////////////////////
//
// CComponentInterface* CFSISuiteApp::GetNextComponent
//                    Interface()
//
// Inputs           : STRING2CI_MAP::iterator& rs2ciIt - a reference to 
//                    an iterator for stepping through the map of 
//                    component libraries
//
// Return Values    : NULL if no component libraries are loaded of if a 
//                    component library has been loaded but is no 
//                    longer loaded.
//                    
//                    Or, a pointer to an instance of a 
//                    CComponentInterface derived class.
//
// Date             : 20 October 1998
//
// Engineer         : Billy Baker
//
// Description      : GetNextComponentInterface is an accessor method 
//                    used to step through the private map of path 
//                    names to pointers of classes derived from 
//                    CComponentInterface.  To step through the entire
//                    map, the return value should not be checked for NULL
//                    since a library may have been loaded but is no longer
//                    loaded.  
//
/////////////////////////////////////////////////////////////////////////////
STRING2CI_MAP CFSISuiteApp::GetComponentInterfaces()
{
    STRING2CI_MAP s2cimap = m_mapComponentInterface;
    return s2cimap;
}

void CFSISuiteApp::LoadComponentConfig(CComponentInterface* pCI)
{
    if (pCI != NULL)
    {
        // Based on the information in the Component Config file, do 
        // nothing, add a button to the component bar 
        // (CMainFrame::AddComponent), or add a group button to the
        // component bar (CMainFrame::AddComponentGroup).
        STRING_LIST::iterator slIt = m_listAvailableWidgets.begin();
        while (slIt != m_listAvailableWidgets.end())
        {
            pCI->AddAvailableWidget(*slIt);

            slIt++;
        }
        slIt = m_listAvailableActions.begin();
        while (slIt != m_listAvailableActions.end())
        {
            pCI->AddAvailableWidget(*slIt);
            slIt++;
        }

        pCI->LoadComponentConfig();

        if (pCI->OnComponentBar() == true)
        {
            CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;
            pFrame->AddComponent(pCI->ComponentName());

            _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = 
                                                    m_vectThreads.begin();
            while (vIt != m_vectThreads.end())
            {
                ::PostThreadMessage((*vIt)->m_nThreadID,
                                    TM_LOAD_CONFIG_COMPONENT, 0, (long)pCI);
                WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
                (*vIt)->m_evMessage.ResetEvent();

                vIt++;
            }
        }

        // Update edit bar data structures.
        if (pCI->OnEditBar() == true)
        {
            CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;

            CEditorControls* pEC = pFrame->EditorControls();
            pEC->AddTab(pCI);

            _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = 
                                                    m_vectThreads.begin();
            while (vIt != m_vectThreads.end())
            {
                ::PostThreadMessage((*vIt)->m_nThreadID,
                                    TM_LOAD_CONFIG_EDIT, 0, (long)pCI);
                WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);
                (*vIt)->m_evMessage.ResetEvent();

                vIt++;
            }
        }
    }
}

void CFSISuiteApp::LoadConfigData()
{
    Cleanup();

    // Add the page widget for display in the main view and on overlays.
    char cWidgetName[256];

    CWidget* pWidget = new CPageWidget;
    strcpy(cWidgetName,pWidget->WidgetName().c_str());
    m_listAvailableWidgets.push_front(_FSI_STL::string(strupr(cWidgetName)));
    m_mapWidgets[strupr(cWidgetName)] = CPageWidget::CreateObject;
    pWidget->Deleting(true);

    m_ucUndoSize = FSI_GetProfileInt(_T("Settings"), _T("UndoSize"), m_ucUndoSize);
    FSI_WriteProfileInt(_T("Settings"), _T("UndoSize"), m_ucUndoSize);
    m_ucFileCacheSize = FSI_GetProfileInt(_T("Settings"), _T("FileCacheSize"), 
                                      m_ucFileCacheSize);
    FSI_WriteProfileInt(_T("Settings"), _T("FileCacheSize"), m_ucFileCacheSize);

    // Set the use scale value for each document.
    CFSISuiteDoc* pDoc = (CFSISuiteDoc*)((CMainFrame*)m_pMainWnd)->GetActiveDocument();
    if (pDoc != NULL)
    {
        pDoc->UseScale(FSI_GetProfileInt(_T("Settings"), _T("UseScale"), 0));
        FSI_WriteProfileInt(_T("Settings"), _T("UseScale"), pDoc->UseScale());
    }

    // Set the help file
    CMainFrame* pFrame = dynamic_cast<CMainFrame*>(m_pMainWnd);
    if (pFrame != NULL)
    {
        pFrame->HelpFile(_FSI_STL::string((LPCTSTR)FSI_GetProfileString(_T("Settings"), 
                                                                    _T("HelpFile"), 
                                                                    NULL)));
        FSI_WriteProfileString(_T("Settings"), _T("HelpFile"), pFrame->HelpFile().c_str());
    }

    long int lLibraryCount = 0;
    long int lLibraryStep = 1;
    lLibraryCount = FSI_GetProfileInt(_T("Settings"),_T("LibraryCount"), 0);
    CString strLibraryXXX;
    CString strLibraryPath;

    while (lLibraryStep <= lLibraryCount)
    {
        strLibraryXXX.Format("Library%d",lLibraryStep);
        strLibraryPath = FSI_GetProfileString(_T("Settings"),
                                          (LPCTSTR)strLibraryXXX,"");
        if (strLibraryPath != "")
        {
            CComponentInterface* pCI = NULL;
            LoadComponentLibrary(strLibraryPath, pCI);
        }

        lLibraryStep++;
    }

    STRING2CI_MAP::iterator s2ciIt = m_mapComponentInterface.begin();
    while (s2ciIt != m_mapComponentInterface.end())
    {
        if ((*s2ciIt).second != NULL)
        {
            LoadComponentConfig((*s2ciIt).second);
            LoadDirectories((*s2ciIt).second);
        }

        s2ciIt++;
    }

    s2ciIt = m_mapComponentInterface.begin();
    while (s2ciIt != m_mapComponentInterface.end())
    {
        if ((*s2ciIt).second != NULL)
        {
            (*s2ciIt).second->InitComplete();
        }

        s2ciIt++;
    }

    s2ciIt = m_mapComponentInterface.begin();
    while (s2ciIt != m_mapComponentInterface.end())
    {
        if ((*s2ciIt).second != NULL)
        {
            (*s2ciIt).second->AfterInitComplete();
        }

        s2ciIt++;
    }
}

void CFSISuiteApp::LoadWidgets(CComponentInterface* pCI)
{
    // The map contains pointers to static CreateObject methods in
    // each widget class.  
	_FSI_STL::list<CreateObject>* pWidgetCtrls = pCI->WidgetCtrls();

	_FSI_STL::list<CreateObject>::iterator lcoIt = pWidgetCtrls->begin(); 
    char cWidgetName[256];
    CWidget* pWidget = NULL;
    while (lcoIt != pWidgetCtrls->end())
    {
        pWidget = (*lcoIt)();
        strcpy(cWidgetName,pWidget->WidgetName().c_str());
        m_listAvailableWidgets.push_front(_FSI_STL::string(strupr(cWidgetName)));
        m_mapWidgets[strupr(cWidgetName)] = *lcoIt;
        pWidget->Deleting(true);

        lcoIt++;
    }

	_FSI_STL::list<CreateAction>* pActions = pCI->Actions();

	_FSI_STL::list<CreateAction>::iterator laIt = pActions->begin();
    char cActionName[256];
    CWidget* pAction = NULL;
    while (laIt != pActions->end())
    {
        pAction = (*laIt)();
        strcpy(cActionName,pAction->WidgetName().c_str());
        m_listAvailableActions.push_front(_FSI_STL::string(strupr(cActionName)));
        m_mapActions[strupr(cActionName)] = *laIt;
        pAction->Deleting(true);

        laIt++;
    }
}

void CFSISuiteApp::SetLandscape()    
{
    PRINTDLG   pd;

    pd.lStructSize = (DWORD) sizeof(PRINTDLG);
    if (GetPrinterDeviceDefaults(&pd))
    {
        // Lock memory handle.
        DEVMODE FAR* pDevMode =
            (DEVMODE FAR*)::GlobalLock(m_hDevMode);
        LPDEVNAMES lpDevNames;
        LPTSTR lpszDriverName, lpszDeviceName, lpszPortName;
        HANDLE hPrinter;


        if (pDevMode)
        {
            // Change printer settings in here.
            pDevMode->dmOrientation = DMORIENT_LANDSCAPE;

            // Unlock memory handle.
            lpDevNames = (LPDEVNAMES)GlobalLock(pd.hDevNames);
            lpszDriverName = (LPTSTR )lpDevNames + lpDevNames->wDriverOffset;
            lpszDeviceName = (LPTSTR )lpDevNames + lpDevNames->wDeviceOffset;
            lpszPortName   = (LPTSTR )lpDevNames + lpDevNames->wOutputOffset;

            OpenPrinter(lpszDeviceName, &hPrinter, NULL);
            DocumentProperties(NULL,hPrinter,lpszDeviceName,pDevMode,
                           pDevMode, DM_IN_BUFFER|DM_OUT_BUFFER);

            // Sync the pDevMode.
            // See SDK help for DocumentProperties for more info.
			ClosePrinter(hPrinter);
			::GlobalUnlock(m_hDevNames);
			::GlobalUnlock(m_hDevMode);
       }
	}
}

void CFSISuiteApp::UnloadWidgets(CComponentInterface* pCI)
{
    // The map contains pointers to static CreateObject methods in
    // each widget class.  
	_FSI_STL::list<CreateObject>* pWidgetCtrls = pCI->WidgetCtrls();

	_FSI_STL::list<CreateObject>::iterator lcoIt = pWidgetCtrls->begin(); 
    CWidget* pWidget = NULL;
    _FSI_STL::list<_FSI_STL::string>::iterator lDelStrIt = NULL;
    STRING2WIDGET_MAP::iterator lDelWidIt;

    char cWidgetName[256];
    while (lcoIt != pWidgetCtrls->end())
    {
        pWidget = (*lcoIt)();
        strcpy(cWidgetName,pWidget->WidgetName().c_str());
        pWidget->Deleting(true);
        lDelStrIt = _FSI_STL::find(m_listAvailableWidgets.begin(),
                              m_listAvailableWidgets.end(),
                              _FSI_STL::string(strupr(cWidgetName)));
        if (lDelStrIt != m_listAvailableWidgets.end())
        {
           m_listAvailableWidgets.erase(lDelStrIt); 
        }

        lDelWidIt = m_mapWidgets.find(strupr(cWidgetName));
        if (lDelWidIt != m_mapWidgets.end())
        {
            m_mapWidgets.erase(lDelWidIt);
        }

        lcoIt++;
    }

	_FSI_STL::list<CreateAction>* pActions = pCI->Actions();

	_FSI_STL::list<CreateAction>::iterator laIt = pActions->begin(); 
    CWidget* pAction = NULL;
    lDelStrIt = NULL;
    STRING2ACTION_MAP::iterator lDelActIt;

    char cActionName[256];
    while (laIt != pActions->end())
    {
        pAction = (*laIt)();
        strcpy(cActionName,pAction->WidgetName().c_str());
        pAction->Deleting(true);
        lDelStrIt = _FSI_STL::find(m_listAvailableActions.begin(),
                              m_listAvailableActions.end(),
                              _FSI_STL::string(strupr(cActionName)));
        if (lDelStrIt != m_listAvailableActions.end())
        {
           m_listAvailableActions.erase(lDelStrIt); 
        }

        lDelActIt = m_mapActions.find(strupr(cActionName));
        if (lDelActIt != m_mapActions.end())
        {
            m_mapActions.erase(lDelActIt);
        }

        laIt++;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteApp::AddPage()
//
// Inputs           : const CString& rStrPathName - the path to the 
//                    file that was just opened.
//                    const CXMLPage* pXMLPage - a pointer to a 
//                    CXMLPage class that stores the data from a file.
//
// Return Values    : None.
//
// Date             : 03 November 1998
//
// Engineer         : Billy Baker
//
// Description      : AddPage add the pass CXMLPage pointer to the 
//                    cache of files.  
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteApp::AddPage(const CString& rStrPathName, 
                           const CXMLPage* pXMLPage)
{
    if (rStrPathName == "")
        return;

    if (m_ucFileCacheSize == 0)
        return;

    // Check size and pop of the front if one more would
    // make it more than the file cache size.
    CacheInfo* pCacheInfo = new CacheInfo;
    if (pCacheInfo == NULL)
        return;

    pCacheInfo->m_pXMLPage = new CXMLPage;
    if (pCacheInfo->m_pXMLPage == NULL)
    {
        delete pCacheInfo;
        return;
    }

    *(pCacheInfo->m_pXMLPage) = *const_cast<CXMLPage*>(pXMLPage);
    pCacheInfo->m_strFilePath = rStrPathName;

    m_sync.Lock();
    if (m_listXMLFileCache.size() == m_ucFileCacheSize &&
        m_ucFileCacheSize > 0)
    {
        delete m_listXMLFileCache.back()->m_pXMLPage;
        delete m_listXMLFileCache.back();
        m_listXMLFileCache.pop_back();
    }

    m_listXMLFileCache.push_front(pCacheInfo);
    m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// CXMLPage* CFSISuiteApp::FindPage()
//
// Inputs           : const CString& rStrPathName - contains the path 
//                    of a file about to be displayed.
//
// Return Values    : NULL if the file has not been opened or if the 
//                    file on the disk is newer than the one in the 
//                    cache.  Otherwise, a pointer to a CXMLPage.
//
// Date             : 03 November 1998
//
// Engineer         : Billy Baker
//
// Description      : FindPage attempts to find a CXMLPage pointer in 
//                    the cache of all recently opened files.  If the 
//                    file is there, the last write time of the file is 
//                    compared with the last write time stored in the 
//                    CXMLPage.  If the disk file is newer, then the 
//                    old pointer is deleted and NULL is returned so 
//                    that the file will be read again.
//
/////////////////////////////////////////////////////////////////////////////
CXMLPage* CFSISuiteApp::FindPage(const CString& rStrPathName)
{
    if (CacheSize() > 0)
    {
        _FSI_STL::list<CacheInfo*>::iterator pageIt = NULL;
        _FSI_STL::list<CacheInfo*>::iterator nullIt = NULL;

        m_sync.Lock();
        _FSI_STL::list<CacheInfo*>::iterator lIt    = m_listXMLFileCache.begin();

        while (lIt != m_listXMLFileCache.end() && pageIt == nullIt)
        {
            if ((*lIt)->m_strFilePath == rStrPathName)
            {
                pageIt = lIt;
            }

            lIt++;
        }

        if (pageIt != nullIt)
        {
            WIN32_FILE_ATTRIBUTE_DATA fad;
            if (::GetFileAttributesEx(rStrPathName, GetFileExInfoStandard, &fad) != 0)
            {
                // Compare the times.
                CXMLPage* pXMLpage = (*pageIt)->m_pXMLPage;
                FILETIME ft = pXMLpage->WriteFileTime();
                if (CompareFileTime(&ft, &(fad.ftLastWriteTime)) < 0)
                {
                    // Disk file is newer.
                    delete (*pageIt)->m_pXMLPage;

                    delete (*pageIt);

                    m_listXMLFileCache.erase(pageIt);

                    m_sync.Unlock();

                    return NULL;
                }
                else
                {
                    // Disk file is older or the same.
                    // Move the CacheInfo* to the front of the
                    // list so that when the max size is reached
                    // only the least used files will be removed from the
                    // end of the list.
                    CacheInfo* pCacheInfo = (*pageIt);

                    m_listXMLFileCache.erase(pageIt);

                    m_listXMLFileCache.push_front(pCacheInfo);

                    m_sync.Unlock();

                    return pCacheInfo->m_pXMLPage;
                }
            }
        }

        m_sync.Unlock();
    }

    return NULL;
}

/////////////////////////////////////////////////////////////////////////////
//
// unsigned char CFSISuiteApp::CacheSize()
//
// Inputs           : None.
//
// Return Values    : The size of the file cache.
//
// Date             : 03 November 1998
//
// Engineer         : Billy Baker
//
// Description      : CacheSize returns the size of the file cache.
//
/////////////////////////////////////////////////////////////////////////////
unsigned char CFSISuiteApp::CacheSize()
{
    unsigned char ucSize;
    m_sync.Lock();
    ucSize = (unsigned char)m_listXMLFileCache.size();
    m_sync.Unlock();
    return ucSize;
}

void CFSISuiteApp::Cleanup(bool bFinalCleanup)
{
    if (bFinalCleanup == true)
    {
        DeleteFile((LPCTSTR)m_strOriginalOptionsBackup);

        m_sync.Lock();

        _FSI_STL::list<CacheInfo*>::iterator lIt = m_listXMLFileCache.begin();

        while (lIt != m_listXMLFileCache.end())
        {
            delete (*lIt)->m_pXMLPage;
            delete *lIt;

            lIt++;
        }

        m_listXMLFileCache.clear();

        m_sync.Unlock();
    }

    // Clear the addresses of the CreateObject pointers.
    m_mapWidgets.clear();
    m_mapActions.clear();

    m_listAvailableWidgets.clear();
    m_listAvailableActions.clear();

    // Get the handle for the component library and then delete
    // the instantiation of the component interface class.  Finally,
    // unload the DLL with the handle from the DLLHandle call.
    STRING2CI_MAP::iterator s2ciIt = m_mapComponentInterface.begin();
    HINSTANCE hDLL;
    if (bFinalCleanup == true)
    {
        while (s2ciIt != m_mapComponentInterface.end())
        {
            if ((*s2ciIt).second != NULL)
            {
                (*s2ciIt).second->CleanComponentResources();
            }

            s2ciIt++;
        }

        s2ciIt = m_mapComponentInterface.begin();

        while (s2ciIt != m_mapComponentInterface.end())
        {
            if ((*s2ciIt).second != NULL)
            {
                hDLL = (*s2ciIt).second->DLLHandle();
                delete (*s2ciIt).second;
                AfxFreeLibrary(hDLL);
            }

            s2ciIt++;
        }
    }
    else
    {
        while (s2ciIt != m_mapComponentInterface.end())
        {
            if ((*s2ciIt).second != NULL)
            {
                DeleteComponentLibrary(CString((*s2ciIt).second->PathName().c_str()));
            }

            s2ciIt++;
        }
    }
}

unsigned char CFSISuiteApp::MaxUndoSize()
{
    return m_ucUndoSize;
}

unsigned char CFSISuiteApp::MaxFileCacheSize()
{
    return m_ucFileCacheSize;
}

void CFSISuiteApp::MaxUndoSize(unsigned char ucUndoSize)
{
    m_ucUndoSize = ucUndoSize;
}

void CFSISuiteApp::MaxFileCacheSize(unsigned char ucFileCacheSize)
{
    m_ucFileCacheSize = ucFileCacheSize;
}

void CFSISuiteApp::AddMonitorInfo(MONITORINFOEX mi)
{
    m_vectMonitorInfo.push_back(mi);
}

void CFSISuiteApp::MarkWndDestroyed(CFrameWnd* pWnd)
{
    if (pWnd != NULL)
    {
        _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = NULL;
        vIt = m_vectThreads.begin();
        while (vIt != m_vectThreads.end())
        {
            if ((*vIt)->m_pMainWnd == pWnd)
            {
                m_vectThreads.erase(vIt);
                return;
            }

            vIt++;
        }
    }
}


// App command to run the dialog
void CFSISuiteApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

BOOL CFSISuiteApp::PreTranslateMessage(MSG* pMsg) 
{
    if (pMsg->message >= ID_FILE_MRU_FILE1 && pMsg->message <= ID_FILE_MRU_FILE16)
    {
        CFSISuiteView* pView = NULL;
        if (pMsg->lParam != 0)
        {
            if (m_vectThreads[pMsg->lParam - 1]->m_pDocTemplate != NULL)
            {
                pView = (CFSISuiteView*)(m_vectThreads[pMsg->lParam - 1]->m_pDocTemplate->m_pFrame->GetActiveView());
            }
        }
        else
        {
            pView = (CFSISuiteView*)(((CMainFrame*)m_pMainWnd)->GetActiveView());
        }

        if (pView != NULL)
        {
	        ASSERT_VALID(this);
	        ASSERT(m_pRecentFileList != NULL);

	        ASSERT(pMsg->message >= ID_FILE_MRU_FILE1);
	        ASSERT(pMsg->message < ID_FILE_MRU_FILE1 + (UINT)m_pRecentFileList->GetSize());
	        int nIndex = pMsg->message - ID_FILE_MRU_FILE1;
	        ASSERT((*m_pRecentFileList)[nIndex].GetLength() != 0);

	        TRACE2("MRU: open file (%d) '%s'.\n", (nIndex) + 1,
			        (LPCTSTR)(*m_pRecentFileList)[nIndex]);

	        if (OpenFile((LPCTSTR)(*m_pRecentFileList)[nIndex],pMsg->lParam) == NULL)
		        m_pRecentFileList->Remove(nIndex);
        }

        return TRUE;
    }

    if (pMsg->message == TM_LOAD_CONFIG_DATA)
    {
        dynamic_cast<CMainFrame*>(m_pMainWnd)->DestroyOverlays();

        _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = m_vectThreads.begin();
        vIt = m_vectThreads.begin();
        while (vIt != m_vectThreads.end())
        {
            dynamic_cast<CMainFrame*>((*vIt)->m_pMainWnd)->DestroyOverlays();

            vIt++;
        }

        LoadConfigData();

        vIt = m_vectThreads.begin();
        while (vIt != m_vectThreads.end())
        {
            ::PostThreadMessage((*vIt)->m_nThreadID, TM_OPTIONS_CLICK, 0, 0);
            WaitForSingleObject((HANDLE)((*vIt)->m_evMessage), INFINITE);

            vIt++;
        }


        // Send a message to the main frame to simulate a click on the
        // component button that was last clicked.  This will refresh the
        // component specific bar.
        CMainFrame* pFrame = (CMainFrame*)m_pMainWnd;

        CString strLastComponent(pFrame->LastComponent().c_str());
        pFrame->SendMessage(WM_COMMAND, pFrame->LastComponentID(), 0);

        if (pFrame->m_pDlgOptions != NULL)
        {
            pFrame->m_pDlgOptions->SendMessage(WM_NOTIFY_CHANGE, 0, 0);
        }

        SetProcessWorkingSetSize(GetCurrentProcess(), -1, -1);
        return TRUE;
    }
    else
    {
    	return CWinApp::PreTranslateMessage(pMsg);
    }
	
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteApp::LoadDirectories()
//
// Inputs           : CComponentInterface* pCI - pointer to the 
//                    component interface instance that may have 
//                    directory aliases.
//
// Return Values    : None.
//
// Date             : 30 July 1999
//
// Engineer         : Billy Baker
//
// Description      : LoadDirectories is called when a component 
//                    library is loaded.  Its purpose is to tell the 
//                    CWidget class what directory aliases exist for 
//                    the component.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteApp::LoadDirectories(CComponentInterface* pCI)
{
    STRING2STRING_MAP* pmapDir = pCI->Directories();

    CWidget::Directories(pCI->ComponentName(), pmapDir);
}

void CFSISuiteApp::MonitorInfo(MONITORINFOEX& mi, const unsigned char ucWindowNumber)
{
    if (ucWindowNumber < m_vectMonitorInfo.size())
    {
        mi = m_vectMonitorInfo[ucWindowNumber];
    }
}

CDocument* CFSISuiteApp::OpenFile(LPCTSTR lpszFileName, const unsigned char ucWindowNumber)
{
    bool bLoadFile      = true;
    CFSISuiteDoc* pDoc  = NULL;
    CString strFileName(lpszFileName);

    _FSI_STL::vector<CFSISuiteWinThread*>::iterator vIt = 
                                            m_vectThreads.begin();
    if (strFileName.Find("^") > -1)
    {
        CWidget::ExpandPath(strFileName);
    }


    if (ucWindowNumber != 0)
    {
        POSITION pos = m_pDocTemplate->GetFirstDocPosition();

        pDoc = (CFSISuiteDoc*)m_pDocTemplate->GetNextDoc(pos);

        // See if the document has the same file and
        // is not in edit mode.
        if (pDoc->GetPathName() == strFileName &&
            pDoc->EditMode() == false)
        {
            bLoadFile = false;
        }
    }

    unsigned char ucCount = 1;
    // Walk all of the other windows to see if they are
    // displaying the same file.  If they are and they
    // are not in edit mode, then do not load the file.
    while (vIt != m_vectThreads.end() && bLoadFile)
    {    
        if ((*vIt)->m_pDocTemplate != NULL && ucCount != ucWindowNumber)
        {
            if ((*vIt)->m_pDocTemplate->m_pFrame != NULL)
            {
                POSITION pos = (*vIt)->m_pDocTemplate->GetFirstDocPosition();

                pDoc = (CFSISuiteDoc*)(*vIt)->m_pDocTemplate->GetNextDoc(pos);

                // See if the document has the same file and
                // is not in edit mode.
                if (pDoc->GetPathName() == strFileName &&
                    pDoc->EditMode() == false)
                {
                    bLoadFile = false;
                }
            }
        }

        ucCount++;
        vIt++;
    }

    CDocument* pDocument = NULL;

    if (bLoadFile)
    {
        m_syncFileOpen.Lock();

        m_ucCurrentFrame = ucWindowNumber;

        pDocument = OpenDocumentFile(lpszFileName);

        m_syncFileOpen.Unlock();
    }
    else
    {
        if (!m_bPageFlippingInUse)
        {
            if (ucWindowNumber != 0)
            {
                ::MessageBox(m_vectThreads[ucWindowNumber-1]->m_pMainWnd->GetSafeHwnd(),
                             _T("\"" + strFileName + "\" is already loaded on another screen."),
                             _T("Invalid selection"),
                             MB_OK   |  MB_ICONINFORMATION);
            }
            else
            {
                ::MessageBox(m_pMainWnd->GetSafeHwnd(),
                             _T("\"" + strFileName + "\" is already loaded on another screen."),
                             _T("Invalid selection"),
                             MB_OK   |  MB_ICONINFORMATION);
            }
        }
   }

    return pDocument;
}

UINT CFSISuiteApp::FSI_GetProfileInt(LPCTSTR lpszSection, LPCTSTR lpszEntry, int nDefault)
{
    // Gets the FSISuite registry keys out of HKEY_LOCAL_MACHINE\Software\FlightSafety\FSISuite,
    // Instead of from HKEY_CURRENT_USER that the normal CWinApp::GetProfileString uses.

    HKEY hKey;

	 DWORD dwValue = nDefault;

    char strAppPath[128];

    strcpy(strAppPath, _T("Software\\FlightSafety\\FSISuite\\"));
    strcat(strAppPath, lpszSection);
    
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, strAppPath, 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
      DWORD dwType;
      DWORD dwCount;
      dwCount = sizeof(DWORD);

		LONG lResult = RegQueryValueEx(hKey, lpszEntry, 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			lResult = RegQueryValueEx(hKey, lpszEntry, NULL, &dwType,
				            (LPBYTE)&dwValue, &dwCount);
		}
    }

    return(dwValue);
}


CString CFSISuiteApp::FSI_GetProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszDefault)
{
    // Gets the FSISuite registry keys out of HKEY_LOCAL_MACHINE\Software\FlightSafety\FSISuite,
    // Instead of from HKEY_CURRENT_USER that the normal CWinApp::GetProfileString uses.

    HKEY hKey;

    static CString strValue;

    char strAppPath[128];

    strValue = lpszDefault;

    strcpy(strAppPath, _T("Software\\FlightSafety\\FSISuite\\"));
    strcat(strAppPath, lpszSection);
    
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, strAppPath, 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
		DWORD dwType, dwCount;

		LONG lResult = RegQueryValueEx(hKey, lpszEntry, 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, lpszEntry, NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
			strValue.ReleaseBuffer();
		}
    }

    return(strValue);
}

BOOL CFSISuiteApp::FSI_WriteProfileInt(LPCTSTR lpszSection, LPCTSTR lpszEntry, int nValue)
{
    // Sets the FSISuite registry keys to HKEY_LOCAL_MACHINE\Software\FlightSafety\FSISuite,
    // Instead of to HKEY_CURRENT_USER that the normal CWinApp::WriteProfileString uses.

    HKEY hKey;

    char strAppPath[128];

    strcpy(strAppPath, _T("Software\\FlightSafety\\FSISuite\\"));
    strcat(strAppPath, lpszSection);

    DWORD dw;

    RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
                 strAppPath,
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                 &hKey, &dw);

    DWORD value = nValue;

    RegSetValueEx(hKey, lpszEntry, NULL, REG_DWORD, 
                            (BYTE*)&value, 
                            sizeof(DWORD));
    
    RegCloseKey(hKey);

    return 0;
}


BOOL CFSISuiteApp::FSI_WriteProfileString(LPCTSTR lpszSection, LPCTSTR lpszEntry, LPCTSTR lpszValue)
{
    // Sets the FSISuite registry keys to HKEY_LOCAL_MACHINE\Software\FlightSafety\FSISuite,
    // Instead of to HKEY_CURRENT_USER that the normal CWinApp::WriteProfileString uses.

    HKEY hKey;

    char strAppPath[128];

    strcpy(strAppPath, _T("Software\\FlightSafety\\FSISuite\\"));
    strcat(strAppPath, lpszSection);

    DWORD dw;

    RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
                 strAppPath,
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                 &hKey, &dw);


    RegSetValueEx(hKey, lpszEntry, NULL, REG_SZ, 
                            (BYTE *)lpszValue, 
                            strlen(lpszValue)+1);
    
    RegCloseKey(hKey);

   return 0;
}


void  CFSISuiteApp::SetVideoModeAndColors(void)
{
   DEVMODE   devmode;

   m_old_COLOR_3DFACE         =  GetSysColor(COLOR_3DFACE);
   m_old_COLOR_MENU           =  GetSysColor(COLOR_MENU);
   m_old_COLOR_MENUTEXT       =  GetSysColor(COLOR_MENUTEXT);
   m_old_COLOR_WINDOWTEXT     =  GetSysColor(COLOR_WINDOWTEXT);
   m_old_COLOR_HIGHLIGHT      =  GetSysColor(COLOR_HIGHLIGHT);
   m_old_COLOR_HIGHLIGHTTEXT  =  GetSysColor(COLOR_HIGHLIGHTTEXT);
   m_old_COLOR_WINDOW         =  GetSysColor(COLOR_WINDOW);
   m_old_COLOR_BTNHIGHLIGHT   =  GetSysColor(COLOR_BTNHIGHLIGHT);
   m_old_COLOR_3DSHADOW       =  GetSysColor(COLOR_3DSHADOW);

   CONST INT   lpaElements[NUMBER_OF_COLORS] =  {  COLOR_3DFACE,        COLOR_MENU,
                                                   COLOR_MENUTEXT,      COLOR_WINDOWTEXT,
                                                   COLOR_HIGHLIGHT,
                                                   COLOR_HIGHLIGHTTEXT,
                                                   COLOR_WINDOW,
                                                   COLOR_BTNHIGHLIGHT,
                                                   COLOR_3DSHADOW
                                                };

   CString  button_color;
   HKEY     hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get SWS name
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("Button Color"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("Button Color"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      button_color   =  strValue;

      // clean up
      RegCloseKey(hKey);
   }

   CString str = "";
   if (button_color.Find(",") > -1)
   {
      str = button_color.Mid(button_color.Find(",") + 1);
      button_color.Format("%03s",button_color.Left(button_color.Find(",")));
   }
   if (str.Find(",") > -1)
   {
      button_color.Format("%s%03s%03s", button_color, str.Left(str.Find(",")),
                                    str.Mid(str.Find(",") + 1));
   }

   COLORREF button_and_menu_color      =  RGB((unsigned char)atoi(button_color.Left(3)), (unsigned char)atoi(button_color.Mid(3,3)), (unsigned char)atoi(button_color.Right(3)));
   COLORREF menu_and_window_text_color =  RGB(0,   0,    0);
   COLORREF highlight_color            =  RGB(0,   0,    128);
   COLORREF highlight_text_color       =  RGB(255, 255,  255);
   COLORREF window_color               =  RGB(255, 255,  255);
   COLORREF btnhighlight_color         =  button_and_menu_color   +  RGB(56, 56, 56);
   COLORREF threeDshadow_color         =  button_and_menu_color   -  RGB(56, 56, 56);

   CONST COLORREF lpaRgbValues[NUMBER_OF_COLORS]   =  {  button_and_menu_color,        button_and_menu_color,
                                                         menu_and_window_text_color,   menu_and_window_text_color,
                                                         highlight_color,
                                                         highlight_text_color,
                                                         window_color,
                                                         btnhighlight_color,
                                                         threeDshadow_color
                                                      };


   SetSysColors(NUMBER_OF_COLORS, lpaElements, lpaRgbValues);

   BOOL  bStatus  =  EnumDisplaySettings(NULL, ENUM_CURRENT_SETTINGS, &devmode);

   if (bStatus == 0)
   {
      LPVOID lpMsgBuf;
      FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |  FORMAT_MESSAGE_FROM_SYSTEM |  FORMAT_MESSAGE_IGNORE_INSERTS,
                    NULL,  GetLastError(),   MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),   (LPTSTR)&lpMsgBuf,   0, NULL);
      // Display the string.
      ::MessageBox(NULL, (LPCTSTR)lpMsgBuf, "Can't determine current display settings.", MB_OK | MB_ICONINFORMATION);
      // Free the buffer.
      LocalFree(lpMsgBuf);
   }

   devmode.dmSize          =  sizeof(DEVMODE);
   devmode.dmBitsPerPel    =  32;
   devmode.dmPelsWidth     =  1280;
   devmode.dmPelsHeight    =  1024;

   long  status   =  ChangeDisplaySettings(&devmode, 0);
   
   if (status  != DISP_CHANGE_SUCCESSFUL)
   {
      devmode.dmSize          =  sizeof(DEVMODE);
      devmode.dmBitsPerPel    =  24;
      devmode.dmPelsWidth     =  1280;
      devmode.dmPelsHeight    =  1024;

      long  status   =  ChangeDisplaySettings(&devmode, 0);

      switch   (status)
      {
         case  DISP_CHANGE_SUCCESSFUL:
            //::MessageBox(NULL, "The display settings were changed successfully.", "Changing display settings...", MB_OK | MB_ICONINFORMATION);
            break;

         case  DISP_CHANGE_RESTART:
            ::MessageBox(NULL, "The computer must be restarted in order for the graphics mode to work.", "Changing display settings...", MB_OK | MB_ICONINFORMATION);
            break;
      
         case  DISP_CHANGE_BADFLAGS:
            ::MessageBox(NULL, "An invalid set of flags was passed in.", "Changing display settings...", MB_OK | MB_ICONINFORMATION);
            break;
      
         case  DISP_CHANGE_BADPARAM:
            ::MessageBox(NULL, "An invalid parameter was passed in. This can include an invalid flag or combination of flags.", "Changing display settings...", MB_OK | MB_ICONINFORMATION);
            break;
      
         case  DISP_CHANGE_FAILED:
            ::MessageBox(NULL, "The display driver failed the specified graphics mode.", "Changing display settings...", MB_OK | MB_ICONINFORMATION);
            break;
      
         case  DISP_CHANGE_BADMODE:
            ::MessageBox(NULL, "The graphics mode is not supported.", "Changing display settings...", MB_OK | MB_ICONINFORMATION);
            break;

         case  DISP_CHANGE_NOTUPDATED:
            break;
      }
   }
}


void  CFSISuiteApp::RestoreVideoModeAndColors(void)
{
   ChangeDisplaySettings(NULL, 0);
	
   CONST INT      lpaElements[NUMBER_OF_COLORS]    =  {  COLOR_3DFACE,        COLOR_MENU,
                                                         COLOR_MENUTEXT,      COLOR_WINDOWTEXT,
                                                         COLOR_HIGHLIGHT,
                                                         COLOR_HIGHLIGHTTEXT,
                                                         COLOR_WINDOW,
                                                         COLOR_BTNHIGHLIGHT,
                                                         COLOR_3DSHADOW
                                                      };

   CONST COLORREF lpaRgbValues[NUMBER_OF_COLORS]   =  {  m_old_COLOR_3DFACE,     m_old_COLOR_MENU,
                                                         m_old_COLOR_MENUTEXT,   m_old_COLOR_WINDOWTEXT,
                                                         m_old_COLOR_HIGHLIGHT,
                                                         m_old_COLOR_HIGHLIGHTTEXT,
                                                         m_old_COLOR_WINDOW,
                                                         m_old_COLOR_BTNHIGHLIGHT,
                                                         m_old_COLOR_3DSHADOW
                                                      };

   SetSysColors(NUMBER_OF_COLORS, lpaElements, lpaRgbValues);
}


bool  CFSISuiteApp::FirstInstance()
{
   static HANDLE hMutex = CreateMutex(NULL, TRUE, "FSISuiteRunningMutex");

   if (GetLastError() == ERROR_ALREADY_EXISTS)
      return false;

   else
      return true;
}

