// EditorTree.h: interface for the CEditorTree class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_EDITORTREE_H_)
#define _EDITORTREE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CFSISuiteDoc;

class CEditorTree : public CStatic
{
    DECLARE_DYNCREATE(CEditorTree)
private:
    bool            m_bFirstInit;
    unsigned short  m_ushObjectNumber;
    bool            m_bAction;
    CTreeCtrl       m_wndTree;
    CStatic         m_wndXPos;
    CStatic         m_wndYPos;

public:
	CEditorTree();

// Attributes
public:

// Operations   
private:
    void TraverseWidgets(CWidget* pWidget, HTREEITEM hTreeParent);

public:   
    void FileNew(CFSISuiteDoc* pDoc);
    void AddWidgets(CFSISuiteDoc* pDoc);
    void UpdatePos(CPoint& point);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditorTree)
	public:
	virtual BOOL Create(CWnd* pParentWnd);
	protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CEditorTree();

	// Generated message map functions
protected:
	//{{AFX_MSG(CEditorTree)
    afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif // !defined(_EDITORTREE_H_)
