// EditorTree.cpp: implementation of the CEditorTree class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "FSISuite.h"
#include "MainFrm.h"

#include "FSISuiteDoc.h"
#include "FSISuiteView.h"

#include "EditorTree.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

static const long int EDITBAR_IMAGE_SIZE_X = 64;
static const long int EDITBAR_IMAGE_SIZE_Y = 64;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE(CEditorTree, CStatic)

CEditorTree::CEditorTree()
{
    m_bFirstInit = true;
    m_ushObjectNumber = 0;
    m_bAction = false;
}

CEditorTree::~CEditorTree()
{
}

BEGIN_MESSAGE_MAP(CEditorTree, CStatic)
	//{{AFX_MSG_MAP(CEditorTree)
    ON_WM_SIZE()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CEditorTree::TraverseWidgets(CWidget* pWidget, HTREEITEM hTreeParent)
{
    if (m_wndTree.GetSafeHwnd() == NULL)
    {
        return;
    }

    HTREEITEM hTreeChild;
    hTreeChild = m_wndTree.InsertItem(TVIF_PARAM | TVIF_TEXT, pWidget->Name().c_str(), 0,
                                      0, 0, 0, pWidget->ID(), hTreeParent, 
                                      TVI_LAST);

    _FSI_STL::list<CWidget*>::iterator wIt = NULL;
    CWidget* pSubWidget = pWidget->GetNextSubWidget(wIt);
    while (pSubWidget != NULL)
    {
        TraverseWidgets(pSubWidget, hTreeChild);
        pSubWidget = pWidget->GetNextSubWidget(wIt);
    }

    _FSI_STL::list<CAction*>::iterator aIt = NULL;
    CWidget* pAction = pWidget->GetNextAction(aIt);
    while (pAction != NULL)
    {
        m_wndTree.InsertItem(TVIF_PARAM | TVIF_TEXT, pAction->Name().c_str(), 0, 0, 0, 0,
                             pAction->ID(), hTreeChild, TVI_LAST);
        pAction = pWidget->GetNextAction(aIt);
    }
}

void CEditorTree::UpdatePos(CPoint& point)
{
    CString strPos;
    strPos.Format("X = %d", point.x);
    m_wndXPos.SetWindowText(strPos);

    strPos.Format("Y = %d", point.y);
    m_wndYPos.SetWindowText(strPos);
}

void CEditorTree::AddWidgets(CFSISuiteDoc* pDoc)
{
    if (m_wndTree.GetSafeHwnd() == NULL || pDoc == NULL)
    {
        return;
    }

    m_wndTree.DeleteAllItems();
    _FSI_STL::list<CWidget*>::iterator lIt = pDoc->m_listWidgets.begin();
    for (; lIt != pDoc->m_listWidgets.end(); lIt++)
    {
        if ((*lIt)->BaseWidget() == (*lIt))
        {
            TraverseWidgets((*lIt), TVI_ROOT);
        }
    }
}

void CEditorTree::OnSize(UINT nType, int cx, int cy)
{
    if (m_wndTree.GetSafeHwnd() != NULL)
    {
        m_wndTree.MoveWindow(0, 0, cx, cy - 3*5 - 2*16);
    }

    if (m_wndXPos.GetSafeHwnd() != NULL)
    {
        m_wndXPos.MoveWindow(0, cy - 2*5 - 2*16, cx, 16);
    }

    if (m_wndYPos.GetSafeHwnd() != NULL)
    {
        m_wndYPos.MoveWindow(0, cy - 5 - 16, cx, 16);
    }
}

BOOL CEditorTree::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	return CStatic::OnNotify(wParam, lParam, pResult);
}

BOOL CEditorTree::Create(CWnd* pParentWnd) 
{
    BOOL bRetVal = CStatic::Create(_T(""), WS_CHILD | WS_VISIBLE, CRect(0,0,1,1),
                                   pParentWnd, IDC_STATIC);

    m_wndTree.CreateEx(WS_EX_CLIENTEDGE, WC_TREEVIEW, NULL, 
                       WS_CHILD | WS_VISIBLE | TVS_HASLINES | TVS_LINESATROOT |
                         TVS_HASBUTTONS | TVS_SHOWSELALWAYS | TVS_SINGLEEXPAND,
                       CRect(0, 0, 1, 1), 
                       this, 0x1199);

    m_wndXPos.Create(_T("X = "), WS_CHILD | WS_VISIBLE | SS_CENTER, CRect(0,0,1,1),
                                   this, IDC_STATIC);

    m_wndYPos.Create(_T("Y = "), WS_CHILD | WS_VISIBLE | SS_CENTER, CRect(0,0,1,1),
                                   this, IDC_STATIC);

    AddWidgets(static_cast<CFSISuiteDoc*>(GetParentFrame()->GetActiveDocument()));
	
    return bRetVal;
}

void CEditorTree::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CStatic::OnLButtonUp(nFlags, point);
}

void CEditorTree::OnMouseMove(UINT nFlags, CPoint point) 
{
	CStatic::OnMouseMove(nFlags, point);
}

void CEditorTree::FileNew(CFSISuiteDoc* pDoc)
{
    m_wndTree.DeleteAllItems();

    CWidget* pWidget = pDoc->PageWidget();
    if (pWidget == NULL)
    {
        return;
    }

    m_wndTree.InsertItem(pWidget->Name().c_str());
}

BOOL CEditorTree::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CS_OWNDC;

	return CStatic::PreCreateWindow(cs);
}
