// EditorControls.h: interface for the CEditorControls class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_EDITORCONTROLS_H_)
#define _EDITORCONTROLS_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CEditorControls : public CStatic
{
    DECLARE_DYNCREATE(CEditorControls)
private:
    CListCtrl*      m_pListCtrl;
    CImageList*     m_pDragImage;
	CTabCtrl*	    m_pctrlWidgetTab;
    CTabCtrl*       m_pctrlActionTab;
    CListCtrl*      m_pctrlActionList;

    bool            m_bFirstInit;
    unsigned short  m_ushObjectNumber;
    bool            m_bAction;

    CPoint          m_ptHotSpot;

    _FSI_STL::map<_FSI_STL::string, CImageList*> m_mapImageLists;
    _FSI_STL::map<_FSI_STL::string, CImageList*> m_mapActionImageLists;

public:
	CEditorControls();

// Attributes
public:

// Operations   
public:   
    void AddTab(CComponentInterface* pCI);
    void DeleteTab(const CString& rstrComponentName);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditorControls)
	public:
	virtual BOOL Create(CWnd* pParentWnd);
	protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CEditorControls();

	// Generated message map functions
protected:
	//{{AFX_MSG(CEditorControls)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif // !defined(_EDITORCONTROLS_H_)
