// EditorControls.cpp: implementation of the CEditorControls class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "FSISuite.h"
#include "MainFrm.h"

#include "FSISuiteDoc.h"
#include "FSISuiteView.h"

#include "EditorControls.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

static const long int EDITBAR_IMAGE_SIZE_X = 64;
static const long int EDITBAR_IMAGE_SIZE_Y = 64;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE(CEditorControls, CStatic)

CEditorControls::CEditorControls()
{
    m_bFirstInit        = true;
    m_pListCtrl         = NULL;
    m_pDragImage        = NULL;
    m_ushObjectNumber   = 0;
    m_pctrlWidgetTab    = NULL;
    m_pctrlActionTab    = NULL;
    m_pctrlActionList   = NULL;
    m_bAction           = false;
}

CEditorControls::~CEditorControls()
{
    // Delete each of the image lists for the upper tabs.
    _FSI_STL::map<_FSI_STL::string,CImageList*>::iterator ilIt = m_mapImageLists.begin();
    while (ilIt != m_mapImageLists.end())
    {
        (*ilIt).second->DeleteImageList();
        delete (*ilIt).second;
        ilIt++;
    }
    m_mapImageLists.clear();

    // Delete each of the image lists for the lower tabs.
    ilIt = m_mapActionImageLists.begin();
    while (ilIt != m_mapActionImageLists.end())
    {
        (*ilIt).second->DeleteImageList();
        delete (*ilIt).second;
        ilIt++;
    }
    m_mapActionImageLists.clear();

    // Delete upper graphical element widget list control
    if (m_pListCtrl != NULL)
    {
        delete m_pListCtrl;
    }

    // Delete lower action widget list control
    if (m_pctrlActionList != NULL)
    {
        delete m_pctrlActionList;
    }

    // Delete upper graphical element widget tab control
    if (m_pctrlWidgetTab != NULL)
    {
        m_pctrlWidgetTab->DestroyWindow();
        delete m_pctrlWidgetTab;
    }

    // Delete lower action widget tab control
    if (m_pctrlActionTab != NULL)
    {
        m_pctrlActionTab->DestroyWindow();
        delete m_pctrlActionTab;
    }

    // Delete any drag image
    if (m_pDragImage != NULL)
    {
        m_pDragImage->DeleteImageList();
        delete m_pDragImage;
    }
}

BEGIN_MESSAGE_MAP(CEditorControls, CStatic)
	//{{AFX_MSG_MAP(CEditorControls)
    ON_WM_CREATE()
    ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CEditorControls::AddTab(CComponentInterface* pCI)
{
    m_mapImageLists[pCI->ComponentName()]       = NULL;
    m_mapActionImageLists[pCI->ComponentName()] = NULL;

    // Add a new image list to the upper map.
    CImageList* pImageList = new CImageList;
    if (pImageList != NULL)
    {
        _FSI_STL::list<CBitmap*>* pWidgetImageList = pCI->WidgetImages();
        _FSI_STL::list<CBitmap*>::iterator bmpIt = pWidgetImageList->begin();
        pImageList->Create(EDITBAR_IMAGE_SIZE_X,
                           EDITBAR_IMAGE_SIZE_Y,
                           TRUE, pWidgetImageList->size(), 0);

        unsigned char ucWidgetNumber = 0;

        // Step through the list of images.
        BITMAP bitmap;
        while (bmpIt != pWidgetImageList->end())
        {
            CBitmap bmp;
            (*bmpIt)->GetBitmap(&bitmap);
            bitmap.bmBits = new unsigned char[bitmap.bmWidthBytes * 
                                              EDITBAR_IMAGE_SIZE_Y];
            (*bmpIt)->GetBitmapBits(bitmap.bmWidthBytes*EDITBAR_IMAGE_SIZE_Y,
                                    bitmap.bmBits);
            bmp.CreateBitmapIndirect(&bitmap);
            pImageList->Add(&bmp,RGB(0,0,255));
            delete [] bitmap.bmBits;

            bmpIt++;
            ucWidgetNumber++;
        }

        if (m_mapImageLists.find(pCI->ComponentName()) != 
                                                    m_mapImageLists.end())
        {
            if (m_mapImageLists[pCI->ComponentName()] != NULL)
            {
                m_mapImageLists[pCI->ComponentName()]->DeleteImageList();
                delete m_mapImageLists[pCI->ComponentName()];
                m_mapImageLists.erase(m_mapImageLists.find(pCI->ComponentName()));
            }
        }

        m_mapImageLists[pCI->ComponentName()] = pImageList;
    }

    // Add a new image list to the lower map.
    pImageList = new CImageList;
    if (pImageList != NULL)
    {
        _FSI_STL::list<CBitmap*>* pActionImageList = pCI->ActionImages();
        _FSI_STL::list<CBitmap*>::iterator bmpIt = pActionImageList->begin();
        pImageList->Create(EDITBAR_IMAGE_SIZE_X,
                           EDITBAR_IMAGE_SIZE_Y,
                           TRUE, pActionImageList->size(), 0);

        unsigned char ucActionNumber = 0;

        // Step through the list of images.
        BITMAP bitmap;
        while (bmpIt != pActionImageList->end())
        {
            CBitmap bmp;
            (*bmpIt)->GetBitmap(&bitmap);
            bitmap.bmBits = new unsigned char[bitmap.bmWidthBytes * 
                                              EDITBAR_IMAGE_SIZE_Y];
            (*bmpIt)->GetBitmapBits(bitmap.bmWidthBytes*EDITBAR_IMAGE_SIZE_Y,
                                    bitmap.bmBits);
            bmp.CreateBitmapIndirect(&bitmap);
            pImageList->Add(&bmp,RGB(0,0,255));
            delete [] bitmap.bmBits;

            bmpIt++;
            ucActionNumber++;
        }

        if (m_mapActionImageLists.find(pCI->ComponentName()) != 
                                                m_mapActionImageLists.end())
        {
            if (m_mapActionImageLists[pCI->ComponentName()] != NULL)
            {
                m_mapActionImageLists[pCI->ComponentName()]->DeleteImageList();
                delete m_mapActionImageLists[pCI->ComponentName()];
                m_mapActionImageLists.erase(m_mapActionImageLists.find(pCI->ComponentName()));
            }
        }

        m_mapActionImageLists[pCI->ComponentName()] = pImageList;
    }

    char cTabText[64];
    NMHDR nmhdr;
    nmhdr.code      = TCN_SELCHANGE;
    TC_ITEM TabItem;
    TabItem.mask    = TCIF_TEXT;
    TabItem.pszText = cTabText;
    strcpy(cTabText, pCI->ComponentName().c_str());

    if (m_pctrlWidgetTab != NULL)
    {
        m_pctrlWidgetTab->InsertItem(0,&TabItem);

        nmhdr.idFrom = IDC_WIDGET_TAB;
        SendMessage(WM_NOTIFY, IDC_WIDGET_TAB, (long)&nmhdr);
    }

    if (m_pctrlActionTab != NULL)
    {
        m_pctrlActionTab->InsertItem(0, &TabItem);

        nmhdr.idFrom = IDC_ACTION_TAB;
        SendMessage(WM_NOTIFY, IDC_ACTION_TAB, (long)&nmhdr);
    }
}

void CEditorControls::DeleteTab(const CString& rstrComponentName)
{
    unsigned char ucTabSize = 0;
    bool bTabFound = false;
    char cTabText[64];

    TC_ITEM TabItem;
    TabItem.mask = TCIF_TEXT;
    TabItem.pszText = cTabText;
    TabItem.cchTextMax = 64;
    _FSI_STL::string stlStrComponentName((LPCTSTR)rstrComponentName);

    if (m_mapImageLists.find(stlStrComponentName) != 
                                                m_mapImageLists.end())
    {
        if (m_mapImageLists[stlStrComponentName] != NULL)
        {
            m_mapImageLists[stlStrComponentName]->DeleteImageList();
            delete m_mapImageLists[stlStrComponentName];
            m_mapImageLists.erase(m_mapImageLists.find(stlStrComponentName));
        }
    }

    if (m_pctrlWidgetTab != NULL)
    {
        while (ucTabSize < m_pctrlWidgetTab->GetItemCount() && bTabFound != true)
        {
            if (m_pctrlWidgetTab->GetItem(ucTabSize,&TabItem) == TRUE)
            {
                if (strstr(TabItem.pszText,rstrComponentName) != NULL)
                {
                    if (m_pListCtrl != NULL) m_pListCtrl->DeleteAllItems();
                    m_pctrlWidgetTab->DeleteItem(ucTabSize);
                    bTabFound = true;
                    m_pctrlWidgetTab->SetCurSel(0);
                }
            }

            ucTabSize++;
        }
    }

    if (m_mapActionImageLists.find(stlStrComponentName) != 
                                            m_mapActionImageLists.end())
    {
        if (m_mapActionImageLists[stlStrComponentName] != NULL)
        {
            m_mapActionImageLists[stlStrComponentName]->DeleteImageList();
            delete m_mapActionImageLists[stlStrComponentName];
            m_mapActionImageLists.erase(m_mapActionImageLists.find(stlStrComponentName));
        }
    }

    ucTabSize = 0;
    bTabFound = false;
    if (m_pctrlActionTab != NULL)
    {
        while (ucTabSize < m_pctrlActionTab->GetItemCount() && bTabFound != true)
        {
            if (m_pctrlActionTab->GetItem(ucTabSize,&TabItem) == TRUE)
            {
                if (strstr(TabItem.pszText,rstrComponentName) != NULL)
                {
                    if (m_pctrlActionList != NULL) m_pctrlActionList->DeleteAllItems();
                    m_pctrlActionTab->DeleteItem(ucTabSize);
                    bTabFound = true;
                    m_pctrlActionTab->SetCurSel(0);
                }
            }

            ucTabSize++;
        }
    }
}

void CEditorControls::OnSize(UINT nType, int cx, int cy)
{
    // Resize the upper tab control
    if (m_pctrlWidgetTab != NULL)
    {
        // Align vertical
        // m_pctrlWidgetTab->MoveWindow(0,cy/32,cx,cy/2-cy/16);

        // Align horizontal
        m_pctrlWidgetTab->MoveWindow(0, 0, cx/2 - 5, cy);
    }

    // Resize the lower tab control
    if (m_pctrlActionTab != NULL)
    {
        // Align vertical
        // m_pctrlActionTab->MoveWindow(0,cy/2+cy/32,cx,cy/2-cy/16);

        // Align horizontal
        m_pctrlActionTab->MoveWindow(cx/2 + 5, 0, cx/2 - 5, cy);
    }

    // Resize the list control on top of the upper tab control
    if (m_pListCtrl != NULL)
    {
        CRect rect;

        m_pctrlWidgetTab->GetWindowRect(rect);
        if (rect.Width() > 0 && rect.Height() > 0)
        {
            m_pctrlWidgetTab->AdjustRect(FALSE,rect);
            m_pListCtrl->MoveWindow(CRect(4, 4,
                                          rect.Width() - 4,
                                          rect.Height()- 4));

        }

        // Rearrange the bitmaps in the list control
        m_pListCtrl->Arrange(LVA_DEFAULT);
    }

    // Resize the list control on top of the lower tab control
    if (m_pctrlActionList != NULL)
    {
        CRect rect;

        m_pctrlActionTab->GetWindowRect(rect);
        if (rect.Width() > 0 && rect.Height() > 0)
        {
            m_pctrlActionTab->AdjustRect(FALSE,rect);
            m_pctrlActionList->MoveWindow(CRect(4, 4,
                                                rect.Width() - 4,
                                                rect.Height()- 4));

        }

        // Rearrange the bitmaps in the list control
        m_pctrlActionList->Arrange(LVA_DEFAULT);
    }
}

BOOL CEditorControls::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
    switch (wParam)
    {
    case 0x1132:        // upper list control
    case 0x1133:        // lower list control
        {
            // An image is being dragged out of either the upper
            // or lower list control.
            NMHDR* pHdr = (NMHDR*)lParam;

            if (pHdr->code == LVN_BEGINDRAG)
            {
                m_ushObjectNumber = ((NM_LISTVIEW*)pHdr)->iItem;

                // Create a drag image for either the uppper list
                // control or the lower list control.
                POINT pt;
                if (wParam == 0x1132)
                {
                    m_pDragImage = 
                          m_pctrlActionList->CreateDragImage(m_ushObjectNumber,
                                                             &pt);
                    m_bAction = true;
                }
                else if (wParam == 0x1133)
                {
                    m_pDragImage = 
                                m_pListCtrl->CreateDragImage(m_ushObjectNumber,
                                                             &pt);
                    m_bAction = false;
                }

                CPoint ptDown(((NM_LISTVIEW*)pHdr)->ptAction);

                m_ptHotSpot = CPoint(ptDown.x - pt.x, ptDown.y - pt.y);
                m_pDragImage->BeginDrag(0, m_ptHotSpot);

                CRect rRect;

                if (wParam == 0x1132)
                {
                    m_pctrlActionList->GetWindowRect(&rRect);
                }
                else if (wParam == 0x1133)
                {
                    m_pListCtrl->GetWindowRect(&rRect);
                }
                rRect += ptDown;
                m_pDragImage->DragEnter(GetDesktopWindow(), 
                                        CPoint(rRect.left, rRect.top));

                SetCapture();

                return TRUE;
            }
            else
            {
                return CStatic::OnNotify(wParam, lParam, pResult);
            }
        }
        break;
    case IDC_WIDGET_TAB:
        {
            // Handle a change in the tab for the upper tab control.
            typedef CWidget* (*CreateObject)();
            NMHDR* pHdr = (NMHDR*)lParam;

            if (pHdr->code == TCN_SELCHANGE)
            {
                // Delete all images in the list control.
                if (m_pListCtrl != NULL) m_pListCtrl->DeleteAllItems();

                unsigned char ucTabSelection = m_pctrlWidgetTab->GetCurSel();
                char cTabText[64];

                TC_ITEM TabItem;
                TabItem.mask = TCIF_TEXT;
                TabItem.pszText = cTabText;
                TabItem.cchTextMax = 64;

                if (m_pctrlWidgetTab->GetItem(ucTabSelection,&TabItem) == TRUE)
                {
                    // After getting the name on the new active tab,
                    // get the pointer to the CComponentInterface for
                    // that tab.
                    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
                    CComponentInterface* pCI = 
                          pApp->FindComponentInterfaceByName(
                                                     CString(TabItem.pszText));

                    _FSI_STL::list<CreateObject>* pWidgetCtrls = pCI->WidgetCtrls();

                    // For each graphical element, create the graphical 
                    // element, get its name, replace '_' with ' ', add the 
                    // text to the list control, and then delete the 
                    // graphical element that was created.
                    _FSI_STL::list<CreateObject>::iterator lcoIt;
                    CWidget* pWidget = NULL;
                    unsigned char ucWidgetNumber = 0;
                    lcoIt = pWidgetCtrls->begin(); 
                    while (lcoIt != pWidgetCtrls->end())
                    {
                        pWidget = (*lcoIt)();
                        CString strWidgetName(pWidget->WidgetName().c_str());
                        while (strWidgetName.Find("_") > -1)
                        {
                           strWidgetName.SetAt(strWidgetName.Find("_"),_T(' '));
                        }
                        m_pListCtrl->InsertItem(ucWidgetNumber,
                                                strWidgetName,
                                                ucWidgetNumber);
                        ucWidgetNumber++;
                        delete pWidget;

                        lcoIt++;
                    }


                    // Set the image list to the list stored in the map
                    // of graphical element image lists based on the name 
                    // of the new active tab.
                    if (m_mapImageLists.find(_FSI_STL::string(TabItem.pszText)) != 
                                 m_mapImageLists.end())
                    {
                        m_pListCtrl->SetImageList(m_mapImageLists[TabItem.pszText],
                                                  LVSIL_NORMAL);
                    }
                }

                return TRUE;
            }
            else
            {
                return CStatic::OnNotify(wParam, lParam, pResult);
            }
        }
        break;
    case IDC_ACTION_TAB:
        {
            // Handle a change in the tab for the lower tab control.
            typedef CWidget* (*CreateObject)();
            NMHDR* pHdr = (NMHDR*)lParam;

            if (pHdr->code == TCN_SELCHANGE)
            {
                // Delete all images in the list control.
                if (m_pctrlActionList != NULL) 
                {
                    m_pctrlActionList->DeleteAllItems();
                }

                unsigned char ucTabSelection = m_pctrlActionTab->GetCurSel();
                char cTabText[64];

                TC_ITEM TabItem;
                TabItem.mask = TCIF_TEXT;
                TabItem.pszText = cTabText;
                TabItem.cchTextMax = 64;

                if (m_pctrlActionTab->GetItem(ucTabSelection,&TabItem) == TRUE)
                {
                    // After getting the name on the new active tab,
                    // get the pointer to the CComponentInterface for
                    // that tab.
                    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
                    CComponentInterface* pCI = 
                          pApp->FindComponentInterfaceByName(
                                                     CString(TabItem.pszText));

                    _FSI_STL::list<CreateObject>* pActions = pCI->Actions();

                    // For each action, create the action, get its name,
                    // replace '_' with ' ', add the text to the
                    // list control, and then delete the action that was
                    // created.
                    _FSI_STL::list<CreateObject>::iterator lcoIt;
                    CWidget* pAction = NULL;
                    unsigned char ucActionNumber = 0;
                    lcoIt = pActions->begin(); 
                    while (lcoIt != pActions->end())
                    {
                        pAction = (*lcoIt)();
                        CString strWidgetName(pAction->WidgetName().c_str());
                        while (strWidgetName.Find("_") > -1)
                        {
                           strWidgetName.SetAt(strWidgetName.Find("_"),_T(' '));
                        }
                        m_pctrlActionList->InsertItem(ucActionNumber,
                                                      strWidgetName,
                                                      ucActionNumber);
                        ucActionNumber++;
                        pAction->Deleting(true);

                        lcoIt++;
                    }


                    // Set the image list to the list stored in the map
                    // of action image lists based on the name of the
                    // new active tab.
                    _FSI_STL::string stlStrTabItem(TabItem.pszText);
                    if (m_mapActionImageLists.find(stlStrTabItem) != 
                                                   m_mapActionImageLists.end())
                    {
                        m_pctrlActionList->SetImageList(
                                        m_mapActionImageLists[TabItem.pszText],
                                        LVSIL_NORMAL);
                    }
                }

                return TRUE;
            }
            else
            {
                return CStatic::OnNotify(wParam, lParam, pResult);
            }
        }
        break;
    }
	
	return CStatic::OnNotify(wParam, lParam, pResult);
}

int CEditorControls::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CStatic::OnCreate(lpCreateStruct) == -1)
    {
        return -1;
    }

    // Allocate and create the upper tab control for the graphical element
    // widgets.
    m_pctrlWidgetTab = new CTabCtrl;
    if (!m_pctrlWidgetTab->CreateEx(WS_EX_CLIENTEDGE, WC_TABCONTROL, NULL,
                                  TCS_BOTTOM | TCS_MULTILINE | WS_BORDER | 
                                  WS_VISIBLE | WS_CHILD,
                                  CRect(0,0,1,1),this,IDC_WIDGET_TAB))
    {
        return -1;
    }

    // Allocate and create the lower tab control for the action
    // widgets.
    m_pctrlActionTab = new CTabCtrl;
    if (!m_pctrlActionTab->CreateEx(WS_EX_CLIENTEDGE, WC_TABCONTROL, NULL,
                                  TCS_BOTTOM | TCS_MULTILINE | WS_BORDER | 
                                  WS_VISIBLE | WS_CHILD,
                                  CRect(0,0,1,1),this,IDC_ACTION_TAB))
    {
        return -1;
    }

    char cTabText[64];
    TC_ITEM TabItem;
    TabItem.mask    = TCIF_TEXT;
    TabItem.pszText = cTabText;

    _FSI_STL::map<_FSI_STL::string, CImageList*>::iterator mIt = NULL;
    _FSI_STL::map<_FSI_STL::string, CImageList*>::iterator mendIt = NULL;

    mIt = m_mapImageLists.begin();
    mendIt = m_mapImageLists.end();

    while (mIt != mendIt)
    {
        strcpy(cTabText, (*mIt).first.c_str());
        m_pctrlWidgetTab->InsertItem(0,&TabItem);
        m_pctrlActionTab->InsertItem(0, &TabItem);

        mIt++;
    }

    return TRUE;
}

BOOL CEditorControls::Create(CWnd* pParentWnd) 
{
    BOOL bRetVal = CStatic::Create(_T(""), WS_CHILD | WS_VISIBLE, CRect(0,0,1,1),
                                   pParentWnd, IDC_STATIC);

    m_pctrlWidgetTab = static_cast<CTabCtrl*>(GetDlgItem(IDC_WIDGET_TAB));
    m_pctrlActionTab = static_cast<CTabCtrl*>(GetDlgItem(IDC_ACTION_TAB));
    if (m_bFirstInit == true)
    {
        m_pListCtrl = new CListCtrl;
        if (m_pListCtrl != NULL)
        {
            m_pListCtrl->CreateEx(WS_EX_CLIENTEDGE, WC_LISTVIEW, NULL,
                                  WS_VISIBLE | WS_CHILD | LVS_ALIGNTOP | 
                                            LVS_ICON | LVS_SINGLESEL,
                                  CRect(0,0,1,1), m_pctrlWidgetTab, 0x1133);
        }

        m_pctrlActionList = new CListCtrl;
        if (m_pctrlActionList != NULL)
        {
            m_pctrlActionList->CreateEx(WS_EX_CLIENTEDGE, WC_LISTVIEW, NULL,
                                  WS_VISIBLE | WS_CHILD | LVS_ALIGNTOP | 
                                            LVS_ICON | LVS_SINGLESEL,
                                  CRect(0,0,1,1), m_pctrlActionTab, 0x1132);
        }

    }

    NMHDR nmhdr;
    nmhdr.code      = TCN_SELCHANGE;

    if (m_pctrlWidgetTab != NULL)
    {
        nmhdr.idFrom = IDC_WIDGET_TAB;
        SendMessage(WM_NOTIFY, IDC_WIDGET_TAB, (long)&nmhdr);
    }

    if (m_pctrlActionTab != NULL)
    {
        nmhdr.idFrom = IDC_ACTION_TAB;
        SendMessage(WM_NOTIFY, IDC_ACTION_TAB, (long)&nmhdr);
    }

	return bRetVal;
}

void CEditorControls::OnDestroy() 
{
	CStatic::OnDestroy();

    // Destroy the upper list control.
    if (m_pListCtrl != NULL) 
    {
        m_pListCtrl->DestroyWindow();	
    }

    // Destroy the lower list control.
    if (m_pctrlActionList != NULL) 
    {
        m_pctrlActionList->DestroyWindow();	
    }
}

void CEditorControls::OnLButtonUp(UINT nFlags, CPoint point) 
{
    // Make sure that the mouse is currently in a drag and drop mode
    if (GetCapture() == this && m_pDragImage != NULL)
    {
        // End the drag and drop mode.
        ReleaseCapture();

        m_pDragImage->DragLeave(GetDesktopWindow());
        m_pDragImage->EndDrag();
        delete m_pDragImage;
        m_pDragImage = NULL;

        // Get the window where the left button up occurred.
        CPoint ptScreen(point);
        ClientToScreen(&ptScreen);

        /*         
         * Get the handle of the window at this point. If the window
         * is a control that is disabled, hidden, or transparent, then
         * the parent's handle is returned.         
         */
        HWND hWndPoint = ::WindowFromPoint(ptScreen);
        if (hWndPoint == NULL)
            return;        

        /*
         * To look at the child windows of hWnd, screen coordinates
         * need to be converted to client coordinates.         
         */
        ::ScreenToClient(hWndPoint,&ptScreen);        

        /*
         * Search through all child windows at this point. This
         * will continue until no child windows remain.         
         */
        HWND hWndChild;
        while (TRUE)            
        {
            hWndChild = ::ChildWindowFromPoint(hWndPoint,ptScreen);
            if (hWndChild && hWndChild != hWndPoint)
                hWndPoint = hWndChild;            
            else
                break;
        }
        CWnd* pWnd = FromHandle(hWndChild);
        CWnd* pParentWnd = pWnd;
        while (pParentWnd != NULL && 
               !pParentWnd->IsKindOf(RUNTIME_CLASS(CFSISuiteView)))
        {
            pParentWnd = pParentWnd->GetParent();
        }

        // Make sure that it was on an acceptable window.  This should either
        // be the background of the main window or on top of another widget.
        if (pParentWnd != NULL)
        {
            // Since the text of the image in the list is the same as the 
            // widget, create a new widget based on the item text if it is 
            // found in the list (which it should since the image was present).
            CString strWidgetName;
            if (m_bAction == true)
            {
                strWidgetName = 
                           m_pctrlActionList->GetItemText(m_ushObjectNumber,0);
            }
            else
            {
                strWidgetName = m_pListCtrl->GetItemText(m_ushObjectNumber,0);
            }
            
            CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
            CMainFrame* pFrame = NULL;
            CWnd* pParent = GetParent();
            if (pParent) 
            {
                pParent = pParent->GetParent();
            }

            CRuntimeClass* pRC;
            if (pParent != NULL)
            {
                pRC = pParent->GetRuntimeClass();
            }

            // Make sure that the window is floating by checking to see
            // if a parent is CMiniDockFrameWnd.  If it is, change the
            // style to get rid of the SYSMENU.
            if (pParent != NULL && 
                (strstr(pRC->m_lpszClassName,"CMainFrame") != NULL))
            {
                pFrame = (CMainFrame*)pParent;
            }
            else
            {
                pFrame = (CMainFrame*)(pParent->GetParent());
            }
            CFSISuiteView* pView = (CFSISuiteView*)(pFrame->GetActiveView());
            CFSISuiteDoc* pDoc = pView->GetDocument();

            while (strWidgetName.Find(" ") > -1)
            {
                strWidgetName.SetAt(strWidgetName.Find(" "),_T('_'));
            }

            if (pApp->m_mapWidgets.find(strupr((char *)(LPCTSTR)strWidgetName)) != 
                                                      pApp->m_mapWidgets.end())
            {
                // Create the new widget
                CWidget* pWidget = 
                   pApp->m_mapWidgets[strupr((char*)(LPCTSTR)strWidgetName)]();
                if ( pWidget != NULL)
                {
                    pDoc->SetModifiedFlag();

                    // Add the widget to the document's list of widgets
                    pDoc->m_listWidgets.push_back(pWidget);

                    // Get the default size of the widget.
                    CRect rectWidget(pWidget->UpperLeft(),
                                     pWidget->LowerRight());

                    // Reset the coordinates based on the left button up point
                    // and the default width and height;
                    CPoint ptUpper = ptScreen;
                    CPoint ptLower(ptUpper.x + rectWidget.Width(),
                                   ptUpper.y + rectWidget.Height());

                    if (pDoc->SnapOn() == true)
                    {   
                        pDoc->Snap(ptUpper);
                        ptLower = CPoint(ptUpper.x + rectWidget.Width(),
                                         ptUpper.y + rectWidget.Height());
                        if (pDoc->SnapAll() == true)
                        {
                            pDoc->Snap(ptLower);
                        }
                    }
                    CExtentsPoint extPtUpper(ptUpper);
                    pWidget->UpperLeft(extPtUpper);
                    CExtentsPoint extPtLower(ptLower);
                    pWidget->LowerRight(extPtLower);

                    // Initialize the new widget
                    CXMLWidget* pXMLWidget = NULL;
                    // Find the parent widget
                    if (pWnd->IsKindOf(RUNTIME_CLASS(CFSISuiteView)))
                    {
                        pWidget->Initialize(pXMLWidget, pWnd, 
                                            IDC_WIDGET + 
                                                pDoc->m_listWidgets.size(),
                                            pDoc->EditMode());
                        if (pXMLWidget == NULL)
                        {
                        	CStatic::OnLButtonUp(nFlags, point);
                            return;
                        }
                        pWidget->BaseWidget(pWidget);
                        CXMLPage* pPage = pDoc->XMLPage();
                        if (pPage->AddWidget(pXMLWidget) == false)
                        {
                            // pXMLWidget may not be found in the list 
                            // of available widgets and pXMLWidget will 
                            // not get added to the list of XMLWidgets.  
                            // This will cause a memory leak.
                            AfxMessageBox("Memory leak in "\
                                          "CXMLPage::AddWidget() via "\
                                          "CEditorControls");
                        }

                    }
                    else
                    {
                        _FSI_STL::list<CWidget*>::iterator wlIt = 
                                              pDoc->m_listWidgets.begin();
                        while (wlIt != pDoc->m_listWidgets.end() &&
                               (*wlIt)->Wnd() != pWnd)
                        {
                            wlIt++;
                        }

                        // Special case for things like CGroupBoxWidget
                        // where a secondary window is created.
                        if (wlIt == pDoc->m_listWidgets.end())
                        {
                            wlIt = pDoc->m_listWidgets.begin();
                            while (wlIt != pDoc->m_listWidgets.end() &&
                                   (*wlIt)->Wnd() != pWnd->GetParent())
                            {
                                wlIt++;
                            }
                        }

                        // Add pWidget as a subwidget to *wlIt
                        // Initialize colors
                        // Set the parent widget
                        pWidget->Initialize(pXMLWidget, (*wlIt)->Wnd(), 
                                            IDC_WIDGET + pDoc->m_listWidgets.size(),
                                            pDoc->EditMode());
                        if (pXMLWidget == NULL)
                        {
                        	CStatic::OnLButtonUp(nFlags, point);
                            return;
                        }
                        (*wlIt)->AddWidget(pWidget);
                        pWidget->Background((*wlIt)->Background());
                        pWidget->BaseWidget((*wlIt)->BaseWidget());
                        pWidget->ParentWidget(*wlIt);
                        
                        (*wlIt)->XMLWidget()->AddWidget(pXMLWidget);
                    }

                    // Add another undo state
                    CXMLPage* pXMLPage = new CXMLPage;
                    CXMLPage* pCurrXMLPage = pDoc->XMLPage();
                    if (pCurrXMLPage != NULL)
                    {
                        *pXMLPage = *pCurrXMLPage;
                        pDoc->m_undoPages.ok_push(pXMLPage);
                    }

                    pFrame->EditorTree()->AddWidgets(pDoc);
                }
            } // if (pApp->m...find(...))
            else 
            {
                _FSI_STL::string stlStrWidgetName = 
                                        strupr((char *)(LPCTSTR)strWidgetName);
                if (pApp->m_mapActions.find(stlStrWidgetName) != 
                                                      pApp->m_mapActions.end())
                {
                    // Create the new widget
                    CWidget* pAction = pApp->m_mapActions[stlStrWidgetName]();
                    if ( pAction != NULL)
                    {
                        pDoc->SetModifiedFlag();

                        // Add the widget to the document's list of widgets
                        pDoc->m_listWidgets.push_back(pAction);

                        // Initialize the new widget
                        CXMLWidget* pXMLWidget = NULL;
                        // Find the parent widget
                        // If an action is placed on the main page,
                        // nothing will happen.  
                        if (pWnd->IsKindOf(RUNTIME_CLASS(CFSISuiteView)))
                        {
                            pAction->Initialize(pXMLWidget, pWnd,
                                                IDC_WIDGET + 
                                                pDoc->m_listWidgets.size(),
                                                pDoc->EditMode());
                            if (pXMLWidget == NULL)
                            {
                        	    CStatic::OnLButtonUp(nFlags, point);
                                return;
                            }
                            pAction->BaseWidget(pAction);
                            if (pDoc->XMLPage()->AddWidget(pXMLWidget) == 
                                                                     false)
                            {
                                // pXMLWidget may not be found in the list 
                                // of available widgets and pXMLWidget will 
                                // not get added to the list of XMLWidgets.  
                                // This will cause a memory leak.
                                AfxMessageBox("Memory leak in "\
                                              "CXMLPage::AddWidget() via "\
                                              "CEditorControls");
                            }

                        }
                        else
                        {
                            _FSI_STL::list<CWidget*>::iterator wlIt = 
                                               pDoc->m_listWidgets.begin();
                            while (wlIt != pDoc->m_listWidgets.end() &&
                                   (*wlIt)->Wnd() != pWnd)
                            {
                                wlIt++;
                            }

                            // Special case for things like CGroupBoxWidget
                            // where a secondary window is created.
                            if (wlIt == pDoc->m_listWidgets.end())
                            {
                                wlIt = pDoc->m_listWidgets.begin();
                                while (wlIt != pDoc->m_listWidgets.end() &&
                                       (*wlIt)->Wnd() != pWnd->GetParent())
                                {
                                    wlIt++;
                                }
                            }

                            // Add pWidget as a subwidget to *wlIt
                            // Initialize colors
                            // Set the parent widget
                            pAction->Initialize(pXMLWidget, (*wlIt)->Wnd(), 
                                                IDC_WIDGET + 
                                                pDoc->m_listWidgets.size(),
                                                pDoc->EditMode());
                            if (pXMLWidget == NULL)
                            {
                        	    CStatic::OnLButtonUp(nFlags, point);
                                return;
                            }
                            (*wlIt)->AddAction(pAction->Action());
                            pAction->Background((*wlIt)->Background());
                            pAction->BaseWidget((*wlIt)->BaseWidget());
                            pAction->ParentWidget(*wlIt);
                        
                            (*wlIt)->XMLWidget()->AddWidget(pXMLWidget);
                        }

                        // Add another undo state
                        CXMLPage* pXMLPage = new CXMLPage;
                        CXMLPage* pCurrXMLPage = pDoc->XMLPage();
                        if (pCurrXMLPage != NULL)
                        {
                            *pXMLPage = *pCurrXMLPage;
                            pDoc->m_undoPages.ok_push(pXMLPage);
                        }

                        pFrame->EditorTree()->AddWidgets(pDoc);
                    }
                }
            } // else if (pApp->m_map...find(...))
        } // if (pParentWnd != NULL)
    }
	
	CStatic::OnLButtonUp(nFlags, point);
}

void CEditorControls::OnMouseMove(UINT nFlags, CPoint point) 
{
    if (GetCapture() == this && m_pDragImage != NULL)
    {
        CPoint ptScreen(point);
        ClientToScreen(&ptScreen);
        CWnd* pWnd = WindowFromPoint(ptScreen);

        while (pWnd != NULL && !pWnd->IsKindOf(RUNTIME_CLASS(CFSISuiteView)))
        {
            pWnd = pWnd->GetParent();
        }

        if (pWnd != NULL)
        {
            SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
        }
        else
        {
            SetCursor(AfxGetApp()->LoadStandardCursor(IDC_NO));
        }

        m_pDragImage->DragMove(ptScreen);
    }
	
	CStatic::OnMouseMove(nFlags, point);
}

BOOL CEditorControls::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CS_OWNDC;

	return CStatic::PreCreateWindow(cs);
}
