#ifndef _DEPTHPAGE_H_
#define _DEPTHPAGE_H_

#include "..\core\BasePage.h"

#include "resource.h"

const unsigned char ucMAX_FILE_CACHE = 15;
const unsigned char ucMIN_FILE_CACHE = 0;
const unsigned char ucMAX_UNDO_DEPTH = 50;
const unsigned char ucMIN_UNDO_DEPTH = 5;

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DepthPage.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CDepthPage dialog

class CDepthPage : public CBasePage
{
private:
    unsigned short m_ushFileCacheDepth;
    unsigned short m_ushUndoDepth;

// Construction
public:
	CDepthPage();   // standard constructor
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CDepthPage)
	enum { IDD = IDD_SUITE_PAGE_DEPTH };
	CStatic	m_ctrlUndoDepthStatic;
	CStatic	m_ctrlCacheValueStatic;
	CSliderCtrl	m_ctrlUndoDepthSlider;
	CSliderCtrl	m_ctrlFileCacheSlider;
	CStatic	m_ctrlMinUndoStatic;
	CStatic	m_ctrlMaxUndoStatic;
	CStatic	m_ctrlMinCacheStatic;
	CStatic	m_ctrlMaxCacheStatic;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDepthPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDepthPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    void InitializeFileCacheSlider();
    void InitializeUndoDepthSlider();

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // #ifndef _DEPTHPAGE_H_
