// DepthPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "DepthPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDepthPage dialog


CDepthPage::CDepthPage() : CBasePage(CDepthPage::IDD)
{
	//{{AFX_DATA_INIT(CDepthPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    m_ushFileCacheDepth = 0;
    m_ushUndoDepth      = 0;
    m_stlStrPageName    = _FSI_STL::string("File Cache and Undo Sizes");
}

void CDepthPage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDepthPage)
	DDX_Control(pDX, IDC_UNDO_DEPTH_STATIC, m_ctrlUndoDepthStatic);
	DDX_Control(pDX, IDC_CACHE_VALUE_STATIC, m_ctrlCacheValueStatic);
	DDX_Control(pDX, IDC_UNDO_SLIDER, m_ctrlUndoDepthSlider);
	DDX_Control(pDX, IDC_CACHE_SLIDER, m_ctrlFileCacheSlider);
	DDX_Control(pDX, IDC_UNDO_MIN_STATIC, m_ctrlMinUndoStatic);
	DDX_Control(pDX, IDC_UNDO_MAX_STATIC, m_ctrlMaxUndoStatic);
	DDX_Control(pDX, IDC_CACHE_MIN_STATIC, m_ctrlMinCacheStatic);
	DDX_Control(pDX, IDC_CACHE_MAX_STATIC, m_ctrlMaxCacheStatic);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDepthPage, CDialog)
	//{{AFX_MSG_MAP(CDepthPage)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDepthPage message handlers
BOOL CDepthPage::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
    char cConvertedNumber[32];
    itoa(ucMAX_FILE_CACHE,cConvertedNumber,10);
    m_ctrlMaxCacheStatic.SetWindowText(cConvertedNumber);
    itoa(ucMIN_FILE_CACHE,cConvertedNumber,10);
    m_ctrlMinCacheStatic.SetWindowText(cConvertedNumber);
    itoa(ucMAX_UNDO_DEPTH,cConvertedNumber,10);
    m_ctrlMaxUndoStatic.SetWindowText(cConvertedNumber);
    itoa(ucMIN_UNDO_DEPTH,cConvertedNumber,10);
    m_ctrlMinUndoStatic.SetWindowText(cConvertedNumber);

    m_ctrlFileCacheSlider.SetRange(ucMIN_FILE_CACHE,ucMAX_FILE_CACHE);
    m_ctrlUndoDepthSlider.SetRange(ucMIN_UNDO_DEPTH,ucMAX_UNDO_DEPTH);

    InitializeFileCacheSlider();
    CString strValue;
    strValue.Format("%d",m_ushFileCacheDepth);
    m_ctrlCacheValueStatic.SetWindowText(strValue);
    m_ctrlFileCacheSlider.SetPos(m_ushFileCacheDepth);

    InitializeUndoDepthSlider();
    strValue.Format("%d",m_ushUndoDepth);
    m_ctrlUndoDepthStatic.SetWindowText(strValue);
    m_ctrlUndoDepthSlider.SetPos(m_ushUndoDepth);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDepthPage::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
    char cConvertedNumber[32];

    CString strCurrentValue;
    m_ctrlCacheValueStatic.GetWindowText(strCurrentValue);
    if (m_ctrlFileCacheSlider.GetPos() != atoi((LPCTSTR)strCurrentValue))
    {
        itoa(m_ctrlFileCacheSlider.GetPos(),cConvertedNumber,10);
        m_ctrlCacheValueStatic.SetWindowText(cConvertedNumber);
    }

    m_ctrlUndoDepthStatic.GetWindowText(strCurrentValue);
    if (m_ctrlUndoDepthSlider.GetPos() != atoi((LPCTSTR)strCurrentValue))
    {
        itoa(m_ctrlUndoDepthSlider.GetPos(),cConvertedNumber,10);
        m_ctrlUndoDepthStatic.SetWindowText(cConvertedNumber);
    }
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CDepthPage::InitializeFileCacheSlider()
{
    char cConvertedNumber[32];

    m_ctrlFileCacheSlider.SetPos(ucMAX_FILE_CACHE);
    itoa(ucMAX_FILE_CACHE,cConvertedNumber,10);
    m_ctrlCacheValueStatic.SetWindowText(cConvertedNumber);
}

void CDepthPage::InitializeUndoDepthSlider()
{
    char cConvertedNumber[32];

    m_ctrlUndoDepthSlider.SetPos(ucMAX_UNDO_DEPTH);
    itoa(ucMAX_UNDO_DEPTH,cConvertedNumber,10);
    m_ctrlUndoDepthStatic.SetWindowText(cConvertedNumber);
}

CBasePage* CDepthPage::CreateObject()
{
    return new CDepthPage;
}

void CDepthPage::SetProperties(void* pWidget)
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("FileCacheSize"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        m_ushFileCacheDepth = ulData;       

        RegQueryValueEx(hKey, _T("UndoSize"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);
        m_ushUndoDepth = ulData;       

        RegCloseKey(hKey);
    }
}

void CDepthPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"),
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);

        unsigned long int ulData;
        DWORD dwSize = sizeof(unsigned long int);
        ulData = m_ctrlFileCacheSlider.GetPos();
        RegSetValueEx(hKey, _T("FileCacheSize"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        ulData = m_ctrlUndoDepthSlider.GetPos();
        RegSetValueEx(hKey, _T("UndoSize"), NULL, REG_DWORD, (BYTE*)&ulData, 
                        dwSize);

        RegCloseKey(hKey);
    }
}