// ComponentPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "FSISuite.h"
#include "ComponentPage.h"
#include "Options.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CComponentPage dialog


CComponentPage::CComponentPage()
	: CBasePage(CComponentPage::IDD)
{
	//{{AFX_DATA_INIT(CComponentPage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Components");
}

void CComponentPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CComponentPage)
	DDX_Control(pDX, IDC_COMPONENT_DELETE_BUTTON, m_ctrlDeleteComponentButton);
	DDX_Control(pDX, IDC_COMPONENT_ADD_BUTTON, m_ctrlAddComponentButton);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CComponentPage, CBasePage)
	//{{AFX_MSG_MAP(CComponentPage)
	ON_BN_CLICKED(IDC_COMPONENT_ADD_BUTTON, OnComponentAddButton)
	ON_BN_CLICKED(IDC_COMPONENT_DELETE_BUTTON, OnComponentDeleteButton)
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_TREEITEM_STATE_CHANGE, OnTreeItemStateChange)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CComponentPage message handlers

BOOL CComponentPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	// TODO: Add extra initialization here

    m_imageState.Create(IDB_STATE, 13, 1, RGB(255,255,255));

    m_wndTreeList.SubclassDlgItem(IDC_COMPONENT_CUSTOM, this);
    m_wndTreeList.m_tree.SetImageList(&m_imageState, TVSIL_STATE);

    // If libraries have been loaded, then get their property dialogs.
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    STRING2CI_MAP s2cimap = pApp->GetComponentInterfaces();
    STRING2CI_MAP::iterator s2ciIt = s2cimap.begin();
    STRING2CI_MAP::iterator s2ciendIt = s2cimap.end();
    CComponentInterface* pCI;

    CNewTreeListCtrl* pTree = &m_wndTreeList.m_tree;
    pTree->InsertColumn(0, "Name",LVCFMT_LEFT, 150);
    pTree->InsertColumn(1, "Data",LVCFMT_LEFT, 450);
    while (s2ciIt != s2ciendIt)
    {
        pCI = (*s2ciIt).second;
        HTREEITEM hTreeItem = TVI_ROOT;
        HTREEITEM hTreeChild;

        hTreeItem = pTree->InsertItem((pCI->ComponentName()).c_str(),0,0);
        pTree->SetCheck(hTreeItem);
        pTree->SetItemColor(hTreeItem,RGB(0,0,0));

        hTreeChild = pTree->InsertItem("Path:",0,0,hTreeItem);

        pTree->SetItemText(hTreeChild,1,(pCI->PathName()).c_str());

        hTreeChild = pTree->InsertItem("Revision Date:",0,0,hTreeItem);
        pTree->SetItemText(hTreeChild,1,(pCI->RevisionDate()).c_str());

        s2ciIt++;
    }

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CComponentPage::OnComponentAddButton() 
{
	// TODO: Add your control notification handler code here
	CFileDialog cfd(TRUE,"dll",NULL,NULL,
					"Component plugin libraries (*.dll)|*.dll|All Files "
					"(*.*)|*.*||",this);
	long int lReturnVal = 0;

	lReturnVal = cfd.DoModal();
	if (lReturnVal && lReturnVal != IDCANCEL)
	{
		// A dll was chosen to add in.  Attempt to load the dll and then check 
		// it for  compatability with the library interface.  If these succeed,
		// then add it to the list/map of plugins and to the tree.
        AddComponent(NULL, cfd.GetPathName());
	}
	
}

void CComponentPage::OnComponentDeleteButton() 
{
	// TODO: Add your control notification handler code here
	HTREEITEM hTreeSelected = m_wndTreeList.m_tree.GetSelectedItem();
	if (hTreeSelected != NULL)
	{
        HTREEITEM hTreePath = m_wndTreeList.m_tree.GetChildItem(hTreeSelected);
        HTREEITEM hTreeRevision = m_wndTreeList.m_tree.GetNextItem(hTreePath,TVGN_NEXT);
        if (DeleteComponent(hTreeSelected) == true)
        {
            m_wndTreeList.m_tree.DeleteItem(hTreeRevision);
            m_wndTreeList.m_tree.DeleteItem(hTreePath);
    		m_wndTreeList.m_tree.DeleteItem(hTreeSelected);
        }
	}
	else
	{
        ::MessageBox(GetSafeHwnd(),
                     _T("A component library could not be deleted because a "\
                        "component was not selected."),
                     _T("Error"),
                     MB_OK);
	}
}

/////////////////////////////////////////////////////////////////////////////
//
// void CComponentPage::OnTreeItemStateChange()
//
// Inputs           : WPARAM wParam - a 32-bit value sent in a 
//                                    WM_TREEITEM_STATE_CHANGE message
//                    LPARAM lParam - another 32-bit value sent in a 
//                                    WM_TREEITEM_STATE_CHANGE message. 
//                                    This value should be a pointer to 
//                                    a CNewTreeListCtrl.
//                    
// Return Values    : 
//
// Date             : 24 September 1998
//
// Engineer         : Billy Baker
//
// Description      : OnTreeItemStateChange is a message handler for a 
//                    state change in a CNewTreeListCtrl item.  The
//                    OnLButtonDown handler in CNewTreeListCtrl will 
//                    toggle the state of the item and then post a
//                    WM_TREEITEM_STATE_CHANGE message to the parent 
//                    of the parent of the CNewTreeListCtrl.  The first
//                    parent is a CTLFrame and the second should be a
//                    window or dialog.  For CComponentPage, a component
//                    library is loaded or unloaded depending on the
//                    state of the item.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CComponentPage::OnTreeItemStateChange(WPARAM wParam, LPARAM lParam)
{
    CNewTreeListCtrl* pTree = (CNewTreeListCtrl*)lParam;

    if (pTree == NULL)
    {
        return -1;
    }

    // Get the selected item.
	HTREEITEM hTreeSelected = pTree->GetSelectedItem();
	if (hTreeSelected != NULL)
	{
        if (pTree->GetCheck(hTreeSelected) == 0)
        {
            DeleteComponent(hTreeSelected);
	    }
        else 
        {
            // If the item has been selected, load a library.
            // On failure, set the check box back to unchecked and
            // the text color back to red.
            HTREEITEM hTreePath = 
                              m_wndTreeList.m_tree.GetChildItem(hTreeSelected);
            CString strPathName = m_wndTreeList.m_tree.GetItemText(hTreePath,1);
            if (AddComponent(hTreeSelected,strPathName) == false)
            {
                m_wndTreeList.m_tree.SetCheck(0);
                m_wndTreeList.m_tree.SetItemColor(hTreeSelected,RGB(255,0,0));
                ::MessageBox(GetSafeHwnd(),
                             _T("A component library corresponding to " + 
                                strPathName + " could not be loaded."),
                             _T("Error"),
                             MB_OK);

            }
        }
    }
	else        
	{
        // no selected item
        ::MessageBox(GetSafeHwnd(),
                     _T("A component library could not be deleted because a "\
                        "component was not selected."),
                     _T("Error"),
                     MB_OK);
	}

    return 0;

}

CBasePage* CComponentPage::CreateObject()
{
    return new CComponentPage;
}

bool CComponentPage::DeleteComponent(HTREEITEM hTreeSelected)
{
    bool bRetVal = false;
    if (hTreeSelected != NULL)
    {
        CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
        CString strComponent = m_wndTreeList.m_tree.GetItemText(hTreeSelected);
        HTREEITEM hTreePath = m_wndTreeList.m_tree.GetChildItem(hTreeSelected);
        CString strPathName = m_wndTreeList.m_tree.GetItemText(hTreePath, 1);
        CWnd* pWnd = GetParent()->GetParent();
        ((COptions*)pWnd)->DeleteTreeItem(strComponent);
        if (pApp->DeleteComponentLibrary(strPathName) == true)
        {
            long int lLibraryCount = 0;
            long int lLibraryStep = 1;
            long int lDeletedLibrary = 0;
            lLibraryCount = pApp->FSI_GetProfileInt(_T("Settings"),
                                                _T("LibraryCount"), 0);
            CString strLibraryXXX;
            CString strLibraryPath;
            HKEY hKey;
            
            for (; lLibraryStep <= lLibraryCount; lLibraryStep++)
            {
                strLibraryXXX.Format("Library%d",lLibraryStep);
                strLibraryPath = pApp->FSI_GetProfileString(_T("Settings"), 
                                                        (LPCTSTR)strLibraryXXX,
                                                        "");
                if (strLibraryPath == strPathName)
                {
                    lDeletedLibrary = lLibraryStep;
                    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_ALL_ACCESS, &hKey);
                    RegDeleteValue(hKey, (LPCSTR)strLibraryXXX);
                    RegCloseKey(hKey);
                }
                else if (lDeletedLibrary > 0)
                {
                    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_ALL_ACCESS, &hKey);
                    RegDeleteValue(hKey, (LPCSTR)strLibraryXXX);

                    strLibraryXXX.Format("Library%d",lDeletedLibrary);

                    RegSetValueEx(hKey,
                                  (LPCTSTR)strLibraryXXX,
                                  0, REG_SZ, (CONST BYTE*)(LPCTSTR)strLibraryPath,
                                  strLibraryPath.GetLength() + 1);
                    RegCloseKey(hKey);
                    lDeletedLibrary++;
                }
            }

            lLibraryCount--;
            pApp->FSI_WriteProfileInt(_T("Settings"),_T("LibraryCount"), lLibraryCount);

            bRetVal = true;
        }
        else
        {
            ::MessageBox(GetSafeHwnd(),
                         _T("A component library could not be deleted because "\
                            "a library corresponding to " + strPathName + 
                            " could not be found in the list of loaded "\
                            "libraries."),
                         _T("Error"),
                         MB_OK);

        }
    }
    return bRetVal;
}

bool CComponentPage::AddComponent(HTREEITEM hTreeSelected, CString strPathName)
{
    bool bRetVal = false;
    CFSISuiteApp* pApp = (CFSISuiteApp*)AfxGetApp();
    CComponentInterface* pCI = NULL;
    if (pApp->LoadComponentLibrary(strPathName, pCI) == true)
    {
        if (pCI != NULL)
        {
            HTREEITEM hTreePrevious = NULL;
            if (hTreeSelected != NULL)
            {
                // Delete the previous tree items since a new library could
                // have been copied to the hard drive.
                HTREEITEM hTreePath = m_wndTreeList.m_tree.GetChildItem(hTreeSelected);
                HTREEITEM hTreeRevision = m_wndTreeList.m_tree.GetNextItem(hTreePath,TVGN_NEXT);
                if (hTreeRevision != NULL)
                {
                    m_wndTreeList.m_tree.DeleteItem(hTreeRevision);
                }

                if (hTreePath != NULL)
                {
                    m_wndTreeList.m_tree.DeleteItem(hTreePath);
                }
            
                hTreePrevious = m_wndTreeList.m_tree.GetNextItem(hTreeSelected,
                                                                 TVGN_PREVIOUS);

    		    m_wndTreeList.m_tree.DeleteItem(hTreeSelected);
            }

            if (hTreePrevious == NULL)
            {
                hTreePrevious = TVI_ROOT;
            }

            pApp->LoadComponentConfig(pCI);

            HTREEITEM hTreeItem = TVI_ROOT;
            HTREEITEM hTreeChild;
            CNewTreeListCtrl* pTree = &m_wndTreeList.m_tree;
            hTreeItem = pTree->InsertItem((pCI->ComponentName()).c_str(),
                                          0, 0, TVI_ROOT, hTreePrevious);
            pTree->SetCheck(hTreeItem);
            pTree->SetItemColor(hTreeItem,RGB(0,255,0));

            hTreeChild = pTree->InsertItem("Path:",0,0,hTreeItem);
            
            CString strComponent((pCI->ComponentName()).c_str());
            pTree->SetItemText(hTreeChild,1,(pCI->PathName()).c_str());
            CWnd* pWnd = GetParent()->GetParent();
            ((COptions*)pWnd)->InsertTreeItem(strComponent);

            hTreeChild = pTree->InsertItem("Revision Date:",0,0,hTreeItem);
            pTree->SetItemText(hTreeChild,1,(pCI->RevisionDate()).c_str());

            // Add the newly loaded component to the libraries in the
            // registry.  First, increment the count.  Then, add the
            // path to the library.
            long int lLibraryCount = 0;
            lLibraryCount = pApp->FSI_GetProfileInt(_T("Settings"),
                                                _T("LibraryCount"), 0);
            lLibraryCount++;
            pApp->FSI_WriteProfileInt(_T("Settings"),_T("LibraryCount"), lLibraryCount);

            CString strLibraryXXX;
            strLibraryXXX.Format("Library%d",lLibraryCount);
            pApp->FSI_WriteProfileString(_T("Settings"), (LPCTSTR)strLibraryXXX,
                                   (LPCTSTR)strPathName);

            bRetVal = true;
        }
    }
     
    return bRetVal;
}
