// ColorFontPage.cpp : implementation file
//

#include "..\core\stdafx.h"

#include "resource.h"

#include "..\core\BasePage.h"
#include "..\core\Color.h"
#include "..\core\ColorPage.h"
#include "..\core\Widget.h"

#include <map>
#include <string>

#include "ColorFontPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorFontPage dialog


CColorFontPage::CColorFontPage() : CBasePage(CColorFontPage::IDD)
{
	//{{AFX_DATA_INIT(CColorFontPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Global Colors/Fonts");

    long int i = 0;
    for (i = 0; i < GLOBAL_COLORS; i++)
    {
        m_mapParameters[cGlobalColors[i]] = _FSI_STL::string("");
    }

    for (i = 0; i < GLOBAL_FONTS; i++)
    {
        m_mapParameters[cGlobalFonts[i]] = _FSI_STL::string("");
    }

    CWindowDC dc(GetDesktopWindow() );

	m_lPixelsPerInch = GetDeviceCaps(dc, LOGPIXELSY);	
	CFont *pfont = dc.GetCurrentFont();		
    pfont->GetLogFont( &m_logfont );
    
    m_font.CreateFontIndirect( &m_logfont );
}

CColorFontPage::~CColorFontPage()
{
    m_font.DeleteObject();	
}


void CColorFontPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColorFontPage)
	DDX_Control(pDX, IDC_CHANGE_GLOBAL_COLOR, m_wndColorChange);
	DDX_Control(pDX, IDC_CHANGE_GLOBAL_FONT, m_wndFontChange);
	DDX_Control(pDX, IDC_COLOR_FONT_LIST, m_ctrlColorFontList);
	DDX_Control(pDX, IDC_SAMPLE_FONT, m_staticSample);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CColorFontPage, CBasePage)
	//{{AFX_MSG_MAP(CColorFontPage)
	ON_BN_CLICKED(IDC_CHANGE_GLOBAL_COLOR, OnChangeGlobalColor)
	ON_BN_CLICKED(IDC_CHANGE_GLOBAL_FONT, OnChangeGlobalFont)
	ON_NOTIFY(NM_CLICK, IDC_COLOR_FONT_LIST, OnClickColorFontList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorFontPage message handlers
CBasePage* CColorFontPage::CreateObject()
{
    return new CColorFontPage;
}

void CColorFontPage::SetProperties(void* pWidget)
{
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 0, KEY_READ, &hKey);
    if (hKey != NULL)
    {
        STRING2STRING_MAP::iterator mIt = m_mapParameters.begin();
		CString strValue;
        DWORD dwType, dwCount;
        LONG lResult;

        for (; mIt != m_mapParameters.end(); mIt++)
        {
            strValue = "";

		    lResult = RegQueryValueEx(hKey, (*mIt).first.c_str(), 
                                           NULL, &dwType, NULL, &dwCount);
		    if (lResult == ERROR_SUCCESS)
		    {
			    ASSERT(dwType == REG_SZ);
			    lResult = RegQueryValueEx(hKey, (*mIt).first.c_str(), NULL, 
                                          &dwType,
				                (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                          &dwCount);

			    strValue.ReleaseBuffer();
		    }
            (*mIt).second = _FSI_STL::string((LPCTSTR)strValue);
        }

        RegCloseKey(hKey);
    }
}

void CColorFontPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    HKEY hKey;
    DWORD dw;
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Settings"), 
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);

        STRING2STRING_MAP::iterator mIt = m_mapParameters.begin();

        for (; mIt != m_mapParameters.end(); mIt++)
        {
            RegSetValueEx(hKey, (*mIt).first.c_str(), NULL, REG_SZ, 
                            (BYTE*)(*mIt).second.c_str(), 
                            (*mIt).second.size() + 1);
        }

        RegCloseKey(hKey);
    }
}

BOOL CColorFontPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    m_ctrlColorFontList.SetExtendedStyle(m_ctrlColorFontList.GetExtendedStyle() & 
                                         LVS_EX_FULLROWSELECT);

    m_ctrlColorFontList.InsertColumn(0,"Parameter", LVCFMT_LEFT, 100);
    m_ctrlColorFontList.InsertColumn(1, "Data", LVCFMT_LEFT, 170);
	
	// TODO: Add extra initialization here
    m_colorStatic.SubclassDlgItem(IDC_GLOBAL_COLOR,this);
    m_colorStatic.Color(m_color);

    m_wndColorChange.EnableWindow(FALSE);
    m_wndFontChange.EnableWindow(FALSE);

    STRING2STRING_MAP::iterator mIt = m_mapParameters.begin();
    long int lColorFontStep = 0;
    for (; mIt != m_mapParameters.end(); mIt++, lColorFontStep++)
    {
        m_ctrlColorFontList.InsertItem(lColorFontStep, (*mIt).first.c_str());
        m_ctrlColorFontList.SetItemText(lColorFontStep, 1, (*mIt).second.c_str());
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CColorFontPage::OnChangeGlobalColor() 
{
    // get the current data
    POSITION pos = m_ctrlColorFontList.GetFirstSelectedItemPosition();
    long int lSelectedIndex = -1;
    CString strColorFontName = "";

    // If found, then reset m_color to the data for the parameter.
    if (pos != NULL)
    {
        
        lSelectedIndex = m_ctrlColorFontList.GetNextSelectedItem(pos);
        strColorFontName = m_ctrlColorFontList.GetItemText(lSelectedIndex, 0);
        CString strColor = 
                        m_ctrlColorFontList.GetItemText(lSelectedIndex, 1);

        CString str = "";
        if (strColor.Find(",") > -1)
        {
            str = strColor.Mid(strColor.Find(",") + 1);
            strColor.Format("%03s",strColor.Left(strColor.Find(",")));
        }
        if (str.Find(",") > -1)
        {
            strColor.Format("%s%03s%03s", strColor, str.Left(str.Find(",")),
                                          str.Mid(str.Find(",") + 1));
        }

        if (strColor != "")
        {
            m_color = CColor(strColor);
        }
        else
        {
            m_color = CColor();
        }
    }
    else 
    {
        m_color = CColor();
    }

    CColorDialog    cd((COLORREF)m_color,0,this);

    if (cd.DoModal() == IDOK)
    {
        // Change the color.
        m_color = CColor(cd.GetColor());
        m_colorStatic.Color(m_color);
        m_colorStatic.Invalidate();

        // Update the data field if possible.
        if (lSelectedIndex > -1)
        {
            CString strValue;
            strValue.Format("%d,%d,%d",m_color.Red(), 
                                         m_color.Green(), 
                                         m_color.Blue());

            m_mapParameters[(LPCTSTR)strColorFontName] = 
                                                _FSI_STL::string((LPCTSTR)strValue);
            m_ctrlColorFontList.SetItemText(lSelectedIndex, 1, strValue);
        }
    }
}

void CColorFontPage::OnChangeGlobalFont() 
{
    // get the current data
    POSITION pos = m_ctrlColorFontList.GetFirstSelectedItemPosition();
    long int lSelectedIndex = -1;
    CString strColorFontName = "";

    // If found, then reset m_color to the data for the parameter.
    if (pos != NULL)
    {
        lSelectedIndex = m_ctrlColorFontList.GetNextSelectedItem(pos);
        strColorFontName = m_ctrlColorFontList.GetItemText(lSelectedIndex, 0);
        CString strFont = 
                        m_ctrlColorFontList.GetItemText(lSelectedIndex, 1);
        CString strFontName = "";
        CString strSize = "";

        if (strFont.Find(",") > -1)
        {
            strFontName = strFont.Left(strFont.Find(","));
            strSize = strFont.Mid(strFont.Find(",") + 1);
            if (strSize.Find(",") > -1)
            {
                strSize = strSize.Mid(strSize.Find(",") + 1);
            }
            else
            {
                strSize = "8";
            }
        }

	    m_font.GetLogFont( &m_logfont );	
        m_logfont.lfStrikeOut = false;
	    m_logfont.lfUnderline = false;
	    memcpy( m_logfont.lfFaceName, strFontName, LF_FACESIZE );

	    m_logfont.lfHeight = -MulDiv(atoi(strSize), m_lPixelsPerInch, 72);	 
	    m_logfont.lfWidth = 0;			
	    m_logfont.lfWeight = 400;			
        //Regular	
        m_logfont.lfItalic = FALSE;
	    if( strFont.Find( _T("Italic") ) != -1 )		
        {
            m_logfont.lfItalic = TRUE;
        }

	    if( strFont.Find( _T("Bold") ) != -1 )		
        {
            m_logfont.lfWeight = 700;
        }
    }
    else 
    {
	    m_font.GetLogFont( &m_logfont );	
    }

    CFontDialog    fd(&m_logfont, 
                      CF_SCREENFONTS | CF_NOSCRIPTSEL, 
                      NULL, 
                      this);

    if (fd.DoModal() == IDOK)
    {
	    m_font.DeleteObject();	
        m_font.CreateFontIndirect( &(fd.m_lf) );
 	    m_staticSample.SetFont(&m_font);	

        if (lSelectedIndex > -1)
        {
            CString strValue;
            CString strStyle;
            if (fd.m_lf.lfItalic > 0)
            {
                if (fd.m_lf.lfWeight == 700)
                {
                    strStyle = "Bold Italic";
                }
                else
                {
                    strStyle = "Italic";
                }
            }
            else if (fd.m_lf.lfWeight == 700)
            {
                strStyle = "Bold";
            }
            else
            {
                strStyle = "Regular";
            }
            strValue.Format("%s,%s,%d",fd.GetFaceName(), 
                                       strStyle, 
                                       fd.GetSize()/10);

            m_mapParameters[(LPCTSTR)strColorFontName] = 
                                                _FSI_STL::string((LPCTSTR)strValue);
            m_ctrlColorFontList.SetItemText(lSelectedIndex, 1, strValue);
        }
    }
}

void CColorFontPage::OnClickColorFontList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	UpdateData(TRUE);
    POSITION pos = m_ctrlColorFontList.GetFirstSelectedItemPosition();
    if (pos != NULL)
    {
        long int lSelectedIndex = m_ctrlColorFontList.GetNextSelectedItem(pos);
        CString strColorFontName = 
                            m_ctrlColorFontList.GetItemText(lSelectedIndex, 0);

        if (strColorFontName.Find("Color") > -1)
        {
            m_wndColorChange.EnableWindow(TRUE);
            m_wndFontChange.EnableWindow(FALSE);
            CString strColor = 
                            m_ctrlColorFontList.GetItemText(lSelectedIndex, 1);

            CString str = "";
            if (strColor.Find(",") > -1)
            {
                str = strColor.Mid(strColor.Find(",") + 1);
                strColor.Format("%03s",strColor.Left(strColor.Find(",")));
            }
            if (str.Find(",") > -1)
            {
                strColor.Format("%s%03s%03s", strColor, str.Left(str.Find(",")),
                                              str.Mid(str.Find(",") + 1));
            }

            if (strColor != "")
            {
                m_color = CColor(strColor);
            }
            else
            {
                m_color = CColor();
            }
            m_colorStatic.Color(m_color);
            m_colorStatic.Invalidate();
        }
        else if (strColorFontName.Find("Font") > -1)
        {
            m_wndColorChange.EnableWindow(FALSE);
            m_wndFontChange.EnableWindow(TRUE);

            CString strFont = 
                            m_ctrlColorFontList.GetItemText(lSelectedIndex, 1);
            CString strFontName = "";
            CString strSize = "";

            if (strFont.Find(",") > -1)
            {
                strFontName = strFont.Left(strFont.Find(","));
                strSize = strFont.Mid(strFont.Find(",") + 1);
                if (strSize.Find(",") > -1)
                {
                    strSize = strSize.Mid(strSize.Find(",") + 1);
                }
                else
                {
                    strSize = "8";
                }
            }

	        m_font.GetLogFont( &m_logfont );	
            m_logfont.lfStrikeOut = false;
	        m_logfont.lfUnderline = false;
	        memcpy( m_logfont.lfFaceName, strFontName, LF_FACESIZE );

	        m_logfont.lfHeight = -MulDiv(atoi(strSize), m_lPixelsPerInch, 72);	 
	        m_logfont.lfWidth = 0;			
	        m_logfont.lfWeight = 400;			
            //Regular	
            m_logfont.lfItalic = FALSE;
	        if( strFont.Find( _T("Italic") ) != -1 )		
            {
                m_logfont.lfItalic = TRUE;
            }

	        if( strFont.Find( _T("Bold") ) != -1 )		
            {
                m_logfont.lfWeight = 700;
            }

	        m_font.DeleteObject();	
            m_font.CreateFontIndirect( &m_logfont );
  	        m_staticSample.SetFont(&m_font);	
        }

        UpdateData(FALSE);
    }

	
	*pResult = 0;
}
