/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CollarContainer.h
//
// Date             : 07 July 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : CollarContainer.h contains the definition of the 
//                    CCollarContainer class.  This class serves as the
//                    parent window for widgets placed on any collar.  
//                    As the parent, this class will receive message to
//                    redraw the child widgets.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : 
//
// Components Used  : 
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other condtions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CollarContainer.h $
// Revision 1.5  2000/01/21 10:22:08  billyb
// Added CUpdateList as a parent.
// Revision 1.4  1999/11/29 06:49:45  billyb
// Removed private m_hWnd.  CWnd already has an m_hWnd.
// Revision 1.3  1999/11/26 20:14:44  billyb
// Changed update code to use new Core::CUpdateList class.
// Also set updating to false in OnDestroy.
// Revision 1.2  1999/11/04 20:56:14  billyb
// Added PreCreateWindow to add WS_CLIPCHILDREN and
// WS_CLIPSIBLINGS.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_COLLARCONTAINER_H_)
#define _COLLARCONTAINER_H_

#include "..\core\UpdateList.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CCollarContainer : public CStatic, public CUpdateList
{
// Construction
public:
	CCollarContainer();

// Attributes
protected:

public:

// Operations
protected:
    
public:
//	static UINT UpdateScreen(LPVOID param);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCollarContainer)
	protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCollarContainer();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCollarContainer)
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

    LPARAM OnUpdateScreen(WPARAM wParam, LPARAM lParam);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_COLLARCONTAINER_H_)
