// CollarContainer.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "..\core\Widget.h"
#include "..\core\UpdateList.h"
#include "FSISuite.h"
#include "MainFrm.h"
#include "CollarContainer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCollarContainer

CCollarContainer::CCollarContainer()
{
}

CCollarContainer::~CCollarContainer()
{
}


BEGIN_MESSAGE_MAP(CCollarContainer, CStatic)
	//{{AFX_MSG_MAP(CCollarContainer)
	ON_WM_DESTROY()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
    ON_MESSAGE(WM_UPDATE_SCREEN, OnUpdateScreen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// UINT CCollarContainer::OnUpdateScreen()
//
// Inputs           : WPARAM wParam - not used.
//                    LPARAM lParam - not used.
//
// Return Values    : 0
//
// Date             : 7 July 1999
//
// Engineer         : Billy Baker
//
// Description      : Message handler to redraw the widgets that need to be
//                    redrawn.
//
/////////////////////////////////////////////////////////////////////////////
LPARAM CCollarContainer::OnUpdateScreen(WPARAM wParam, LPARAM lParam)
{
    _FSI_STL::map<long, CWidget*>            updateList     = CUpdateList::GetList(m_hWnd);
    _FSI_STL::map<long, CWidget*>::iterator  lIt            = NULL;
    _FSI_STL::map<long, CWidget*>::iterator  lendIt         = NULL;

    lIt     = updateList.begin();
    lendIt  = updateList.end();

    while (lIt != lendIt)
    {
        if (CWidget::IsValidAddress((*lIt).second) == VALID)
        {
            (*lIt).second->Draw();
        }

        lIt++;
    }

    CWidget::ScreenRedrawing(m_hWnd, false);

    return 0;
}

BOOL CCollarContainer::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN | CS_OWNDC;

	return CStatic::PreCreateWindow(cs);
}

void CCollarContainer::OnDestroy() 
{
    CWidget::ScreenRedrawing(m_hWnd, true);

	CStatic::OnDestroy();

    CUpdateList::Cleanup(m_hWnd);
}

int CCollarContainer::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CStatic::OnCreate(lpCreateStruct) == -1)
		return -1;

    CString str;
    CMainFrame* pFrame = dynamic_cast<CMainFrame*>(GetParentFrame());
    if (pFrame == NULL)
        return 0;

    CWnd* pWnd = GetParent();

    if (dynamic_cast<CBottomBar*>(pWnd) != NULL)
    {
        str.Format("Bottom on screen %d.", pFrame->WindowNumber());
        m_mapUpdateWindowText[m_hWnd] = (LPCTSTR)str;
    }
    else if (dynamic_cast<CLeftRightBar*>(pWnd) != NULL)
    {
        str.Format("Left/Right on screen %d.", pFrame->WindowNumber());
        m_mapUpdateWindowText[m_hWnd] = (LPCTSTR)str;
    }
        

	return 0;
}

