// BottomBar.cpp: implementation of the CBottomBar class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "FSISuite.h"
#include "MainFrm.h"

#include "FSISuiteDoc.h"
#include "FSISuiteView.h"

#include "BottomBar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CBottomBar::CBottomBar()
{

}

CBottomBar::~CBottomBar()
{

}

BEGIN_MESSAGE_MAP(CBottomBar, CSizingControlBar)
    //{{AFX_MSG_MAP(CBottomBar)
//    ON_WM_CREATE()
//    ON_WM_SIZE()
//	ON_WM_DESTROY()
//	ON_WM_LBUTTONUP()
//	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CBottomBar::OnUpdateCmdUI(CFrameWnd* pTarget, BOOL bDisableIfNoHndler)
{
    UpdateDialogControls(pTarget, bDisableIfNoHndler);
}

BOOL CBottomBar::Create(CWnd* pParentWnd) 
{
    BOOL bRetVal = CSizingControlBar::Create(_T("Bottom Bar"), 
                                             pParentWnd, 
                                             CSize(300,300), FALSE,
                                             AFX_IDW_CONTROLBAR_FIRST + 33);

    // Set the default size of a button.  This should not use SM_CXSCREEN since
    // multimonitors will be supported.  It should use the corresponding
    // identifier for current monitor display width.
	CRect rectWindow;
    CMainFrame* pFrame = (CMainFrame*)pParentWnd;
	pParentWnd->GetWindowRect(&rectWindow);
    unsigned char ucButtonDivider = pFrame->m_ucButtonDivider;
    unsigned char ucButtonsAcross = pFrame->m_ucButtonsAcross;

    rectWindow.left += GetSystemMetrics(SM_CXDLGFRAME);
    rectWindow.right -= 2*GetSystemMetrics(SM_CXDLGFRAME);

    unsigned long int ulBottomHeight = (int)(((float)pFrame->m_ucBottomHeight / 
                                                (float)pFrame->m_ulClientScreenHeightBase) * 
                                             GetSystemMetrics(SM_CYSCREEN) + .5);
    CRect rectButtonSize(0,ucButtonDivider,
       (rectWindow.Width()-(ucButtonsAcross-1)*ucButtonDivider)/ucButtonsAcross,
       ulBottomHeight - ucButtonDivider);


    // Create the help, printing, and navigation buttons and place them
    // in the correct positions on the third section of the Rebar.
    m_wndButtonHelp.Create("Help",WS_VISIBLE | WS_CHILD | BS_CHECKBOX |  
                                  BS_MULTILINE | BS_CENTER | BS_PUSHLIKE, 
                           rectButtonSize, this, 
                           ID_HELP);
    m_wndButtonHelp.MoveWindow(rectWindow.Width() - ucButtonDivider - 
                                                    rectButtonSize.Width(),
                               ucButtonDivider,
                               rectButtonSize.Width(),
                               rectButtonSize.Height()/2 - ucButtonDivider/2);

    m_wndButtonPrinting.Create("Print",WS_VISIBLE | WS_CHILD | BS_CHECKBOX |  
                                  BS_MULTILINE | BS_CENTER | BS_PUSHLIKE, 
                               rectButtonSize, this, 
                               IDC_PRINT);
    m_wndButtonPrinting.MoveWindow(rectWindow.Width() - ucButtonDivider - 
                                                        rectButtonSize.Width(),
                                   ucButtonDivider + 
                                            rectButtonSize.Height()/2 + 
                                            ucButtonDivider/2,
                                   rectButtonSize.Width(),
                                   rectButtonSize.Height()/2 - 
                                            ucButtonDivider/2);

	return bRetVal;
}

BOOL CBottomBar::PreCreateWindow(CREATESTRUCT& cs) 
{
    cs.style |= WS_CLIPSIBLINGS | WS_CLIPCHILDREN;  
	return CSizingControlBar::PreCreateWindow(cs);
}
