#include "..\core\stdafx.h"
#include "AboutDlg.h"
#include "FSISuite.h"
#include "product_version.h"


BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	m_CStr_version = _T("");
	//}}AFX_DATA_INIT
   m_CStr_version.Format("%s", PRODUCT_BUILD_STRING);
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, IDC_LIST_COMPONENTS, m_ctrl_components);
	DDX_Text(pDX, IDC_VERSION, m_CStr_version);
	//}}AFX_DATA_MAP
}

BOOL CAboutDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();

   // If libraries have been loaded, then get their property dialogs.
   CFSISuiteApp            *pApp       =  (CFSISuiteApp*)AfxGetApp();
   STRING2CI_MAP           s2cimap     =  pApp->GetComponentInterfaces();
   STRING2CI_MAP::iterator s2ciIt      =  s2cimap.begin();
   STRING2CI_MAP::iterator s2ciendIt   =  s2cimap.end();
   CComponentInterface     *pCI;
   
   m_ctrl_components.SetExtendedStyle(LVS_EX_FULLROWSELECT);
   // Remove all the old data.
   // Remove all the old data and columns.
   m_ctrl_components.DeleteAllItems();
   int   ii;
   for (ii = 2; ii >= 0; ii--)
      m_ctrl_components.DeleteColumn(ii);

   // Setup the new columns...
   CRect       rect;
   m_ctrl_components.GetWindowRect(&rect);
   LV_COLUMN   lvcolumn;
   TCHAR       rgtsz[2][32]   =  {  _T("Component"),  _T("Revision") };

   for (ii = 0; ii < 2; ii++)  // add the columns to the list control
   {
      lvcolumn.mask     =  LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
      lvcolumn.fmt      =  LVCFMT_LEFT;
      lvcolumn.pszText  =  rgtsz[ii];
      lvcolumn.iSubItem =  ii;
      lvcolumn.cx       =  (rect.Width() - GetSystemMetrics(SM_CXVSCROLL) - 4) /  2;
      m_ctrl_components.InsertColumn(ii, &lvcolumn);  // assumes return value is OK.
   }

   // Put data in the list control...
   LV_ITEM  lvitem;
   long     index =  0;
   CString  component;
   CString  revision;
   int      iActualItem;

   while (s2ciIt != s2ciendIt)
   {
      pCI               = (*s2ciIt).second;

      component         =  (pCI->ComponentName()).c_str();
      lvitem.mask       =  LVIF_TEXT;
      lvitem.iItem      =  index;
      lvitem.iSubItem   =  0;
      lvitem.pszText    =  (char *)(LPCTSTR)component;
      lvitem.iImage     =  0;
      iActualItem       =  m_ctrl_components.InsertItem(&lvitem);
      index++;

      revision          =  (pCI->RevisionDate()).c_str();
      lvitem.mask       =  LVIF_TEXT;
      lvitem.iItem      =  iActualItem;
      lvitem.iSubItem   =  1;
      lvitem.pszText    =  (char *)(LPCTSTR)revision;
      m_ctrl_components.SetItem(&lvitem);

      s2ciIt++;
   }

   m_ctrl_components.UpdateWindow();

   return   TRUE; // return TRUE unless you set the focus to a control
	               // EXCEPTION: OCX Property Pages should return FALSE
}

