// OptionsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "debrief.h"
#include "OptionsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg dialog


COptionsDlg::COptionsDlg(CWnd* pParent /*=NULL*/)
   : CDialog(COptionsDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(COptionsDlg)
   m_CStr_sws_name = _T("");
   m_CStr_debrief_folder = _T("");
   //}}AFX_DATA_INIT
}


void COptionsDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(COptionsDlg)
   DDX_Text(pDX, IDC_EDIT_SWS_NAME, m_CStr_sws_name);
   DDX_Text(pDX, IDC_EDIT_DEBRIEF_FOLDER, m_CStr_debrief_folder);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionsDlg, CDialog)
   //{{AFX_MSG_MAP(COptionsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionsDlg message handlers

BOOL COptionsDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();
   
   HKEY     hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\Common"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get SWS name
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("SWS Name"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("SWS Name"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_sws_name   =  strValue;

      // get Debrief Folder
      lResult  =  RegQueryValueEx(hKey,      _T("Debrief Folder"),  NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("Debrief Folder"),  NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_debrief_folder   =  strValue;

      // clean up
      RegCloseKey(hKey);
   }
   
   UpdateData(FALSE);

   return   TRUE; // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}

void COptionsDlg::OnOK() 
{
   UpdateData(TRUE);    // Get the data from the dialog.

   if (m_CStr_sws_name.IsEmpty())
   {
      AfxMessageBox("Please enter a valid SWS name and folder.");
   }
   else if (m_CStr_sws_name.Right(1) != "\\")
   {
      AfxMessageBox("Please include a trailing backslash (\\) in the SWS name and folder selection.");
   }
   else if (m_CStr_debrief_folder.IsEmpty())
   {
      AfxMessageBox("Please enter a folder name for the location of the debrief files.");
   }
   else if (m_CStr_debrief_folder.Left(1)    == "\\")
   {
      AfxMessageBox("Please do not include a preceding backslash (\\) in the debrief files folder name.");
   }
   else if (m_CStr_debrief_folder.Left(1)    == "/")
   {
      AfxMessageBox("Please do not include a preceding forwardslash (/) in the debrief files folder name.");
   }
   else if (m_CStr_debrief_folder.Right(1)   == "\\")
   {
      AfxMessageBox("Please do not include a trailing backslash (\\) in the debrief files folder name.");
   }
   else if (m_CStr_debrief_folder.Right(1)   == "/")
   {
      AfxMessageBox("Please do not include a trailing forwardslash (/) in the debrief files folder name.");
   }
   else
   {   
      HKEY  hKey;
      DWORD dw;
      RegCreateKeyEx(HKEY_LOCAL_MACHINE,  _T("Software\\FlightSafety\\Common"), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

      if (hKey != NULL)
      {
         RegSetValueEx(hKey,  _T("SWS Name"),         NULL, REG_SZ,  (BYTE*)(LPCTSTR)m_CStr_sws_name,       m_CStr_sws_name.GetLength()         +  1);

         RegSetValueEx(hKey,  _T("Debrief Folder"),   NULL, REG_SZ,  (BYTE*)(LPCTSTR)m_CStr_debrief_folder, m_CStr_debrief_folder.GetLength()   +  1);

         RegCloseKey(hKey);
      }

      CDialog::OnOK();
   }
}

