// debriefDlg.cpp : implementation file
//

#include "stdafx.h"
#include <lm.h>
#include <process.h>
#include "debrief.h"
#include "debriefDlg.h"
#include <windows.h>
#include <winbase.h>
#include "WorkingDlg.h"
#include "OptionsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDebriefDlg dialog

CDebriefDlg::CDebriefDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDebriefDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDebriefDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
   m_CStr_primary_extension   =  "dat";
   m_CStr_secondary_extension =  "ini";
   pimagelist                 =  NULL;
}

CDebriefDlg::~CDebriefDlg()
{
   if (pimagelist)
   {
      if (pimagelist->GetSafeHandle())
      {
         pimagelist->DeleteImageList();
         delete   pimagelist;
      }
   }
}


void CDebriefDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDebriefDlg)
	DDX_Control(pDX, IDC_LIST_OF_DEBRIEF_FILES, m_ctrl_list_of_debrief_files);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDebriefDlg, CDialog)
	//{{AFX_MSG_MAP(CDebriefDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(NM_CLICK, IDC_LIST_OF_DEBRIEF_FILES, OnClickListOfDebriefFiles)
	ON_BN_CLICKED(IDC_ADVANCED_OPTIONS, OnAdvancedOptions)
	ON_BN_CLICKED(IDC_BUTTON_GO_TO_STUDENTS, OnButtonGoToStudents)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDebriefDlg message handlers

BOOL CDebriefDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon


   VERIFY(m_labelFont.CreateFont(
      24,                        // nHeight
      0,                         // nWidth
      0,                         // nEscapement
      0,                         // nOrientation
      FW_NORMAL,                 // nWeight
      TRUE,                      // bItalic
      FALSE,                     // bUnderline
      0,                         // cStrikeOut
      ANSI_CHARSET,              // nCharSet
      OUT_DEFAULT_PRECIS,        // nOutPrecision
      CLIP_DEFAULT_PRECIS,       // nClipPrecision
      DEFAULT_QUALITY,           // nQuality
      DEFAULT_PITCH | FF_DONTCARE,  // nPitchAndFamily
      "Arial"));          


   m_ctrl_list_of_debrief_files.SetExtendedStyle(LVS_EX_FULLROWSELECT);

   // Look up file list here.
   HKEY     hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\Common"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get SWS name
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("SWS Name"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("SWS Name"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_sws_name   =  strValue;

      // get Debrief Folder
      lResult  =  RegQueryValueEx(hKey,      _T("Debrief Folder"),   NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("Debrief Folder"),   NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_sws_name   += strValue;

      // get ios exec path
      lResult  =  RegQueryValueEx(hKey,      _T("IOS Exec Path"), NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("IOS Exec Path"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_IOS_exec_path =  strValue;

      // get ios options
      lResult  =  RegQueryValueEx(hKey,      _T("IOS Options"),   NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("IOS Options"),   NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_IOS_options   =  strValue;

      // clean up
      RegCloseKey(hKey);
   }

   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\Debrief Manager"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get hide options dialog button
      unsigned long  int   ulData   =  0;
      DWORD dwSize   =  sizeof(unsigned   long  int);
      RegQueryValueEx(hKey, _T("HideOptionsDialog"), NULL, NULL, (BYTE*)&ulData, &dwSize);

      m_bHideOptionsDialog =  (ulData  != 0);

      // clean up
      RegCloseKey(hKey);
   }


   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Comms"), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      // get SWS name
      CString  strValue;
      DWORD    dwType, dwCount;
      LONG     lResult;
      lResult  =  RegQueryValueEx(hKey,      _T("VariablesFile"),      NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey,   _T("VariablesFile"),      NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_CStr_destination   =  strValue;
      m_CStr_destination   =  m_CStr_destination.Left(m_CStr_destination.Find("."));

      // clean up
      RegCloseKey(hKey);
   }

   if (m_bHideOptionsDialog)
      GetDlgItem(IDC_ADVANCED_OPTIONS)->ShowWindow(SW_HIDE);
   else
      GetDlgItem(IDC_ADVANCED_OPTIONS)->ShowWindow(SW_NORMAL);
   

   char     szLoginName[256];
   DWORD    dwSizeofLoginName =  sizeof(szLoginName);
   GetUserName(szLoginName,   &dwSizeofLoginName);
/*
   char     dest[256];
   memset(dest, 0, 256);
   WCHAR    wszUserName[256];          // Unicode user name
   LPBYTE   ComputerName;
   struct   _USER_INFO_2   *ui;        // User structure
   // Convert ASCII user name and domain to Unicode.
   MultiByteToWideChar(CP_ACP,   0, szLoginName,   strlen(szLoginName)+1,  wszUserName,   sizeof(wszUserName));
   // Get the computer name of a DC for the specified domain.
   NetGetDCName(NULL,   NULL, &ComputerName);
   // Look up the user on the DC.
   if (NetUserGetInfo((LPWSTR)ComputerName,   (LPWSTR)&wszUserName,   2, (LPBYTE *)&ui))
      printf( "Error getting user information.\n" );
   else  // Convert the Unicode full name to ASCII.
      WideCharToMultiByte(CP_ACP,   0, ui->usri2_full_name, -1, dest, 256, NULL, NULL);

   m_users_full_name   =  dest;
*/
   m_users_full_name   =  szLoginName;
   CString  caption;
   GetWindowText(caption);
   CString  ios_filename;

   if (IsInstructor())
   {
      SetWindowText(caption   +  " - " +  m_users_full_name +  " (instructor)");
      m_CStr_ios_path   =  m_CStr_sws_name   +  "\\";
      ios_filename      =  m_CStr_ios_path   +  "\\"  +  "*.*";
      ShowDirectories(ios_filename);
   }
   else
   {
      SetWindowText(caption   +  " - " +  m_users_full_name +  " (student)");
      m_CStr_ios_path   =  m_CStr_sws_name   +  "\\"  +  m_users_full_name   +  "\\";
      ios_filename      =  m_CStr_ios_path   +  "*."  +  m_CStr_primary_extension;
      bool  valid       =  ShowFiles(ios_filename, false, m_users_full_name);
      if (!valid)
      {
         CWnd  *pHeading   =  GetDlgItem(IDC_INSTRUCTIONS);
         pHeading->SetFont(&m_labelFont);
         CString  status;
         status.Format("Sorry, no debriefing data found for %s", m_users_full_name);
         pHeading->SetWindowText(status);
      }
   }

	return TRUE;  // return TRUE  unless you set the focus to a control
}


// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDebriefDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDebriefDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void  CDebriefDlg::OnClickListOfDebriefFiles(NMHDR* pNMHDR, LRESULT* pResult) 
{
   POSITION pos = m_ctrl_list_of_debrief_files.GetFirstSelectedItemPosition();
   if (pos != NULL)
   {
      int      nItem    =  m_ctrl_list_of_debrief_files.GetNextSelectedItem(pos);
      CString  name     =  m_ctrl_list_of_debrief_files.GetItemText(nItem, 0);
      CString  source   =  m_CStr_ios_path   +  name;

      bool     valid    =  ShowFiles(source  +  "\\*."   +  m_CStr_primary_extension, true, name);

      if (valid)
      {
         m_CStr_ios_path   = source +  "\\";
         return;
      }

      m_ctrl_list_of_debrief_files.EnableWindow(FALSE);
      m_ctrl_list_of_debrief_files.UpdateWindow();

      CWorkingDlg    workingDlg;
      workingDlg.m_CStr_source               =  source;
      workingDlg.m_CStr_destination          =  m_CStr_destination;
      workingDlg.m_CStr_primary_extension    =  m_CStr_primary_extension;
      workingDlg.m_CStr_secondary_extension  =  m_CStr_secondary_extension;
      workingDlg.m_CStr_start_caption        =  "Retrieving recorded data...";
      workingDlg.m_CStr_finish_caption       =  "Finished retrieving recorded data.";
      
      if (workingDlg.DoModal()   == IDOK)
      {
         _spawnl(_P_WAIT, LPCTSTR(m_CStr_IOS_exec_path), LPCTSTR(m_CStr_IOS_exec_path +  " "   +  m_CStr_IOS_options), NULL);
   
         if (IsInstructor())
            MessageBox("Please remember to update the student records.","Reminder", MB_ICONINFORMATION|MB_OK);
      }
      else
      {
      }

      m_ctrl_list_of_debrief_files.EnableWindow(TRUE);
      m_ctrl_list_of_debrief_files.UpdateWindow();
   }
}

void CDebriefDlg::OnAdvancedOptions() 
{
   COptionsDlg optionsDlg;
   optionsDlg.DoModal();
}


void  CDebriefDlg::ShowDirectories(CString path)
{
   CWnd  *pHeading   =  GetDlgItem(IDC_INSTRUCTIONS);
   pHeading->SetFont(&m_labelFont);
   pHeading->SetWindowText("\nPlease select student to debrief...");

   GetDlgItem(IDC_BUTTON_GO_TO_STUDENTS)->ShowWindow(SW_HIDE);

   CFileFind   finder;
   BOOL        found       =  finder.FindFile(path);

   // Change to LIST mode so only one column can be shown.
   DWORD dwStyle  =  GetWindowLong(m_ctrl_list_of_debrief_files.m_hWnd, GWL_STYLE); // Get the current window style. 
   if ((dwStyle   &  LVS_TYPEMASK)  != LVS_LIST)                                    // Only set the window style if the view bits have changed. 
      SetWindowLong(m_ctrl_list_of_debrief_files.m_hWnd, GWL_STYLE, (dwStyle & ~LVS_TYPEMASK) | LVS_LIST); 


   // Setup the imagelist...
   CBitmap     bitmap;
   pimagelist  =  m_ctrl_list_of_debrief_files.GetImageList(LVSIL_SMALL);
   if (pimagelist)
   {
      pimagelist->DeleteImageList();
      delete   pimagelist;
   }
   pimagelist  =  new CImageList();
   pimagelist->Create(32, 32, TRUE, 0, 1);
   bitmap.LoadBitmap(IDB_STUDENT);
   pimagelist->Add(&bitmap, (COLORREF)0xFFFFFF);
   bitmap.DeleteObject();
   m_ctrl_list_of_debrief_files.SetImageList(pimagelist, LVSIL_SMALL);
   
   // Remove all the old data.
   m_ctrl_list_of_debrief_files.DeleteAllItems();

   LV_ITEM  lvitem;
   long     index =  0;
   CString  the_file;

   while (found)
   {
      found =  finder.FindNextFile();

      if (finder.IsDots())
         continue;

      if (finder.IsDirectory())
      {
         CFileFind   anotherFinder;
         CString     newPath;
         newPath  =  finder.GetFilePath()  +  "\\*."   +  m_CStr_primary_extension;
         if (anotherFinder.FindFile(newPath))
         {
            lvitem.mask       =  LVIF_TEXT   |  LVIF_IMAGE;
            lvitem.iItem      =  index;
            lvitem.iSubItem   =  0;
            the_file          =  finder.GetFileName();
            lvitem.pszText    =  (char *)(LPCTSTR)the_file;
            lvitem.iImage     =  0;
            m_ctrl_list_of_debrief_files.InsertItem(&lvitem);
            index++;
         }
      }
   }
}


bool  CDebriefDlg::ShowFiles(CString path, bool allowed_to_see_all_students, CString name)
{
   CFileFind   finder;
   BOOL        found =  finder.FindFile(path);

   if (!found)
      return   false;

   CWnd  *pHeading   =  GetDlgItem(IDC_INSTRUCTIONS);
   pHeading->SetFont(&m_labelFont);
   pHeading->SetWindowText("Please select sortie to debrief for\n" +  name);

   if (allowed_to_see_all_students)    // If we are allowed to go back up to a list of all the students.
      GetDlgItem(IDC_BUTTON_GO_TO_STUDENTS)->ShowWindow(SW_NORMAL);

   // Change to REPORT mode so multiple columns can be shown.
   DWORD dwStyle     =  GetWindowLong(m_ctrl_list_of_debrief_files.m_hWnd, GWL_STYLE);    // Get the current window style. 
   if ((dwStyle   &  LVS_TYPEMASK)  != LVS_REPORT)                                        // Only set the window style if the view bits have changed. 
      SetWindowLong(m_ctrl_list_of_debrief_files.m_hWnd, GWL_STYLE,  (dwStyle &  ~LVS_TYPEMASK) |  LVS_REPORT); 

   // Setup the imagelist...
   CBitmap     bitmap;
   pimagelist  =  m_ctrl_list_of_debrief_files.GetImageList(LVSIL_SMALL);
   if (pimagelist)
   {
      pimagelist->DeleteImageList();
      delete   pimagelist;
   }
   pimagelist  =  new CImageList();
   pimagelist->Create(32, 32, TRUE, 0, 1);
   bitmap.LoadBitmap(IDB_PLANE);
   pimagelist->Add(&bitmap, (COLORREF)0xFFFFFF);
   bitmap.DeleteObject();
   m_ctrl_list_of_debrief_files.SetImageList(pimagelist, LVSIL_SMALL);

   // Remove all the old data and columns.
   m_ctrl_list_of_debrief_files.DeleteAllItems();
   int   ii;
   for (ii = 2; ii >= 0; ii--)
   {
      m_ctrl_list_of_debrief_files.DeleteColumn(ii);
   }

   // Setup the new columns...
   CRect       rect;
   m_ctrl_list_of_debrief_files.GetWindowRect(&rect);
   LV_COLUMN   lvcolumn;
   TCHAR       rgtsz[2][32]   =  {  _T("Sortie"),  _T("Recorded On") };
   char        time[32];

   for (ii = 0; ii < 2; ii++)  // add the columns to the list control
   {
      lvcolumn.mask     =  LVCF_FMT | LVCF_SUBITEM | LVCF_TEXT | LVCF_WIDTH;
      lvcolumn.fmt      =  LVCFMT_LEFT;
      lvcolumn.pszText  =  rgtsz[ii];
      lvcolumn.iSubItem =  ii;
      lvcolumn.cx       =  (rect.Width() - GetSystemMetrics(SM_CXVSCROLL) - 4) /  2;
      m_ctrl_list_of_debrief_files.InsertColumn(ii, &lvcolumn);  // assumes return value is OK.
   }


   // Put data in the list control...
   CTime    tempTime;
   CString  str;
   LV_ITEM  lvitem;
   long     index =  0;
   CString  the_file;
   int      iActualItem;

   while (found)
   {
      found             =  finder.FindNextFile();
      lvitem.mask       =  LVIF_TEXT   |  LVIF_IMAGE;
      lvitem.iItem      =  index;
      lvitem.iSubItem   =  0;
      the_file          =  finder.GetFileTitle();
      lvitem.pszText    =  (char *)(LPCTSTR)the_file;
      lvitem.iImage     =  0;
      iActualItem       =  m_ctrl_list_of_debrief_files.InsertItem(&lvitem);
      index++;

      if (finder.GetLastWriteTime(tempTime))
      {
         str               =  tempTime.Format("%c");
         sprintf(time, "%s", str);
         lvitem.mask       =  LVIF_TEXT;
         lvitem.iItem      =  iActualItem;
         lvitem.iSubItem   =  1;
         lvitem.pszText    =  time;
         m_ctrl_list_of_debrief_files.SetItem(&lvitem);
      }
   }

   m_ctrl_list_of_debrief_files.UpdateWindow();

   return   true;
}

void CDebriefDlg::OnButtonGoToStudents() 
{
   m_CStr_ios_path   =  m_CStr_sws_name   +  "\\";
   CString  ios_filename(m_CStr_ios_path  +  "\\"  +  "*.*");
   ShowDirectories(ios_filename);
}


bool  CDebriefDlg::IsInstructor() 
{
   bool  retval   =  false;

   try
   {
      SIMPROFILELib::IProfilePtr p(__uuidof(SIMPROFILELib::Profile));
       
      long     bInstructor;
      HRESULT  hr =  p->IsInstructor(&bInstructor);

      if (SUCCEEDED(hr))
      {
         retval   =  (bInstructor   != 0);
      }
   }
   catch (_com_error &e)
   {
      TCHAR szBuffer[255] = {0};
	   wsprintf(szBuffer, _T("Error: 0x%x "), e.Error() );
	   MessageBox(szBuffer, _T("Error") );
   }

   return   retval;
}
