
#ifndef _XMLWIDGET_H_
#define _XMLWIDGET_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "XMLElement.h"

#include <list>

#include <afxtempl.h>

typedef _FSI_STL::list<CXMLElement*> ELEMENT_LIST;

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
   
class DLLAPI CXMLWidget
{
private:
    typedef _FSI_STL::list<CXMLWidget*> WIDGET_LIST;        

protected:
    int                     m_nNumberOfSubWidgets;

    WIDGET_LIST             m_listSubWidgets;

    CList<CXMLElement*, CXMLElement*> m_listElements;

    _FSI_STL::string        m_stlStrWidgetName;

    unsigned char           m_ucIndentation;
    
public:
    // CArchive I/O
    friend CArchive& operator<<(CArchive& rArchive, 
        const CXMLWidget& rXMLWidget);
//    friend CArchive& operator>>(CArchive& rArchive, CXMLWidget& rXMLWidget);
    
    // Constructors
    CXMLWidget();
    CXMLWidget(const _FSI_STL::string& stlStrName);
    CXMLWidget(const CXMLWidget& rXMLWidget);
    
    // Destructor
    virtual ~CXMLWidget();
    
    // Assignment overload
    CXMLWidget& operator=(const CXMLWidget& rXMLWidget);
    
    // Equals overload
    bool operator==(const CXMLWidget& rXMLWidget);

    // Accessors
    const _FSI_STL::string& WidgetName();
    CXMLWidget* GetNextSubWidget(WIDGET_LIST::iterator& wlIt);
    unsigned char Indent();
    
    // Mutators
    void AddElement(const _FSI_STL::string& stlStrName, 
                    const _FSI_STL::string& stlStrValue,
                    STRING2STRING_MAP* pMapXMLAttributes);
    void AddWidget(CXMLWidget* pXMLWidget);
    void AddElementValue(const _FSI_STL::string& rstlStrElementValue);
    bool FindElement(CXMLElement*& pXMLElement, 
                     POSITION& pos,
                     const _FSI_STL::string& rstlStrAttributeName);
    void Indent(const unsigned char ucIndent);

    _FSI_STL::list<CXMLWidget*>::iterator DeleteItem(CXMLWidget* pXMLWidget);
    POSITION DeleteItem(CXMLElement* pXMLElement);
};

#endif // ifndef _XMLWidget_H_
