#include "stdafx.h"
#include "XMLWidget.h"

#include <algorithm>

CArchive& operator<<(CArchive& rArchive, const CXMLWidget& rXMLWidget)
{
    CXMLWidget& rWidget = const_cast<CXMLWidget&>(rXMLWidget);
	CString strFormattedOutput;
    CString strIndentation = "";
    unsigned char ucSpaceStep = 0;
    while (ucSpaceStep < rXMLWidget.m_ucIndentation)
    {
        strIndentation += " ";
        ucSpaceStep++;
    }

    CString strWidgetName = rXMLWidget.m_stlStrWidgetName.c_str();
    strWidgetName.MakeUpper();
    strFormattedOutput.Format("%s<%s>\r\n",strIndentation, strWidgetName);
	rArchive.WriteString(strFormattedOutput);

    POSITION pos = rWidget.m_listElements.GetHeadPosition();
    CXMLElement* pXMLElement;
    while (pos != NULL)
    {
        pXMLElement = rWidget.m_listElements.GetNext(pos);

        rArchive.WriteString(strIndentation + strIndentation);
        rArchive << *pXMLElement;
    }

    _FSI_STL::list<CXMLWidget*>::iterator widListIt = 
                                        rWidget.m_listSubWidgets.begin();

    _FSI_STL::list<CXMLWidget*>::iterator endListIt = 
                                        rWidget.m_listSubWidgets.end();

    while (widListIt != endListIt)
    {
        (*widListIt)->Indent(rXMLWidget.m_ucIndentation + 4);
        rArchive << *(*widListIt);
        widListIt++;
    }

    strFormattedOutput.Format("%s</%s>\r\n",strIndentation, strWidgetName);
	rArchive.WriteString(strFormattedOutput);

	return (rArchive);
}

/*
CArchive& operator>>(CArchive& rArchive, CXMLWidget& rXMLWidget)
{
	return (rArchive);
}
*/

CXMLWidget::CXMLWidget() :  m_stlStrWidgetName(""),
                            m_ucIndentation(0),
                            m_nNumberOfSubWidgets(0)
{ 
}

CXMLWidget::CXMLWidget(const _FSI_STL::string& stlStrName) :    
                            m_stlStrWidgetName(stlStrName),
                            m_ucIndentation(0),
                            m_nNumberOfSubWidgets(0)
{ 
}

CXMLWidget::CXMLWidget(const CXMLWidget& rXMLWidget) :  m_stlStrWidgetName(""),
                            m_ucIndentation(0),
                            m_nNumberOfSubWidgets(0)
{
    *this = rXMLWidget;
}

CXMLWidget::~CXMLWidget() 
{ 
    if (m_nNumberOfSubWidgets > 0)
    {
        WIDGET_LIST::iterator wlIt     = m_listSubWidgets.begin();
        WIDGET_LIST::iterator wlendIt  = m_listSubWidgets.end();
        while (wlIt != wlendIt)
        {
            delete (*wlIt);
            wlIt++;
        }
        m_listSubWidgets.clear();
        m_nNumberOfSubWidgets = 0;
    }

    CXMLElement* pXMLElement;
    POSITION pos = m_listElements.GetHeadPosition();
    while (pos != NULL)
    {
        pXMLElement = m_listElements.GetNext(pos);
        delete pXMLElement;
    }

    m_listElements.RemoveAll();
}

CXMLWidget& CXMLWidget::operator=(const CXMLWidget& rXMLWidget)
{
	if (this != &rXMLWidget)
	{
        if (m_nNumberOfSubWidgets > 0)
        {
            WIDGET_LIST::iterator wlIt     = m_listSubWidgets.begin();
            WIDGET_LIST::iterator wlendIt  = m_listSubWidgets.end();
            while (wlIt != wlendIt)
            {
                delete (*wlIt);
                wlIt++;
            }
            m_listSubWidgets.clear();
            m_nNumberOfSubWidgets = 0;
        }

        CXMLElement* pXMLElement = NULL;
        if (m_listElements.GetCount() > 0)
        {
            POSITION posLocal = m_listElements.GetHeadPosition();
            while (posLocal != NULL)
            {
                pXMLElement = m_listElements.GetNext(posLocal);
                delete pXMLElement;
            }
            m_listElements.RemoveAll();
        }

        POSITION pos = rXMLWidget.m_listElements.GetHeadPosition();
        while (pos != NULL)
        {
            pXMLElement = new CXMLElement;
            *pXMLElement = *(rXMLWidget.m_listElements.GetNext(pos));
            m_listElements.AddTail(pXMLElement);
        }

        WIDGET_LIST::const_iterator wlIt    = rXMLWidget.m_listSubWidgets.begin();
        WIDGET_LIST::const_iterator wlendIt = rXMLWidget.m_listSubWidgets.end();
        CXMLWidget* pXMLWidget = NULL;
        while (wlIt != wlendIt)
        {
            pXMLWidget = new CXMLWidget;
            *pXMLWidget = *(*wlIt);
            m_listSubWidgets.push_back(pXMLWidget);
            wlIt++;
        }

        m_nNumberOfSubWidgets   = rXMLWidget.m_nNumberOfSubWidgets;

        m_stlStrWidgetName      = rXMLWidget.m_stlStrWidgetName;
    }

	return *this;
}


bool CXMLWidget::operator==(const CXMLWidget& rXMLWidget)
{
    // Make sure all of the elements are the same.
    if (m_listElements.GetCount() == rXMLWidget.m_listElements.GetCount())
    {
        POSITION pos1 = m_listElements.GetHeadPosition();
        POSITION pos2 = rXMLWidget.m_listElements.GetHeadPosition();
        while (pos1 != NULL)
        {
            if (!( *(m_listElements.GetNext(pos1)) == *(rXMLWidget.m_listElements.GetNext(pos2)) ))
            {
                return false;
            }
        }
    }
    else
    {
        // Different size
        return false;
    }

    // Make sure all of the widgets are the same.
    if (m_nNumberOfSubWidgets == rXMLWidget.m_nNumberOfSubWidgets)
    {
        WIDGET_LIST::iterator wl1It     = m_listSubWidgets.begin();
        WIDGET_LIST::iterator wl1endIt  = m_listSubWidgets.end();
        WIDGET_LIST::const_iterator wl2It = rXMLWidget.m_listSubWidgets.begin();
        while (wl1It != wl1endIt)
        {
            if (!(*(*wl1It) == *(*wl2It)))
            {
                return false;
            }

            wl1It++;
            wl2It++;
        }
    }
    else
    {
        // Different size
        return false;
    }

    if (m_stlStrWidgetName != rXMLWidget.m_stlStrWidgetName)
    {
        return false;
    }

    return true;
}

const _FSI_STL::string& CXMLWidget::WidgetName()
{
    return m_stlStrWidgetName;
}

CXMLWidget* CXMLWidget::GetNextSubWidget(WIDGET_LIST::iterator& wlIt) 
{ 
    WIDGET_LIST::iterator nullIt = NULL;
    if (wlIt == nullIt && m_nNumberOfSubWidgets > 0)
    {
        wlIt = m_listSubWidgets.begin();
    }
    else if (wlIt == m_listSubWidgets.end() || m_nNumberOfSubWidgets == 0)
    {
        return NULL;
    }

    CXMLWidget* pXMLWidget = *wlIt;
    wlIt++;
    return pXMLWidget;
}

void CXMLWidget::AddElement(const _FSI_STL::string& stlStrName, 
                            const _FSI_STL::string& stlStrValue,
                            STRING2STRING_MAP* pMapXMLAttributes)
{
    CXMLElement* pXMLElement = new CXMLElement(stlStrName, stlStrValue);

    if (pXMLElement != NULL)
    {
        pXMLElement->SetAttributes(pMapXMLAttributes);

        m_listElements.AddTail(pXMLElement);
    }
}

void CXMLWidget::AddWidget(CXMLWidget* pXMLWidget)
{
    strupr((char *)pXMLWidget->m_stlStrWidgetName.c_str());

    m_listSubWidgets.push_back(pXMLWidget);

    m_nNumberOfSubWidgets++;
}

void CXMLWidget::AddElementValue(const _FSI_STL::string& rstlStrElementValue)
{
    if (m_listElements.GetCount() > 0)
    {
        m_listElements.GetTail()->AddElementValue(rstlStrElementValue);
    }
}

bool CXMLWidget::FindElement(CXMLElement*& pXMLElement,
                             POSITION& pos,
                             const _FSI_STL::string& rstlStrElementName)
{
    // Find an attribute for the main page element.
    if (m_listElements.GetCount() > 0)
    {
        POSITION posLocal = pos;
        bool bDone = false;
        if (pXMLElement == NULL)
        {
            posLocal = m_listElements.GetHeadPosition();
        }
        else if (pos == NULL)
        {
            return false;
        }

        pos = posLocal;
        pXMLElement = m_listElements.GetNext(posLocal);
        if (posLocal == NULL && pXMLElement != NULL)
        {
            pos = posLocal;
            if (pXMLElement->ElementName() != rstlStrElementName)
            {
                bDone = false;
            }
            else
            {
                bDone = true;
            }
        }
        else
        {
            while (posLocal != NULL && bDone != true)
            {
                pos = posLocal;
                if (pXMLElement->ElementName() != rstlStrElementName)
                {
                    pXMLElement = m_listElements.GetNext(posLocal);
                }
                else
                {
                    bDone = true;
                }
            }

            if (posLocal == NULL && pXMLElement != NULL)
            {
                pos = posLocal;
                if (pXMLElement->ElementName() != rstlStrElementName)
                {
                    bDone = false;
                }
                else
                {
                    bDone = true;
                }
            }
        }

        return bDone;
    }

    return false;
}

unsigned char CXMLWidget::Indent()
{
    return m_ucIndentation;
}

void CXMLWidget::Indent(const unsigned char ucIndent)
{
    m_ucIndentation = ucIndent;
}

_FSI_STL::list<CXMLWidget*>::iterator CXMLWidget::DeleteItem(CXMLWidget* pXMLWidget)
{
    WIDGET_LIST::iterator lIt       = m_listSubWidgets.begin();
    WIDGET_LIST::iterator lendIt    = m_listSubWidgets.end();
    while (lIt != lendIt && (*lIt) != pXMLWidget)
    {
        lIt++;
    }

    // Make sure that the pointer is in the list of elements for this page.
    if (lIt != lendIt)
    {
        lIt = m_listSubWidgets.erase(lIt);
        m_nNumberOfSubWidgets--;
        delete pXMLWidget;
    }

    return lIt;
}

POSITION CXMLWidget::DeleteItem(CXMLElement* pXMLElement)
{
    POSITION pos = m_listElements.Find(pXMLElement);

    // Make sure that the pointer is in the list of elements for this page.
    if (pos != NULL)
    {
        m_listElements.RemoveAt(pos);
        delete pXMLElement;
    }

    return pos;
}