/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// Copyright 1998 FlightSafety International
//
// The information contained herein is the property of FLIGHTSAFETY
// INTERNATIONAL Simulation Systems Division and shall not be copied, in
// part or in whole, or disclosed to others in any manner without the
// express written authorization of the FLIGHTSAFETY INTERNATIONAL
// Simulation Systems Division.
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : XMLParser.h
//
// Date             : 06 September 1998
//
// Author           : Billy Baker
//
// Description      : The CXMLParser class is the main interface for 
//                    parsing one of the page files that uses XML for 
//                    its description.  It passes along the filename of 
//                    the page to load.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : James Clark's free SP package for parsing and 
//                    validating SGML and XML.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other condtions for proper execution
//                        None.
//
// Envrionment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service packs 3 or 4
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0
//                                  Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _XMLPARSER5_H_
#define _XMLPARSER5_H_

#include "..\core\XMLPage.h"

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif


#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
    
class DLLAPI CXMLParser5
{
private:
    long int                m_lValueLen;
    long int                m_lNameLen;
    long int                m_lLen;
    char                    m_cAttributeName[256];
    char                    m_cAttributeValue[256];
//    char*                   m_pcElementValue;
    char*                   m_pcFileName;
    STRING_LIST             m_listAvailableWidgets;
    IXMLDOMNode*            m_pNext;
    IXMLDOMNamedNodeMap*    m_pAttrbs;
    BSTR                    m_bstrNodeName;
    DOMNodeType             m_eType;
    BSTR                    m_name;
    VARIANT                 m_value;
    _FSI_STL::string        m_stlStrBlank;
    _FSI_STL::string        m_stlStrElementValue;
    
protected:
    UINT Parse(LPVOID lParam, IXMLDOMDocument* pDoc);
	void TraverseElements(IXMLDOMNode* pXMLNode,CXMLPage* pXMLPage);
    
public:
    // Constructors
    explicit CXMLParser5(const char* pwcXMLPageFilename = NULL);
    CXMLParser5(const CXMLParser5& rXMLParser);
    
    // Assignment overload
    CXMLParser5& operator=(const CXMLParser5& rXMLParser);
    
    // Equals overload
    bool operator==(const CXMLParser5& rXMLParser);

    // Accessors

    // Mutators
    void AddAvailableWidget(const _FSI_STL::string rstlStrWidget);

    // Method to actually parser a file.
    void ParseFile(CXMLPage* pXMLPage, IXMLDOMDocument* pDoc);
};

#endif // ifndef _XMLPARSER5_H_
