#include "stdafx.h"
#include <msxml.h>
#include <comdef.h>

#include "XMLParser5.h"

#define SAFERELEASE(p) if (p) {(p)->Release(); p = NULL;} else ;

void CXMLParser5::TraverseElements(IXMLDOMNode* pXMLNode, CXMLPage* pXMLPage)
{
    if (pXMLPage == NULL || pXMLNode == NULL)
    {
        return;
    }

    char         cText[256];
    cText[0]            = '\0';
    IXMLDOMNode* pChild = NULL;
    m_pNext             = NULL;
    m_pAttrbs           = NULL;

    pXMLNode->get_nodeType(&m_eType);

    switch (m_eType)
    {
    case NODE_ELEMENT:
        {
            pXMLNode->get_nodeName(&m_bstrNodeName);

            m_lLen = SysStringLen(m_bstrNodeName);
            WideCharToMultiByte(CP_ACP, 0, m_bstrNodeName, m_lLen, 
                                cText, m_lLen, 
                                NULL, NULL);
            cText[m_lLen] = '\0';
            SysFreeString(m_bstrNodeName);

            pXMLNode->get_attributes(&m_pAttrbs);
            m_pAttrbs->nextNode(&pChild);

            while (pChild)
            {
                pChild->get_nodeValue(&m_value);

                if (m_value.vt == VT_BSTR)
                {
                    pChild->get_nodeName(&m_name);

                    m_lValueLen = SysStringLen(m_value.bstrVal);
                    m_lNameLen  = SysStringLen(m_name);

                    ::WideCharToMultiByte(CP_ACP, 0, m_value.bstrVal, m_lValueLen,
                                          m_cAttributeValue, m_lValueLen, 
                                          NULL, NULL);
                    ::WideCharToMultiByte(CP_ACP, 0, m_name, m_lNameLen,
                                          m_cAttributeName, m_lNameLen, 
                                          NULL, NULL);

                    m_cAttributeValue[m_lValueLen]  = '\0';
                    m_cAttributeName[m_lNameLen]    = '\0';

                    pXMLPage->AddAttribute(_FSI_STL::string(m_cAttributeName),
                                           _FSI_STL::string(m_cAttributeValue));

                    ::SysFreeString(m_name);
                }

                VariantClear(&m_value);
                pChild->Release();
                m_pAttrbs->nextNode(&pChild);
            }

            m_pAttrbs->Release();

            pXMLPage->AddWidget(_FSI_STL::string(cText), m_stlStrBlank);
        }
        break;
    case NODE_TEXT:
        {
            pXMLNode->get_nodeValue(&m_value);

            if (m_value.vt == VT_BSTR)
            {
                m_lValueLen = SysStringLen(m_value.bstrVal);

                char* pElementValue = new char[m_lValueLen + 1];

                m_stlStrElementValue.resize(m_lValueLen);

                ::WideCharToMultiByte(CP_ACP, 0, m_value.bstrVal, m_lValueLen,
                                      pElementValue, m_lValueLen, 
                                      NULL, NULL);

                m_stlStrElementValue[m_lValueLen] = '\0';
                pElementValue[m_lValueLen] = '\0';


                pXMLPage->AddElementValue(_FSI_STL::string(pElementValue));
                delete pElementValue;
            }

            VariantClear(&m_value);
        }
        break;
    };


    pXMLNode->get_firstChild(&pChild);
    while (pChild)
    {
        TraverseElements(pChild, pXMLPage);
        pChild->get_nextSibling(&m_pNext);
        pChild->Release();
        pChild = m_pNext;
    }

    if (cText[0] != '\0')
    {
        pXMLPage->EndWidgetDefinition(_FSI_STL::string(cText));
    }
}

UINT CXMLParser5::Parse(LPVOID lParam, IXMLDOMDocument* pDoc)
{
    CXMLPage* pXMLPage = (CXMLPage*)lParam;
    HRESULT hr;

    if (pXMLPage == NULL)
    {
        return 0;
    }

    hr = CoInitialize(NULL);
    if (hr != S_OK && hr != S_FALSE)
    {
        return 0;
    }

    VARIANT_BOOL    vb      = VARIANT_FALSE;
    BSTR            pBURL   = NULL;
    WCHAR*          wszXML  = new WCHAR[MAX_PATH];

    ::MultiByteToWideChar(CP_ACP, 0, m_pcFileName, -1, wszXML, MAX_PATH);
    pBURL = SysAllocString(wszXML);
    delete [] wszXML;

    VARIANT vURL;
    VariantInit(&vURL);
    vURL.vt = VT_BSTR;
    V_BSTR(&vURL) = pBURL;
    if (pDoc->load(vURL, &vb) != S_OK)
    {
        SysFreeString(pBURL);

        IXMLDOMParseError *pXMLError = NULL;
        LONG errorCode = E_FAIL;

        if (pDoc->get_parseError(&pXMLError) != S_OK)
        {
            SAFERELEASE(pXMLError);
            CoUninitialize();
            return 0;
        }

        if (pXMLError->get_errorCode(&errorCode) != S_OK)
        {
            SAFERELEASE(pXMLError);
            CoUninitialize();
            return 0;
        }

        long line, linePos;
        BSTR pBReason;
        pXMLError->get_line(&line);
        pXMLError->get_linepos(&linePos);
        pXMLError->get_reason(&pBReason);
        CString str;
        str.Format("Error on line %d, position %d in \"%S\".",line, linePos, pBReason);
        AfxMessageBox(str);

        SysFreeString(pBReason);
        SAFERELEASE(pXMLError);
        CoUninitialize();
        return 0;
    }

    SysFreeString(pBURL);

    IXMLDOMParseError *pXMLError = NULL;
    LONG errorCode = E_FAIL;

    if (pDoc->get_parseError(&pXMLError) != S_OK)
    {
        SAFERELEASE(pXMLError);
        CoUninitialize();
        return 0;
    }
/*
    if (pXMLError->get_errorCode(&errorCode) != S_OK)
    {
        SAFERELEASE(pXMLError);
        SAFERELEASE(pDoc);
        CoUninitialize();
        return 0;
    }
*/
    SAFERELEASE(pXMLError);

    IXMLDOMNode*  pNode = NULL;

    if (pDoc->QueryInterface(IID_IXMLDOMNode, (void**)&pNode) != S_OK)
    {
        SAFERELEASE(pNode);
        CoUninitialize();
        return 0;
    }

    TraverseElements(pNode,pXMLPage);

    CoUninitialize();
    return 0;
}


CXMLParser5::CXMLParser5(const char* pcXMLPageFilename)
{
    m_pcFileName = (char*)pcXMLPageFilename;
    m_stlStrBlank = _FSI_STL::string("");
}

CXMLParser5::CXMLParser5(const CXMLParser5& rXMLParser)
{
    *this = rXMLParser;
}

CXMLParser5& CXMLParser5::operator=(const CXMLParser5& rXMLParser)
{
	// no work if they are the same
	if (this != &rXMLParser)
	{
		m_pcFileName = rXMLParser.m_pcFileName;
		m_listAvailableWidgets = rXMLParser.m_listAvailableWidgets;
	}

	return *this;
}

bool CXMLParser5::operator==(const CXMLParser5& rXMLParser)
{
    bool bRetVal = true;

    if (m_pcFileName != rXMLParser.m_pcFileName)
    {
        bRetVal = false;
    }

	if (m_listAvailableWidgets.size() != rXMLParser.m_listAvailableWidgets.size())
	{
		bRetVal = false;
	}
    else
    {
        STRING_LIST::iterator lIt = m_listAvailableWidgets.begin();
        STRING_LIST* pList = (STRING_LIST*)&(rXMLParser.m_listAvailableWidgets);
        STRING_LIST::iterator rlIt = pList->begin();

        for (; lIt != m_listAvailableWidgets.end(); lIt++, rlIt++)
        {
            if ((*lIt) != (*rlIt))
            {
                bRetVal = false;
            }
        }
    }

	return bRetVal;
}

void CXMLParser5::ParseFile(CXMLPage* pXMLPage, IXMLDOMDocument* pDoc)
{
    if (pXMLPage != NULL && pDoc != NULL)
    {
        STRING_LIST::iterator slIt = m_listAvailableWidgets.begin();
        for (; slIt != m_listAvailableWidgets.end(); slIt++)
        {
            pXMLPage->AddAvailableWidget(*slIt);
        }
        m_listAvailableWidgets.clear();

		Parse(pXMLPage, pDoc);
    }
}

void CXMLParser5::AddAvailableWidget(const _FSI_STL::string stlStrWidget)
{
    _FSI_STL::string stlStrWidgetName(stlStrWidget);
    m_listAvailableWidgets.push_back(stlStrWidgetName);
}



