#ifndef _XMLPAGE_H_
#define _XMLPAGE_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "STLTypes.h"
#include "XMLWidget.h"

typedef _FSI_STL::vector<CXMLWidget*> WIDGET_VECTOR;
typedef _FSI_STL::stack<CXMLWidget*, _FSI_STL::vector<CXMLWidget*> > WIDGET_STACK;

typedef _FSI_STL::list<CXMLWidget*> WIDGET_LIST;

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class DLLAPI CXMLPage
{
protected:
    int                                     m_nNumberOfWidgets;

    STRING2STRING_MAP*                      m_pMapXMLAttributes;

    ELEMENT_LIST                            m_listElements;

    _FSI_STL::map<_FSI_STL::string, bool>   m_mapAvailableWidgets;

    WIDGET_STACK                            m_stlStackOfWidgets;

    WIDGET_LIST                             m_listXMLWidgets;

    FILETIME                                m_WriteFileTime;

    bool                                    m_bElementStarted;

    _FSI_STL::string                        m_stlStrAttribute;
    
public:

    // CArchive I/O
    friend DLLAPI CArchive& operator<<(CArchive& rArchive, 
        const CXMLPage& rXMLPage);
//    friend DLLAPI CArchive& operator>>(CArchive& rArchive, CXMLPage& rXMLPage);

    // Constructors
    CXMLPage();
    CXMLPage(const CXMLPage& rXMLPage);
    
    // Destructor
    virtual ~CXMLPage();
    
    // Assignment overload
    CXMLPage& operator=(const CXMLPage& rXMLPage);
    
    // Equals overload
    bool operator==(const CXMLPage& rXMLPage);

    // Accessors
    CXMLWidget* GetNextWidget(WIDGET_LIST::iterator& wlIt);
    CXMLElement* GetNextElement(ELEMENT_LIST::iterator& elIt); 

    bool FindElement(ELEMENT_LIST::iterator& elIt, 
                     const _FSI_STL::string& stlStrElementName);
    FILETIME WriteFileTime();

    // Mutators
    void AddAttribute(const _FSI_STL::string& stlStrName, 
                      const _FSI_STL::string& stlStrValue);
    void AddWidget(const _FSI_STL::string& stlStrName, 
                   const _FSI_STL::string& stlStrValue);
    bool AddWidget(CXMLWidget* pXMLWidget);
    void AddElement(const _FSI_STL::string& rstlStrName, 
                    const _FSI_STL::string& rstlStrValue,
                    STRING2STRING_MAP* pMapXMLAttributes);
    void AddElementValue(const _FSI_STL::string& rstlStrElementValue);

    void EndWidgetDefinition(const _FSI_STL::string& rstlStrName);

    void AddAvailableWidget(const _FSI_STL::string& stlStrWidget);

    void WriteFileTime(FILETIME* pWriteFileTime);

    _FSI_STL::list <CXMLWidget*>::iterator DeleteItem(CXMLWidget* pXMLWidget);
    _FSI_STL::list<CXMLElement*>::iterator DeleteItem(CXMLElement* pXMLElement);
};

#endif // ifndef _XMLPAGEOBJECT_H_
