#include "stdafx.h"
#include "XMLPage.h"

#include <algorithm>

CArchive& operator<<(CArchive& rArchive, const CXMLPage& rXMLPage)
{
    CXMLPage& rPage = const_cast<CXMLPage&>(rXMLPage);
	CString strFormattedOutput;
    CString strOuterElement;

    // Write the XML header information
    rArchive.WriteString("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>\r\n");
    rArchive.WriteString("<!DOCTYPE FSISuitePage SYSTEM \"IOSPage.dtd\">\r\n");

    // Write the non-widget elements of the file.  The first element should
    // be the main page element.
    if (!rPage.m_listElements.empty())
    {
        // Main page element
        ELEMENT_LIST::iterator eleListIt;
        eleListIt = rPage.m_listElements.begin();
        strOuterElement.Format("%s",(*eleListIt)->ElementName().c_str());
        strFormattedOutput.Format("<%s",strOuterElement);

        STRING2STRING_MAP s2smap = (*eleListIt)->GetAttributes();
        STRING2STRING_MAP::iterator mIt     = s2smap.begin();
        STRING2STRING_MAP::iterator mendIt  = s2smap.end();
        CString strAttribute;
        while (mIt != mendIt)
        {
            strAttribute.Format(" %s=\"%s\"",(*mIt).first.c_str(),
                                             (*mIt).second.c_str());
            strFormattedOutput += strAttribute;
            mIt++;
        }

        strFormattedOutput +=">\r\n";
	    rArchive.WriteString(strFormattedOutput);
        rArchive.WriteString("\r\n");

        // The rest of the non-widget elements
        if (rPage.m_listElements.size() > 1)
        {
            ELEMENT_LIST::iterator endListIt = rPage.m_listElements.end();
            eleListIt++;
            while (eleListIt != endListIt)
            {
                rArchive << *(*eleListIt);
                rArchive.WriteString("\r\n");
                eleListIt++;
            }
        }
    }

    // All of the widgets
    WIDGET_LIST::iterator widListIt = rPage.m_listXMLWidgets.begin();
    WIDGET_LIST::iterator endListIt = rPage.m_listXMLWidgets.end();
    while (widListIt != endListIt)
    {
        rArchive << *(*widListIt);
        rArchive.WriteString("\r\n");
        widListIt++;
    }

    // The end tag for the main page element.
    strFormattedOutput = "</" + strOuterElement + ">\r\n";
	rArchive.WriteString(strFormattedOutput);

	return (rArchive);
}

/*
CArchive& operator>>(CArchive& rArchive, CXMLPage& rXMLPage)
{
	return (rArchive);
}
*/

CXMLPage::CXMLPage() :  m_pMapXMLAttributes(NULL),
                        m_bElementStarted(false),
                        m_nNumberOfWidgets(0)

{
    memset(&m_WriteFileTime, 0, sizeof(FILETIME));
}

CXMLPage::CXMLPage(const CXMLPage& rXMLPage) : m_pMapXMLAttributes(NULL),
                        m_bElementStarted(false),
                        m_nNumberOfWidgets(0)
{
    *this = rXMLPage;
}

CXMLPage::~CXMLPage()
{
    // Delete the widgets for the page.
    // The stack doesn't need to delete any Widgets on it,
    // because they are either in the m_listXMLWidgets or in 
    // the SubWidget list of a Widget.
    if (m_nNumberOfWidgets > 0)
    {
        WIDGET_LIST::iterator wlIt = m_listXMLWidgets.begin();
        WIDGET_LIST::iterator wlendIt = m_listXMLWidgets.end();
        while (wlIt != wlendIt)
        {
            delete (*wlIt);
            wlIt++;
        }
        m_listXMLWidgets.clear();
        m_nNumberOfWidgets = 0;
    }

    // Clean up the stack of widgets.
    while (!m_stlStackOfWidgets.empty())
    {
        m_stlStackOfWidgets.pop();
    }

    // Clean up the attributes memory.  This would be non NULL if
    // it was not assigned to an element.
    if (m_pMapXMLAttributes != NULL) 
    {
        m_pMapXMLAttributes->clear();
        delete m_pMapXMLAttributes;
    }

    // Clean up the list of non-widget elements.
    if (!m_listElements.empty())
    {
        ELEMENT_LIST::iterator elIt    = m_listElements.begin();
        ELEMENT_LIST::iterator elendIt = m_listElements.end();
        while (elIt != elendIt)
        {
            delete (*elIt);
            elIt++;
        }
        m_listElements.clear();
    }
}

CXMLPage& CXMLPage::operator=(const CXMLPage& rXMLPage)
{
    if (this != &rXMLPage)
    {
        if (m_nNumberOfWidgets > 0)
        {
            WIDGET_LIST::iterator this_wlIt = m_listXMLWidgets.begin();
            WIDGET_LIST::iterator this_wlendIt = m_listXMLWidgets.end();
            while (this_wlIt != this_wlendIt)
            {
                delete (*this_wlIt);
                this_wlIt++;
            }
            m_listXMLWidgets.clear();
            m_nNumberOfWidgets = 0;
        }

        // Clean up the stack of widgets.
        while (!m_stlStackOfWidgets.empty())
        {
            m_stlStackOfWidgets.pop();
        }

        // Clean up the attributes memory.  This would be non NULL if
        // it was not assigned to an element.
        if (m_pMapXMLAttributes != NULL) 
        {
            m_pMapXMLAttributes->clear();
            if (rXMLPage.m_pMapXMLAttributes == NULL)
            {
                delete m_pMapXMLAttributes;
                m_pMapXMLAttributes = NULL;
            }
            else
            {
                *(m_pMapXMLAttributes) = *(rXMLPage.m_pMapXMLAttributes);
            }
        }
        else
        {
            if (rXMLPage.m_pMapXMLAttributes != NULL)
            {
                m_pMapXMLAttributes = new STRING2STRING_MAP;

                // Copy attributes one by one.
                STRING2STRING_MAP::const_iterator mIt = 
                                     rXMLPage.m_pMapXMLAttributes->begin();
                STRING2STRING_MAP::const_iterator mendIt = 
                                     rXMLPage.m_pMapXMLAttributes->end();
                while (mIt != mendIt)
                {
                    (*m_pMapXMLAttributes)[(*mIt).first] = (*mIt).second;
                    mIt++;
                }
            }
        }

        if (!m_listElements.empty())
        {
            ELEMENT_LIST::iterator this_elIt    = m_listElements.begin();
            ELEMENT_LIST::iterator this_elendIt = m_listElements.end();
            while (this_elIt != this_elendIt)
            {
                delete (*this_elIt);
                this_elIt++;
            }
            m_listElements.clear();
        }

        m_mapAvailableWidgets.clear();
        m_mapAvailableWidgets = rXMLPage.m_mapAvailableWidgets;

        WIDGET_LIST::const_iterator wlIt = rXMLPage.m_listXMLWidgets.begin();
        WIDGET_LIST::const_iterator wlendIt = rXMLPage.m_listXMLWidgets.end();
        CXMLWidget* pXMLWidget = NULL;
        while (wlIt != wlendIt)
        {
            pXMLWidget = new CXMLWidget;
            *pXMLWidget = *(*wlIt);
            m_listXMLWidgets.push_back(pXMLWidget);
            wlIt++;
        }

        ELEMENT_LIST::const_iterator elIt   = rXMLPage.m_listElements.begin();
        ELEMENT_LIST::const_iterator elendIt = rXMLPage.m_listElements.end();
        CXMLElement* pXMLElement = NULL;

        while (elIt != elendIt)
        {
            pXMLElement = new CXMLElement;
            *pXMLElement = *(*elIt);
            m_listElements.push_back(pXMLElement);
            elIt++;
        }

        m_nNumberOfWidgets = rXMLPage.m_nNumberOfWidgets;

        memcpy(&m_WriteFileTime, &(rXMLPage.m_WriteFileTime), sizeof(FILETIME));
    }

    return *this;
}

bool CXMLPage::operator==(const CXMLPage& rXMLPage)
{
    // Make sure all of the available widgets are the same.
    if (m_mapAvailableWidgets.size() == rXMLPage.m_mapAvailableWidgets.size())
    {
        _FSI_STL::map<_FSI_STL::string, bool>::iterator sl1It     = 
                                                 m_mapAvailableWidgets.begin();

        _FSI_STL::map<_FSI_STL::string, bool>::iterator sl1endIt  = 
                                                  m_mapAvailableWidgets.end();
        _FSI_STL::map<_FSI_STL::string, bool>::const_iterator sl2It = 
                                       rXMLPage.m_mapAvailableWidgets.begin();

        while (sl1It != sl1endIt)
        {
            if ((*sl1It) != (*sl2It))
            {
                return false;
            }

            sl1It++;
            sl2It++;
        }
    }
    else
    {
        // Different size
        return false;
    }

    // Make sure all of the elements are the same.
    if (m_listElements.size() == rXMLPage.m_listElements.size())
    {
        ELEMENT_LIST::iterator el1It    = m_listElements.begin();
        ELEMENT_LIST::iterator el1endIt = m_listElements.end();
        ELEMENT_LIST::const_iterator el2It = rXMLPage.m_listElements.begin();
        while (el1It != el1endIt)
        {
            if (!(*(*el1It) == *(*el2It)))
            {
                return false;
            }

            el1It++;
            el2It++;
        }
    }
    else
    {
        // Different size
        return false;
    }

    // Make sure all of the widgets are the same.
    if (m_nNumberOfWidgets == rXMLPage.m_nNumberOfWidgets)
    {
        WIDGET_LIST::iterator wl1It     = m_listXMLWidgets.begin();
        WIDGET_LIST::iterator wl1endIt  = m_listXMLWidgets.end();
        WIDGET_LIST::const_iterator wl2It = rXMLPage.m_listXMLWidgets.begin();
        while (wl1It != wl1endIt)
        {
            if (!(*(*wl1It) == *(*wl2It)))
            {
                return false;
            }

            wl1It++;
            wl2It++;
        }
    }
    else
    {
        // Different size
        return false;
    }

    // Make sure the write times are the same.
    if (CompareFileTime(&m_WriteFileTime, &rXMLPage.m_WriteFileTime) != 0)
    {
        return false;
    }

    return true;
}

void CXMLPage::AddAttribute(const _FSI_STL::string& stlStrName, 
                            const _FSI_STL::string& stlStrValue)
{
    if (m_pMapXMLAttributes == NULL)
    {
        // Create a new map of attributes.
        // This should be added to an element that is stored
        // in a widget.  Once the end element is reached, the
        // map will be "given" to the widget's element and
        // the pointer will be reset to NULL.
        m_pMapXMLAttributes = new STRING2STRING_MAP;
    }

    if (m_pMapXMLAttributes != NULL)
    {
        // If the map was created, add the name and the
        // value to it.
        (*m_pMapXMLAttributes)[stlStrName] = stlStrValue;
    }
}

void CXMLPage::AddWidget(const _FSI_STL::string& stlStrName, 
                         const _FSI_STL::string& stlStrValue)
{
    // Check to see if it is a widget
    if (m_mapAvailableWidgets.find(stlStrName) != 
                                                m_mapAvailableWidgets.end())
    {
        CXMLWidget* pXMLWidget = new CXMLWidget(stlStrName);

        // If the widget stack is has a widget on it, then
        // this new widget is a sub-widget.  Else, just push
        // this widget onto the list of widgets.
        if (!m_stlStackOfWidgets.empty())
        {
            m_stlStackOfWidgets.top()->AddWidget(pXMLWidget);
        }
        else
        {
            m_listXMLWidgets.push_back(pXMLWidget);
            m_nNumberOfWidgets++;
        }

        // Put the widget on the stack.
        m_stlStackOfWidgets.push(pXMLWidget);
    }
    else
    {
        // A non-widget element was found.  This will not nest
        // non-widget elements.
        if (!m_stlStackOfWidgets.empty())
        {
            // Add the element to the top widget on the stack.
            m_stlStackOfWidgets.top()->AddElement(stlStrName, stlStrValue,
                                                  m_pMapXMLAttributes);
        }
        else
        {
            // Add the element to the main page.
            AddElement(stlStrName, stlStrValue, m_pMapXMLAttributes);
        }

        m_bElementStarted = true;
        m_pMapXMLAttributes = NULL;
    }
}

bool CXMLPage::AddWidget(CXMLWidget* pXMLWidget)
{
    if (pXMLWidget != NULL)
    {
        _FSI_STL::string stlStrWidgetName = pXMLWidget->WidgetName();
        strupr((char *)stlStrWidgetName.c_str());
        if (m_mapAvailableWidgets.find(stlStrWidgetName) != 
                                                m_mapAvailableWidgets.end())
        {
            m_listXMLWidgets.push_back(pXMLWidget);
            m_nNumberOfWidgets++;
            return true;
        }
        else
        {
            return false;
        }
    }

    return false;
}

void CXMLPage::AddElement(const _FSI_STL::string& rstlStrName, 
                          const _FSI_STL::string& rstlStrValue,
                          STRING2STRING_MAP* pMapXMLAttributes)
{
    // If there is a widget on the stack, the element gets added to the
    // widget.  Else, the element is a part of the main page.
    if (!m_stlStackOfWidgets.empty())
    {
        m_stlStackOfWidgets.top()->AddElement(rstlStrName,rstlStrValue,
                                              pMapXMLAttributes);
    }
    else
    {
        CXMLElement* pXMLElement = new CXMLElement(rstlStrName,rstlStrValue);
        if (pXMLElement != NULL)
        {
            pXMLElement->SetAttributes(pMapXMLAttributes);
            m_listElements.push_back(pXMLElement);
        }
    }
}

void CXMLPage::AddElementValue(const _FSI_STL::string& rstlStrElementValue)
{
    // Set the value of the last element added to a widget.  Else,
    // set the value of the last element added to the main page.
    if (m_bElementStarted == true)
    {
        if (!m_stlStackOfWidgets.empty())
        {
            m_stlStackOfWidgets.top()->AddElementValue(rstlStrElementValue);
        }
        else if (!m_listElements.empty())
        {
            m_listElements.back()->AddElementValue(rstlStrElementValue);
        }
    }
}

void CXMLPage::EndWidgetDefinition(const _FSI_STL::string& rstlStrName)
{
    // When an end element tag is found, pop the stack and set the
    // widget's name.
    m_bElementStarted = false;
    CXMLWidget* pXMLWidget;
    if (m_nNumberOfWidgets > 0)
    {
        if (!m_stlStackOfWidgets.empty())
        {
            pXMLWidget = m_stlStackOfWidgets.top();
            if (strcmp(pXMLWidget->WidgetName().c_str(), 
                       rstlStrName.c_str()) == 0)
            {
                m_stlStackOfWidgets.pop();
            }
        }
    }
}

void CXMLPage::AddAvailableWidget(const _FSI_STL::string& stlStrWidget)
{
    m_mapAvailableWidgets[stlStrWidget];
}

CXMLWidget* CXMLPage::GetNextWidget(WIDGET_LIST::iterator& wlIt) 
{   
    // Step through the list of widgets.
    WIDGET_LIST::iterator nullIt = NULL;
    if (wlIt == nullIt && m_nNumberOfWidgets > 0)
    {
        wlIt = m_listXMLWidgets.begin();
    }
    else if (wlIt == m_listXMLWidgets.end() || m_nNumberOfWidgets == 0)
    {
        return NULL;
    }

    CXMLWidget* pXMLWidget = *wlIt;
    wlIt++;
    return pXMLWidget;
}

CXMLElement* CXMLPage::GetNextElement(ELEMENT_LIST::iterator& elIt) 
{ 
    // Step through the elements of the main page.
    ELEMENT_LIST::iterator nullIt = NULL;
    if (elIt == nullIt && !m_listElements.empty())
    {
        elIt = m_listElements.begin();
    }
    else if (elIt == m_listElements.end() ||
             m_listElements.empty())
    {
        return NULL;
    }

    CXMLElement* pXMLElement = *elIt;
    elIt++;

    return pXMLElement; 
}

bool CXMLPage::FindElement(ELEMENT_LIST::iterator& elIt,
                           const _FSI_STL::string& rstlStrElementName)
{
    // Find an attribute for the main page element.
    if (!m_listElements.empty())
    {
        ELEMENT_LIST::iterator nullIt = NULL;
        ELEMENT_LIST::iterator lendIt = m_listElements.end();
        if (elIt == nullIt)
        {
            elIt = m_listElements.begin();
        }

        while (elIt != lendIt)
        {
            if ((*elIt)->ElementName() != rstlStrElementName)
            {
                elIt++;
            }
            else
            {
                return true;
            }
        }
    }

    return false;
}

FILETIME CXMLPage::WriteFileTime()
{
    return m_WriteFileTime;
}

void CXMLPage::WriteFileTime(FILETIME* pWriteFileTime)
{
    memcpy(&m_WriteFileTime, pWriteFileTime, sizeof(FILETIME));
}

_FSI_STL::list<CXMLWidget*>::iterator CXMLPage::DeleteItem(CXMLWidget* pXMLWidget)
{
    WIDGET_LIST::iterator lIt       = m_listXMLWidgets.begin();
    WIDGET_LIST::iterator lendIt    = m_listXMLWidgets.end();
    while (lIt != lendIt && (*lIt) != pXMLWidget)
    {
        lIt++;
    }

    // Make sure that the pointer is in the list of widgets for this page.
    if (lIt != lendIt)
    {
        lIt = m_listXMLWidgets.erase(lIt);
        m_nNumberOfWidgets--;
        delete pXMLWidget;
    }

    return lIt;
}

_FSI_STL::list<CXMLElement*>::iterator CXMLPage::DeleteItem(CXMLElement* pXMLElement)
{
    ELEMENT_LIST::iterator lIt      = m_listElements.begin();
    ELEMENT_LIST::iterator lendIt   = m_listElements.end();
    while (lIt != lendIt && (*lIt) != pXMLElement)
    {
        lIt++;
    }

    // Make sure that the pointer is in the list of elements for this page.
    if (lIt != lendIt)
    {
        lIt = m_listElements.erase(lIt);
        delete pXMLElement;
    }

    return lIt;
}