#ifndef _XMLELEMENT_H_
#define _XMLELEMENT_H_

#ifdef CORE
#define DLLAPI __declspec( dllexport )
#else
#define DLLAPI __declspec( dllimport )
#endif

#include "stltypes.h"
#include <afx.h>

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class DLLAPI CXMLElement
{
protected:
    STRING2STRING_MAP*       m_pmapXMLAttributes;

    _FSI_STL::string         m_stlStrElementName;

    _FSI_STL::string         m_stlStrElementValue;

    _FSI_STL::string         m_stlStrAttribute;
    
public:
    // CArchive I/O
    friend CArchive& operator<<(CArchive& rArchive, 
        const CXMLElement& rXMLElement);
//    friend CArchive& operator>>(CArchive& rArchive, CXMLElement& rXMLElement);
    
    // Constructors
    CXMLElement();
    CXMLElement(const _FSI_STL::string& stlStrName, const _FSI_STL::string& stlStrValue);
    CXMLElement(const CXMLElement& rXMLElement);
    
    // Destructor
    virtual ~CXMLElement();
    
    // Assignment overload
    CXMLElement& operator=(const CXMLElement& rXMLElement);
    
    // Equals overload
    bool operator==(const CXMLElement& rXMLElement);

    //Accessors
    const _FSI_STL::string& ElementName();
    const _FSI_STL::string& ElementValue();

    bool FindAttribute(STRING2STRING_MAP::iterator& s2sIt, 
                       const _FSI_STL::string& stlStrAttributeName);

    void AddAttribute(const _FSI_STL::string& rstlStrAttributeName, 
                      const _FSI_STL::string& rstlStrAttributeValue);

    void AddElementValue(const _FSI_STL::string& rstlStrElementValue);

    void SetAttributes(STRING2STRING_MAP* pMapXMLAttributes);
    STRING2STRING_MAP GetAttributes();
};

#endif // ifndef _XMLElement_H_
